// ViewFile.cpp : implementation file
//
#include  <afxwin.h>
#include  <afxdlgs.h>
#include  <math.h>

#include  "Locale.h"
#include  "GestDsk.h"
#include  "Resource.h"
#include  "ViewFile.h"
#include  "TypeFichier.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define     MAX_LIGNES_HEX  32

#define     MAX_LIGNES_SCR  200

#define     MAX_COLS_SCR    80


/////////////////////////////////////////////////////////////////////////////
// CViewFile dialog


CViewFile::CViewFile( BYTE * b, int n, int t, int l, CWnd * pParent /*=NULL*/ )
    : CDialog(CViewFile::IDD, pParent)
{
    //{{AFX_DATA_INIT(CViewFile)
    //}}AFX_DATA_INIT
    BufFile = b;
    TailleFic = n;
    TypeModeExport = t;
    Langue = l;
    NbLignes = ( n + 15 ) >> 4;
    CurLigne = 0;
    NbCols = MAX_COLS_SCR;
    NbL = MAX_LIGNES_SCR;
    Mode = 1;
    IsBasic = FALSE;
}


void CViewFile::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CViewFile)
    DDX_Control(pDX, IDC_SAVE, m_BpSave);
    DDX_Control(pDX, IDC_MODE0, m_Mode0);
    DDX_Control(pDX, IDC_MODE1, m_Mode1);
    DDX_Control(pDX, IDC_MODE2, m_Mode2);
    DDX_Control(pDX, IDC_STATIC_NBLIGNES, m_StaticNbLignes);
    DDX_Control(pDX, IDC_STATIC_OFFSET, m_StaticOffset);
    DDX_Control(pDX, IDC_STATIC_NBCOL, m_StaticNbCol);
    DDX_Control(pDX, IDC_CLEAR, m_Clear);
    DDX_Control(pDX, IDC_CRLF, m_CrLf);
    DDX_Control(pDX, IDC_HEXA, m_Hexa);
    DDX_Control(pDX, IDC_ECR, m_Ecran);
    DDX_Control(pDX, IDC_BASIC, m_Basic);
    DDX_Control(pDX, IDC_LIST_BASIC, m_ListBasic);
    DDX_Control(pDX, IDC_VIEW_HEX, m_ViewHex);
    DDX_Control(pDX, IDC_VIEW_ASCII, m_ViewAscii);
    DDX_Control(pDX, IDC_SCROLL, m_Scroll);
    DDX_Control(pDX, IDC_SCROLLSCR, m_ScrollScr);
    DDX_Control(pDX, IDC_SPIN_COL, m_SpinCol);
    DDX_Control(pDX, IDC_SPIN_LIGNES, m_SpinLignes);
    //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CViewFile, CDialog)
    //{{AFX_MSG_MAP(CViewFile)
    ON_WM_VSCROLL()
    ON_BN_CLICKED(IDC_BASIC, OnBasic)
    ON_BN_CLICKED(IDC_ECR, OnEcr)
    ON_BN_CLICKED(IDC_HEXA, OnHexa)
    ON_BN_CLICKED(IDC_CRLF, OnCrlf)
    ON_WM_PAINT()
    ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_COL, OnDeltaposSpinCol)
    ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_LIGNES, OnDeltaposSpinLignes)
    ON_BN_CLICKED(IDC_MODE0, OnMode0)
    ON_BN_CLICKED(IDC_MODE1, OnMode1)
    ON_BN_CLICKED(IDC_MODE2, OnMode2)
    ON_BN_CLICKED(IDC_SAVE, OnSave)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CViewFile message handlers


BOOL CViewFile::OnInitDialog()
{
    CDialog::OnInitDialog();

    SetWindowText( GetTexteLoc( 58, Langue ) );
    m_Hexa.SetWindowText( GetTexteLoc( 59, Langue ) );
    m_Basic.SetWindowText( GetTexteLoc( 60, Langue ) );
    m_Ecran.SetWindowText( GetTexteLoc( 61, Langue ) );
    font8.CreatePointFont( 80, "Courier New", this->GetDC() );
    m_ViewHex.SetFont( &font8 );
    m_ViewAscii.SetFont( &font8 );
    font9.CreatePointFont( 90, "Courier New", this->GetDC() );
    m_ListBasic.SetFont( &font9 );
    m_BpSave.SetWindowText( GetTexteLoc( 7, Langue ) );

    IsAmsdos = CheckAmsdos( BufFile );
    if ( IsAmsdos )
        {
        StAmsdos * Entete = ( StAmsdos * )BufFile;
        if ( Entete->FileType == 0 || Entete->FileType == 1 )
            IsBasic = TRUE;
        else
            m_Basic.EnableWindow( FALSE );
        }
    BITMAPINFO pbmi;

    pbmi.bmiHeader.biSize = sizeof( BITMAPINFOHEADER );
    pbmi.bmiHeader.biWidth = TAILLE_CPC_X;
    pbmi.bmiHeader.biHeight = -TAILLE_CPC_Y;
    pbmi.bmiHeader.biPlanes = 1;
    pbmi.bmiHeader.biBitCount = 32;
    pbmi.bmiHeader.biCompression = BI_RGB;
    pbmi.bmiHeader.biSizeImage = 0;
    pbmi.bmiHeader.biXPelsPerMeter = 0;
    pbmi.bmiHeader.biYPelsPerMeter = 0;
    pbmi.bmiHeader.biClrUsed = 0;
    pbmi.bmiHeader.biClrImportant = 0;
    bmImage = CreateDIBSection( GetDC()->m_hDC
                              , &pbmi
                              , DIB_RGB_COLORS
                              , &MemBitmapImage
                              , NULL
                              , 0
                              );
    if ( bmImage )
        {
        DcBitmapImage = CreateCompatibleDC( GetDC()->m_hDC );
        if ( DcBitmapImage )
            {
            SelectObject( DcBitmapImage, bmImage );
            SetStretchBltMode( DcBitmapImage, COLORONCOLOR );
            memset( EcrCPC.GetBitmapCPC(), 0, 0x4000 ); // Efface image
            BYTE Pal[ 16 ] = { 1, 24, 20, 6, 26, 0, 2, 8, 10, 12, 14, 16, 18, 22, 3, 4 };
            EcrCPC.InitPalette( Pal, TRUE );
            OnMode1();
            m_Mode1.SetCheck( 1 );
            }
        }

    m_Hexa.SetCheck( 1 );
    OnHexa();
    return( TRUE );
}


//
// Affichage secteur en cours
//
void CViewFile::ViewLine( void )
{
    static char Ascii[ 513 ];       // Buffer de reprsentation en ASCII
    static char HexSect[ 2048 ];    // Buffer de reprsentation en HEXA

    SetBuffViewHexa( &BufFile[ CurLigne << 4 ]
                   , HexSect
                   , Ascii
                   , CurLigne << 4
                   , TRUE
                   );
    m_ViewHex.SetWindowText( HexSect );
    m_ViewAscii.SetWindowText( Ascii );
}


void CViewFile::ViewBasic( void )
{
    static char LigneBasic[ 0x20000 ];
    int Nbignes = 0, DansChaine = 0, Token;
    char Tmp[ 32 ];
    double f, exp;

    static char * Nbre[ 11 ] =
        {
        "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"
        };
    static char * MotsClefs[ 0x80 ] =
        {
        "AFTER", "AUTO", "BORDER", "CALL", "CAT", "CHAIN", "CLEAR", "CLG",
        "CLOSEIN", "CLOSEOUT", "CLS", "CONT", "DATA", "DEF", "DEFINT",
        "DEFREAL", "DEFSTR", "DEG", "DELETE", "DIM", "DRAW", "DRAWR", "EDIT",
        "ELSE", "END", "ENT", "ENV", "ERASE", "ERROR", "EVERY", "FOR",
        "GOSUB", "GOTO", "IF", "INK", "INPUT", "KEY", "LET", "LINE", "LIST",
        "LOAD", "LOCATE", "MEMORY", "MERGE", "MID$", "MODE", "MOVE", "MOVER",
        "NEXT", "NEW", "ON", "ON BREAK", "ON ERROR GOTO", "SQ", "OPENIN",
        "OPENOUT", "ORIGIN", "OUT", "PAPER", "PEN", "PLOT", "PLOTR", "POKE",
        "PRINT", "'", "RAD", "RANDOMIZE", "READ", "RELEASE", "REM", "RENUM",
        "RESTORE", "RESUME", "RETURN", "RUN", "SAVE", "SOUND", "SPEED", "STOP",
        "SYMBOL", "TAG", "TAGOFF", "TROFF", "TRON", "WAIT", "WEND", "WHILE",
        "WIDTH", "WINDOW", "WRITE", "ZONE", "DI", "EI", "FILL", "GRAPHICS",
        "MASK", "FRAME", "CURSOR", "#E2", "ERL", "FN", "SPC", "STEP", "SWAP",
        "#E8", "#E9", "TAB", "THEN", "TO", "USING", ">", "=", ">=", "<", "<>",
        "<=", "+", "-", "*", "/", "^", "\\ ", "AND", "MOD", "OR", "XOR", "NOT",
        "#FF"
        };

    static char * Fcts[ 0x80 ] =
        {
        "ABS", "ASC", "ATN", "CHR$", "CINT", "COS", "CREAL", "EXP", "FIX",
        "FRE", "INKEY", "INP", "INT", "JOY", "LEN", "LOG", "LOG10", "LOWER$",
        "PEEK", "REMAIN", "SGN", "SIN", "SPACE$", "SQ", "SQR", "STR$", "TAN",
        "UNT", "UPPER$", "VAL", "", "", "", "", "", "", "", "", "", "", "",
        "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
        "", "", "", "", "", "", "EOF", "ERR", "HIMEM", "INKEY$", "PI", "RND",
        "TIME", "XPOS", "YPOS", "DERR", "", "", "", "", "", "", "", "", "", "",
        "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
        "", "", "", "", "", "", "", "", "", "", "", "BIN$", "DEC$", "HEX$",
        "INSTR", "LEFT$", "MAX", "MIN", "POS", "RIGHT$", "ROUND", "STRING$",
        "TEST", "TESTR", "COPYCHR$", "VPOS"
        };


    int Pos = sizeof( StAmsdos );
    * LigneBasic = 0;
    if ( ! IsBasic )
        Pos = 0;

    int StartLigne = 0, EndLigne;
    for ( ;; )
        {
        if ( IsBasic )
            {
            int lg = BufFile[ Pos ] + ( BufFile[ Pos + 1 ] << 8 );
            Pos += 2;
            if ( ! lg )
                break;

            int NumLigne = BufFile[ Pos ] + ( BufFile[ Pos + 1 ] << 8 );
            Pos += 2;
            sprintf( Tmp, "%d ", NumLigne );
            strcat( LigneBasic, Tmp );
            }
        else
            if ( ! Token || Token == 0x1A )
                break;

        do
            {
            Token = BufFile[ Pos++ ];
            if ( ! IsBasic && Token == 0x1A )
                break;

            if ( DansChaine || ! IsBasic )
                {
                Tmp[ 0 ] = Token;
                Tmp[ 1 ] = 0;
                strcat( LigneBasic, Tmp );
                if ( Token == '"' )
                    DansChaine ^= 1;
                }
            else
                if ( Token > 0x7F && Token < 0xFF )
                    {
                    // #### Traitement particulier du ':' avant le ELSE
                    if (  LigneBasic[ strlen( LigneBasic ) - 1 ] == ':' 
                       && Token == 0x97
                       )
                        LigneBasic[ strlen( LigneBasic ) - 1 ] = 0;

                    strcat( LigneBasic
                          , MotsClefs[ Token & 0x7F ]
                          );
                    }
                else
                    if ( Token >= 0x0E && Token <= 0x18 )
                        strcat( LigneBasic
                              , Nbre[ Token - 0x0E ]
                              );
                    else
                        if ( Token >= 0x20 && Token < 0x7C )
                            {
                            Tmp[ 0 ] = Token;
                            Tmp[ 1 ] = 0;
                            strcat( LigneBasic, Tmp );
                            if ( Token == '"' )
                                DansChaine ^= 1;
                            }
                        else
                            {
                            switch( Token )
                                {
                                case 0x01 :
                                    Tmp[ 0 ] = ':';
                                    Tmp[ 1 ] = 0;
                                    strcat( LigneBasic, Tmp );
                                    break;

                                case 0x03 : // ####
                                    Pos += 2;
                                    Tmp[ 1 ] = 0;
                                    do
                                        {
                                        Tmp[ 0 ] = BufFile[ Pos ] & 0x7F;
                                        strcat( LigneBasic, Tmp );
                                        }
                                    while( ! ( BufFile[ Pos++ ] & 0x80 ) );
                                    strcat( LigneBasic, "$" );
                                    break;

                                case 0x0B :
                                case 0x0C :
                                case 0x0D : // ####
                                    Pos += 2;
                                    Tmp[ 1 ] = 0;
                                    do
                                        {
                                        Tmp[ 0 ] = BufFile[ Pos ] & 0x7F;
                                        strcat( LigneBasic, Tmp );
                                        }
                                    while( ! ( BufFile[ Pos++ ] & 0x80 ) );
                                    break;

                                case 0x19 :
                                    strcat( LigneBasic
                                          , itoa( BufFile[ Pos ], Tmp, 10 )
                                          );
                                    Pos++;
                                    break;

                                case 0x1A :
                                case 0x1E :
                                    strcat( LigneBasic
                                           , itoa( BufFile[ Pos ]
                                                 + ( BufFile[ Pos + 1 ] << 8 )
                                                 , Tmp
                                                 , 10
                                                 )
                                           );
                                    Pos += 2;
                                    break;

                                case 0x1B :
                                    sprintf( Tmp
                                           , "&X%X"
                                           , BufFile[ Pos ]
                                           + ( BufFile[ Pos + 1 ] << 8 )
                                           );
                                    strcat( LigneBasic, Tmp );
                                    Pos += 2;
                                    break;

                                case 0x1C :
                                    sprintf( Tmp
                                           , "&%X"
                                           , BufFile[ Pos ]
                                           + ( BufFile[ Pos + 1 ] << 8 )
                                           );
                                    strcat( LigneBasic, Tmp );
                                    Pos += 2;
                                    break;

                                case 0x1F : // #####
                                    f = ( BufFile[ Pos ] << 16 )
                                      + ( BufFile[ Pos + 1 ] << 8 )
                                      + BufFile[ Pos + 2 ]
                                      + ( ( BufFile[ Pos + 3 ] & 0x7F ) << 24 );
                                    if ( BufFile[ Pos + 3 ] & 0x80 )
                                        f = -f;

                                    exp = BufFile[ Pos + 4 ] - 127;
                                    f = pow( 2, exp );
                                    Pos += 5;
//                                    sprintf( Tmp, "%f", f );
    strcpy( Tmp, "####" );
                                    strcat( LigneBasic, Tmp );
                                    break;

                                case 0x7C :
                                    strcat( LigneBasic, "" );
                                    Tmp[ 1 ] = 0;
                                    Pos++;
                                    do
                                        {
                                        Tmp[ 0 ] = BufFile[ Pos ] & 0x7F;
                                        strcat( LigneBasic, Tmp );
                                        }
                                    while( ! ( BufFile[ Pos++ ] & 0x80 ) );
                                    break;

                                case 0xFF :
                                    if ( BufFile[ Pos ] < 0x80 )
                                        strcat( LigneBasic
                                              , Fcts[ BufFile[ Pos++ ] ]
                                              );
                                    else
                                        {
                                        Tmp[ 1 ] = 0;
                                        Tmp[ 0 ] = BufFile[ Pos++ ] & 0x7F;
                                        strcat( LigneBasic, Tmp );
                                        }
                                    break;

                                default :
                                    Token = Token;
                                }
                            }
            }
        while( Token );
        if ( m_CrLf.GetCheck() )
            {
            //
            // Retour  la ligne si > 80 caractres
            //
            EndLigne = strlen( &LigneBasic[ StartLigne ] );
            while( EndLigne > 80 )
                {
                memmove( &LigneBasic[ StartLigne + 82 ]
                       , &LigneBasic[ StartLigne + 80 ]
                       , EndLigne
                       );
                memcpy( &LigneBasic[ StartLigne + 80 ], "\r\n", 2 );
                StartLigne += 82;
                EndLigne -= 80;
                }
            }
        strcat( LigneBasic, "\r\n" );
        StartLigne = strlen( LigneBasic );
        }
    m_ListBasic.SetWindowText( LigneBasic );
    m_ListBasic.SetSel( -1, -1 );
}


void CViewFile::SetResScroll( CScrollBar * pScrollBar )
{
    if ( m_Ecran.GetCheck() )
        {
        pScrollBar->SetScrollPos( CurLigne >> 1 );
        ViewBitmap();
        }
    else
        {
        pScrollBar->SetScrollPos( CurLigne );
        ViewLine();
        }
}


void CViewFile::OnVScroll( UINT nSBCode, UINT nPos, CScrollBar * pScrollBar )
{
    int Ligne1 = 1;
    int LigneM = MAX_LIGNES_HEX;
    int LigneF = NbLignes;

    if ( pScrollBar == &m_ScrollScr || pScrollBar == &m_Scroll )
        {
        if ( pScrollBar == &m_ScrollScr )
            {
            Ligne1 = 1;
            LigneM = NbCols;
            LigneF = TailleFic;
            }
        switch( nSBCode )
            {
            case SB_BOTTOM :
                CurLigne = LigneF - LigneM;
                if ( CurLigne < 0 )
                    CurLigne = 0;

                SetResScroll( pScrollBar );
                break;

            case SB_ENDSCROLL :
                SetResScroll( pScrollBar );
                break;

            case SB_LINEDOWN :
                if ( CurLigne + LigneM + Ligne1 <= LigneF )
                    CurLigne += Ligne1;
                else
                    CurLigne = LigneF - LigneM;

                SetResScroll( pScrollBar );
                break;

            case SB_LINEUP :
                if ( CurLigne - Ligne1 >= 0 )
                    CurLigne -= Ligne1;
                else
                    CurLigne = 0;

                SetResScroll( pScrollBar );
                break;

            case SB_PAGEUP :
                CurLigne -= LigneM;
                if ( CurLigne < 0 )
                    CurLigne = 0;

                SetResScroll( pScrollBar );
                break;

            case SB_PAGEDOWN :
                CurLigne += LigneM;
                if ( CurLigne + LigneM >= LigneF )
                    {
                    CurLigne = LigneF - LigneM;
                    if ( CurLigne < 0 )
                        CurLigne = 0;
                    }
                SetResScroll( pScrollBar );
                break;

            case SB_THUMBPOSITION :
            case SB_THUMBTRACK :
                if ( pScrollBar == &m_ScrollScr )
                    CurLigne = nPos << 1;
                else
                    CurLigne = nPos;

                SetResScroll( pScrollBar );
                break;

            case SB_TOP :
                CurLigne = 0;
                SetResScroll( pScrollBar );
                break;
            }
        }
    CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}


void CViewFile::ViewBitmap( void )
{
    char Tmp[ 128 ];
    int Start = CurLigne;
    if ( IsAmsdos )
        Start += sizeof( StAmsdos );

    memset( MemBitmapImage, 0, TAILLE_CPC_X * TAILLE_CPC_Y * 4 );
    EcrCPC.SetNbCol( NbCols );
    EcrCPC.SetNbLignes( NbL );
    EcrCPC.SetBitmapCPC( &BufFile[ Start ] );
    EcrCPC.Render( ( StRVB * )MemBitmapImage, m_CrLf.GetCheck() );
    StretchBlt( GetDC()->m_hDC, 4, 4, TAILLE_CPC_X, TAILLE_CPC_Y << 1
              , DcBitmapImage, 0, 0, TAILLE_CPC_X, TAILLE_CPC_Y
              , SRCCOPY
              );
    wsprintf( Tmp, GetTexteLoc( 65, Langue ), CurLigne );
    m_StaticOffset.SetWindowText( Tmp );
    if ( m_CrLf.GetCheck() )
        {
        m_BpSave.ShowWindow( SW_SHOW );
        wsprintf( Tmp, GetTexteLoc( 64, Langue ), NbCols );
        m_StaticNbCol.SetWindowText( Tmp );
        wsprintf( Tmp, GetTexteLoc( 66, Langue ), NbL );
        m_StaticNbLignes.SetWindowText( Tmp );
        m_SpinCol.ShowWindow( SW_SHOW );
        m_SpinLignes.ShowWindow( SW_SHOW );
        }
    else
        {
        m_BpSave.ShowWindow( SW_HIDE );
        m_StaticNbCol.SetWindowText( "" );
        m_StaticNbLignes.SetWindowText( "" );
        m_SpinCol.ShowWindow( SW_HIDE );
        m_SpinLignes.ShowWindow( SW_HIDE );
        }

    // Ajustement offset
    if ( CurLigne + NbCols * NbL >= TailleFic )
        {
        CurLigne = TailleFic - NbL * NbCols;
        if ( CurLigne < 0 )
            CurLigne = 0;
        }

    // Calcul scrolling min-max
    int MaxScroll;
    if ( m_CrLf.GetCheck() )
        MaxScroll = TailleFic - NbCols * NbL;
    else
        MaxScroll = TailleFic - 0x4000;

    if ( IsAmsdos )
        MaxScroll -= sizeof( StAmsdos );

    if ( MaxScroll <= 0 )
        {
        MaxScroll = 0;
        m_ScrollScr.ShowWindow( SW_HIDE );
        m_ScrollScr.EnableWindow( FALSE );
        }
    else
        {
        m_ScrollScr.SetScrollRange( 0, MaxScroll >> 1 );
        m_ScrollScr.ShowWindow( SW_SHOW );
        }
}


void CViewFile::OnBasic()
{
    m_Mode0.ShowWindow( SW_HIDE );
    m_Mode1.ShowWindow( SW_HIDE );
    m_Mode2.ShowWindow( SW_HIDE );
    m_ScrollScr.ShowWindow( SW_HIDE );
    m_BpSave.ShowWindow( SW_HIDE );
    m_Clear.ShowWindow( SW_SHOW );
    m_Clear.ShowWindow( SW_HIDE );
    m_ViewHex.ShowWindow( SW_HIDE );
    m_ViewAscii.ShowWindow( SW_HIDE );
    m_Scroll.ShowWindow( SW_HIDE );
    m_SpinCol.ShowWindow( SW_HIDE );
    m_SpinLignes.ShowWindow( SW_HIDE );
    m_StaticNbCol.SetWindowText( "" );
    m_StaticNbLignes.SetWindowText( "" );
    m_StaticOffset.SetWindowText( "" );
    m_ListBasic.ShowWindow( SW_SHOW );
    m_CrLf.ShowWindow( SW_SHOW );
    m_CrLf.SetWindowText( GetTexteLoc( 62, Langue ) );
    m_CrLf.SetCheck( 0 );
    ViewBasic();
}


void CViewFile::OnEcr()
{
    CurLigne = 0;
    m_Mode0.ShowWindow( SW_SHOW );
    m_Mode1.ShowWindow( SW_SHOW );
    m_Mode2.ShowWindow( SW_SHOW );
    m_ScrollScr.ShowWindow( SW_SHOW );
    m_ViewHex.ShowWindow( SW_HIDE );
    m_ViewAscii.ShowWindow( SW_HIDE );
    m_Scroll.ShowWindow( SW_HIDE );
    m_ListBasic.ShowWindow( SW_HIDE );
    m_CrLf.ShowWindow( SW_SHOW );
    m_CrLf.SetWindowText( GetTexteLoc( 63, Langue ) );
    m_CrLf.SetCheck( 0 );
    ViewBitmap();
}


void CViewFile::OnHexa()
{
    CurLigne = 0;
    m_Mode0.ShowWindow( SW_HIDE );
    m_Mode1.ShowWindow( SW_HIDE );
    m_Mode2.ShowWindow( SW_HIDE );
    m_ScrollScr.ShowWindow( SW_HIDE );
    m_BpSave.ShowWindow( SW_HIDE );
    m_Clear.ShowWindow( SW_SHOW );
    m_Clear.ShowWindow( SW_HIDE );
    m_ViewHex.ShowWindow( SW_SHOW );
    m_ViewAscii.ShowWindow( SW_SHOW );
    m_ListBasic.ShowWindow( SW_HIDE );
    m_CrLf.ShowWindow( SW_HIDE );
    m_SpinCol.ShowWindow( SW_HIDE );
    m_SpinLignes.ShowWindow( SW_HIDE );
    m_StaticNbCol.SetWindowText( "" );
    m_StaticNbLignes.SetWindowText( "" );
    m_StaticOffset.SetWindowText( "" );
    int MaxScroll = NbLignes - MAX_LIGNES_HEX;
    if ( MaxScroll < 0 )
        {
        MaxScroll = 0;
        m_Scroll.ShowWindow( SW_HIDE );
        m_Scroll.EnableWindow( FALSE );
        }
    else
        {
        m_Scroll.SetScrollRange( 0, MaxScroll );
        m_Scroll.ShowWindow( SW_SHOW );
        }
    ViewLine();
}


void CViewFile::OnCrlf()
{
    if ( m_Basic.GetCheck() )
        ViewBasic();

    if ( m_Ecran.GetCheck() )
        {
        CurLigne = 0;
        ViewBitmap();
        }
}


void CViewFile::OnPaint()
{
    CPaintDC dc(this);
    if ( m_Ecran.GetCheck() )
        ViewBitmap();
}


void CViewFile::OnDeltaposSpinCol( NMHDR * pNMHDR, LRESULT * pResult )
{
    if ( m_Ecran.GetCheck() )
        {
        NM_UPDOWN * pNMUpDown = ( NM_UPDOWN * )pNMHDR;
        NbCols -= pNMUpDown->iDelta;

        if ( NbCols > MAX_COLS_SCR )
            NbCols = MAX_COLS_SCR;

        if ( NbCols < 1 )
            NbCols = 1;

        ViewBitmap();
        }
    * pResult = 0;
}


void CViewFile::OnDeltaposSpinLignes( NMHDR * pNMHDR, LRESULT * pResult)
{
    if ( m_Ecran.GetCheck() )
        {
        NM_UPDOWN * pNMUpDown = ( NM_UPDOWN * )pNMHDR;
        NbL -= pNMUpDown->iDelta;

        if ( NbL > MAX_LIGNES_SCR )
            NbL = MAX_LIGNES_SCR;

        if ( NbL < 1 )
            NbL = 1;

        ViewBitmap();
        }
    * pResult = 0;
}


void CViewFile::OnMode0()
{
    EcrCPC.SetMode( 0 );
    ViewBitmap();
}


void CViewFile::OnMode1()
{
    EcrCPC.SetMode( 1 );
    ViewBitmap();
}


void CViewFile::OnMode2()
{
    EcrCPC.SetMode( 2 );
    ViewBitmap();
}


void CViewFile::OnSave()
{
    char Nom[ 128 ];
    DWORD Lg;
    BYTE EndWin[ 5 ];

    * Nom = 0;
    CFileDialog SelectFic( FALSE
                         , "*.WIN"
                         , Nom
                         , OFN_OVERWRITEPROMPT
                         , GetTexteLoc( 67, Langue )
                         );
    if ( SelectFic.DoModal() == IDOK )
        {
        HANDLE f = CreateFile( SelectFic.GetPathName()
                             , GENERIC_WRITE
                             , 0
                             , NULL
                             , CREATE_ALWAYS
                             , 0
                             , NULL
                             );
        if ( f != INVALID_HANDLE_VALUE )
            {
            int Longueur = NbL * NbCols;
            if ( TypeModeExport == MODE_BINAIRE )
                {
                //
                // Ajoute en-tte amsdos
                //
                CString s = SelectFic.GetFileName();
                StAmsdos * e = CreeEnteteAmsdos( ( char * )( const char * )s
                                               , Longueur + 5
                                               );
                WriteFile( f, e, sizeof( StAmsdos ), &Lg, NULL );
                }
            int Start = CurLigne;
            if ( IsAmsdos )
                Start += sizeof( StAmsdos );

            WriteFile( f, &BufFile[ Start ], Longueur, &Lg, NULL );
            //
            // 5 octets dfinissant la taille de la fentre
            //
            int Largeur = NbCols << 3;
            EndWin[ 0 ] = 0;
            EndWin[ 1 ] = Largeur & 0xFF;
            EndWin[ 2 ] = Largeur >> 8;
            EndWin[ 3 ] = NbL;
            EndWin[ 4 ] = 0;
            WriteFile( f, EndWin, sizeof( EndWin ), &Lg, NULL );
            CloseHandle( f );
            }
        }
}
