// ManageDsk.cpp : Defines the class behaviors for the application.
//

#include  <afxwin.h>
#include  <afxcmn.h>
#include  <afxext.h>

#include  "Locale.h"
#include  "GestDsk.h"
#include  "ManageDsk.h"
#include  "ManageDskDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/********************************************************* !NAME! **************
* Nom : Retour
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Chaine de caractres utilise pour stocker les arguments
*
********************************************************** !0! ****************/
static char Retour[ 256 ];


/////////////////////////////////////////////////////////////////////////////
// CManageDskApp

BEGIN_MESSAGE_MAP(CManageDskApp, CWinApp)
    //{{AFX_MSG_MAP(CManageDskApp)
    //}}AFX_MSG
    ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CManageDskApp construction

CManageDskApp::CManageDskApp()
{
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CManageDskApp object

CManageDskApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CManageDskApp initialization

BOOL CManageDskApp::InitInstance()
{
    // Standard initialization
    if ( ! m_lpCmdLine[ 0 ] )
        {
        CManageDskDlg dlg;
        m_pMainWnd = &dlg;
        dlg.DoModal();
        }
    else
        DecomposeArg( m_lpCmdLine );

    return( TRUE );
}


/********************************************************* !NAME! **************
* Nom : CManageDskApp::GetArg
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Description : Recherche le sparateur d'arguments (-)
*
* Rsultat    : La position du premier argument trouv
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
char * CManageDskApp::GetArg( char * argc )
{
    while( * argc && * argc != '-' )
        argc++;

    if ( * argc == '-' )
        return( ++argc );

    return( NULL );
}


/********************************************************* !NAME! **************
* Nom : CManageDskApp::Argument
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Description : Isole un argument de la ligne de commande
*
* Rsultat    : Le premier argument trouv
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
char * CManageDskApp::Argument( char * argc )
{

    char * p = Retour;

    while( * argc != ' ' )
        * p++ = * argc++;

    * p = 0;

     return( Retour );
}


void CManageDskApp::AjouteFichiers( char * Masque )
{
    WIN32_FIND_DATA FindData;
    static BYTE Buff[ 0x20000 ];
    static char Path[ 256 ];
    static char FullName[ 512 ];
    DWORD Lg;

    strcpy( Path, Masque );
    // Recherche le dernier caractre '\'
    char * p = Path;
    char * last = p;
    do
        {
        last = strchr( p, '\\' );
        if ( last )
            p = ++last;
        }
    while( last );

    if ( p > Path )
        * --p = 0;

    HANDLE Hfile = FindFirstFile( Masque, &FindData );
    while( Hfile != INVALID_HANDLE_VALUE )
        {
        if ( ! ( FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ) )
            {
            wsprintf( FullName, "%s\\%s", Path, FindData.cFileName );

            HANDLE fp = CreateFile( FullName
                                 , GENERIC_READ
                                 , 0
                                 , NULL
                                 , OPEN_EXISTING
                                 , 0
                                 , NULL
                                 );
            if ( fp != INVALID_HANDLE_VALUE )
                {
                ReadFile( fp, Buff, sizeof( Buff ), &Lg, NULL );
                CloseHandle( fp );
                CopieFichier( Buff, FindData.cFileName, Lg );
                }
            else
                printf( "Erreur impossible de lire le fichier %s\n"
                      , FindData.cFileName
                      );
            }
        if ( ! FindNextFile( Hfile, &FindData ) )
            break; 
        }
    FindClose( Hfile );
}


/********************************************************* !NAME! **************
* Nom : CManageDskApp::DecomposeArg
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Description : Dcompose les arguments passs en ligne de commande
*
* Rsultat    : /
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
void CManageDskApp::DecomposeArg( char * argc )
{
    char * p;
    BOOL IsDsk = FALSE;

    do
        {
        argc = GetArg( argc );
        if ( argc )
            {
            switch( toupper( * argc++ ) )
                {
                case 'C' :  // Crer dsk
                    FormatDsk( 9, 40 );
                    IsDsk = TRUE;
                    printf( "Cration dsk ok.\n" );
                    break;

                case 'L' :  // Lire Dsk
                    p = Argument( argc );
                    if ( ReadDsk( p ) )
                        {
                        printf( "Lecture fichier %s ok.\n", p );
                        IsDsk = TRUE;
                        }
                    else
                        {
                        printf( "Erreur lecture fichier %s\n", p );
                        IsDsk = FALSE;
                        }
                    break;

                case 'A' :  // Ajouter fichiers sur dsk
                    p = Argument( argc );
                    if ( IsDsk )
                        AjouteFichiers( p );
                    else
                        printf( "Erreur pas de dsk charg.\n" );
                    break;

                case 'S' :  // Sauver dsk
                    p = Argument( argc );
                    if ( IsDsk )
                        {
                        if ( WriteDsk( p ) )
                            printf( "Sauvegarde fichier %s ok.\n", p );
                        else
                            printf( "Erreur criture fichier %s\n", p );
                        }
                    else
                        printf( "Erreur pas de dsk charg.\n" );
                    break;

                default :
                    break;
                }
            }
        }
    while( argc );
}


char * GetUser( int u )
{
    static char User[ 8 ];

    return( itoa( u, User, 10 ) );
}


char * GetType( int Langue, StAmsdos * Ams )
{
    if ( CheckAmsdos( ( BYTE * )Ams ) )
        {
        switch( Ams->FileType )
            {
            case 0 :    // BASIC
                return( GetTexteLoc( 22, Langue ) );

            case 1 :    // BASIC (P)
                return( GetTexteLoc( 23, Langue ) );

            case 2 :    // BINAIRE
                return( GetTexteLoc( 24, Langue ) );

            case 3 :    // BINAIRE (P)
                return( GetTexteLoc( 25, Langue ) );

            default :
                return( GetTexteLoc( 26, Langue ) );
            }
        }
    return( GetTexteLoc( 27, Langue ) );
}


char * GetTaille( int t )
{
    static char Taille[ 16 ];

    wsprintf( Taille, "%d Ko", t );
    return( Taille );
}


char * GetNomAmsdos( BYTE * AmsName )
{
    static char NomAmsdos[ 16 ];

    char * p = NomAmsdos;
    for ( int i = 0; i < 8; i++ )
        if ( * AmsName > ' ' )
            * p++ = * AmsName++;

    while( * AmsName <= '.' && * AmsName )
        AmsName++;

    * p = 0;
    strcat( NomAmsdos, "." );

    for ( i = 0; * AmsName && i < 3; i++ )
        *++p = * AmsName++;

    * ++p = 0;
    i = 0;
    while( NomAmsdos[ i ] )
        NomAmsdos[ i++ ] &= 0x7F;

    return( NomAmsdos );
}
