#ifndef GESTDSK_H
#define GESTDSK_H


#define     USER_DELETED    0xE5


//
// Structure d'une entre AMSDOS
//
typedef struct
    {
    BYTE    UserNumber;             // User
    BYTE    FileName[ 15 ];         // Nom + extension
    BYTE    BlockNum;               // Numro du premier bloc (disquette)
    BYTE    LastBlock;              // Numro du dernier bloc (disquette)
    BYTE    FileType;               // Type de fichier
    USHORT  Length;                 // Longueur
    USHORT  Adress;                 // Adresse
    BYTE    FirstBlock;             // Premier bloc de fichier (disquette)
    USHORT  LogicalLength;          // Longueur logique
    USHORT  EntryAdress;            // Point d'entre
    BYTE    Unused[ 0x24 ];
    USHORT  RealLength;             // Longueur relle
    BYTE    BigLength;              // Longueur relle (3 octets)
    USHORT  CheckSum;               // CheckSum Amsdos
    BYTE    Unused2[ 0x3B ];
    } StAmsdos;


#define SECTSIZE   512


typedef struct
    {
    char        debut[ 0x30 ];  // "MV - CPCEMU Disk-File\r\nDisk-Info\r\n"
    BYTE        NbTracks;
    BYTE        NbHeads;
    short       DataSize;       // 0x1300 = 256 + ( 512 * nbsecteurs )
    BYTE        Unused[ 0xCC ];
    } CPCEMUEnt;


typedef struct
    {
    BYTE        C;              // track
    BYTE        H;              // head
    BYTE        R;              // sect
    BYTE        N;              // size
    short       Un1;
    short       Un2;
    } CPCEMUSect;


typedef struct
    {
    char        ID[ 0x10 ];     // "Track-Info\r\n"
    BYTE        Track;
    BYTE        Head;
    short       Unused;
    BYTE        SectSize;       // 2
    BYTE        NbSect;         // 9
    BYTE        Gap3;           // 0x4E
    BYTE        OctRemp;        // 0xE5
    CPCEMUSect  Sect[ 29 ];
    } CPCEMUTrack;


typedef struct
    {
    BYTE        User;
    BYTE        Nom[ 8 ];
    BYTE        Ext[ 3 ];
    BYTE        NumPage;
    BYTE        Unused[ 2 ];
    BYTE        NbPages;
    BYTE        Blocks[ 16 ];
    } StDirEntry;


enum { ERR_NO_ERR = 0, ERR_NO_DIRENTRY, ERR_NO_BLOCK };


BYTE * ReadBloc( int bloc );

void WriteBloc( int bloc, BYTE * BufBloc );

void WriteSect( int Track, int Sect, BYTE * Buff );

BYTE * ReadSect( int Track, int Sect );

void FormatDsk( int NbSect, int NbTrack );

int CopieFichier( BYTE * BufFile, char * NomFic, int TailleFic );

BOOL WriteDsk( char * NomDsk );

BOOL CheckAmsdos( BYTE * Buf );

BOOL ReadDsk( char * NomFic );

StDirEntry * GetInfoDirEntry( int NumDir );

void SetInfoDirEntry( int NumDir, StDirEntry * Dir );

int FillBitmap( void );

void ClearAmsdos( BYTE * Buf );

StAmsdos * CreeEnteteAmsdos( char * NomFic, USHORT Length );

void SetChecksum( StAmsdos * pEntete );

void SetBuffViewHexa( BYTE * src
                    , char * Hex
                    , char * Ascii
                    , USHORT Offset = 0
                    , BOOL AddOffset = FALSE
                    );


#endif
