#include  <afxwin.h>

#include  "GestDsk.h"


static CPCEMUEnt Infos;

static BYTE ImgDsk[ 1024 * 256 ];

static BYTE Bitmap[ 256 ];


//
// Recherche le plus petit secteur d'une piste
//
static int GetMinSect( void )
{
    int Sect = 0x100;
    CPCEMUTrack * tr = ( CPCEMUTrack * )ImgDsk;
    for ( int s = 0; s < tr->NbSect; s++ )
        if ( Sect > tr->Sect[ s ].R )
            Sect = tr->Sect[ s ].R;

    return( Sect );
}


//
// Retourne la position d'un secteur dans le fichier DSK
//
static int GetPosData( int track, int sect )
{
    int Pos = 0;
    // Recherche position secteur
    CPCEMUTrack * tr = ( CPCEMUTrack * )&ImgDsk[ Pos ];
    Pos = 0x1300 * track + sizeof( * tr );
    
    for ( int s = 0; s < tr->NbSect; s++ )
        {
        if ( tr->Sect[ s ].R == sect )
            break;

        if ( tr->Sect[ s ].Un2 )
            Pos += tr->Sect[ s ].Un2;
        else
            Pos += ( 128 << tr->Sect[ s ].N );
        }
    return( Pos );
}


//
// Recherche un bloc libre et le remplis
//
static int RechercheBlocLibre( void )
{
    for ( int i = 0; i < 256; i++ )
        if ( ! Bitmap[ i ] )
            {
            Bitmap[ i ] = 1;
            return( i );
            }
    return( 0 );
}


//
// Recherche une entre de rpertoire libre
//
static int RechercheDirLibre( void )
{
    for ( int i = 0; i < 64; i++ )
        {
        StDirEntry * Dir = GetInfoDirEntry( i );
        if ( Dir->User == USER_DELETED )
            return( i );
        }
    return( -1 );
}


//
// Lecture d'un bloc AMSDOS (1 block = 2 secteurs)
//
BYTE * ReadBloc( int bloc )
{
    static BYTE BufBloc[ SECTSIZE * 2 ];
    int track = ( bloc << 1 ) / 9;
    int sect = ( bloc << 1 ) % 9;
    int MinSect = GetMinSect();
    if ( MinSect == 0x41 )
        track += 2;

    int Pos = GetPosData( track, sect + MinSect );
    memcpy( BufBloc, &ImgDsk[ Pos ], SECTSIZE );
    if ( ++sect > 8 )
        {
        track++;
        sect = 0;
        }

    Pos = GetPosData( track, sect + MinSect );
    memcpy( &BufBloc[ SECTSIZE ], &ImgDsk[ Pos ], SECTSIZE );
    return( BufBloc );
}


//
// Ecriture d'un bloc AMSDOS (1 block = 2 secteurs)
//
void WriteBloc( int bloc, BYTE BufBloc[ SECTSIZE * 2 ] )
{
    int track = ( bloc << 1 ) / 9;
    int sect = ( bloc << 1 ) % 9;
    int MinSect = GetMinSect();
    if ( MinSect == 0x41 )
        track += 2;

    int Pos = GetPosData( track, sect + MinSect );
    memcpy( &ImgDsk[ Pos ], BufBloc, SECTSIZE );
    if ( ++sect > 8 )
        {
        track++;
        sect = 0;
        }
    Pos = GetPosData( track, sect + MinSect );
    memcpy( &ImgDsk[ Pos ], &BufBloc[ SECTSIZE ], SECTSIZE );
}


//
// Ecriture d'un secteur
//
void WriteSect( int Track, int Sect, BYTE * Buff )
{
    int MinSect = GetMinSect();
    if ( MinSect == 0x41 )
        Track += 2;

    int Pos = GetPosData( Track, Sect + MinSect );
    memcpy( &ImgDsk[ Pos ], Buff, SECTSIZE );
}


//
// Lecture d'un secteur
//
BYTE * ReadSect( int Track, int Sect )
{
    int MinSect = GetMinSect();
    if ( MinSect == 0x41 )
        Track += 2;

    int Pos = GetPosData( Track, Sect + MinSect );
    return( &ImgDsk[ Pos ] );
}


//
// Remplit un "bitmap" pour savoir o il y a des fichiers sur la disquette
// Retourne galement le nombre de Ko utiliss sur la disquette
//
int FillBitmap( void )
{
    int NbKo = 0;

    memset( Bitmap, 0, sizeof( Bitmap ) );
    Bitmap[ 0 ] = Bitmap[ 1 ] = 1;
    for ( int i = 0; i < 64; i++ )
        {
        StDirEntry * Dir = GetInfoDirEntry( i );
        if ( Dir->User != USER_DELETED )
            {
            for ( int j = 0; j < 16; j++ )
                {
                int b = Dir->Blocks[ j ];
                if ( b > 1 && ( ! Bitmap[ b ] ) )
                    {
                    Bitmap[ b ] = 1;
                    NbKo++;
                    }
                }
            }
        }
    return( NbKo );
}


//
// Positionne une entre dans le rpertoire
//
void SetInfoDirEntry( int NumDir, StDirEntry * Dir )
{
    int MinSect = GetMinSect();
    int s = ( NumDir >> 4 ) + MinSect;
    int t = ( MinSect == 0x41 ? 2 : 0 );
    memcpy( &ImgDsk[ ( ( NumDir & 15 ) << 5 ) + GetPosData( t, s ) ]
          , Dir
          , sizeof( StDirEntry )
          );
}


//
// Copie un fichier sur le DSK
//
int CopieFichier( BYTE * BufFile, char * NomFic, int TailleFic )
{
    static StDirEntry DirLoc;
    int NbBlocks = ( TailleFic + 1023 ) >> 10;
    int j, l, Bloc, PosFile, NbPages = 0, PosDir, TaillePage;

    FillBitmap();
    for ( PosFile = 0; PosFile < TailleFic; )
        {
        memset( &DirLoc, 0, sizeof( DirLoc ) );
        memset( DirLoc.Nom, ' ', 8 );
        memset( DirLoc.Ext, ' ', 3 );
        PosDir = RechercheDirLibre();
        if ( PosDir != -1 )
            {
            char * p = strchr( NomFic, '.' );
            if ( p )
                {
                p++;
                memcpy( DirLoc.Nom, NomFic, min( p - NomFic - 1, 8 ) );
                memcpy( DirLoc.Ext, p, min( strlen( p ), 3 ) );
                }
            else
                memcpy( DirLoc.Nom, NomFic, min( strlen( NomFic ), 8 ) );

            for ( int i = 0; i < 11; i++ )
                DirLoc.Nom[ i ] = toupper( DirLoc.Nom[ i ] );

            DirLoc.User = 0;
            DirLoc.NumPage = NbPages++;
            TaillePage = ( ( TailleFic - PosFile ) + 127 ) >> 7;
            if ( TaillePage > 128 )
                TaillePage = 128;

            DirLoc.NbPages = TaillePage;
            l = ( DirLoc.NbPages + 7 ) >> 3;
            for ( j = 0; j < l; j++ )
                {
                Bloc = RechercheBlocLibre();
                if ( Bloc )
                    {
                    DirLoc.Blocks[ j ] = Bloc;
                    WriteBloc( Bloc, &BufFile[ PosFile ] );
                    PosFile += 1024;
                    }
                else
                    return( ERR_NO_BLOCK );
                }
            SetInfoDirEntry( PosDir, &DirLoc );
            }
        else
            return( ERR_NO_DIRENTRY );
        }
    return( ERR_NO_ERR );
}


//
// Retourne une entre du rpertoire
//
StDirEntry * GetInfoDirEntry( int NumDir )
{
    static StDirEntry Dir;
    int MinSect = GetMinSect();
    int s = ( NumDir >> 4 ) + MinSect;
    int t = ( MinSect == 0x41 ? 2 : 0 );
    memcpy( &Dir
          , &ImgDsk[ ( ( NumDir & 15 ) << 5 ) + GetPosData( t, s ) ]
          , sizeof( StDirEntry )
          );
    return( &Dir );
}


//
// Vrifier si DSK est "standard" (DATA ou VENDOR)
//
static BOOL CheckDsk( void )
{
    if ( Infos.NbHeads == 1 )
        {
        int MinSectFirst = GetMinSect();
        if ( MinSectFirst != 0x41 && MinSectFirst != 0xC1 )
            return( FALSE );

        for ( int track = 0; track < Infos.NbTracks; track++ )
            {
            // Recherche position secteur
            int Pos = ( 0x1200+ sizeof( CPCEMUTrack ) ) * track;
            CPCEMUTrack * tr = ( CPCEMUTrack * )&ImgDsk[ Pos ];
    
            int MinSect = 0xFF, MaxSect = 0;
            if ( tr->NbSect != 9 )
                return( FALSE );

            for ( int s = 0; s < tr->NbSect; s++ )
                {
                if ( MinSect > tr->Sect[ s ].R )
                    MinSect = tr->Sect[ s ].R;

                if ( MaxSect < tr->Sect[ s ].R )
                    MaxSect = tr->Sect[ s ].R;
                }
            if ( MaxSect - MinSect != 8 )
                return( FALSE );

            if ( MinSect != MinSectFirst )
                return( FALSE );
            }
        return( TRUE );
        }
    return( FALSE );
}


//
// Lire un fichier DSK
//
BOOL ReadDsk( char * NomFic )
{
    BOOL Ret = FALSE;
    DWORD Lg;

    HANDLE fp = CreateFile( NomFic
                         , GENERIC_READ
                         , 0
                         , NULL
                         , OPEN_EXISTING
                         , 0
                         , NULL
                         );
    if ( fp != INVALID_HANDLE_VALUE )
        {
        ReadFile( fp, &Infos, sizeof( Infos ), &Lg, NULL );
        if (  ! strncmp( Infos.debut, "MV -", 4 )
           || ! strncmp( Infos.debut, "EXTENDED CPC DSK", 16 )
           )
            {
            ReadFile( fp, ImgDsk, sizeof( ImgDsk ), &Lg, NULL );
            Ret = CheckDsk();
            }
        CloseHandle( fp );
        }
    return( Ret );
}


//
// Formatter une disquette
//
void FormatDsk( int NbSect, int NbTrack )
{
    strcpy( Infos.debut, "MV - CPCEMU Disk-File\r\nDisk-Info\r\n" );
    Infos.DataSize = sizeof( CPCEMUTrack ) + 0x200 * NbSect;
    Infos.NbTracks = NbTrack;
    Infos.NbHeads = 1;
    for ( int t = 0; t < NbTrack; t++ )
        {
        CPCEMUTrack * tr = ( CPCEMUTrack * )&ImgDsk[ t * Infos.DataSize ];
        memset( &ImgDsk[ sizeof( CPCEMUTrack ) + ( t * Infos.DataSize ) ]
              , 0xE5
              , 0x200 * NbSect
              );
        strcpy( tr->ID, "Track-Info\r\n" );
        tr->Track = t;
        tr->Head = 0;
        tr->SectSize = 2;
        tr->NbSect = NbSect;
        tr->Gap3 = 0x4E;
        tr->OctRemp = 0xE5;
        int ss = 0;
        //
        // Gestion "entrelacement" des secteurs
        //
        for ( int s = 0; s < NbSect; )
            {
            tr->Sect[ s ].C = t;
            tr->Sect[ s ].H = 0;
            tr->Sect[ s ].R = ss + 0xC1;
            tr->Sect[ s ].N = 2;
            tr->Sect[ s ].Un2 = 0x200;
            ss++;
            if ( ++s < NbSect )
                {
                tr->Sect[ s ].C = t;
                tr->Sect[ s ].H = 0;
                tr->Sect[ s ].R = ss + 0xC5;
                tr->Sect[ s ].N = 2;
                tr->Sect[ s ].Un2 = 0x200;
                s++;
                }
            }
        }
    FillBitmap();
}


//
// Ecriture du fichier DSK
//
BOOL WriteDsk( char * NomDsk )
{
    DWORD Lg;

    HANDLE fp = CreateFile( NomDsk
                         , GENERIC_WRITE
                         , 0
                         , NULL
                         , CREATE_ALWAYS
                         , 0
                         , NULL
                         );
    if ( fp != INVALID_HANDLE_VALUE )
        {
        WriteFile( fp, &Infos, sizeof( Infos ), &Lg, NULL );
        if ( ! Infos.DataSize )
            Infos.DataSize = sizeof( CPCEMUTrack ) + 0x200 * 9;

        WriteFile( fp, ImgDsk, Infos.NbTracks * Infos.DataSize, &Lg, NULL );
        CloseHandle( fp );
        return( TRUE );
        }
    return( FALSE );
}


//
// Vrifie si en-tte AMSDOS est valide
//
BOOL CheckAmsdos( BYTE * Buf )
{
    int i, Checksum = 0;
    BOOL ModeAmsdos = FALSE;
    StAmsdos * pEntete = ( StAmsdos * )Buf;

    for ( i = 0; i < 67; i++ )
        Checksum += Buf[ i ];

    if ( ( pEntete->CheckSum == ( unsigned short )Checksum ) && Checksum )
        ModeAmsdos = TRUE;

    return( ModeAmsdos );
}


//
// Effectue un "nettoyage" de l'en-tte Amsdos :
// remet  zro les octets inutiliss
//
void ClearAmsdos( BYTE * Buf )
{
    if ( CheckAmsdos( Buf ) )
        {
        int i, Checksum = 0;
        BOOL ModeAmsdos = FALSE;
        StAmsdos * pEntete = ( StAmsdos * )Buf;
        memset( pEntete->Unused, 0, sizeof( pEntete->Unused ) );
        memset( pEntete->Unused2, 0, sizeof( pEntete->Unused2 ) );
        for ( i = 0; i < 67; i++ )
            Checksum += Buf[ i ];

        pEntete->CheckSum = Checksum;
        }
}


//
// Cre une en-tte AMSDOS par dfaut
//
StAmsdos * CreeEnteteAmsdos( char * NomFic, USHORT Longueur )
{
    static char NomReel[ 256 ];
    static StAmsdos Entete;
    static char Nom[ 12 ];
    int CheckSum = 0;

    strcpy( NomReel, NomFic );
    memset( &Entete, 0, sizeof( Entete ) );
    memset( Nom, ' ', sizeof( Nom ) );
    char * p = NULL;
    do
        {
        p = strchr( NomReel, '\\' );
        if ( p )
            strcpy( NomReel, ++p );
        }
    while( p );
    p = strchr( NomReel, '.' );
    if ( p )
        * p++ = 0;

    int l = strlen( NomReel );
    if ( l > 8 )
        l = 8;

    for ( int i = 0; i < l; i++ )
        Nom[ i ] = toupper( NomReel[ i ] );

    if ( p )
        for ( i = 0; i < 3; i++ )
            Nom[ i + 8 ] = toupper( p[ i ] );

    memcpy( Entete.FileName, Nom, 11 );
    Entete.Length = Entete.RealLength = Entete.LogicalLength = Longueur;
    Entete.FileType = 2;

    BYTE * pEntete = ( BYTE * )&Entete;
    for ( i = 0; i < 67; i++ )
        CheckSum += * pEntete++;

    Entete.CheckSum = ( USHORT )CheckSum;
    return( &Entete );
}


//
// Calcule et positionne le checksum AMSDOS
//
void SetChecksum( StAmsdos * pEntete )
{
    int i, Checksum = 0;

    BYTE * p = ( BYTE * )pEntete;
    for ( i = 0; i < 67; i++ )
        Checksum += * p++;

    pEntete->CheckSum = ( USHORT )Checksum;
}


//
// Conversion d'un secteur (512 octets) en affichage Hexa et ASCII
//
void SetBuffViewHexa( BYTE * src
                    , char * Hex
                    , char * Ascii
                    , USHORT Offset
                    , BOOL AddOffset
                    )
{
    static char * CodeHexa = "0123456789ABCDEF";
    int q = 0;

    //
    // Parcourir les 512 octets de la source et remplir les buffers
    //
    for ( int i = 0; i < 512; i++ )
        {
        BYTE b = * src++;
        if ( b > 32 && b < 128 )
            Ascii[ i ] = b;
        else
            Ascii[ i ] = '.';

        if ( AddOffset && ( ! ( i & 0x0F ) ) )
            {
            Hex[ q++ ] = '#';
            Hex[ q++ ] = CodeHexa[ Offset >> 12 ];
            Hex[ q++ ] = CodeHexa[ ( Offset >> 8 ) & 0x0F ];
            Hex[ q++ ] = CodeHexa[ ( Offset >> 4 ) & 0x0F ];
            Hex[ q++ ] = CodeHexa[ Offset & 0x0F ];
            Hex[ q++ ] = ':';
            }
        Offset++;
        Hex[ q++ ] = CodeHexa[ b >> 4 ];
        Hex[ q++ ] = CodeHexa[ b & 0x0F ];
        Hex[ q++ ] = ' ';
        }
    Hex[ q ] = 0;
    Ascii[ i ] = 0;
}


