/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class YMC_View
implements Observer {
    private static final String strAboutMessage = "YMCruncher's purpose is to convert AY-3-891X chiptunes to a packed format to be replayed on the Amstrad cpc machines.\nIt can handle YM(2, 3, 3b, 5, 6) and VTX file formats\nThe chiptune will be compressed using the AYC file format originated by OVL\nThis is actually a beta version which will be upgraded soon (with support for Loop/Special Atari FX, etc)\n\nFeel free to give your impressions/requests/congratulations at : F-key/RevivaL : WhaleandHK@hotmail.com";
    private static final long serialVersionUID = 1L;
    private static String strPath = ".\\";
    private YMC_Model model;
    private Display display;
    private Shell shell;
    private ProgressBar pbProgressCrunch;
    private ProgressBar pbProgressSingleCrunch;
    private List lstSourceFiles;
    private Label lblFileProcessed;
    private Group grpList;
    private MenuItem menuItemPath;

    public YMC_View(YMC_Model pmodel) {
        try {
            strPath = new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            System.out.println("Warning ! Cannot set the Current Working Directory");
        }
        this.model = pmodel;
        this.model.addObserver(this);
        this.display = new Display();
        this.shell = new Shell(this.display);
        this.shell.setText("YaMaha Cruncher - Version 0.4");
        Menu menuConf = new Menu(this.shell, 4);
        MenuItem menuItemVerbose = new MenuItem(menuConf, 32);
        menuItemVerbose.setText("&Verbose");
        menuItemVerbose.setSelection(this.model.isVerbose());
        menuItemVerbose.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                YMC_View.this.model.ToggleVerbosity();
            }
        });
        MenuItem menuItemAYC = new MenuItem(menuConf, 32);
        menuItemAYC.setText("&AYC Format");
        menuItemAYC.setSelection(this.model.getCrunchingFormat() == 1);
        menuItemAYC.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (YMC_View.this.model.getCrunchingFormat()) {
                    case 1: {
                        YMC_View.this.model.setFormat((byte)0);
                        break;
                    }
                    default: {
                        YMC_View.this.model.setFormat((byte)1);
                    }
                }
            }
        });
        menuItemAYC.setEnabled(false);
        MenuItem menuItemAYL = new MenuItem(menuConf, 32);
        menuItemAYL.setText("&AYL Format");
        menuItemAYL.setSelection(this.model.getCrunchingFormat() == 2);
        menuItemAYL.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (YMC_View.this.model.getCrunchingFormat()) {
                    case 1: {
                        YMC_View.this.model.setFormat((byte)2);
                        break;
                    }
                    default: {
                        YMC_View.this.model.setFormat((byte)1);
                    }
                }
            }
        });
        menuItemAYL.setEnabled(false);
        this.menuItemPath = new MenuItem(menuConf, 8);
        this.menuItemPath.setText("&Change Destination Folder");
        this.menuItemPath.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectoryDialog dirDialog = new DirectoryDialog(YMC_View.this.shell, 4096);
                dirDialog.setFilterPath(strPath);
                dirDialog.setText("Change Folder Dialog");
                dirDialog.setMessage("Please select a directory");
                String strChangedPath = dirDialog.open();
                if (strChangedPath != null) {
                    strPath = strChangedPath;
                }
            }
        });
        Menu menuMain = new Menu(this.shell, 2);
        MenuItem menuItemConf = new MenuItem(menuMain, 64);
        menuItemConf.setText("&Settings");
        menuItemConf.setMenu(menuConf);
        MenuItem menuItemAbout = new MenuItem(menuMain, 8);
        menuItemAbout.setText("&About");
        menuItemAbout.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MessageBox mb = new MessageBox(YMC_View.this.shell, 32);
                mb.setText("About YMCruncher");
                mb.setMessage(YMC_View.strAboutMessage);
                mb.open();
            }
        });
        RowLayout lytMain = new RowLayout(512);
        lytMain.fill = true;
        this.shell.setLayout(lytMain);
        this.grpList = new Group(this.shell, 0);
        RowLayout lytList = new RowLayout(512);
        lytList.fill = true;
        this.grpList.setLayout(lytList);
        this.grpList.setText("Files to be Crunched");
        Group grpProgressBar = new Group(this.shell, 0);
        grpProgressBar.setLayout(new GridLayout(2, false));
        Label lblFile = new Label(grpProgressBar, 0);
        lblFile.setText("File processed :");
        this.lblFileProcessed = new Label(grpProgressBar, 0);
        this.lblFileProcessed.setText("none");
        Label lblProgressBar = new Label(grpProgressBar, 0);
        lblProgressBar.setText("Current process");
        this.pbProgressSingleCrunch = new ProgressBar(grpProgressBar, 0);
        this.pbProgressSingleCrunch.setMinimum(0);
        this.pbProgressSingleCrunch.setMaximum(100);
        this.pbProgressSingleCrunch.setToolTipText("Progress Bar");
        Label lblProgressCrunch = new Label(grpProgressBar, 0);
        lblProgressCrunch.setText("Overall process");
        this.pbProgressCrunch = new ProgressBar(grpProgressBar, 0);
        this.pbProgressCrunch.setMinimum(0);
        this.pbProgressCrunch.setMaximum(100);
        this.pbProgressCrunch.setToolTipText("Overall Process");
        this.lstSourceFiles = new List(this.grpList, 2818);
        Composite cmpButtons = new Composite(this.grpList, 0);
        RowLayout lytButtons = new RowLayout(256);
        cmpButtons.setLayout(lytButtons);
        Button btnAddFile = new Button(cmpButtons, 8);
        btnAddFile.setText("Add File(s)");
        btnAddFile.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog dialog = new FileDialog(YMC_View.this.shell, 4098);
                dialog.setFilterPath(strPath);
                dialog.open();
                String[] arrFileName = dialog.getFileNames();
                int i = 0;
                while (i < arrFileName.length) {
                    YMC_View.this.lstSourceFiles.add(String.valueOf(dialog.getFilterPath()) + File.separatorChar + arrFileName[i]);
                    ++i;
                }
            }
        });
        Button btnRemFile = new Button(cmpButtons, 8);
        btnRemFile.setText("Remove File(s)");
        btnRemFile.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                YMC_View.this.lstSourceFiles.remove(YMC_View.this.lstSourceFiles.getSelectionIndices());
            }
        });
        Button btnCrunchEntireList = new Button(cmpButtons, 8);
        btnCrunchEntireList.setText("Crunch Entire List");
        Listener doCrunchEntireListListener = new Listener(){

            public void handleEvent(Event event) {
                String[] arrFileName = YMC_View.this.lstSourceFiles.getItems();
                ProcessCrunch process = new ProcessCrunch(arrFileName);
                process.start();
            }
        };
        btnCrunchEntireList.addListener(13, doCrunchEntireListListener);
        this.shell.setMenuBar(menuMain);
        this.shell.pack();
    }

    private void forceDisplay(Control control) {
        control.pack();
        control.redraw();
        control.update();
    }

    public void displayWindow() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.display.dispose();
    }

    public void update(Observable o, Object arg) {
        final int ratio = this.model.getCompletionRatio();
        if (this.display.isDisposed()) {
            return;
        }
        this.display.asyncExec(new Runnable(){

            public void run() {
                if (YMC_View.this.pbProgressSingleCrunch.isDisposed()) {
                    return;
                }
                YMC_View.this.pbProgressSingleCrunch.setSelection(ratio);
            }
        });
    }

    class ProcessCrunch
    extends Thread {
        private String[] arrFileName;

        public ProcessCrunch(String[] arrParamFileName) {
            this.arrFileName = arrParamFileName;
        }

        private void updateProgressBar(final int intValue) {
            if (YMC_View.this.display.isDisposed()) {
                return;
            }
            YMC_View.this.display.asyncExec(new Runnable(){

                public void run() {
                    if (YMC_View.this.pbProgressCrunch.isDisposed()) {
                        return;
                    }
                    YMC_View.this.pbProgressCrunch.setSelection(intValue);
                }
            });
        }

        private void resetProgressSingleBar() {
            if (YMC_View.this.display.isDisposed()) {
                return;
            }
            YMC_View.this.display.asyncExec(new Runnable(){

                public void run() {
                    if (YMC_View.this.pbProgressSingleCrunch.isDisposed()) {
                        return;
                    }
                    YMC_View.this.pbProgressSingleCrunch.setSelection(0);
                }
            });
        }

        private void updateLabel(final String strFileName) {
            if (YMC_View.this.display.isDisposed()) {
                return;
            }
            YMC_View.this.display.asyncExec(new Runnable(){

                public void run() {
                    if (YMC_View.this.pbProgressCrunch.isDisposed()) {
                        return;
                    }
                    YMC_View.this.lblFileProcessed.setText(strFileName);
                    YMC_View.this.forceDisplay(YMC_View.this.lblFileProcessed);
                }
            });
        }

        private void enableButtons(final boolean blnEnabled) {
            if (YMC_View.this.display.isDisposed()) {
                return;
            }
            YMC_View.this.display.asyncExec(new Runnable(){

                public void run() {
                    if (YMC_View.this.grpList.isDisposed() || YMC_View.this.menuItemPath.isDisposed()) {
                        return;
                    }
                    YMC_View.this.grpList.setEnabled(blnEnabled);
                    YMC_View.this.menuItemPath.setEnabled(blnEnabled);
                }
            });
        }

        public void run() {
            this.enableButtons(false);
            int i = 0;
            while (i < this.arrFileName.length) {
                if (YMC_View.this.shell.isDisposed()) break;
                String strFileName = this.arrFileName[i];
                String strREFileNameOnly = "^.*\\" + File.separatorChar;
                String strFileNameOnly = strFileName.replaceFirst(strREFileNameOnly, "");
                String strFileNameOnlyWithoutExt = strFileNameOnly.replaceFirst("\\.[^\\.]*$", "");
                this.updateLabel(strFileNameOnly);
                YMC_View.this.model.doCrunch(strFileName, String.valueOf(strPath) + File.separatorChar + strFileNameOnlyWithoutExt);
                this.resetProgressSingleBar();
                int intProgress = (i + 1) * 100 / this.arrFileName.length;
                this.updateProgressBar(intProgress);
                ++i;
            }
            this.updateLabel("finished.");
            this.updateProgressBar(0);
            this.enableButtons(true);
        }
    }
}

