/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Vector;
import lha.LhaEntry;
import lha.LhaException;
import lha.LhaFile;
import lha.LhaInputStream;

public class YMC_Model
extends Observable {
    private static final int[] mfpPrediv;
    private static final long MFP_CLOCK = 2457600L;
    private static final long YM_ATARI_FREQUENCY = 2000000L;
    private static final long YM_CPC_FREQUENCY = 1000000L;
    public static final String strApplicationName = "YaMaha Cruncher - Version 0.4";
    public static final byte[] header;
    public static final byte staticNbRegister = 14;
    public static final byte staticFrequency = 50;
    public static final byte FORMAT_YMC = 0;
    public static final byte FORMAT_AYC = 1;
    public static final byte FORMAT_AYL = 2;
    private int curr_register = 0;
    private byte bytFormat = 1;
    private long lngChipFrequency = 1000000L;
    private boolean blnVerbose = false;
    StringBuffer str_debug;

    static {
        int[] nArray = new int[8];
        nArray[1] = 4;
        nArray[2] = 10;
        nArray[3] = 16;
        nArray[4] = 50;
        nArray[5] = 64;
        nArray[6] = 100;
        nArray[7] = 200;
        mfpPrediv = nArray;
        header = new byte[]{89, 77, 67, 2};
    }

    public YMC_Model(boolean blnParamVerbose) {
        this.debug(strApplicationName);
        this.blnVerbose = blnParamVerbose;
    }

    private void info(String strMsg) {
        this.str_debug.append(strMsg);
        this.str_debug.append("\r\n");
    }

    private void debug(String strMsg) {
        if (this.blnVerbose) {
            this.info(strMsg);
        }
    }

    public void ToggleVerbosity() {
        this.blnVerbose = !this.blnVerbose;
    }

    public boolean isVerbose() {
        return this.blnVerbose;
    }

    private Short getLEByte(Vector arrVect, int intOffset) {
        short b0 = (short)((short)((Byte)arrVect.elementAt(intOffset)).byteValue() & 0xFF);
        return new Short(b0);
    }

    private Integer getLEShort(Vector arrVect, int intOffset) {
        int b1 = ((Byte)arrVect.elementAt(intOffset + 1) & 0xFF) << 8;
        int b0 = (Byte)arrVect.elementAt(intOffset) & 0xFF;
        int intValue = b0 + b1;
        return new Integer(intValue);
    }

    private Long getLEInt(Vector arrVect, int intOffset) {
        long b3 = ((long)((Byte)arrVect.elementAt(intOffset + 3)).byteValue() & 0xFFL) << 24;
        long b2 = ((long)((Byte)arrVect.elementAt(intOffset + 2)).byteValue() & 0xFFL) << 16;
        long b1 = ((long)((Byte)arrVect.elementAt(intOffset + 1)).byteValue() & 0xFFL) << 8;
        long b0 = (long)((Byte)arrVect.elementAt(intOffset)).byteValue() & 0xFFL;
        long lngValue = b0 + b1 + b2 + b3;
        return new Long(lngValue);
    }

    private Integer getBEShort(Vector arrVect, int intOffset) {
        int b0 = (Byte)arrVect.elementAt(intOffset + 1) & 0xFF;
        int b1 = ((Byte)arrVect.elementAt(intOffset) & 0xFF) << 8;
        int intValue = b0 + b1;
        return new Integer(intValue);
    }

    private Long getBEInt(Vector arrVect, int intOffset) {
        long b0 = (long)((Byte)arrVect.elementAt(intOffset + 3)).byteValue() & 0xFFL;
        long b1 = ((long)((Byte)arrVect.elementAt(intOffset + 2)).byteValue() & 0xFFL) << 8;
        long b2 = ((long)((Byte)arrVect.elementAt(intOffset + 1)).byteValue() & 0xFFL) << 16;
        long b3 = ((long)((Byte)arrVect.elementAt(intOffset)).byteValue() & 0xFFL) << 24;
        long lngValue = b0 + b1 + b2 + b3;
        return new Long(lngValue);
    }

    private String getNTString(Vector arrVect, int intOffset, boolean blnStopAtNextChar) {
        boolean blnNullPassed = false;
        StringBuffer sb = new StringBuffer();
        do {
            char c;
            if ((c = (char)((Byte)arrVect.elementAt(intOffset++)).byteValue()) == '\u0000') {
                char d;
                blnNullPassed = true;
                if (!blnStopAtNextChar) continue;
                do {
                    if ((d = (char)((Byte)arrVect.elementAt(intOffset++)).byteValue()) != '\u0000') continue;
                    sb.append(c);
                } while ((c = d) == '\u0000');
                continue;
            }
            sb.append(c);
        } while (intOffset < arrVect.size() && !blnNullPassed);
        return new String(sb);
    }

    private String getString(Vector arrVect, int intOffset, int intLength) {
        byte[] arrByte = new byte[intLength];
        int i = 0;
        while (i < intLength) {
            arrByte[i] = (Byte)arrVect.elementAt(intOffset + i);
            ++i;
        }
        return new String(arrByte);
    }

    private Vector getData(Vector arrRawChiptune) {
        String strFileType = this.getString(arrRawChiptune, 0, 4);
        this.debug("+ File Type = " + strFileType);
        Long intFrequency = new Long(0L);
        byte[][] arrDigiDrums = null;
        int intNbRegisters = 14;
        boolean blnDDIs4bits = false;
        if (strFileType.subSequence(0, 2).equals("ay") || strFileType.subSequence(0, 2).equals("ym")) {
            ByteArrayInputStream arrBytesIS;
            Short bytPlayingMode = this.getLEByte(arrRawChiptune, 2);
            Integer shtLoopVBL = this.getLEShort(arrRawChiptune, 3);
            intFrequency = this.getLEInt(arrRawChiptune, 5);
            Short bytPlayerfrequency = this.getLEByte(arrRawChiptune, 9);
            Integer shtCreationDate = this.getLEShort(arrRawChiptune, 10);
            Long intPackedDataSize = this.getLEInt(arrRawChiptune, 12);
            this.info("+ Playing Mode = 0x" + Long.toHexString(bytPlayingMode.longValue()).toUpperCase());
            this.info("+ Loop VBL = 0x" + Long.toHexString(shtLoopVBL.longValue()).toUpperCase());
            this.info("+ Chip Frequency = " + intFrequency + "Hz");
            this.info("+ Player Frequency = " + bytPlayerfrequency + "Hz");
            this.info("+ Creation Date = " + shtCreationDate);
            this.info("+ Size of Packed Data = 0x" + Long.toHexString(intPackedDataSize).toUpperCase());
            int intOffset = 16;
            String strSongName = this.getNTString(arrRawChiptune, intOffset, false);
            String strAuthorName = this.getNTString(arrRawChiptune, intOffset += strSongName.length() + 1, false);
            String strEditor = this.getNTString(arrRawChiptune, intOffset += strAuthorName.length() + 1, false);
            String strSourceProgram = this.getNTString(arrRawChiptune, intOffset += strEditor.length() + 1, false);
            String strComments = this.getNTString(arrRawChiptune, intOffset += strSourceProgram.length() + 1, false);
            this.info("+ Song Name = " + strSongName);
            this.info("+ Author = " + strAuthorName);
            this.info("+ Source Program = " + strSourceProgram);
            this.info("+ Editor Name = " + strEditor);
            this.info("+ Comments = " + strComments);
            arrRawChiptune = new Vector(arrRawChiptune.subList(intOffset += strComments.length() + 1, arrRawChiptune.size()));
            byte[] byArray = new byte[33];
            byArray[0] = 31;
            byArray[2] = 45;
            byArray[3] = 108;
            byArray[4] = 104;
            byArray[5] = 53;
            byArray[6] = 45;
            byArray[21] = 9;
            byArray[22] = 86;
            byArray[23] = 84;
            byArray[24] = 88;
            byArray[25] = 70;
            byArray[26] = 73;
            byArray[27] = 76;
            byArray[28] = 69;
            byArray[30] = 83;
            byte[] arrBytesHeader = byArray;
            arrBytesHeader[7] = (byte)(arrRawChiptune.size() & 0xFF);
            arrBytesHeader[8] = (byte)((arrRawChiptune.size() & 0xFF00) >> 8);
            arrBytesHeader[9] = (byte)((arrRawChiptune.size() & 0xFF0000) >> 16);
            arrBytesHeader[10] = (byte)((arrRawChiptune.size() & 0xFF000000) >> 24);
            arrBytesHeader[11] = (byte)(intPackedDataSize.intValue() & 0xFF);
            arrBytesHeader[12] = (byte)((intPackedDataSize.intValue() & 0xFF00) >> 8);
            arrBytesHeader[13] = (byte)((intPackedDataSize.intValue() & 0xFF0000) >> 16);
            arrBytesHeader[14] = (byte)((intPackedDataSize.intValue() & 0xFF000000) >> 24);
            byte[] arrBytes = new byte[arrRawChiptune.size() + arrBytesHeader.length + 1];
            int b = 0;
            while (b < arrBytesHeader.length) {
                arrBytes[b] = arrBytesHeader[b];
                b = (byte)(b + 1);
            }
            int i = 0;
            while (i < arrRawChiptune.size()) {
                arrBytes[i + arrBytesHeader.length] = (Byte)arrRawChiptune.elementAt(i);
                ++i;
            }
            arrBytes[arrBytes.length - 1] = 0;
            byte bytHeaderChecksum = 0;
            int b2 = 2;
            while (b2 < arrBytesHeader.length) {
                bytHeaderChecksum = (byte)(bytHeaderChecksum + arrBytes[b2]);
                b2 = (byte)(b2 + 1);
            }
            arrBytes[1] = bytHeaderChecksum;
            ByteArrayInputStream in = arrBytesIS = new ByteArrayInputStream(arrBytes);
            LhaInputStream lhaInp = new LhaInputStream(in);
            try {
                LhaEntry lhaCompressedEntry = lhaInp.getNextEntry();
                lhaCompressedEntry.setOffset(33L);
                this.debug("+ Entry = " + lhaCompressedEntry);
                Vector<Byte> arrData = new Vector<Byte>();
                arrData.addElement(new Byte(89));
                arrData.addElement(new Byte(77));
                arrData.addElement(new Byte(51));
                arrData.addElement(new Byte(33));
                FileOutputStream tmpFile = new FileOutputStream("VTXFILE.LHA");
                tmpFile.write(arrBytes);
                tmpFile.close();
                File inpFile = new File("VTXFILE.LHA");
                LhaFile inpLhaFile = new LhaFile(inpFile);
                InputStream inputStreamEntry = inpLhaFile.getInputStream(lhaCompressedEntry);
                int intBytesRead = 0;
                while (inputStreamEntry.available() > 0 && (long)intBytesRead++ < lhaCompressedEntry.getOriginalSize()) {
                    Byte byte_read = new Byte((byte)inputStreamEntry.read());
                    arrData.addElement(byte_read);
                }
                inpLhaFile.close();
                inpFile.delete();
                arrRawChiptune = this.getData(arrData);
                return arrRawChiptune;
            }
            catch (LhaException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (strFileType.equals("YM2!") || strFileType.equals("YM3!")) {
            intFrequency = new Long(2000000L);
            arrRawChiptune = new Vector(arrRawChiptune.subList(4, arrRawChiptune.size()));
        } else if (strFileType.equals("YM3b")) {
            intFrequency = new Long(2000000L);
            arrRawChiptune = new Vector(arrRawChiptune.subList(4, arrRawChiptune.size() - 4));
        } else if (strFileType.equals("YM5!") || strFileType.equals("YM6!")) {
            intNbRegisters = 16;
            Long intVBL = this.getBEInt(arrRawChiptune, 12);
            Long intAttributes = this.getBEInt(arrRawChiptune, 16);
            Integer shtDigiDrum = this.getBEShort(arrRawChiptune, 20);
            intFrequency = this.getBEInt(arrRawChiptune, 22);
            Integer shtPlayerFrequency = this.getBEShort(arrRawChiptune, 26);
            Long intLoopVBL = this.getBEInt(arrRawChiptune, 28);
            this.info("+ VBL = 0x" + Long.toHexString(intVBL).toUpperCase() + " (~" + intVBL / 50L + " seconds)");
            this.info("+ Attributes = 0x" + Long.toHexString(intAttributes).toUpperCase());
            this.info("+ Number of DigiDrum = " + shtDigiDrum);
            this.info("+ Frequency = " + intFrequency + " Hz");
            this.info("+ Player Frequency = " + shtPlayerFrequency + " Hz");
            this.info("+ Loop VBL = " + Long.toHexString(intLoopVBL).toUpperCase());
            int intOffset = 34;
            arrDigiDrums = new byte[shtDigiDrum.intValue()][];
            int i = 0;
            while (i < shtDigiDrum) {
                Long intSizeDD = this.getBEInt(arrRawChiptune, intOffset);
                intOffset += 4;
                byte[] arrDigi = new byte[intSizeDD.intValue()];
                int j = 0;
                while ((long)j < intSizeDD) {
                    byte bDD;
                    arrDigi[j] = bDD = ((Byte)arrRawChiptune.elementAt(intOffset++)).byteValue();
                    ++j;
                }
                arrDigiDrums[i] = arrDigi;
                this.debug("- DigiDrums (" + i + ") size = " + intSizeDD);
                ++i;
            }
            String strSongName = this.getNTString(arrRawChiptune, intOffset, false);
            String strAuthorName = this.getNTString(arrRawChiptune, intOffset += strSongName.length() + 1, false);
            String strComments = this.getNTString(arrRawChiptune, intOffset += strAuthorName.length() + 1, false);
            this.info("+ Song Name = " + strSongName);
            this.info("+ Author = " + strAuthorName);
            this.info("+ Comments = " + strComments);
            intOffset += strComments.length() + 1;
            int intTailer = 0;
            if (this.getString(arrRawChiptune, arrRawChiptune.size() - 4, 4).equals("End!")) {
                intTailer = 4;
            }
            arrRawChiptune = new Vector(arrRawChiptune.subList(intOffset, arrRawChiptune.size() - intTailer));
            if ((intAttributes & 1L) != 1L) {
                Vector arrUninterleavedRawChiptune = new Vector();
                int reg = 0;
                while (reg < intNbRegisters) {
                    int i2 = 0;
                    while ((long)i2 < intVBL) {
                        arrUninterleavedRawChiptune.add(arrRawChiptune.elementAt(i2 + reg));
                        ++i2;
                    }
                    ++reg;
                }
                arrRawChiptune = arrUninterleavedRawChiptune;
            }
        } else {
            System.out.println("Unsupported file type" + strFileType);
            return null;
        }
        int intFileSize = arrRawChiptune.size();
        int intPeriode = intFileSize / intNbRegisters;
        int intDuration = intPeriode / 50;
        this.debug("+ File Informations");
        this.debug("  - File size : " + intFileSize + " bytes.");
        this.debug("  - Notes number : " + intPeriode);
        this.debug("  - Time : " + intDuration + " secondes.");
        Vector arrRawRegister = new Vector();
        this.curr_register = 0;
        while (this.curr_register < intNbRegisters) {
            int intStartValues = this.curr_register * intPeriode;
            int intEndValues = intStartValues + intPeriode - 1;
            Vector arrRawData = new Vector();
            int j = intStartValues;
            while (j <= intEndValues) {
                arrRawData.add(arrRawChiptune.elementAt(j));
                ++j;
            }
            arrRawRegister.addElement(arrRawData);
            ++this.curr_register;
        }
        DigiDrums digidrums = null;
        if (arrDigiDrums != null) {
            digidrums = new DigiDrums(arrDigiDrums, blnDDIs4bits);
        }
        arrRawRegister = this.getConvertedFrequencyData(arrRawRegister, strFileType, intFrequency, digidrums);
        return arrRawRegister;
    }

    private Vector getData(String strSourceFile) {
        this.info("# File Name: " + strSourceFile);
        Vector<Byte> arrData = new Vector<Byte>();
        if (this.blnIsCompressed(strSourceFile)) {
            try {
                LhaFile inpLhaFile = new LhaFile(strSourceFile);
                Enumeration e = inpLhaFile.entries();
                while (e.hasMoreElements()) {
                    LhaEntry entry = (LhaEntry)e.nextElement();
                    InputStream in = inpLhaFile.getInputStream(entry);
                    while (in.available() > 0) {
                        Byte byte_read = new Byte((byte)in.read());
                        arrData.addElement(byte_read);
                    }
                }
                inpLhaFile.close();
            }
            catch (LhaException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            FileInputStream file_input = new FileInputStream(strSourceFile);
            DataInputStream data_in = new DataInputStream(file_input);
            boolean endoffile = false;
            while (!endoffile) {
                try {
                    arrData.add(new Byte(data_in.readByte()));
                }
                catch (EOFException eof) {
                    endoffile = true;
                }
            }
            data_in.close();
            file_input.close();
        }
        catch (IOException e) {
            System.out.println(e);
            return null;
        }
        return this.getData(arrData);
    }

    private boolean blnIsCompressed(String strSourceFile) {
        return this.getFileType(strSourceFile, 2, 5).equals("-lh5-");
    }

    private String getFileType(String strSourceFile, int intOffset, int intNbBytes) {
        byte[] arrType = new byte[intNbBytes];
        try {
            RandomAccessFile file_input = new RandomAccessFile(strSourceFile, "r");
            try {
                file_input.seek(intOffset);
                file_input.read(arrType);
            }
            catch (EOFException eof) {
                System.out.println(eof);
                System.exit(-1);
            }
            file_input.close();
        }
        catch (IOException e) {
            System.out.println(e);
            System.exit(-1);
        }
        String strHeader = new String(arrType);
        return strHeader;
    }

    public void doCrunch(String source, String destination) {
        this.str_debug = new StringBuffer();
        Vector arrRawRegister = this.getData(source);
        Vector<Byte> arrBuffLen = new Vector<Byte>();
        if (arrRawRegister != null) {
            Vector arrCrunchedRegister;
            int intPeriode = ((Vector)arrRawRegister.elementAt(0)).size();
            switch (this.getCrunchingFormat()) {
                case 2: {
                    Cruncher crunch_engine = new Cruncher(arrRawRegister, this.blnVerbose);
                    arrCrunchedRegister = crunch_engine.doAYLCrunch(intPeriode);
                    break;
                }
                default: {
                    arrCrunchedRegister = new Vector();
                    int intRawSize = intPeriode * arrRawRegister.size();
                    int sum = 0;
                    this.curr_register = 0;
                    while (this.curr_register < 14) {
                        this.debug("+ Process Register " + this.curr_register);
                        Vector arrRawData = (Vector)arrRawRegister.elementAt(this.curr_register);
                        Cruncher crunch_engine = new Cruncher(arrRawData, this.blnVerbose);
                        Vector arrCrunchedData = crunch_engine.doCrunch(this.bytFormat, 256);
                        switch (this.getCrunchingFormat()) {
                            case 1: {
                                Vector arrCrunchedData400 = crunch_engine.doCrunch(this.bytFormat, 1024);
                                byte bytBuffLen = 1;
                                if (arrCrunchedData400.size() + 768 < arrCrunchedData.size()) {
                                    arrCrunchedData = arrCrunchedData400;
                                    bytBuffLen = 4;
                                }
                                arrBuffLen.add(new Byte(bytBuffLen));
                            }
                        }
                        this.debug(crunch_engine.getDebugMsg());
                        arrCrunchedRegister.addElement(arrCrunchedData);
                        sum += arrCrunchedData.size();
                        this.setChanged();
                        this.notifyObservers();
                        System.out.print("#");
                        ++this.curr_register;
                    }
                    this.debug("+ Total Raw Size = " + intRawSize + " bytes");
                    this.debug("+ Total Compressed Size = " + sum + " bytes");
                    this.info("+ Compression ratio ~ " + (float)sum * 100.0f / (float)intRawSize + " %");
                }
            }
            try {
                FileOutputStream file_output;
                switch (this.bytFormat) {
                    case 2: {
                        destination = String.valueOf(destination) + ".ayl";
                        file_output = new FileOutputStream(destination);
                        this.writeAYL(file_output, arrCrunchedRegister, intPeriode);
                        break;
                    }
                    case 1: {
                        destination = String.valueOf(destination) + ".ayc";
                        file_output = new FileOutputStream(destination);
                        this.writeAYC(file_output, arrCrunchedRegister, intPeriode, arrBuffLen);
                        break;
                    }
                    default: {
                        destination = String.valueOf(destination) + ".ymc";
                        file_output = new FileOutputStream(destination);
                        this.writeYMC(file_output, arrCrunchedRegister, intPeriode);
                    }
                }
                file_output.close();
                System.out.println(" " + destination);
                FileWriter log_output = new FileWriter(String.valueOf(destination) + ".txt", false);
                log_output.write(this.str_debug.toString());
                log_output.close();
            }
            catch (IOException e) {
                System.out.println(e);
                System.exit(-1);
            }
        }
    }

    private Vector getConvertedFrequencyData(Vector arrRawRegister, String strFileType, long lngOrigFrequency, DigiDrums digidrums) {
        int intNbRegisters = arrRawRegister.size();
        int intVBL = ((Vector)arrRawRegister.elementAt(0)).size();
        byte[] arrRegs = new byte[intNbRegisters];
        int currVBL = 0;
        while (currVBL < intVBL) {
            byte byteConverted;
            int reg = 0;
            while (reg < intNbRegisters) {
                Vector vecReg = (Vector)arrRawRegister.elementAt(reg);
                arrRegs[reg] = (Byte)vecReg.elementAt(currVBL);
                reg = (byte)(reg + 1);
            }
            if (strFileType.equals("YM2!")) {
                if (arrRegs[13] != -1) {
                    arrRegs[12] = 0;
                    arrRegs[13] = 10;
                }
                if ((arrRegs[10] & 0x80) != 0) {
                    arrRegs[7] = (byte)(arrRegs[7] | 0x24);
                    int sampleNum = arrRegs[10] & 0x7F;
                    if (arrRegs[12] != 0) {
                        long vecReg = 2457600L / (long)arrRegs[12];
                    }
                }
            } else if (strFileType.equals("YM5!") || strFileType.equals("YM6!")) {
                if (strFileType.equals("YM6!")) {
                    this.readYm6Effect(arrRegs, digidrums, 1, 6, 14);
                    this.readYm6Effect(arrRegs, digidrums, 3, 8, 15);
                } else if (strFileType.equals("YM5!")) {
                    int voice;
                    int ndrum;
                    int code = arrRegs[1] >> 4 & 3;
                    if (code != 0) {
                        int voice2 = code - 1;
                        int prediv = mfpPrediv[arrRegs[6] >> 5 & 7];
                        long tmpFreq = 0L;
                        if ((prediv *= arrRegs[14]) != 0) {
                            tmpFreq = 2457600L / (long)prediv;
                            System.out.println("+ Sid Sound");
                            System.out.println("- Voice : " + voice2);
                            System.out.println("- VMax : " + (arrRegs[voice2 + 8] & 0xF));
                            System.out.println("- Frequency : " + tmpFreq);
                        }
                    }
                    if ((code = arrRegs[3] >> 4 & 3) != 0 && (ndrum = arrRegs[8 + (voice = code - 1)] & 0x1F) >= 0 && ndrum < digidrums.getNumberOfDrums()) {
                        int prediv = mfpPrediv[arrRegs[8] >> 5 & 7];
                        if ((prediv *= arrRegs[15]) != 0) {
                            long sampleFrq = 2457600L / (long)prediv;
                            System.out.println("+ DigiDrum");
                            System.out.println("- Voice : " + voice);
                            System.out.println("- Sample : " + ndrum);
                            System.out.println("- Frequency : " + sampleFrq);
                        }
                    }
                }
            }
            int b = 0;
            while (b < 3) {
                byte byteConvertedL;
                long byteH = arrRegs[2 * b + 1];
                long byteL = arrRegs[2 * b];
                long lngH = byteH & 0xFL;
                long lngL = byteL & 0xFFL;
                long lngValue = (lngH << 8) + lngL;
                long lngConvertedValue = lngValue * this.lngChipFrequency / lngOrigFrequency;
                byte byteConvertedH = (byte)(lngConvertedValue >> 8 & 0xFL);
                arrRegs[2 * b] = byteConvertedL = (byte)(lngConvertedValue & 0xFFL);
                arrRegs[2 * b + 1] = byteConvertedH;
                b = (byte)(b + 1);
            }
            long byteL = arrRegs[6];
            long lngValue = byteL & 0x1FL;
            long lngConvertedValue = lngValue * this.lngChipFrequency / lngOrigFrequency;
            arrRegs[6] = byteConverted = (byte)(lngConvertedValue & 0x1FL);
            byte byte7 = arrRegs[7];
            arrRegs[7] = byteConverted = (byte)(byte7 & 0x3F);
            int b2 = 0;
            while (b2 < 3) {
                byte byte89A = arrRegs[8 + b2];
                arrRegs[8 + b2] = byteConverted = (byte)(byte89A & 0x1F);
                b2 = (byte)(b2 + 1);
            }
            long byte12 = arrRegs[12];
            long byte11 = arrRegs[11];
            long lngH = byte12 & 0xFFL;
            long lngL = byte11 & 0xFFL;
            lngValue = (lngH << 8) + lngL;
            lngConvertedValue = lngValue * this.lngChipFrequency / lngOrigFrequency;
            byte byteConvertedH = (byte)(lngConvertedValue >> 8 & 0xFFL);
            byte byteConvertedL = (byte)(lngConvertedValue & 0xFFL);
            arrRegs[12] = byteConvertedH;
            arrRegs[11] = byteConvertedL;
            int reg2 = 0;
            while (reg2 < 14) {
                Vector vecReg = (Vector)arrRawRegister.elementAt(reg2);
                vecReg.setElementAt(new Byte(arrRegs[reg2]), currVBL);
                reg2 = (byte)(reg2 + 1);
            }
            ++currVBL;
        }
        return arrRawRegister;
    }

    private void readYm6Effect(byte[] pReg, DigiDrums digidrums, int code, int prediv, int count) {
        code = (byte)(pReg[code] & 0xF0);
        prediv = pReg[prediv] >> 5 & 7;
        count = pReg[count];
        if ((code & 0x30) != 0) {
            int voice = ((code & 0x30) >> 4) - 1;
            switch (code & 0xC0) {
                case 0: 
                case 128: {
                    prediv = mfpPrediv[prediv];
                    long tmpFreq = 0L;
                    if ((prediv *= count) == 0) break;
                    tmpFreq = 2457600L / (long)prediv;
                    if ((code & 0xC0) == 0) {
                        System.out.println("Sid Sound : " + tmpFreq + ", " + (pReg[voice + 8] & 0xF));
                        break;
                    }
                    System.out.println("Sinus Sid : " + tmpFreq + ", " + (pReg[voice + 8] & 0xF));
                    break;
                }
                case 64: {
                    int ndrum = pReg[voice + 8] & 0x1F;
                    if (ndrum < 0) break;
                    prediv = mfpPrediv[prediv];
                    if ((prediv *= count) <= 0) break;
                    long tmpFreq = 2457600L / (long)prediv;
                    System.out.println("DigiDrum : " + tmpFreq + ", " + ndrum);
                    break;
                }
                case 192: {
                    prediv = mfpPrediv[prediv];
                    long tmpFreq = 0L;
                    if ((prediv *= count) == 0) break;
                    tmpFreq = 2457600L / (long)prediv;
                    System.out.println("Sync-Buzzer : " + tmpFreq + ", " + (pReg[voice + 8] & 0xF));
                }
            }
        }
    }

    private void writeAYL(FileOutputStream file_output, Vector arrCrunchedRegister, int intPeriode) throws IOException {
        System.out.println("Warning : AYL format to be Tested");
        int i = 0;
        while (i < arrCrunchedRegister.size()) {
            byte data = (Byte)arrCrunchedRegister.elementAt(i);
            file_output.write(data);
            ++i;
        }
    }

    private void writeAYC(FileOutputStream file_output, Vector arrCrunchedRegister, int intPeriode, Vector arrBuffSize) throws IOException {
        Vector arrData;
        file_output.write(intPeriode & 0xFF);
        file_output.write((intPeriode & 0xFF00) >> 8);
        int offsetBase = 4;
        int offsetPhysical = 50;
        int offset = offsetPhysical - offsetBase;
        file_output.write(((Byte)arrBuffSize.elementAt(0)).byteValue());
        file_output.write(offset & 0xFF);
        file_output.write((offset & 0xFF00) >> 8);
        this.debug("! Offset Register 0 = " + Long.toHexString(offsetPhysical) + "(" + Long.toHexString(offset) + ")");
        int i = 1;
        while (i < arrCrunchedRegister.size()) {
            arrData = (Vector)arrCrunchedRegister.elementAt(i - 1);
            offset = (offsetPhysical += arrData.size()) - (offsetBase += 3);
            file_output.write(((Byte)arrBuffSize.elementAt(i)).byteValue());
            file_output.write(offset & 0xFF);
            file_output.write((offset & 0xFF00) >> 8);
            this.debug("! Offset Register " + i + " = " + Long.toHexString(offsetPhysical) + "(" + Long.toHexString(offset) + ")");
            ++i;
        }
        int b = 0;
        while (b < 6) {
            file_output.write(255);
            b = (byte)(b + 1);
        }
        i = 0;
        while (i < arrCrunchedRegister.size()) {
            arrData = (Vector)arrCrunchedRegister.elementAt(i);
            int j = 0;
            while (j < arrData.size()) {
                byte data = (Byte)arrData.elementAt(j);
                file_output.write(data);
                ++j;
            }
            ++i;
        }
    }

    private void writeYMC(FileOutputStream file_output, Vector arrCrunchedRegister, int intPeriode) throws IOException {
        Vector arrData;
        file_output.write(header);
        file_output.write(intPeriode & 0xFF);
        file_output.write((intPeriode & 0xFF00) >> 8);
        file_output.write(new byte[]{70, 75, 47, 82, 101, 118, 105, 118, 97, 76});
        int offset = 48;
        file_output.write(offset & 0xFF);
        file_output.write((offset & 0xFF00) >> 8);
        int i = 0;
        while (i < arrCrunchedRegister.size() - 1) {
            arrData = (Vector)arrCrunchedRegister.elementAt(i);
            file_output.write((offset += arrData.size()) & 0xFF);
            file_output.write((offset & 0xFF00) >> 8);
            ++i;
        }
        file_output.write(new byte[4]);
        i = 0;
        while (i < arrCrunchedRegister.size()) {
            arrData = (Vector)arrCrunchedRegister.elementAt(i);
            int j = 0;
            while (j < arrData.size()) {
                byte data;
                Object obj_data = arrData.elementAt(j);
                if (obj_data.getClass() == Integer.class) {
                    data = (byte)(-((Integer)arrData.elementAt(j++)).intValue());
                    file_output.write(data);
                    data = (byte)((Integer)arrData.elementAt(j)).intValue();
                    file_output.write(data);
                } else {
                    data = (Byte)arrData.elementAt(j);
                    file_output.write(data);
                }
                ++j;
            }
            ++i;
        }
    }

    public int getCompletionRatio() {
        return 100 * (this.curr_register + 1) / 14;
    }

    public byte getCrunchingFormat() {
        return this.bytFormat;
    }

    public void setFormat(byte bytParamFormat) {
        this.bytFormat = bytParamFormat;
    }
}

