/*
 * Decompiled with CFR 0.152.
 */
class DigiDrums {
    private static final long CPCDMA_FREQUENCY = 16000L;
    private byte[][] arrOrigDrums;
    private byte[][] arrConvDrums;
    private boolean blnDDIs4bits;

    public DigiDrums(byte[][] arrOD, boolean blnDDIs4bits) {
        this.blnDDIs4bits = blnDDIs4bits;
        this.arrOrigDrums = arrOD;
        this.arrConvDrums = new byte[this.arrOrigDrums.length][];
        int i = 0;
        while (i < this.arrConvDrums.length) {
            this.arrConvDrums[i] = null;
            ++i;
        }
    }

    public int getNumberOfDrums() {
        return this.arrOrigDrums.length;
    }

    public byte[] getDrum(int nbDrum, long lngFrequency) {
        if (this.arrConvDrums[nbDrum] == null) {
            this.arrConvDrums[nbDrum] = this.convertDrum(nbDrum, lngFrequency);
        }
        return this.arrConvDrums[nbDrum];
    }

    private byte[] convertDrum(int nbDrum, long lngFrequency) {
        byte[] arrOrig = this.arrOrigDrums[nbDrum];
        long intCPCSampleLength = (long)arrOrig.length * 16000L / lngFrequency;
        byte[] arrConv = new byte[4 * arrOrig.length];
        int i = 0;
        while ((long)i < intCPCSampleLength) {
            float k = (long)(i * arrOrig.length) / intCPCSampleLength;
            byte bytVolValue = arrOrig[(int)k];
            if (!this.blnDDIs4bits) {
                // empty if block
            }
            arrConv[i] = 0;
            arrConv[i + 1] = 10;
            arrConv[i + 2] = bytVolValue;
            arrConv[i + 3] = bytVolValue;
            i += 4;
        }
        return arrConv;
    }
}

