/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCRIPT_ANALYSIS;
import org.eclipse.swt.internal.win32.SCRIPT_CONTROL;
import org.eclipse.swt.internal.win32.SCRIPT_DIGITSUBSTITUTE;
import org.eclipse.swt.internal.win32.SCRIPT_FONTPROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_ITEM;
import org.eclipse.swt.internal.win32.SCRIPT_LOGATTR;
import org.eclipse.swt.internal.win32.SCRIPT_PROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_STATE;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    String segmentsText;
    int lineSpacing;
    int ascent;
    int descent;
    int alignment;
    int wrapWidth;
    int orientation;
    int indent;
    boolean justify;
    int[] tabs;
    int[] segments;
    StyleItem[] styles;
    StyleItem[] allRuns;
    StyleItem[][] runs;
    int[] lineOffset;
    int[] lineY;
    int[] lineWidth;
    int mLangFontLink2;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final int SCRIPT_VISATTR_SIZEOF = 2;
    static final int GOFFSET_SIZEOF = 8;
    static final byte[] CLSID_CMultiLanguage = new byte[16];
    static final byte[] IID_IMLangFontLink2 = new byte[16];

    static {
        OS.IIDFromString("{275c23e2-3747-11d0-9fea-00aa003f8646}\u0000".toCharArray(), CLSID_CMultiLanguage);
        OS.IIDFromString("{DCCFC162-2B38-11d2-B7EC-00C04F8F5D9A}\u0000".toCharArray(), IID_IMLangFontLink2);
    }

    public TextLayout(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.descent = -1;
        this.ascent = -1;
        this.wrapWidth = -1;
        this.lineSpacing = 0;
        this.orientation = 0x2000000;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.text = "";
        int[] ppv = new int[1];
        OS.OleInitialize(0);
        if (OS.CoCreateInstance(CLSID_CMultiLanguage, 0, 1, IID_IMLangFontLink2, ppv) == 0) {
            this.mLangFontLink2 = ppv[0];
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    void breakRun(StyleItem run) {
        if (run.psla != 0) {
            return;
        }
        char[] chars = new char[run.length];
        this.segmentsText.getChars(run.start, run.start + run.length, chars, 0);
        int hHeap = OS.GetProcessHeap();
        run.psla = OS.HeapAlloc(hHeap, 8, 1 * chars.length);
        OS.ScriptBreak(chars, chars.length, run.analysis, run.psla);
    }

    void checkItem(int hDC, StyleItem item) {
        if (item.fallbackFont != 0) {
            LOGFONT logFont;
            LOGFONT lOGFONT = logFont = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            if (OS.GetObject(item.fallbackFont, LOGFONT.sizeof, logFont) == 0) {
                item.free();
                OS.SelectObject(hDC, this.getItemFont(item));
                this.shape(hDC, item);
            }
        }
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns(GC gc) {
        if (this.runs != null) {
            return;
        }
        int hDC = gc != null ? gc.handle : this.device.internal_new_GC(null);
        int srcHdc = OS.CreateCompatibleDC(hDC);
        this.allRuns = this.itemize();
        int i = 0;
        while (i < this.allRuns.length - 1) {
            StyleItem run = this.allRuns[i];
            OS.SelectObject(srcHdc, this.getItemFont(run));
            this.shape(srcHdc, run);
            ++i;
        }
        SCRIPT_LOGATTR logAttr = new SCRIPT_LOGATTR();
        SCRIPT_PROPERTIES properties = new SCRIPT_PROPERTIES();
        int lineWidth = this.indent;
        int lineStart = 0;
        int lineCount = 1;
        int i2 = 0;
        while (i2 < this.allRuns.length - 1) {
            StyleItem run = this.allRuns[i2];
            if (run.length == 1) {
                char ch = this.segmentsText.charAt(run.start);
                switch (ch) {
                    case '\t': {
                        int lastTabWidth;
                        run.tab = true;
                        if (this.tabs == null) break;
                        int tabsLength = this.tabs.length;
                        int j = 0;
                        while (j < tabsLength) {
                            if (this.tabs[j] > lineWidth) {
                                run.width = this.tabs[j] - lineWidth;
                                break;
                            }
                            ++j;
                        }
                        if (j != tabsLength) break;
                        int tabX = this.tabs[tabsLength - 1];
                        int n = lastTabWidth = tabsLength > 1 ? this.tabs[tabsLength - 1] - this.tabs[tabsLength - 2] : this.tabs[0];
                        if (lastTabWidth <= 0) break;
                        while (tabX <= lineWidth) {
                            tabX += lastTabWidth;
                        }
                        run.width = tabX - lineWidth;
                        break;
                    }
                    case '\n': {
                        run.lineBreak = true;
                        break;
                    }
                    case '\r': {
                        run.lineBreak = true;
                        StyleItem next = this.allRuns[i2 + 1];
                        if (next.length == 0 || this.segmentsText.charAt(next.start) != '\n') break;
                        ++run.length;
                        next.free();
                        ++i2;
                    }
                }
            }
            if (this.wrapWidth != -1 && lineWidth + run.width > this.wrapWidth && !run.tab) {
                int start = 0;
                int[] piDx = new int[run.length];
                if (run.style != null && run.style.metrics != null) {
                    piDx[0] = run.width;
                } else {
                    OS.ScriptGetLogicalWidths(run.analysis, run.length, run.glyphCount, run.advances, run.clusters, run.visAttrs, piDx);
                }
                int width = 0;
                int maxWidth = this.wrapWidth - lineWidth;
                while (width + piDx[start] < maxWidth) {
                    width += piDx[start++];
                }
                int firstStart = start;
                int firstIndice = i2;
                while (i2 >= lineStart) {
                    this.breakRun(run);
                    while (start >= 0) {
                        OS.MoveMemory(logAttr, run.psla + start * 1, 1);
                        if (logAttr.fSoftBreak || logAttr.fWhiteSpace) break;
                        --start;
                    }
                    if (start == 0 && i2 != lineStart && !run.tab && logAttr.fSoftBreak && !logAttr.fWhiteSpace) {
                        OS.MoveMemory(properties, this.device.scripts[run.analysis.eScript], 8);
                        short langID = properties.langid;
                        StyleItem pRun = this.allRuns[i2 - 1];
                        OS.MoveMemory(properties, this.device.scripts[pRun.analysis.eScript], 8);
                        if (properties.langid == langID || langID == 0 || properties.langid == 0) {
                            this.breakRun(pRun);
                            OS.MoveMemory(logAttr, pRun.psla + (pRun.length - 1) * 1, 1);
                            if (!logAttr.fWhiteSpace) {
                                start = -1;
                            }
                        }
                    }
                    if (start >= 0 || i2 == lineStart) break;
                    run = this.allRuns[--i2];
                    start = run.length - 1;
                }
                if (start == 0 && i2 != lineStart && !run.tab) {
                    run = this.allRuns[--i2];
                } else if (start <= 0 && i2 == lineStart) {
                    i2 = firstIndice;
                    run = this.allRuns[i2];
                    start = Math.max(1, firstStart);
                }
                this.breakRun(run);
                while (start < run.length) {
                    OS.MoveMemory(logAttr, run.psla + start * 1, 1);
                    if (!logAttr.fWhiteSpace) break;
                    ++start;
                }
                if (start > 0 && start < run.length) {
                    StyleItem newRun = new StyleItem();
                    newRun.start = run.start + start;
                    newRun.length = run.length - start;
                    newRun.style = run.style;
                    newRun.analysis = run.analysis;
                    run.free();
                    run.length = start;
                    OS.SelectObject(srcHdc, this.getItemFont(run));
                    this.shape(srcHdc, run);
                    OS.SelectObject(srcHdc, this.getItemFont(newRun));
                    this.shape(srcHdc, newRun);
                    StyleItem[] newAllRuns = new StyleItem[this.allRuns.length + 1];
                    System.arraycopy(this.allRuns, 0, newAllRuns, 0, i2 + 1);
                    System.arraycopy(this.allRuns, i2 + 1, newAllRuns, i2 + 2, this.allRuns.length - i2 - 1);
                    this.allRuns = newAllRuns;
                    this.allRuns[i2 + 1] = newRun;
                }
                if (i2 != this.allRuns.length - 2) {
                    run.lineBreak = true;
                    run.softBreak = true;
                }
            }
            lineWidth += run.width;
            if (run.lineBreak) {
                lineStart = i2 + 1;
                lineWidth = run.softBreak ? 0 : this.indent;
                ++lineCount;
            }
            ++i2;
        }
        lineWidth = 0;
        this.runs = new StyleItem[lineCount][];
        this.lineOffset = new int[lineCount + 1];
        this.lineY = new int[lineCount + 1];
        this.lineWidth = new int[lineCount];
        int lineRunCount = 0;
        int line = 0;
        int ascent = Math.max(0, this.ascent);
        int descent = Math.max(0, this.descent);
        StyleItem[] lineRuns = new StyleItem[this.allRuns.length];
        int i3 = 0;
        while (i3 < this.allRuns.length) {
            StyleItem run = this.allRuns[i3];
            lineRuns[lineRunCount++] = run;
            lineWidth += run.width;
            ascent = Math.max(ascent, run.ascent);
            descent = Math.max(descent, run.descent);
            if (run.lineBreak || i3 == this.allRuns.length - 1) {
                if (lineRunCount == 1 && i3 == this.allRuns.length - 1) {
                    TEXTMETRIC lptm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                    OS.SelectObject(srcHdc, this.getItemFont(run));
                    OS.GetTextMetrics(srcHdc, lptm);
                    run.ascent = lptm.tmAscent;
                    run.descent = lptm.tmDescent;
                    ascent = Math.max(ascent, run.ascent);
                    descent = Math.max(descent, run.descent);
                }
                this.runs[line] = new StyleItem[lineRunCount];
                System.arraycopy(lineRuns, 0, this.runs[line], 0, lineRunCount);
                if (this.justify && this.wrapWidth != -1 && run.softBreak && lineWidth > 0) {
                    if (line == 0) {
                        lineWidth += this.indent;
                    } else {
                        StyleItem[] previousLine = this.runs[line - 1];
                        StyleItem previousRun = previousLine[previousLine.length - 1];
                        if (previousRun.lineBreak && !previousRun.softBreak) {
                            lineWidth += this.indent;
                        }
                    }
                    int hHeap = OS.GetProcessHeap();
                    int newLineWidth = 0;
                    int j = 0;
                    while (j < this.runs[line].length) {
                        StyleItem item = this.runs[line][j];
                        int iDx = item.width * this.wrapWidth / lineWidth;
                        if (iDx != item.width) {
                            item.justify = OS.HeapAlloc(hHeap, 8, item.glyphCount * 4);
                            OS.ScriptJustify(item.visAttrs, item.advances, item.glyphCount, iDx - item.width, 2, item.justify);
                            item.width = iDx;
                        }
                        newLineWidth += item.width;
                        ++j;
                    }
                    lineWidth = newLineWidth;
                }
                this.lineWidth[line] = lineWidth;
                this.runs[line] = this.reorder(this.runs[line]);
                StyleItem lastRun = this.runs[line][lineRunCount - 1];
                if (run.softBreak && run != lastRun) {
                    run.lineBreak = false;
                    run.softBreak = false;
                    lastRun.lineBreak = true;
                    lastRun.softBreak = true;
                }
                lineWidth = this.getLineIndent(line);
                int j = 0;
                while (j < this.runs[line].length) {
                    this.runs[line][j].x = lineWidth;
                    lineWidth += this.runs[line][j].width;
                    ++j;
                }
                this.lineY[++line] = this.lineY[line - 1] + ascent + descent + this.lineSpacing;
                this.lineOffset[line] = lastRun.start + lastRun.length;
                lineWidth = 0;
                lineRunCount = 0;
                ascent = Math.max(0, this.ascent);
                descent = Math.max(0, this.descent);
            }
            ++i3;
        }
        if (srcHdc != 0) {
            OS.DeleteDC(srcHdc);
        }
        if (gc == null) {
            this.device.internal_dispose_GC(hDC, null);
        }
    }

    public void dispose() {
        if (this.device == null) {
            return;
        }
        this.freeRuns();
        this.font = null;
        this.text = null;
        this.segmentsText = null;
        this.tabs = null;
        this.styles = null;
        this.runs = null;
        this.lineOffset = null;
        this.lineY = null;
        this.lineWidth = null;
        if (this.mLangFontLink2 != 0) {
            OS.VtblCall(2, this.mLangFontLink2);
            this.mLangFontLink2 = 0;
        }
        OS.OleUninitialize();
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public void draw(GC gc, int x, int y) {
        this.draw(gc, x, y, -1, -1, null, null);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        boolean hasSelection;
        int length;
        this.checkLayout();
        this.computeRuns(gc);
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        if (selectionForeground != null && selectionForeground.isDisposed()) {
            SWT.error(5);
        }
        if (selectionBackground != null && selectionBackground.isDisposed()) {
            SWT.error(5);
        }
        if ((length = this.text.length()) == 0) {
            return;
        }
        int hdc = gc.handle;
        boolean bl = hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
        if (hasSelection) {
            selectionStart = Math.min(Math.max(0, selectionStart), length - 1);
            selectionEnd = Math.min(Math.max(0, selectionEnd), length - 1);
            if (selectionForeground == null) {
                selectionForeground = this.device.getSystemColor(27);
            }
            if (selectionBackground == null) {
                selectionBackground = this.device.getSystemColor(26);
            }
            selectionStart = this.translateOffset(selectionStart);
            selectionEnd = this.translateOffset(selectionEnd);
        }
        int foreground = OS.GetTextColor(hdc);
        int state = OS.SaveDC(hdc);
        RECT rect = new RECT();
        int selBrush = 0;
        int selPen = 0;
        if (hasSelection) {
            selBrush = OS.CreateSolidBrush(selectionBackground.handle);
            selPen = OS.CreatePen(0, 1, selectionForeground.handle);
        }
        int rop2 = 0;
        if (OS.IsWinCE) {
            rop2 = OS.SetROP2(hdc, 13);
            OS.SetROP2(hdc, rop2);
        } else {
            rop2 = OS.GetROP2(hdc);
        }
        int dwRop = rop2 == 7 ? 5898313 : 15728673;
        OS.SetBkMode(hdc, 1);
        Rectangle clip = gc.getClipping();
        int line = 0;
        while (line < this.runs.length) {
            int drawX = x + this.getLineIndent(line);
            int drawY = y + this.lineY[line];
            if (drawX <= clip.x + clip.width && drawX + this.lineWidth[line] >= clip.x) {
                int drawRunY;
                int end;
                StyleItem run;
                StyleItem[] lineRuns = this.runs[line];
                int baseline = Math.max(0, this.ascent);
                int i = 0;
                while (i < lineRuns.length) {
                    baseline = Math.max(baseline, lineRuns[i].ascent);
                    ++i;
                }
                int lineHeight = this.lineY[line + 1] - this.lineY[line];
                int alignmentX = drawX;
                int i2 = 0;
                while (i2 < lineRuns.length) {
                    run = lineRuns[i2];
                    if (run.length != 0) {
                        if (drawX > clip.x + clip.width) break;
                        if (drawX + run.width >= clip.x && (!run.lineBreak || run.softBreak)) {
                            boolean fullSelection;
                            end = run.start + run.length - 1;
                            boolean bl2 = fullSelection = hasSelection && selectionStart <= run.start && selectionEnd >= end;
                            if (fullSelection) {
                                OS.SelectObject(hdc, selBrush);
                                OS.PatBlt(hdc, drawX, drawY, run.width, lineHeight - this.lineSpacing, dwRop);
                            } else {
                                boolean partialSelection;
                                if (run.style != null && run.style.background != null) {
                                    int bg = run.style.background.handle;
                                    drawRunY = drawY + (baseline - run.ascent);
                                    int hBrush = OS.CreateSolidBrush(bg);
                                    int oldBrush = OS.SelectObject(hdc, hBrush);
                                    OS.PatBlt(hdc, drawX, drawRunY, run.width, run.ascent + run.descent, dwRop);
                                    OS.SelectObject(hdc, oldBrush);
                                    OS.DeleteObject(hBrush);
                                }
                                boolean bl3 = partialSelection = hasSelection && selectionStart <= end && run.start <= selectionEnd;
                                if (partialSelection) {
                                    OS.SelectObject(hdc, selBrush);
                                    int selStart = Math.max(selectionStart, run.start) - run.start;
                                    int selEnd = Math.min(selectionEnd, end) - run.start;
                                    int cChars = run.length;
                                    int gGlyphs = run.glyphCount;
                                    int[] piX = new int[1];
                                    int advances = run.justify != 0 ? run.justify : run.advances;
                                    OS.ScriptCPtoX(selStart, false, cChars, gGlyphs, run.clusters, run.visAttrs, advances, run.analysis, piX);
                                    int runX = (this.orientation & 0x4000000) != 0 ? run.width - piX[0] : piX[0];
                                    rect.left = drawX + runX;
                                    rect.top = drawY;
                                    OS.ScriptCPtoX(selEnd, true, cChars, gGlyphs, run.clusters, run.visAttrs, advances, run.analysis, piX);
                                    runX = (this.orientation & 0x4000000) != 0 ? run.width - piX[0] : piX[0];
                                    rect.right = drawX + runX;
                                    rect.bottom = drawY + lineHeight - this.lineSpacing;
                                    OS.PatBlt(hdc, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, dwRop);
                                }
                            }
                        }
                        drawX += run.width;
                    }
                    ++i2;
                }
                drawX = alignmentX;
                i2 = 0;
                while (i2 < lineRuns.length) {
                    run = lineRuns[i2];
                    if (run.length != 0) {
                        if (drawX > clip.x + clip.width) break;
                        if (!(drawX + run.width < clip.x || run.tab || run.lineBreak && !run.softBreak || run.style != null && run.style.metrics != null)) {
                            boolean partialSelection;
                            boolean fullSelection;
                            end = run.start + run.length - 1;
                            int fg = foreground;
                            boolean bl4 = fullSelection = hasSelection && selectionStart <= run.start && selectionEnd >= end;
                            if (fullSelection) {
                                fg = selectionForeground.handle;
                            } else if (run.style != null && run.style.foreground != null) {
                                fg = run.style.foreground.handle;
                            }
                            OS.SetTextColor(hdc, fg);
                            this.checkItem(hdc, run);
                            OS.SelectObject(hdc, this.getItemFont(run));
                            drawRunY = drawY + (baseline - run.ascent);
                            OS.ScriptTextOut(hdc, run.psc, drawX, drawRunY, 0, null, run.analysis, 0, 0, run.glyphs, run.glyphCount, run.advances, run.justify, run.goffsets);
                            if (run.style != null && (run.style.underline || run.style.strikeout)) {
                                int newPen = hasSelection && fg == selectionForeground.handle ? selPen : OS.CreatePen(0, 1, fg);
                                int oldPen = OS.SelectObject(hdc, newPen);
                                if (run.style.underline) {
                                    int underlineY = drawY + baseline + 1 - run.style.rise;
                                    OS.MoveToEx(hdc, drawX, underlineY, 0);
                                    OS.LineTo(hdc, drawX + run.width, underlineY);
                                }
                                if (run.style.strikeout) {
                                    int strikeoutY = drawRunY + run.leading + (run.ascent - run.style.rise) / 2;
                                    OS.MoveToEx(hdc, drawX, strikeoutY, 0);
                                    OS.LineTo(hdc, drawX + run.width, strikeoutY);
                                }
                                OS.SelectObject(hdc, oldPen);
                                if (!hasSelection || fg != selectionForeground.handle) {
                                    OS.DeleteObject(newPen);
                                }
                            }
                            boolean bl5 = partialSelection = hasSelection && selectionStart <= end && run.start <= selectionEnd;
                            if (!fullSelection && partialSelection && fg != selectionForeground.handle) {
                                OS.SetTextColor(hdc, selectionForeground.handle);
                                int selStart = Math.max(selectionStart, run.start) - run.start;
                                int selEnd = Math.min(selectionEnd, end) - run.start;
                                int cChars = run.length;
                                int gGlyphs = run.glyphCount;
                                int[] piX = new int[1];
                                int advances = run.justify != 0 ? run.justify : run.advances;
                                OS.ScriptCPtoX(selStart, false, cChars, gGlyphs, run.clusters, run.visAttrs, advances, run.analysis, piX);
                                int runX = (this.orientation & 0x4000000) != 0 ? run.width - piX[0] : piX[0];
                                rect.left = drawX + runX;
                                rect.top = drawY;
                                OS.ScriptCPtoX(selEnd, true, cChars, gGlyphs, run.clusters, run.visAttrs, advances, run.analysis, piX);
                                runX = (this.orientation & 0x4000000) != 0 ? run.width - piX[0] : piX[0];
                                rect.right = drawX + runX;
                                rect.bottom = drawY + lineHeight;
                                OS.ScriptTextOut(hdc, run.psc, drawX, drawRunY, 4, rect, run.analysis, 0, 0, run.glyphs, run.glyphCount, run.advances, run.justify, run.goffsets);
                                if (run.style != null && (run.style.underline || run.style.strikeout)) {
                                    int oldPen = OS.SelectObject(hdc, selPen);
                                    if (run.style.underline) {
                                        int underlineY = drawY + baseline + 1 - run.style.rise;
                                        OS.MoveToEx(hdc, rect.left, underlineY, 0);
                                        OS.LineTo(hdc, rect.right, underlineY);
                                    }
                                    if (run.style.strikeout) {
                                        int strikeoutY = drawRunY + run.leading + (run.ascent - run.style.rise) / 2;
                                        OS.MoveToEx(hdc, rect.left, strikeoutY, 0);
                                        OS.LineTo(hdc, rect.right, strikeoutY);
                                    }
                                    OS.SelectObject(hdc, oldPen);
                                }
                            }
                        }
                        drawX += run.width;
                    }
                    ++i2;
                }
            }
            ++line;
        }
        OS.RestoreDC(hdc, state);
        if (selBrush != 0) {
            OS.DeleteObject(selBrush);
        }
        if (selPen != 0) {
            OS.DeleteObject(selPen);
        }
    }

    void freeRuns() {
        if (this.allRuns == null) {
            return;
        }
        int i = 0;
        while (i < this.allRuns.length) {
            StyleItem run = this.allRuns[i];
            run.free();
            ++i;
        }
        this.allRuns = null;
        this.runs = null;
        this.segmentsText = null;
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns(null);
        int width = 0;
        if (this.wrapWidth != -1) {
            width = this.wrapWidth;
        } else {
            int line = 0;
            while (line < this.runs.length) {
                width = Math.max(width, this.lineWidth[line] + this.getLineIndent(line));
                ++line;
            }
        }
        return new Rectangle(0, 0, width, this.lineY[this.lineY.length - 1]);
    }

    public Rectangle getBounds(int start, int end) {
        this.checkLayout();
        this.computeRuns(null);
        int length = this.text.length();
        if (length == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (start > end) {
            return new Rectangle(0, 0, 0, 0);
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        start = this.translateOffset(start);
        end = this.translateOffset(end);
        int left = Integer.MAX_VALUE;
        int right = 0;
        int top = Integer.MAX_VALUE;
        int bottom = 0;
        int lineIndex = 0;
        boolean isRTL = (this.orientation & 0x4000000) != 0;
        int i = 0;
        while (i < this.allRuns.length - 1) {
            StyleItem run = this.allRuns[i];
            int runEnd = run.start + run.length;
            if (run.lineBreak) {
                ++lineIndex;
            }
            if (runEnd > start) {
                int advances;
                int[] piX;
                GlyphMetrics metrics;
                int cx;
                if (run.start > end) break;
                int runLead = run.x;
                int runTrail = run.x + run.width;
                if (run.start <= start && start < runEnd) {
                    cx = 0;
                    if (run.style != null && run.style.metrics != null) {
                        metrics = run.style.metrics;
                        cx = metrics.width * (start - run.start);
                    } else if (!run.tab) {
                        piX = new int[1];
                        advances = run.justify != 0 ? run.justify : run.advances;
                        OS.ScriptCPtoX(start - run.start, false, run.length, run.glyphCount, run.clusters, run.visAttrs, advances, run.analysis, piX);
                        int n = cx = isRTL ? run.width - piX[0] : piX[0];
                    }
                    if (run.analysis.fRTL ^ isRTL) {
                        runTrail = run.x + cx;
                    } else {
                        runLead = run.x + cx;
                    }
                }
                if (run.start <= end && end < runEnd) {
                    cx = run.width;
                    if (run.style != null && run.style.metrics != null) {
                        metrics = run.style.metrics;
                        cx = metrics.width * (end - run.start + 1);
                    } else if (!run.tab) {
                        piX = new int[1];
                        advances = run.justify != 0 ? run.justify : run.advances;
                        OS.ScriptCPtoX(end - run.start, true, run.length, run.glyphCount, run.clusters, run.visAttrs, advances, run.analysis, piX);
                        int n = cx = isRTL ? run.width - piX[0] : piX[0];
                    }
                    if (run.analysis.fRTL ^ isRTL) {
                        runLead = run.x + cx;
                    } else {
                        runTrail = run.x + cx;
                    }
                }
                left = Math.min(left, runLead);
                right = Math.max(right, runTrail);
                top = Math.min(top, this.lineY[run.lineBreak ? lineIndex - 1 : lineIndex]);
                bottom = Math.max(bottom, this.lineY[run.lineBreak ? lineIndex : lineIndex + 1] - this.lineSpacing);
            }
            ++i;
        }
        return new Rectangle(left, top, right - left, bottom - top);
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return this.justify;
    }

    int getItemFont(StyleItem item) {
        if (item.fallbackFont != 0) {
            return item.fallbackFont;
        }
        if (item.style != null && item.style.font != null) {
            return item.style.font.handle;
        }
        if (this.font != null) {
            return this.font.handle;
        }
        return this.device.systemFont;
    }

    public int getLevel(int offset) {
        this.checkLayout();
        this.computeRuns(null);
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        offset = this.translateOffset(offset);
        int i = 1;
        while (i < this.allRuns.length) {
            if (this.allRuns[i].start > offset) {
                return this.allRuns[i - 1].analysis.s.uBidiLevel;
            }
            ++i;
        }
        return (this.orientation & 0x4000000) != 0 ? 1 : 0;
    }

    public Rectangle getLineBounds(int lineIndex) {
        this.checkLayout();
        this.computeRuns(null);
        if (lineIndex < 0 || lineIndex >= this.runs.length) {
            SWT.error(6);
        }
        int x = this.getLineIndent(lineIndex);
        int y = this.lineY[lineIndex];
        int width = this.lineWidth[lineIndex];
        int height = this.lineY[lineIndex + 1] - y - this.lineSpacing;
        return new Rectangle(x, y, width, height);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns(null);
        return this.runs.length;
    }

    int getLineIndent(int lineIndex) {
        int lineIndent = 0;
        if (lineIndex == 0) {
            lineIndent = this.indent;
        } else {
            StyleItem[] previousLine = this.runs[lineIndex - 1];
            StyleItem previousRun = previousLine[previousLine.length - 1];
            if (previousRun.lineBreak && !previousRun.softBreak) {
                lineIndent = this.indent;
            }
        }
        if (this.wrapWidth != -1) {
            boolean partialLine = true;
            if (this.justify) {
                StyleItem[] lineRun = this.runs[lineIndex];
                if (lineRun[lineRun.length - 1].softBreak) {
                    partialLine = false;
                }
            }
            if (partialLine) {
                int lineWidth = this.lineWidth[lineIndex] + lineIndent;
                switch (this.alignment) {
                    case 0x1000000: {
                        lineIndent += (this.wrapWidth - lineWidth) / 2;
                        break;
                    }
                    case 131072: {
                        lineIndent += this.wrapWidth - lineWidth;
                    }
                }
            }
        }
        return lineIndent;
    }

    public int getLineIndex(int offset) {
        this.checkLayout();
        this.computeRuns(null);
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        offset = this.translateOffset(offset);
        int line = 0;
        while (line < this.runs.length) {
            if (this.lineOffset[line + 1] > offset) {
                return line;
            }
            ++line;
        }
        return this.runs.length - 1;
    }

    public FontMetrics getLineMetrics(int lineIndex) {
        this.checkLayout();
        this.computeRuns(null);
        if (lineIndex < 0 || lineIndex >= this.runs.length) {
            SWT.error(6);
        }
        int hDC = this.device.internal_new_GC(null);
        int srcHdc = OS.CreateCompatibleDC(hDC);
        TEXTMETRIC lptm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.SelectObject(srcHdc, this.font != null ? this.font.handle : this.device.systemFont);
        OS.GetTextMetrics(srcHdc, lptm);
        OS.DeleteDC(srcHdc);
        this.device.internal_dispose_GC(hDC, null);
        int ascent = Math.max(lptm.tmAscent, this.ascent);
        int descent = Math.max(lptm.tmDescent, this.descent);
        int leading = lptm.tmInternalLeading;
        if (this.text.length() != 0) {
            StyleItem[] lineRuns = this.runs[lineIndex];
            int i = 0;
            while (i < lineRuns.length) {
                StyleItem run = lineRuns[i];
                if (run.ascent > ascent) {
                    ascent = run.ascent;
                    leading = run.leading;
                }
                descent = Math.max(descent, run.descent);
                ++i;
            }
        }
        lptm.tmAscent = ascent;
        lptm.tmDescent = descent;
        lptm.tmHeight = ascent + descent;
        lptm.tmInternalLeading = leading;
        lptm.tmAveCharWidth = 0;
        return FontMetrics.win32_new(lptm);
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns(null);
        int[] offsets = new int[this.lineOffset.length];
        int i = 0;
        while (i < offsets.length) {
            offsets[i] = this.untranslateOffset(this.lineOffset[i]);
            ++i;
        }
        return offsets;
    }

    public Point getLocation(int offset, boolean trailing) {
        this.checkLayout();
        this.computeRuns(null);
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        length = this.segmentsText.length();
        offset = this.translateOffset(offset);
        int line = 0;
        while (line < this.runs.length) {
            if (this.lineOffset[line + 1] > offset) break;
            ++line;
        }
        line = Math.min(line, this.runs.length - 1);
        StyleItem[] lineRuns = this.runs[line];
        Point result = null;
        if (offset == length) {
            result = new Point(this.lineWidth[line], this.lineY[line]);
        } else {
            int width = 0;
            int i = 0;
            while (i < lineRuns.length) {
                StyleItem run = lineRuns[i];
                int end = run.start + run.length;
                if (run.start <= offset && offset < end) {
                    if (run.style != null && run.style.metrics != null) {
                        GlyphMetrics metrics = run.style.metrics;
                        result = new Point(width += metrics.width * (offset - run.start + (trailing ? 1 : 0)), this.lineY[line]);
                        break;
                    }
                    if (run.tab) {
                        if (trailing || offset == length) {
                            width += run.width;
                        }
                        result = new Point(width, this.lineY[line]);
                        break;
                    }
                    int runOffset = offset - run.start;
                    int cChars = run.length;
                    int gGlyphs = run.glyphCount;
                    int[] piX = new int[1];
                    int advances = run.justify != 0 ? run.justify : run.advances;
                    OS.ScriptCPtoX(runOffset, trailing, cChars, gGlyphs, run.clusters, run.visAttrs, advances, run.analysis, piX);
                    if ((this.orientation & 0x4000000) != 0) {
                        result = new Point(width + (run.width - piX[0]), this.lineY[line]);
                        break;
                    }
                    result = new Point(width + piX[0], this.lineY[line]);
                    break;
                }
                width += run.width;
                ++i;
            }
        }
        if (result == null) {
            result = new Point(0, 0);
        }
        result.x += this.getLineIndent(line);
        return result;
    }

    public int getNextOffset(int offset, int movement) {
        this.checkLayout();
        return this._getOffset(offset, movement, true);
    }

    int _getOffset(int offset, int movement, boolean forward) {
        int step;
        this.computeRuns(null);
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        if (forward && offset == length) {
            return length;
        }
        if (!forward && offset == 0) {
            return 0;
        }
        int n = step = forward ? 1 : -1;
        if ((movement & 1) != 0) {
            return offset + step;
        }
        length = this.segmentsText.length();
        offset = this.translateOffset(offset);
        SCRIPT_LOGATTR logAttr = new SCRIPT_LOGATTR();
        SCRIPT_PROPERTIES properties = new SCRIPT_PROPERTIES();
        int i = forward ? 0 : this.allRuns.length - 1;
        offset = this.validadeOffset(offset, step);
        do {
            boolean isComplex;
            StyleItem run = this.allRuns[i];
            if (run.start > offset || offset >= run.start + run.length) continue;
            if (run.lineBreak && !run.softBreak) {
                return this.untranslateOffset(run.start);
            }
            if (run.tab) {
                return this.untranslateOffset(run.start);
            }
            OS.MoveMemory(properties, this.device.scripts[run.analysis.eScript], 8);
            boolean bl = isComplex = properties.fNeedsCaretInfo || properties.fNeedsWordBreaking;
            if (isComplex) {
                this.breakRun(run);
            }
            while (run.start <= offset && offset < run.start + run.length) {
                if (isComplex) {
                    OS.MoveMemory(logAttr, run.psla + (offset - run.start) * 1, 1);
                }
                switch (movement) {
                    case 2: {
                        if (properties.fNeedsCaretInfo) {
                            if (logAttr.fInvalid || !logAttr.fCharStop) break;
                            return this.untranslateOffset(offset);
                        }
                        return this.untranslateOffset(offset);
                    }
                    case 4: {
                        boolean previousLetterOrDigit;
                        boolean letterOrDigit;
                        if (!(properties.fNeedsWordBreaking ? !logAttr.fInvalid && logAttr.fWordStop : offset > 0 && ((letterOrDigit = Compatibility.isLetterOrDigit(this.segmentsText.charAt(offset))) != (previousLetterOrDigit = Compatibility.isLetterOrDigit(this.segmentsText.charAt(offset - 1))) || !letterOrDigit) && !Compatibility.isWhitespace(this.segmentsText.charAt(offset)))) break;
                        return this.untranslateOffset(offset);
                    }
                }
                offset = this.validadeOffset(offset, step);
            }
        } while ((i += step) >= 0 && i < this.allRuns.length - 1 && offset >= 0 && offset < length);
        return forward ? this.text.length() : 0;
    }

    public int getOffset(Point point, int[] trailing) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, trailing);
    }

    public int getOffset(int x, int y, int[] trailing) {
        this.checkLayout();
        this.computeRuns(null);
        if (trailing != null && trailing.length < 1) {
            SWT.error(5);
        }
        int lineCount = this.runs.length;
        int line = 0;
        while (line < lineCount) {
            if (this.lineY[line + 1] > y) break;
            ++line;
        }
        line = Math.min(line, this.runs.length - 1);
        StyleItem[] lineRuns = this.runs[line];
        if ((x -= this.getLineIndent(line)) >= this.lineWidth[line]) {
            x = this.lineWidth[line] - 1;
        }
        if (x < 0) {
            x = 0;
        }
        int width = 0;
        int i = 0;
        while (i < lineRuns.length) {
            StyleItem run = lineRuns[i];
            if (run.lineBreak && !run.softBreak) {
                return this.untranslateOffset(run.start);
            }
            if (width + run.width > x) {
                int xRun = x - width;
                if (run.style != null && run.style.metrics != null) {
                    GlyphMetrics metrics = run.style.metrics;
                    if (metrics.width > 0) {
                        if (trailing != null) {
                            trailing[0] = xRun % metrics.width < metrics.width / 2 ? 0 : 1;
                        }
                        return this.untranslateOffset(run.start + xRun / metrics.width);
                    }
                }
                if (run.tab) {
                    if (trailing != null) {
                        trailing[0] = x < width + run.width / 2 ? 0 : 1;
                    }
                    return this.untranslateOffset(run.start);
                }
                int cChars = run.length;
                int cGlyphs = run.glyphCount;
                int[] piCP = new int[1];
                int[] piTrailing = new int[1];
                if ((this.orientation & 0x4000000) != 0) {
                    xRun = run.width - xRun;
                }
                int advances = run.justify != 0 ? run.justify : run.advances;
                OS.ScriptXtoCP(xRun, cChars, cGlyphs, run.clusters, run.visAttrs, advances, run.analysis, piCP, piTrailing);
                if (trailing != null) {
                    trailing[0] = piTrailing[0];
                }
                return this.untranslateOffset(run.start + piCP[0]);
            }
            width += run.width;
            ++i;
        }
        if (trailing != null) {
            trailing[0] = 0;
        }
        return this.untranslateOffset(this.lineOffset[line + 1]);
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    public int getPreviousOffset(int offset, int movement) {
        this.checkLayout();
        return this._getOffset(offset, movement, false);
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] result = new int[this.styles.length * 2];
        int count = 0;
        int i = 0;
        while (i < this.styles.length - 1) {
            if (this.styles[i].style != null) {
                result[count++] = this.styles[i].start;
                result[count++] = this.styles[i + 1].start - 1;
            }
            ++i;
        }
        if (count != result.length) {
            int[] newResult = new int[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    String getSegmentsText() {
        if (this.segments == null) {
            return this.text;
        }
        int nSegments = this.segments.length;
        if (nSegments <= 1) {
            return this.text;
        }
        int length = this.text.length();
        if (length == 0) {
            return this.text;
        }
        if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
            return this.text;
        }
        char[] oldChars = new char[length];
        this.text.getChars(0, length, oldChars, 0);
        char[] newChars = new char[length + nSegments];
        int charCount = 0;
        int segmentCount = 0;
        int separator = this.orientation == 0x4000000 ? 8207 : 8206;
        while (charCount < length) {
            if (segmentCount < nSegments && charCount == this.segments[segmentCount]) {
                newChars[charCount + segmentCount++] = separator;
                continue;
            }
            newChars[charCount + segmentCount] = oldChars[charCount++];
        }
        if (segmentCount < nSegments) {
            this.segments[segmentCount] = charCount;
            newChars[charCount + segmentCount++] = separator;
        }
        return new String(newChars, 0, Math.min(charCount + segmentCount, newChars.length));
    }

    public int getSpacing() {
        this.checkLayout();
        return this.lineSpacing;
    }

    public TextStyle getStyle(int offset) {
        this.checkLayout();
        int length = this.text.length();
        if (offset < 0 || offset >= length) {
            SWT.error(6);
        }
        int i = 1;
        while (i < this.styles.length) {
            if (this.styles[i].start > offset) {
                return this.styles[i - 1].style;
            }
            ++i;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] result = new TextStyle[this.styles.length];
        int count = 0;
        int i = 0;
        while (i < this.styles.length) {
            if (this.styles[i].style != null) {
                result[count++] = this.styles[i].style;
            }
            ++i;
        }
        if (count != result.length) {
            TextStyle[] newResult = new TextStyle[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    StyleItem[] itemize() {
        this.segmentsText = this.getSegmentsText();
        int length = this.segmentsText.length();
        SCRIPT_CONTROL scriptControl = new SCRIPT_CONTROL();
        SCRIPT_STATE scriptState = new SCRIPT_STATE();
        int MAX_ITEM = length + 1;
        if ((this.orientation & 0x4000000) != 0) {
            scriptState.uBidiLevel = 1;
            scriptState.fArabicNumContext = true;
            SCRIPT_DIGITSUBSTITUTE psds = new SCRIPT_DIGITSUBSTITUTE();
            OS.ScriptRecordDigitSubstitution(1024, psds);
            OS.ScriptApplyDigitSubstitution(psds, scriptControl, scriptState);
        }
        int hHeap = OS.GetProcessHeap();
        int pItems = OS.HeapAlloc(hHeap, 8, MAX_ITEM * 8);
        int[] pcItems = new int[1];
        char[] chars = new char[length];
        this.segmentsText.getChars(0, length, chars, 0);
        OS.ScriptItemize(chars, length, MAX_ITEM, scriptControl, scriptState, pItems, pcItems);
        StyleItem[] runs = this.merge(pItems, pcItems[0]);
        OS.HeapFree(hHeap, 0, pItems);
        return runs;
    }

    StyleItem[] merge(int items, int itemCount) {
        StyleItem item;
        int count = 0;
        int start = 0;
        int end = this.segmentsText.length();
        int itemIndex = 0;
        int styleIndex = 0;
        StyleItem[] runs = new StyleItem[itemCount + this.styles.length];
        SCRIPT_ITEM scriptItem = new SCRIPT_ITEM();
        boolean linkBefore = false;
        while (start < end) {
            item = new StyleItem();
            item.start = start;
            item.style = this.styles[styleIndex].style;
            runs[count++] = item;
            OS.MoveMemory(scriptItem, items + itemIndex * 8, 8);
            item.analysis = scriptItem.a;
            if (linkBefore) {
                item.analysis.fLinkBefore = true;
                linkBefore = false;
            }
            scriptItem.a = new SCRIPT_ANALYSIS();
            OS.MoveMemory(scriptItem, items + (itemIndex + 1) * 8, 8);
            int itemLimit = scriptItem.iCharPos;
            int styleLimit = this.translateOffset(this.styles[styleIndex + 1].start);
            if (styleLimit <= itemLimit) {
                ++styleIndex;
                start = styleLimit;
                if (start < itemLimit && start > 0 && start < end) {
                    char pChar = this.segmentsText.charAt(start - 1);
                    char tChar = this.segmentsText.charAt(start);
                    if (!Compatibility.isWhitespace(pChar) && !Compatibility.isWhitespace(tChar)) {
                        item.analysis.fLinkAfter = true;
                        linkBefore = true;
                    }
                }
            }
            if (itemLimit <= styleLimit) {
                ++itemIndex;
                start = itemLimit;
            }
            item.length = start - item.start;
        }
        item = new StyleItem();
        item.start = end;
        OS.MoveMemory(scriptItem, items + itemCount * 8, 8);
        item.analysis = scriptItem.a;
        runs[count++] = item;
        if (runs.length != count) {
            StyleItem[] result = new StyleItem[count];
            System.arraycopy(runs, 0, result, 0, count);
            return result;
        }
        return runs;
    }

    StyleItem[] reorder(StyleItem[] runs) {
        int length = runs.length;
        if (length <= 1) {
            return runs;
        }
        byte[] bidiLevels = new byte[length];
        int i = 0;
        while (i < length) {
            bidiLevels[i] = (byte)(runs[i].analysis.s.uBidiLevel & 0x1F);
            ++i;
        }
        StyleItem lastRun = runs[length - 1];
        if (lastRun.lineBreak && !lastRun.softBreak) {
            bidiLevels[length - 1] = 0;
        }
        int[] log2vis = new int[length];
        OS.ScriptLayout(length, bidiLevels, null, log2vis);
        StyleItem[] result = new StyleItem[length];
        int i2 = 0;
        while (i2 < length) {
            result[log2vis[i2]] = runs[i2];
            ++i2;
        }
        if ((this.orientation & 0x4000000) != 0) {
            i2 = 0;
            while (i2 < (length - 1) / 2) {
                StyleItem tmp = result[i2];
                result[i2] = result[length - i2 - 2];
                result[length - i2 - 2] = tmp;
                ++i2;
            }
        }
        return result;
    }

    public void setAlignment(int alignment) {
        this.checkLayout();
        int mask = 16924672;
        if ((alignment &= mask) == 0) {
            return;
        }
        if ((alignment & 0x4000) != 0) {
            alignment = 16384;
        }
        if ((alignment & 0x20000) != 0) {
            alignment = 131072;
        }
        if (this.alignment == alignment) {
            return;
        }
        this.freeRuns();
        this.alignment = alignment;
    }

    public void setAscent(int ascent) {
        this.checkLayout();
        if (ascent < -1) {
            SWT.error(5);
        }
        if (this.ascent == ascent) {
            return;
        }
        this.freeRuns();
        this.ascent = ascent;
    }

    public void setDescent(int descent) {
        this.checkLayout();
        if (descent < -1) {
            SWT.error(5);
        }
        if (this.descent == descent) {
            return;
        }
        this.freeRuns();
        this.descent = descent;
    }

    public void setFont(Font font) {
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (this.font == font) {
            return;
        }
        if (font != null && font.equals(this.font)) {
            return;
        }
        this.freeRuns();
        this.font = font;
    }

    public void setIndent(int indent) {
        this.checkLayout();
        if (indent < 0) {
            return;
        }
        if (this.indent == indent) {
            return;
        }
        this.freeRuns();
        this.indent = indent;
    }

    public void setJustify(boolean justify) {
        this.checkLayout();
        if (this.justify == justify) {
            return;
        }
        this.freeRuns();
        this.justify = justify;
    }

    public void setOrientation(int orientation) {
        this.checkLayout();
        int mask = 0x6000000;
        if ((orientation &= mask) == 0) {
            return;
        }
        if ((orientation & 0x2000000) != 0) {
            orientation = 0x2000000;
        }
        if (this.orientation == orientation) {
            return;
        }
        this.orientation = orientation;
        this.freeRuns();
    }

    public void setSegments(int[] segments) {
        this.checkLayout();
        if (this.segments == null && segments == null) {
            return;
        }
        if (this.segments != null && segments != null && this.segments.length == segments.length) {
            int i = 0;
            while (i < segments.length) {
                if (this.segments[i] != segments[i]) break;
                ++i;
            }
            if (i == segments.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = segments;
    }

    public void setSpacing(int spacing) {
        this.checkLayout();
        if (spacing < 0) {
            SWT.error(5);
        }
        if (this.lineSpacing == spacing) {
            return;
        }
        this.freeRuns();
        this.lineSpacing = spacing;
    }

    public void setStyle(TextStyle style, int start, int end) {
        int modifyStart;
        this.checkLayout();
        int length = this.text.length();
        if (length == 0) {
            return;
        }
        if (start > end) {
            return;
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        int low = -1;
        int high = this.styles.length;
        while (high - low > 1) {
            int index = (high + low) / 2;
            if (this.styles[index + 1].start > start) {
                high = index;
                continue;
            }
            low = index;
        }
        if (high >= 0 && high < this.styles.length) {
            StyleItem item = this.styles[high];
            if (item.start == start && this.styles[high + 1].start - 1 == end && (style == null ? item.style == null : style.equals(item.style))) {
                return;
            }
        }
        this.freeRuns();
        int modifyEnd = modifyStart = high;
        while (modifyEnd < this.styles.length) {
            if (this.styles[modifyEnd + 1].start > end) break;
            ++modifyEnd;
        }
        if (modifyStart == modifyEnd) {
            int styleStart = this.styles[modifyStart].start;
            int styleEnd = this.styles[modifyEnd + 1].start - 1;
            if (styleStart == start && styleEnd == end) {
                this.styles[modifyStart].style = style;
                return;
            }
            if (styleStart != start && styleEnd != end) {
                StyleItem[] newStyles = new StyleItem[this.styles.length + 2];
                System.arraycopy(this.styles, 0, newStyles, 0, modifyStart + 1);
                StyleItem item = new StyleItem();
                item.start = start;
                item.style = style;
                newStyles[modifyStart + 1] = item;
                item = new StyleItem();
                item.start = end + 1;
                item.style = this.styles[modifyStart].style;
                newStyles[modifyStart + 2] = item;
                System.arraycopy(this.styles, modifyEnd + 1, newStyles, modifyEnd + 3, this.styles.length - modifyEnd - 1);
                this.styles = newStyles;
                return;
            }
        }
        if (start == this.styles[modifyStart].start) {
            --modifyStart;
        }
        if (end == this.styles[modifyEnd + 1].start - 1) {
            ++modifyEnd;
        }
        int newLength = this.styles.length + 1 - (modifyEnd - modifyStart - 1);
        StyleItem[] newStyles = new StyleItem[newLength];
        System.arraycopy(this.styles, 0, newStyles, 0, modifyStart + 1);
        StyleItem item = new StyleItem();
        item.start = start;
        item.style = style;
        newStyles[modifyStart + 1] = item;
        this.styles[modifyEnd].start = end + 1;
        System.arraycopy(this.styles, modifyEnd, newStyles, modifyStart + 2, this.styles.length - modifyEnd);
        this.styles = newStyles;
    }

    public void setTabs(int[] tabs) {
        this.checkLayout();
        if (this.tabs == null && tabs == null) {
            return;
        }
        if (this.tabs != null && tabs != null && this.tabs.length == tabs.length) {
            int i = 0;
            while (i < tabs.length) {
                if (this.tabs[i] != tabs[i]) break;
                ++i;
            }
            if (i == tabs.length) {
                return;
            }
        }
        this.freeRuns();
        this.tabs = tabs;
    }

    public void setText(String text) {
        this.checkLayout();
        if (text == null) {
            SWT.error(4);
        }
        if (text.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = text;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[1].start = text.length();
    }

    public void setWidth(int width) {
        this.checkLayout();
        if (width < -1 || width == 0) {
            SWT.error(5);
        }
        if (this.wrapWidth == width) {
            return;
        }
        this.freeRuns();
        this.wrapWidth = width;
    }

    boolean shape(int hdc, StyleItem run, char[] chars, int[] glyphCount, int maxGlyphs) {
        int hr = OS.ScriptShape(hdc, run.psc, chars, chars.length, maxGlyphs, run.analysis, run.glyphs, run.clusters, run.visAttrs, glyphCount);
        run.glyphCount = glyphCount[0];
        if (hr != -2147220992) {
            SCRIPT_FONTPROPERTIES fp = new SCRIPT_FONTPROPERTIES();
            fp.cBytes = 16;
            OS.ScriptGetFontProperties(hdc, run.psc, fp);
            short[] glyphs = new short[glyphCount[0]];
            OS.MoveMemory(glyphs, run.glyphs, glyphs.length * 2);
            int i = 0;
            while (i < glyphs.length) {
                if (glyphs[i] == fp.wgDefault) break;
                ++i;
            }
            if (i == glyphs.length) {
                return true;
            }
        }
        if (run.psc != 0) {
            OS.ScriptFreeCache(run.psc);
            glyphCount[0] = 0;
            OS.MoveMemory(run.psc, glyphCount, 4);
        }
        run.glyphCount = 0;
        return false;
    }

    void shape(int hdc, StyleItem run) {
        int[] buffer = new int[1];
        char[] chars = new char[run.length];
        this.segmentsText.getChars(run.start, run.start + run.length, chars, 0);
        int maxGlyphs = chars.length * 3 / 2 + 16;
        int hHeap = OS.GetProcessHeap();
        run.glyphs = OS.HeapAlloc(hHeap, 8, maxGlyphs * 2);
        run.clusters = OS.HeapAlloc(hHeap, 8, maxGlyphs * 2);
        run.visAttrs = OS.HeapAlloc(hHeap, 8, maxGlyphs * 2);
        run.psc = OS.HeapAlloc(hHeap, 8, 4);
        if (!this.shape(hdc, run, chars, buffer, maxGlyphs) && this.mLangFontLink2 != 0) {
            int[] dwCodePages = new int[1];
            int[] cchCodePages = new int[1];
            OS.VtblCall(4, this.mLangFontLink2, chars, chars.length, 0, dwCodePages, cchCodePages);
            int[] hNewFont = new int[1];
            if (OS.VtblCall(10, this.mLangFontLink2, hdc, dwCodePages[0], chars[0], hNewFont) == 0) {
                int hFont = OS.SelectObject(hdc, hNewFont[0]);
                if (this.shape(hdc, run, chars, buffer, maxGlyphs)) {
                    run.fallbackFont = hNewFont[0];
                } else {
                    OS.VtblCall(8, this.mLangFontLink2, hNewFont[0]);
                    OS.SelectObject(hdc, hFont);
                    OS.ScriptShape(hdc, run.psc, chars, chars.length, maxGlyphs, run.analysis, run.glyphs, run.clusters, run.visAttrs, buffer);
                    run.glyphCount = buffer[0];
                }
            }
        }
        int[] abc = new int[3];
        run.advances = OS.HeapAlloc(hHeap, 8, run.glyphCount * 4);
        run.goffsets = OS.HeapAlloc(hHeap, 8, run.glyphCount * 8);
        OS.ScriptPlace(hdc, run.psc, run.glyphs, run.glyphCount, run.visAttrs, run.analysis, run.advances, run.goffsets, abc);
        if (run.style != null && run.style.metrics != null) {
            GlyphMetrics metrics = run.style.metrics;
            run.width = metrics.width * Math.max(1, run.glyphCount);
            run.ascent = metrics.ascent;
            run.descent = metrics.descent;
            run.leading = 0;
        } else {
            run.width = abc[0] + abc[1] + abc[2];
            TEXTMETRIC lptm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(hdc, lptm);
            run.ascent = lptm.tmAscent;
            run.descent = lptm.tmDescent;
            run.leading = lptm.tmInternalLeading;
        }
        if (run.style != null) {
            run.ascent += run.style.rise;
            run.descent -= run.style.rise;
        }
    }

    int validadeOffset(int offset, int step) {
        offset += step;
        if (this.segments != null && this.segments.length > 2) {
            int i = 0;
            while (i < this.segments.length) {
                if (this.translateOffset(this.segments[i]) - 1 == offset) {
                    offset += step;
                    break;
                }
                ++i;
            }
        }
        return offset;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {}";
    }

    int translateOffset(int offset) {
        if (this.segments == null) {
            return offset;
        }
        int nSegments = this.segments.length;
        if (nSegments <= 1) {
            return offset;
        }
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
            return offset;
        }
        int i = 0;
        while (i < nSegments && offset - i >= this.segments[i]) {
            ++offset;
            ++i;
        }
        return offset;
    }

    int untranslateOffset(int offset) {
        if (this.segments == null) {
            return offset;
        }
        int nSegments = this.segments.length;
        if (nSegments <= 1) {
            return offset;
        }
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
            return offset;
        }
        int i = 0;
        while (i < nSegments && offset > this.segments[i]) {
            --offset;
            ++i;
        }
        return offset;
    }

    class StyleItem {
        TextStyle style;
        int start;
        int length;
        boolean lineBreak;
        boolean softBreak;
        boolean tab;
        SCRIPT_ANALYSIS analysis;
        int psc = 0;
        int glyphs;
        int glyphCount;
        int clusters;
        int visAttrs;
        int advances;
        int goffsets;
        int width;
        int ascent;
        int descent;
        int leading;
        int x;
        int justify;
        int psla;
        int fallbackFont;

        StyleItem() {
        }

        void free() {
            int hHeap = OS.GetProcessHeap();
            if (this.psc != 0) {
                OS.ScriptFreeCache(this.psc);
                OS.HeapFree(hHeap, 0, this.psc);
                this.psc = 0;
            }
            if (this.glyphs != 0) {
                OS.HeapFree(hHeap, 0, this.glyphs);
                this.glyphs = 0;
                this.glyphCount = 0;
            }
            if (this.clusters != 0) {
                OS.HeapFree(hHeap, 0, this.clusters);
                this.clusters = 0;
            }
            if (this.visAttrs != 0) {
                OS.HeapFree(hHeap, 0, this.visAttrs);
                this.visAttrs = 0;
            }
            if (this.advances != 0) {
                OS.HeapFree(hHeap, 0, this.advances);
                this.advances = 0;
            }
            if (this.goffsets != 0) {
                OS.HeapFree(hHeap, 0, this.goffsets);
                this.goffsets = 0;
            }
            if (this.justify != 0) {
                OS.HeapFree(hHeap, 0, this.justify);
                this.justify = 0;
            }
            if (this.psla != 0) {
                OS.HeapFree(hHeap, 0, this.psla);
                this.psla = 0;
            }
            if (this.fallbackFont != 0) {
                if (TextLayout.this.mLangFontLink2 != 0) {
                    OS.VtblCall(8, TextLayout.this.mLangFontLink2, this.fallbackFont);
                }
                this.fallbackFont = 0;
            }
            this.x = 0;
            this.descent = 0;
            this.ascent = 0;
            this.width = 0;
            this.softBreak = false;
            this.lineBreak = false;
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

