/*
 * Decompiled with CFR 0.152.
 */
package lha;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Checksum;
import lha.CRC16;
import lha.LH0Decompressor;
import lha.LH5Decompressor;
import lha.LHDDecompressor;
import lha.LhaDecompressor;
import lha.LhaEntry;
import lha.LhaException;

public class LhaDecompressInputStream
extends InputStream {
    private static final int SIZE_SKIP_BUFFER = 512;
    protected LhaDecompressor decompressor;
    protected LhaEntry entry;
    protected Checksum crc;
    protected byte[] skipBuf;
    protected long entryCount;

    public LhaDecompressInputStream(InputStream in, LhaEntry entry) throws LhaException, IOException {
        this.entry = entry;
        this.crc = new CRC16();
        this.skipBuf = new byte[512];
        this.entryCount = entry.getOriginalSize();
        this.decompressor = LhaDecompressInputStream.createDecompressor(in, this.entryCount, entry.getMethod());
        this.crc.reset();
    }

    public Checksum getChecksum() {
        return this.crc;
    }

    public int available() throws IOException {
        if (this.decompressor == null) {
            return 0;
        }
        return this.entryCount > 0L ? 1 : 0;
    }

    public synchronized int read() throws IOException {
        if (this.decompressor == null) {
            return -1;
        }
        byte[] b = new byte[1];
        int n = this.decompressor.read(b, 0, 1);
        if (n > 0) {
            this.crc.update(b[0]);
            --this.entryCount;
        }
        return b[0];
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.decompressor == null) {
            return -1;
        }
        int n = this.decompressor.read(b, off, len);
        if (n > 0) {
            this.crc.update(b, off, n);
            this.entryCount -= (long)n;
        }
        return n;
    }

    public synchronized long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        n = Math.min(n, Integer.MAX_VALUE);
        int total = 0;
        while ((long)total < n) {
            int len = (int)n - total;
            if (len > this.skipBuf.length) {
                len = this.skipBuf.length;
            }
            if ((len = this.read(this.skipBuf, 0, len)) == -1) break;
            this.crc.update(this.skipBuf, 0, len);
            total += len;
        }
        this.entryCount -= (long)total;
        return total;
    }

    public synchronized void close() throws IOException {
        if (this.decompressor != null) {
            this.decompressor.close();
            this.decompressor = null;
            this.entry = null;
            this.crc = null;
        }
    }

    public void closeEntry() throws LhaException, IOException {
        this.skip(this.entryCount);
        if (this.entry.hasCRC() && (long)this.entry.getCRC() != this.crc.getValue()) {
            throw new LhaException("File crc is not matched");
        }
        this.close();
    }

    private static LhaDecompressor createDecompressor(InputStream in, long origsize, String method) throws LhaException, IOException {
        if (method.equals("-lhd-")) {
            return new LHDDecompressor();
        }
        if (method.equals("-lh0-")) {
            return new LH0Decompressor(in, origsize);
        }
        if (method.equals("-lh1-")) {
            throw new LhaException("Unsupported method: " + method);
        }
        if (method.equals("-lh2-")) {
            throw new LhaException("Unsupported method: " + method);
        }
        if (method.equals("-lh3-")) {
            throw new LhaException("Unsupported method: " + method);
        }
        if (method.equals("-lh4-")) {
            return new LH5Decompressor(in, origsize, 12);
        }
        if (method.equals("-lh5-")) {
            return new LH5Decompressor(in, origsize, 13);
        }
        if (method.equals("-lh6-")) {
            return new LH5Decompressor(in, origsize, 15);
        }
        if (method.equals("-lh7-")) {
            return new LH5Decompressor(in, origsize, 16);
        }
        if (method.equals("-lzs-")) {
            throw new LhaException("Unsupported method: " + method);
        }
        if (method.equals("-lz4-")) {
            return new LH0Decompressor(in, origsize);
        }
        if (method.equals("-lz5-")) {
            throw new LhaException("Unsupported method: " + method);
        }
        throw new LhaException("Unknown method: " + method);
    }
}

