/*
 * Decompiled with CFR 0.152.
 */
package lha;

import java.io.IOException;
import java.io.InputStream;
import lha.LhaDecompressor;

public class LH0Decompressor
implements LhaDecompressor {
    private InputStream in;
    private long origsize;

    public LH0Decompressor(InputStream in, long origsize) throws IOException {
        this.in = in;
        this.origsize = origsize;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (len <= 0) {
            return 0;
        }
        if (this.origsize <= 0L) {
            return -1;
        }
        int sl = len;
        while (this.origsize > 0L && len > 0) {
            b[off++] = (byte)this.in.read();
            --this.origsize;
            --len;
        }
        return sl - len;
    }

    public synchronized void close() throws IOException {
        this.in = null;
    }
}

