/*-----------------------------------------------------------------------------

	ST-Sound ( YM files player library )

	Copyright (C) 1995-1999 Arnaud Carre ( http://leonard.oxg.free.fr )

	YM Music Driver

-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------

	This file is part of ST-Sound

	ST-Sound is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	ST-Sound is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with ST-Sound; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-----------------------------------------------------------------------------*/


#ifndef __YMMUSIC__
#define __YMMUSIC__

#include "Ym2149Ex.h"
#include "YmLoad.h"
#include "digidrum.h"

typedef	int		YM_BOOL;
typedef signed short	YM_SAMPLE;
#define	YM_FALSE	(0)
#define	YM_TRUE		(!YM_FALSE)
#define	MAX_DIGIDRUM	128

#define	YMTPREC		16
#define	MAX_VOICE	8
#define	PCDACFREQ	44100
#define	YMTNBSRATE	(PCDACFREQ/50)

typedef enum
{
	YM_V2,
	YM_V3,
	YM_V4,
	YM_V5,
	YM_V6,
	YM_VMAX,

	YM_TRACKER1=32,
	YM_TRACKER2,
	YM_TRACKERMAX,

	YM_MIX1=64,
	YM_MIX2,
	YM_MIXMAX,
} ymFile_t;

typedef struct
{
	char	*pSongName;
	char	*pSongAuthor;
	char	*pSongComment;
	char	*pSongType;
	char	*pSongPlayer;
	long	musicTimeInSec;
} ymMusicInfo_t;

typedef struct
{
	unsigned long	sampleStart;
	unsigned long	sampleLength;
	unsigned short	nbRepeat;
	unsigned short	replayFreq;
} mixBlock_t;

typedef struct
{
	unsigned long size;
	unsigned char *pData;
	unsigned long repLen;
} digiDrum_t;

typedef struct
{
	int nbVoice;
	unsigned long nbVbl;
	unsigned char *pDataBufer;
	unsigned long currentVbl;
	unsigned long flags;
	int	bLoop;
} ymTrackerPartoche_t;


typedef struct
{
	unsigned char *pSample;
	unsigned long sampleSize;
	unsigned long samplePos;
	unsigned long repLen;
	int sampleVolume;
	unsigned int sampleFreq;
	int	bLoop;
	int bRunning;
} ymTrackerVoice_t;

typedef struct
{
	unsigned char noteOn;
	unsigned char volume;
	unsigned short freq;
} ymTrackerLine_t;


enum
{
	A_STREAMINTERLEAVED = 1,
	A_DRUMSIGNED = 2,
	A_DRUM4BITS = 4,
	A_TIMECONTROL = 8,
	A_LOOPMODE = 16,
};


class	CYmMusic
{

public:
	CYmMusic(int _replayRate=44100);
	~CYmMusic();

	YM_BOOL	load(char *pName);
	YM_BOOL	loadMemory(void *pBlock,unsigned long size);

	void	unLoad(void);
	YM_BOOL	isSeekable(void);
	YM_BOOL	update(YM_SAMPLE *pBuffer,int nbSample);
	long	getPos(void);
	long	getMusicTime(void);
	long	setMusicTime(long time);
	void	play(void);
	void	pause(void);
	void	stop(void);
	void	setVolume(int volume);
	void	setPos(int time_ms);
	int		getAttrib(void);
	void	getMusicInfo(ymMusicInfo_t *pInfo);
	void	setLoopMode(YM_BOOL bLoop);
	char	*getLastError(void);
	int		 readYmRegister(int reg)		{ return ymChip.readRegister(reg); }

//-------------------------------------------------------------
// WAVE Generator
//-------------------------------------------------------------
	int		waveCreate(char *fName);

	YM_BOOL	bMusicOver;

private:



	void	setPlayerRate(int rate);
	void	setAttrib(int _attrib);
	void	setLastError(char *pError);
	unsigned char *depackFile(void);
	YM_BOOL	deInterleave(void);
	void	readYm6Effect(unsigned char *pReg,int code,int prediv,int count);
	void	player(void);
	void	setTimeControl(YM_BOOL bFlag);


	CYm2149Ex	ymChip;
	char	*pLastError;
	ymFile_t	songType;
	int		nbFrame;
	int		loopFrame;
	int		currentFrame;
	int		nbDrum;
	digiDrum_t *pDrumTab;
	int		musicTime;
	unsigned char *pBigMalloc;
	unsigned char *pDataStream;
	YM_BOOL	bLoop;
	size_t	fileSize;
	YM_BOOL	ymDecode(void);
	int		playerRate;
	int		attrib;
	volatile	YM_BOOL	bMusicOk;
	volatile	YM_BOOL	bPause;
	int		streamInc;
	int		innerSamplePos;
	int		replayRate;

	char	*pSongName;
	char	*pSongAuthor;
	char	*pSongComment;
	char	*pSongType;
	char	*pSongPlayer;

//-------------------------------------------------------------
// ATARI Digi Mix Music.
//-------------------------------------------------------------
	void	readNextBlockInfo(void);
	void	stDigitMix(signed short *pWrite16,int nbs);
	int	nbRepeat;
	int	nbMixBlock;
	mixBlock_t *pMixBlock;
	int	mixPos;
	unsigned char *pBigSampleBuffer;
	unsigned char	*pCurrentMixSample;
	unsigned long	currentSampleLength;
	unsigned long	currentPente;
	unsigned long	currentPos;

//-------------------------------------------------------------
// YM-Universal-Tracker
//-------------------------------------------------------------
	void	ymTrackerInit(int volMaxPercent);
	void	ymTrackerUpdate(signed short *pBuffer,int nbSample);
	void	ymTrackerDesInterleave(void);
	void	ymTrackerPlayer(ymTrackerVoice_t *pVoice);
	void	ymTrackerVoiceAdd(ymTrackerVoice_t *pVoice,signed short *pBuffer,int nbs);

	int			nbVoice;
	ymTrackerVoice_t	ymTrackerVoice[MAX_VOICE];
	int					ymTrackerNbSampleBefore;
	signed short		ymTrackerVolumeTable[256*64];
	int					ymTrackerFreqShift;


};

/*
		int	version;
		SD	pos;
		UD	inc;
		UD	timeSec;
		UD	timeMin;
		UD	loopSec;
		UD	loopMin;
		UD	nbVbl;
		UD	vblRestart;
		UD	ymFreq;
		UD	playerFreq;
		UB	*pRegister;
		UB	*pFileBuffer;
		UD	fileSize;
		UD	attrib;
		char *pSongName;
		char *pSongComment;
		char *pSongAuthor;
		mixBlock_t *pMixBlock;
		long	nbMixBlock;
		UD	nbDrum;
		digiDrum_t *pDrumTab;
		int	nbVoice;
		unsigned long currentVbl;
		int	bTimeControl;
		int	timeTotal;
		int	ymtFreqShift;
*/

#endif
