/*-----------------------------------------------------------------------------

	ST-Sound ( YM files player library )

	Copyright (C) 1995-1999 Arnaud Carre ( http://leonard.oxg.free.fr )

	Extended YM-2149 Emulator, with ATARI music demos effects.
	(SID-Like, Digidrum, Sync Buzzer, Sinus SID and Pattern SID)

-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------

	This file is part of ST-Sound

	ST-Sound is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	ST-Sound is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with ST-Sound; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-----------------------------------------------------------------------------*/


#ifndef __YM2149EX__
#define __YM2149EX__

#define	AMSTRAD_CLOCK	1000000L
#define	ATARI_CLOCK		2000000L
#define	SPECTRUM_CLOCK	1773400L
#define	NOISESIZE		16384
#define	MAX_NBSAMPLE	1024
#define	DRUM_PREC		15

#define	PI				3.1415926
#define	SIDSINPOWER		0.7

#ifndef YM_BOOL
typedef	int		YM_BOOL;
#endif
#ifndef YM_FALSE
#define	YM_FALSE	(0)
#endif
#ifndef YM_TRUE
#define	YM_TRUE		(!YM_FALSE)
#endif

enum
{
	VOICE_A=0,
	VOICE_B=1,
	VOICE_C=2,
};

struct	YmSpecialEffect
{

		int				bDrum;
		unsigned long	drumSize;
		unsigned char  *drumData;
		unsigned long	drumPos;
		unsigned long	drumStep;

		int				bSid;
		unsigned long	sidPos;
		unsigned long	sidStep;
		int				sidVol;

};

static	const	int		DC_ADJUST_BUFFERLEN		=	512;

class	CDcAdjuster
{
public:
	CDcAdjuster();
	
	void	AddSample(int sample);
	int		GetDcLevel(void)			{ return m_sum / DC_ADJUST_BUFFERLEN; }
	void	Reset(void);

private:
	int		m_buffer[DC_ADJUST_BUFFERLEN];
	int		m_pos;
	int		m_sum;
};


class CYm2149Ex
{
public:
		CYm2149Ex(unsigned long masterClock=ATARI_CLOCK,int prediv=1,unsigned long playRate=44100);
		~CYm2149Ex();

		void	reset(void);
		void	update(signed short *pSampleBuffer,int nbSample);

		void	setClock(unsigned long _clock);
		void	writeRegister(int reg,int value);
		int		readRegister(int reg);
		void	drumStart(int voice,unsigned char *drumBuffer,unsigned long drumSize,int drumFreq);
		void	drumStop(int voice);
		void	sidStart(int voice,int freq,int vol);
		void	sidSinStart(int voice,int timerFreq,int sinPattern);
		void	sidStop(int voice);
		void	syncBuzzerStart(int freq,int envShape);
		void	syncBuzzerStop(void);


private:

		CDcAdjuster		m_dcAdjust;

		unsigned long	frameCycle;
		unsigned long	cyclePerSample;
		inline	signed short nextSample(void);
		unsigned long toneStepCompute(int rHigh,int rLow);
		unsigned long noiseStepCompute(int rNoise);
		unsigned long envStepCompute(int rHigh,int rLow);
		void	updateEnvGen(int nbSample);
		void	updateNoiseGen(int nbSample);
		void	updateToneGen(int voice,int nbSample);
		unsigned int	rndCompute(void);

		void	sidVolumeCompute(int voice,int *pVol);

		int		replayFrequency;
		unsigned long internalClock;
		int		registers[14];

		unsigned long	cycleSample;
		unsigned long	stepA,stepB,stepC;
		unsigned long	posA,posB,posC;
		int				volA,volB,volC,volE;
		unsigned long	mixerTA,mixerTB,mixerTC;
		unsigned long	mixerNA,mixerNB,mixerNC;
		int				*pVolA,*pVolB,*pVolC;

		unsigned long	noiseStep;
		unsigned long noisePos;
		unsigned int	rndRack;
		unsigned int	currentNoise;
		unsigned int	bWrite13;

		unsigned long	envStep;
		unsigned long envPos;
		int		envPhase;
		int		envShape;
		unsigned char	envData[16][2][16*2];
		int	globalVolume;

		struct	YmSpecialEffect	specialEffect[3];
		int				bSyncBuzzer;
		unsigned long	syncBuzzerStep;
		int				syncBuzzerShape;


};

#endif
