/*-----------------------------------------------------------------------------

	ST-Sound ( YM files player library )

	Copyright (C) 1995-1999 Arnaud Carre ( http://leonard.oxg.free.fr )

	Extended YM-2149 Emulator, with ATARI music demos effects.
	(SID-Like, Digidrum, Sync Buzzer, Sinus SID and Pattern SID)

-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------

	This file is part of ST-Sound

	ST-Sound is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	ST-Sound is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with ST-Sound; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-----------------------------------------------------------------------------*/


#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <stdio.h>
#include "Ym2149Ex.h"

extern	int	bSoundFilter;

//-------------------------------------------------------------------
// env shapes.
//-------------------------------------------------------------------
static	int Env00xx[8]={ 1,0,0,0,0,0,0,0 };
static	int	Env01xx[8]={ 0,1,0,0,0,0,0,0 };
static	int Env1000[8]={ 1,0,1,0,1,0,1,0 };
static	int Env1001[8]={ 1,0,0,0,0,0,0,0 };
static	int Env1010[8]={ 1,0,0,1,1,0,0,1 };
static	int Env1011[8]={ 1,0,1,1,1,1,1,1 };
static	int Env1100[8]={ 0,1,0,1,0,1,0,1 };
static	int Env1101[8]={ 0,1,1,1,1,1,1,1 };
static	int Env1110[8]={ 0,1,1,0,0,1,1,0 };
static	int	Env1111[8]={ 0,1,0,0,0,0,0,0 };
static	int *EnvWave[16] = {Env00xx,Env00xx,Env00xx,Env00xx,
							Env01xx,Env01xx,Env01xx,Env01xx,
							Env1000,Env1001,Env1010,Env1011,
							Env1100,Env1101,Env1110,Env1111};

static	unsigned short ymVolumeTable[16] =
{	62,161,265,377,580,774,1155,1575,2260,3088,4570,6233,9330,13187,21220,32767};


//----------------------------------------------------------------------
// Very cool and fast DC Adjuster ! This is the *new* stuff of that
// package coz I get that idea working on SainT in 2004 !
// ( almost everything here is from 1995 !)
//----------------------------------------------------------------------
CDcAdjuster::CDcAdjuster()
{
	Reset();
}

void	CDcAdjuster::Reset(void)
{
	for (int i=0;i<DC_ADJUST_BUFFERLEN;i++)
		m_buffer[i] = 0;

	m_pos = 0;
	m_sum = 0;
}

void	CDcAdjuster::AddSample(int sample)
{
	m_sum -= m_buffer[m_pos];
	m_sum += sample;

	m_buffer[m_pos] = sample;
	m_pos = (m_pos+1)&(DC_ADJUST_BUFFERLEN-1);
}




//----------------------------------------------------------------------
// Very simple low pass filter.
// Filter coefs are 0.25,0.5,0.25
//----------------------------------------------------------------------
static	signed short	*pInternalInput = NULL;
static	long			internalInputLen = 0;
static	signed short	oldFilter[2] = {0,0};

signed short *getBufferCopy(signed short *pIn,int len)
{
		if (len>internalInputLen)
		{
			if (pInternalInput) free(pInternalInput);
			pInternalInput = (signed short *)malloc(len*sizeof(short));
			internalInputLen = len;
		}
		memcpy(pInternalInput,pIn,len*sizeof(short));
		return pInternalInput;
}

#define	DSP_FILTER(a,b,c)	(((int)(a)+((int)b+(int)b)+(int)(c))>>2)

// filter: out -> out
void	lowpFilterProcess(signed short *pOut,int len)		// private
{
signed short *pIn;
int i;

		pIn = getBufferCopy(pOut,len);
		if (len>0) *pOut++ = DSP_FILTER(oldFilter[0],oldFilter[1],pIn[0]);
		if (len>1) *pOut++ = DSP_FILTER(oldFilter[1],pIn[0],pIn[1]);
		oldFilter[0] = pIn[len-2];
		oldFilter[1] = pIn[len-1];
		for (i=2;i<len;i++)
		{
			*pOut++ = DSP_FILTER(pIn[0],pIn[1],pIn[2]);
			pIn++;
		}
}



static	unsigned char *ym2149EnvInit(unsigned char *pEnv,int a,int b)
{
int i;
int d;

		d = b-a;
		a *= 15;
		for (i=0;i<16;i++)
		{
			*pEnv++ = (unsigned char)a;
			a += d;
		}
		return pEnv;
}


CYm2149Ex::CYm2149Ex(unsigned long masterClock,int prediv,unsigned long playRate)
{
int i,env;


		frameCycle = 0;
		if (ymVolumeTable[15]==32767)		// excuse me for that bad trick ;-)
		{
			for (i=0;i<16;i++)
			{
				ymVolumeTable[i] = (ymVolumeTable[i]*2)/6;
			}
		}

	//--------------------------------------------------------
	// build env shapes.
	//--------------------------------------------------------
		unsigned char *pEnv = &envData[0][0][0];
		for (env=0;env<16;env++)
		{
			int *pse = EnvWave[env];
			for (int phase=0;phase<4;phase++)
			{
				pEnv = ym2149EnvInit(pEnv,pse[phase*2+0],pse[phase*2+1]);
			}
		}

		internalClock = masterClock/prediv;		// YM at 2Mhz on ATARI ST
		replayFrequency = playRate;				// DAC at 44.1Khz on PC
		cycleSample = 0;

	// Set volume voice pointers.
		pVolA = &volA;
		pVolB = &volB;
		pVolC = &volC;

	// Reset YM2149
		reset();


}

CYm2149Ex::~CYm2149Ex()
{
}

void	CYm2149Ex::setClock(unsigned long _clock)
{
		internalClock = _clock;
}


unsigned long CYm2149Ex::toneStepCompute(int rHigh,int rLow)
{
double step;
unsigned long istep;
int per;


	per = rHigh&15;
	per = (per<<8)+rLow;
	if (per<=5) 
	{
		return 0;
	}

	step = internalClock;
	step /= ((double)per*8.0*(double)replayFrequency);
	step *= 32768.0*65536.0;
	istep = (unsigned long)step;
	return istep;
}

unsigned long CYm2149Ex::noiseStepCompute(int rNoise)
{
double step;
unsigned long istep;
int per;


	per = (rNoise&0x1f);
	if (per<3)
	{
		return 0;
	}
	step = internalClock;
	step /= ((double)per*8.0*(double)replayFrequency);
	step *= 65536.0/2.0;
	istep = (unsigned long)step;
	return istep;
}

unsigned	int	CYm2149Ex::rndCompute(void)
{
		int	rBit = (rndRack&1) ^ ((rndRack>>2)&1);
		rndRack = (rndRack>>1) | (rBit<<16);
		return (rBit ? 0 : 0xffff);
}

unsigned long CYm2149Ex::envStepCompute(int rHigh,int rLow)
{
double step;
unsigned long istep;
int per;


	per = rHigh;
	per = (per<<8)+rLow;
	step = internalClock;
	step /= ((double)per*512.0*(double)replayFrequency);
	step *= 65536.0*65536.0;
	istep = (unsigned long)step;
	return istep;
}


void	CYm2149Ex::reset(void)
{
		writeRegister(7,0x3f);
		writeRegister(8,0);
		writeRegister(9,0);
		writeRegister(10,0);
		currentNoise = 0xffff;
		rndRack = 1;
		sidStop(0);
		sidStop(1);
		sidStop(2);

		envShape = 0;
		envPhase = 0;
		envPos = 0;

		m_dcAdjust.Reset();


		memset(specialEffect,0,sizeof(specialEffect));

		bSyncBuzzer = YM_FALSE;

}


void	CYm2149Ex::sidVolumeCompute(int voice,int *pVol)
{

		struct	YmSpecialEffect	*pVoice = specialEffect+voice;

		if (pVoice->bSid)
		{
			if (pVoice->sidPos & (1<<31))
				writeRegister(8+voice,pVoice->sidVol);
			else
				writeRegister(8+voice,0);
		}
		else if (pVoice->bDrum)
		{
//			writeRegister(8+voice,pVoice->drumData[pVoice->drumPos>>DRUM_PREC]>>4);

			*pVol = (pVoice->drumData[pVoice->drumPos>>DRUM_PREC] * 255) / 6;

			switch (voice)
			{
				case 0:
					pVolA = &volA;
					mixerTA = 0xffff;
					mixerNA = 0xffff;
					break;
				case 1:
					pVolB = &volB;
					mixerTB = 0xffff;
					mixerNB = 0xffff;
					break;
				case 2:
					pVolC = &volC;
					mixerTC = 0xffff;
					mixerNC = 0xffff;
					break;
			}

			pVoice->drumPos += pVoice->drumStep;
			if ((pVoice->drumPos>>DRUM_PREC) >= pVoice->drumSize)
			{
				pVoice->bDrum = 0;
			}

		}
}

signed short CYm2149Ex::nextSample(void)
{
int vol;
int bt,bn;

		if (noisePos&0xffff0000)
		{
			currentNoise ^= rndCompute();
			noisePos &= 0xffff;
		}
		bn = currentNoise;

		volE = ymVolumeTable[envData[envShape][envPhase][envPos>>(32-5)]];

		sidVolumeCompute(0,&volA);
		sidVolumeCompute(1,&volB);
		sidVolumeCompute(2,&volC);

	//---------------------------------------------------
	// Tone+noise+env+DAC for three voices !
	//---------------------------------------------------
		bt = ((((signed long)posA)>>31) | mixerTA) & (bn | mixerNA);
		vol  = (*pVolA)&bt;
		bt = ((((signed long)posB)>>31) | mixerTB) & (bn | mixerNB);
		vol += (*pVolB)&bt;
		bt = ((((signed long)posC)>>31) | mixerTC) & (bn | mixerNC);
		vol += (*pVolC)&bt;

	//---------------------------------------------------
	// Inc
	//---------------------------------------------------
		posA += stepA;
		posB += stepB;
		posC += stepC;
		noisePos += noiseStep;
		envPos += envStep;
		if (envPhase==0)
		{
			if (envPos<envStep)
			{
				envPhase = 1;
			}
		}

		specialEffect[0].sidPos += specialEffect[0].sidStep;
		specialEffect[1].sidPos += specialEffect[1].sidStep;
		specialEffect[2].sidPos += specialEffect[2].sidStep;

	//---------------------------------------------------
	// Normalize process
	//---------------------------------------------------
		m_dcAdjust.AddSample(vol);
		return (vol - m_dcAdjust.GetDcLevel());
}


int		CYm2149Ex::readRegister(int reg)
{
		if ((reg>=0) && (reg<=13)) return registers[reg];
		else return -1;
}

void	CYm2149Ex::writeRegister(int reg,int data)
{

		switch (reg)
		{
		case 0:
			registers[0] = data&255;
			stepA = toneStepCompute(registers[1],registers[0]);
			if (!stepA) posA = (1<<31);		// Assume output always 1 if 0 period (for Digi-sample !)
			break;

		case 2:
			registers[2] = data&255;
			stepB = toneStepCompute(registers[3],registers[2]);
			if (!stepB) posB = (1<<31);		// Assume output always 1 if 0 period (for Digi-sample !)
			break;

		case 4:
			registers[4] = data&255;
			stepC = toneStepCompute(registers[5],registers[4]);
			if (!stepC) posC = (1<<31);		// Assume output always 1 if 0 period (for Digi-sample !)
			break;

		case 1:
			registers[1] = data&15;
			stepA = toneStepCompute(registers[1],registers[0]);
			if (!stepA) posA = (1<<31);		// Assume output always 1 if 0 period (for Digi-sample !)
			break;

		case 3:
			registers[3] = data&15;
			stepB = toneStepCompute(registers[3],registers[2]);
			if (!stepB) posB = (1<<31);		// Assume output always 1 if 0 period (for Digi-sample !)
			break;

		case 5:
			registers[5] = data&15;
			stepC = toneStepCompute(registers[5],registers[4]);
			if (!stepC) posC = (1<<31);		// Assume output always 1 if 0 period (for Digi-sample !)
			break;

		case 6:
			registers[6] = data&0x1f;
			noiseStep = noiseStepCompute(registers[6]);
			if (!noiseStep)
			{
				noisePos = 0;
				currentNoise = 0xffff;
			}
			break;

		case 7:
			registers[7] = data&255;
			mixerTA = (data&(1<<0)) ? 0xffff : 0;
			mixerTB = (data&(1<<1)) ? 0xffff : 0;
			mixerTC = (data&(1<<2)) ? 0xffff : 0;
			mixerNA = (data&(1<<3)) ? 0xffff : 0;
			mixerNB = (data&(1<<4)) ? 0xffff : 0;
			mixerNC = (data&(1<<5)) ? 0xffff : 0;
			break;

		case 8:
			registers[8] = data&31;
			volA = ymVolumeTable[data&15];
			if (data&0x10)
				pVolA = &volE;
			else
				pVolA = &volA;
			break;
		
		case 9:
			registers[9] = data&31;
			volB = ymVolumeTable[data&15];
			if (data&0x10)
				pVolB = &volE;
			else
				pVolB = &volB;
			break;
		
		case 10:
			registers[10] = data&31;
			volC = ymVolumeTable[data&15];
			if (data&0x10)
				pVolC = &volE;
			else
				pVolC = &volC;
			break;

		case 11:
			registers[11] = data&255;
			envStep = envStepCompute(registers[12],registers[11]);
			break;

		case 12:
			registers[12] = data&255;
			envStep = envStepCompute(registers[12],registers[11]);
			break;

		case 13:
			registers[13] = data&0xf;
			envPos = 0;
			envPhase = 0;
			envShape = data&0xf;
			break;

		}
}

void	CYm2149Ex::update(signed short *pSampleBuffer,int nbSample)
{


		signed short *pBuffer = pSampleBuffer;
		int	nbs = nbSample;


		if (nbSample>0)
		{
			do
			{
				*pSampleBuffer++ = nextSample();
			}
			while (--nbSample);
		}

		lowpFilterProcess((signed short*)pBuffer,nbs);

}

void	CYm2149Ex::drumStart(int voice,unsigned char *pDrumBuffer,unsigned long drumSize,int drumFreq)
{
	specialEffect[voice].drumData = pDrumBuffer;
	specialEffect[voice].drumPos = 0;
	specialEffect[voice].drumSize = drumSize;
	specialEffect[voice].drumStep = (drumFreq<<DRUM_PREC)/replayFrequency;
	specialEffect[voice].bDrum = 1;
}

void	CYm2149Ex::drumStop(int voice)
{
		specialEffect[voice].bDrum = 0;
}

void	CYm2149Ex::sidStart(int voice,int timerFreq,int vol)
{
		double tmp = (double)timerFreq*((double)(1<<31))/(double)replayFrequency;
		specialEffect[voice].sidStep = (unsigned long)tmp;
		specialEffect[voice].sidVol = vol&15;
		specialEffect[voice].bSid = 1;
}

void	CYm2149Ex::sidSinStart(int voice,int timerFreq,int vol)
{
/*
		double tmp = (double)timerFreq*((double)(1<<(32-3)))/(double)replayFrequency;
		ymVoice[voice].sidStep = (unsigned long)tmp;
		ymVoice[voice].sidVol = vol&15;
		ymVoice[voice].bSid = YM_FALSE;
		ymVoice[voice].bSidSin = YM_TRUE;
*/
}

void	CYm2149Ex::sidStop(int voice)
{
		specialEffect[voice].bSid = 0;
}

void	CYm2149Ex::syncBuzzerStart(int timerFreq,int _envShape)
{
		double tmp = (double)timerFreq*((double)(1<<31))/(double)replayFrequency;
		syncBuzzerShape = _envShape&15;
		syncBuzzerStep = (unsigned long)tmp;
		bSyncBuzzer = 1;
}

void	CYm2149Ex::syncBuzzerStop(void)
{
		bSyncBuzzer = 0;
}

