/*-----------------------------------------------------------------------------

	ST-Sound ( YM files player library )

	Copyright (C) 1995-1999 Arnaud Carre ( http://leonard.oxg.free.fr )

	Main header to use StSound library in your production.

-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------

	This file is part of ST-Sound

	ST-Sound is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	ST-Sound is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with ST-Sound; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-----------------------------------------------------------------------------*/


#ifndef __YMENGINEPUBLIC__
#define __YMENGINEPUBLIC__

#define	YM_FALSE		(0)
#define	YM_TRUE			(!YM_FALSE)
typedef int				YM_BOOL;
typedef signed short	YM_SAMPLE;

typedef	void			YMMUSIC;

typedef struct
{
	char	*	pSongName;
	char	*	pSongAuthor;
	char	*	pSongComment;
	char	*	pSongType;
	char	*	pSongPlayer;
	long		musicTimeInSec;
} ymMusicInfo_t;

extern	YMMUSIC	*	ymMusicLoad(char *fName);
extern	YMMUSIC	*	ymMusicLoadMemory(void *pBlock,unsigned long size);
extern	void		ymMusicUnload(YMMUSIC *pMusic);
extern	YM_BOOL		ymMusicCompute(YMMUSIC *pMusic,YM_SAMPLE *pBuffer,int nbSample);
extern	void		ymMusicSetLoopMode(YMMUSIC *pMusic,YM_BOOL bLoop);
extern	char	*	ymMusicGetLastError(YMMUSIC *pMusic);
extern	int			ymMusicGetRegister(YMMUSIC *pMusic,int reg);
extern	void		ymMusicGetInfo(YMMUSIC *pMusic,ymMusicInfo_t *pInfo);
extern	void		ymMusicPlay(YMMUSIC *pMusic);
extern	void		ymMusicPause(YMMUSIC *pMusic);
extern	void		ymMusicStop(YMMUSIC *pMusic);

extern	YM_BOOL			ymMusicIsSeekable(YMMUSIC *pMusic);
extern	unsigned long	ymMusicGetPos(YMMUSIC *pMusic);
extern	void			ymMusicSeek(YMMUSIC *pMusic,unsigned long timeInMs);


#endif
