#include  <afxwin.h>
#include  <afxcmn.h>
#include  <commdlg.h>

#include  "Constantes.h"
#include  "ConvImgCpc.h"
#include  "ConvImgCpcDlg.h"
#include  "Conversion.h"
#include  "SauveCPC.h"
#include  "ChoixCouleur.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


static char Msg[ 128 ];


/////////////////////////////////////////////////////////////////////////////
// CConvImgCpcDlg dialog

CConvImgCpcDlg::CConvImgCpcDlg(CWnd* pParent /*=NULL*/)
    : CDialog(CConvImgCpcDlg::IDD, pParent)
{
    //{{AFX_DATA_INIT(CConvImgCpcDlg)
    //}}AFX_DATA_INIT
    m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
    ImageLue = ImageCalculee = FALSE;
}

CConvImgCpcDlg::~CConvImgCpcDlg( void )
{
    DeleteObject( bm );
}

void CConvImgCpcDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CConvImgCpcDlg)
    DDX_Control(pDX, IDC_LOCKCOL15, m_LockCol[ 15 ] );
    DDX_Control(pDX, IDC_LOCKCOL14, m_LockCol[ 14 ] );
    DDX_Control(pDX, IDC_LOCKCOL13, m_LockCol[ 13 ] );
    DDX_Control(pDX, IDC_LOCKCOL12, m_LockCol[ 12 ] );
    DDX_Control(pDX, IDC_LOCKCOL11, m_LockCol[ 11 ] );
    DDX_Control(pDX, IDC_LOCKCOL10, m_LockCol[ 10 ] );
    DDX_Control(pDX, IDC_LOCKCOL09, m_LockCol[ 9 ] );
    DDX_Control(pDX, IDC_LOCKCOL08, m_LockCol[ 8 ] );
    DDX_Control(pDX, IDC_LOCKCOL07, m_LockCol[ 7 ] );
    DDX_Control(pDX, IDC_LOCKCOL06, m_LockCol[ 6 ] );
    DDX_Control(pDX, IDC_LOCKCOL05, m_LockCol[ 5 ] );
    DDX_Control(pDX, IDC_LOCKCOL04, m_LockCol[ 4 ] );
    DDX_Control(pDX, IDC_LOCKCOL03, m_LockCol[ 3 ] );
    DDX_Control(pDX, IDC_LOCKCOL02, m_LockCol[ 2 ] );
    DDX_Control(pDX, IDC_LOCKCOL01, m_LockCol[ 1 ] );
    DDX_Control(pDX, IDC_LOCKCOL00, m_LockCol[ 0 ] );
    DDX_Control(pDX, IDC_COL15, m_Col[ 15 ] );
    DDX_Control(pDX, IDC_COL14, m_Col[ 14 ] );
    DDX_Control(pDX, IDC_COL13, m_Col[ 13 ] );
    DDX_Control(pDX, IDC_COL12, m_Col[ 12 ] );
    DDX_Control(pDX, IDC_COL11, m_Col[ 11 ] );
    DDX_Control(pDX, IDC_COL10, m_Col[ 10 ] );
    DDX_Control(pDX, IDC_COL09, m_Col[ 9 ] );
    DDX_Control(pDX, IDC_COL08, m_Col[ 8 ] );
    DDX_Control(pDX, IDC_COL07, m_Col[ 7 ] );
    DDX_Control(pDX, IDC_COL06, m_Col[ 6 ] );
    DDX_Control(pDX, IDC_COL05, m_Col[ 5 ] );
    DDX_Control(pDX, IDC_COL04, m_Col[ 4 ] );
    DDX_Control(pDX, IDC_COL03, m_Col[ 3 ] );
    DDX_Control(pDX, IDC_COL02, m_Col[ 2 ] );
    DDX_Control(pDX, IDC_COL01, m_Col[ 1 ] );
    DDX_Control(pDX, IDC_COL00, m_Col[ 0 ] );
    DDX_Control(pDX, IDC_SAUVE, m_BpSauve);
    DDX_Control(pDX, IDC_LIRE, m_BpLire);
    DDX_Control(pDX, IDC_AFFICHE, m_BpAffiche);
    DDX_Control(pDX, IDC_CALCULE, m_BpCalcule);
    DDX_Control(pDX, IDC_GAMMA, m_Gamma);
    DDX_Control(pDX, IDC_MODE2, m_Mode2);
    DDX_Control(pDX, IDC_MODE1, m_Mode1);
    DDX_Control(pDX, IDC_MODE0, m_Mode0);
    DDX_Control(pDX, IDC_CORR2, m_Corr2);
    DDX_Control(pDX, IDC_CORR1, m_Corr1);
    DDX_Control(pDX, IDC_LISTE, m_Liste);
    DDX_Control(pDX, IDC_TAILLEORG, m_TailleOrg);
    DDX_Control(pDX, IDC_DPLX, m_DeplX);
    DDX_Control(pDX, IDC_DPLY, m_DeplY);
    DDX_Control(pDX, IDC_NEWTAILLE, m_NewTaille);
    DDX_Control(pDX, IDC_TAILLEX, m_TailleX);
    DDX_Control(pDX, IDC_TAILLEY, m_TailleY);
//    DDX_Control(pDX, IDC_EFFACE, m_BpEfface);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CConvImgCpcDlg, CDialog)
    //{{AFX_MSG_MAP(CConvImgCpcDlg)
    ON_WM_PAINT()
    ON_WM_QUERYDRAGICON()
    ON_BN_CLICKED(IDC_CALCULE, OnCalcule)
    ON_BN_CLICKED(IDC_LIRE, OnLire)
    ON_BN_CLICKED(IDC_AFFICHE, OnAffiche)
    ON_BN_CLICKED(IDC_SAUVE, OnSauve)
    ON_BN_CLICKED(IDC_COL00, OnCol00)
    ON_BN_CLICKED(IDC_COL01, OnCol01)
    ON_BN_CLICKED(IDC_COL02, OnCol02)
    ON_BN_CLICKED(IDC_COL03, OnCol03)
    ON_BN_CLICKED(IDC_COL04, OnCol04)
    ON_BN_CLICKED(IDC_COL05, OnCol05)
    ON_BN_CLICKED(IDC_COL06, OnCol06)
    ON_BN_CLICKED(IDC_COL07, OnCol07)
    ON_BN_CLICKED(IDC_COL08, OnCol08)
    ON_BN_CLICKED(IDC_COL09, OnCol09)
    ON_BN_CLICKED(IDC_COL10, OnCol10)
    ON_BN_CLICKED(IDC_COL11, OnCol11)
    ON_BN_CLICKED(IDC_COL12, OnCol12)
    ON_BN_CLICKED(IDC_COL13, OnCol13)
    ON_BN_CLICKED(IDC_COL14, OnCol14)
    ON_BN_CLICKED(IDC_COL15, OnCol15)
    ON_BN_CLICKED(IDC_TAILLEORG, OnTailleOrg)
    ON_BN_CLICKED(IDC_NEWTAILLE, OnNewTaille)
    ON_BN_CLICKED(IDC_EFFACE, OnEfface)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConvImgCpcDlg message handlers


//
// Initialisation de la boite de dialoge, et cration d'un bitmap
// pour le stockage des images
//
BOOL CConvImgCpcDlg::OnInitDialog()
{
    BITMAPINFO pbmi;

    CDialog::OnInitDialog();

    memset( PalCPC, 0, sizeof( PalCPC ) );
    BpOn();
    m_Gamma.SetWindowText( "100" );
    m_Mode0.SetCheck( 1 );
    m_DeplX.SetWindowText( "0" );
    m_DeplY.SetWindowText( "0" );
    OnTailleOrg();
    m_TailleX.SetWindowText( "640" );
    m_TailleY.SetWindowText( "400" );
    OnNewTaille();
    SetIcon(m_hIcon, TRUE);
    SetIcon(m_hIcon, FALSE);

    SetWindowText( VERSION );
    pbmi.bmiHeader.biSize = sizeof( BITMAPINFOHEADER );
    pbmi.bmiHeader.biWidth = TAILLE_X;
    pbmi.bmiHeader.biHeight = -TAILLE_Y;
    pbmi.bmiHeader.biPlanes = 1;
    pbmi.bmiHeader.biBitCount = 32;
    pbmi.bmiHeader.biCompression = BI_RGB;
    pbmi.bmiHeader.biSizeImage = 0;
    pbmi.bmiHeader.biXPelsPerMeter = 0;
    pbmi.bmiHeader.biYPelsPerMeter = 0;
    pbmi.bmiHeader.biClrUsed = 0;
    pbmi.bmiHeader.biClrImportant = 0;
    bm = CreateDIBSection( GetDC()->m_hDC
                         , &pbmi
                         , DIB_RGB_COLORS
                         , &MemBitmap
                         , NULL
                         , 0
                         );
    if ( bm )
        {
        DcBitmap = CreateCompatibleDC( GetDC()->m_hDC );
        if ( DcBitmap )
            {
            SelectObject( DcBitmap, bm );
            SetStretchBltMode( DcBitmap, COLORONCOLOR );
            return( TRUE );
            }
        }
    return( FALSE );
}

//
// Redessine la fentre... Fonctions propres  WinDaube
//
void CConvImgCpcDlg::OnPaint()
{
    if ( IsIconic() )
        {
        CPaintDC dc( this ); // device context for painting

        SendMessage( WM_ICONERASEBKGND, ( WPARAM )dc.GetSafeHdc(), 0 );

        // Center icon in client rectangle
        int cxIcon = GetSystemMetrics( SM_CXICON );
        int cyIcon = GetSystemMetrics( SM_CYICON );
        CRect rect;
        GetClientRect(&rect);
        int x = ( rect.Width() - cxIcon + 1 ) / 2;
        int y = ( rect.Height() - cyIcon + 1 ) / 2;

        // Draw the icon
        dc.DrawIcon(x, y, m_hIcon);
        }
    else
        {
        StretchBlt( GetDC()->m_hDC, 4, 10, TAILLE_X, TAILLE_Y
                  , DcBitmap, 0, 0, TAILLE_X, TAILLE_Y
                  , SRCCOPY
                  );
        AffichePalette();
        CDialog::OnPaint();
        }
}


HCURSOR CConvImgCpcDlg::OnQueryDragIcon()
{
    return( ( HCURSOR )m_hIcon );
}


//
// Gestion des boites de dialoge Ouvrir/Enregistrer
//
char * CConvImgCpcDlg::OpenNewFile( char * Filtre
                                  , char * Ext
                                  , char * Dir
                                  , BOOL Save
                                  )
{
    static char NomFic[ 256 ];
    OPENFILENAME ofn;
    BOOL ret;
    char * p;

    p = strchr( Dir + 1, '.' );
    * NomFic = 0;
    if ( p )
        {
        while( * p != '\\' )
            * p-- = 0;
        }
    memset( &ofn, 0, sizeof( ofn ) );
    ofn.lStructSize = sizeof( OPENFILENAME );
    ofn.lpstrFilter = Filtre;
    ofn.lpstrCustomFilter = ( LPSTR )NULL;
    ofn.nFilterIndex = 1L;
    ofn.lpstrFile = NomFic;
    ofn.nMaxFile = sizeof( NomFic );
    ofn.lpstrInitialDir = Dir;
    ofn.lpstrDefExt = Ext;
    ofn.Flags = OFN_PATHMUSTEXIST;

    if ( Save )
        {
        ofn.Flags |= OFN_OVERWRITEPROMPT;
        ret = GetSaveFileName( &ofn );
        }
    else
        {
        ofn.Flags |= OFN_FILEMUSTEXIST;
        ret = GetOpenFileName( &ofn );
        }
    return( ( char * )ofn.lpstrFile );
}


//
// Affichage de la palette CPC (16 couleurs max)
//
void CConvImgCpcDlg::AffichePalette( void )
{
    CRect rect;

    for ( int i = 0; i < 16; i++ )
        {
        m_Col[ i ].GetClientRect( rect );
        m_Col[ i ].GetDC()->FillSolidRect( rect, GetRgbCPC( PalCPC[ i ] ) );
        }
}


//
// Lecture d'une image source
//
void CConvImgCpcDlg::OnLire()
{
    char * Nom = OpenNewFile( "fichier image (*.*)\0*.*\0"
                            , "*.*"
                            , ""
                            , FALSE
                            );
    if ( * Nom )
        {
        BpOff();
        wsprintf( Msg, "Lecture %s en cours...", Nom );
        m_Liste.AddString( Msg );
        m_Liste.SetTopIndex( m_Liste.GetCount() - 1 );
        m_Liste.UpdateWindow();
        if ( Picture.Load( Nom ) )
            {
            ImageLue = TRUE;
            ImageCalculee = FALSE;
            SIZE s = Picture.GetImageSize();
            wsprintf( Msg, "Taille image : %dx%d", s.cx, s.cy );
            m_Liste.AddString( "Lecture Ok." );
            m_Liste.AddString( Msg );
            InitBitmap( TRUE );
            wsprintf( Msg, "%s - %s", VERSION, Nom );
            SetWindowText( Msg );
            }
        else
            m_Liste.AddString( "### Erreur de lecture ###" );

        m_Liste.SetTopIndex( m_Liste.GetCount() - 1 );
        BpOn();
        }
}


//
// Effectue la conversion de l'image vers le mode CPC choisi
//
void CConvImgCpcDlg::OnCalcule()
{
    if ( InitBitmap( FALSE ) )
        {
        BpOff();
        ModeCPC = 0;
        if ( m_Mode1.GetCheck() )
            ModeCPC = 1;
        else
            if ( m_Mode2.GetCheck() )
                ModeCPC = 2;

        for ( int i = 0; i < 16; i++ )
            BlockPal[ i ] = m_LockCol[ i ].GetCheck();

        Convert( &m_Liste
               , m_Corr1.GetCheck()
               , m_Corr2.GetCheck()
               , ModeCPC
               , ( int * )MemBitmap
               , PalCPC
               , BlockPal
               );
        ImageCalculee = TRUE;
        StretchBlt( GetDC()->m_hDC, 4, 10, TAILLE_X, TAILLE_Y
                  , DcBitmap, 0, 0, TAILLE_X, TAILLE_Y
                  , SRCCOPY
                  );
        AffichePalette();
        BpOn();
        }
    else
        {
        m_Liste.AddString( "### Pas d'image charge ###" );
        m_Liste.SetTopIndex( m_Liste.GetCount() - 1 );
        }
}


//
// Affiche l'image source  l'cran
//
void CConvImgCpcDlg::OnAffiche()
{
    InitBitmap( TRUE );
}


//
// Initialise le bitmap en mmoire en fonction de l'image source lue,
// et l'affiche  l'cran si demand
//
BOOL CConvImgCpcDlg::InitBitmap( BOOL Affiche )
{
    SIZE s = Picture.GetImageSize();
    int x = 0, y = 0;
    int tx = TAILLE_X, ty = TAILLE_Y;
    if ( s.cx && s.cy )
        {
        char Buf[ 16 ];
        m_Gamma.GetWindowText( Buf, sizeof( Buf ) );
        int Gamma = atoi( Buf );
        if ( Gamma < 1 )
            Gamma = 100;
        if ( Gamma > 400 )
            Gamma = 400;

        m_Gamma.SetWindowText( itoa( Gamma, Buf, 10 ) );
        if ( m_TailleOrg.GetCheck() || m_NewTaille.GetCheck() )
            {
            if ( m_TailleOrg.GetCheck() )
                {
                tx = s.cx;
                ty = s.cy;
                }
            else
                {
                m_TailleX.GetWindowText( Buf, sizeof( Buf ) );
                tx = atoi( Buf );
                m_TailleY.GetWindowText( Buf, sizeof( Buf ) );
                ty = atoi( Buf );
                }
            m_DeplX.GetWindowText( Buf, sizeof( Buf ) );
            x = atoi( Buf );
            m_DeplY.GetWindowText( Buf, sizeof( Buf ) );
            y = atoi( Buf );
            }
        memset( MemBitmap, 0, TAILLE_X * TAILLE_Y * 4 );
        Picture.Render( DcBitmap, CRect( x, y, tx + x, ty + y ) );
        AjusteContraste( ( int * )MemBitmap, Gamma );

        if ( Affiche )
            StretchBlt( GetDC()->m_hDC, 4, 10, TAILLE_X, TAILLE_Y
                      , DcBitmap, 0, 0, TAILLE_X, TAILLE_Y
                      , SRCCOPY
                      );
        return( TRUE );
        }
    return( FALSE );
}


//
// Sauvegarde l'image au format cpc (.SCR)
//
void CConvImgCpcDlg::OnSauve()
{
    char * Nom = OpenNewFile( "fichier scr (*.scr)\0*.scr\0"
                            , "*.scr"
                            , ""
                            , TRUE
                            );
    if ( * Nom )
        {
        BpOff();
        wsprintf( Msg, "Sauvegarde %s en cours...", Nom );
        m_Liste.AddString( Msg );
        m_Liste.SetTopIndex( m_Liste.GetCount() - 1 );
        m_Liste.UpdateWindow();
        if ( SauveCPC( Nom, ( int * )MemBitmap, ModeCPC, PalCPC ) )
            m_Liste.AddString( "Sauvegarde russie." );
        else
            m_Liste.AddString( "### Erreur de sauvegarde ###" );
        m_Liste.SetTopIndex( m_Liste.GetCount() - 1 );
        BpOn();
        }
}


//
// Inhibition de tous les boutons
//
void CConvImgCpcDlg::BpOff( void )
{
    m_BpSauve.EnableWindow( FALSE );
    m_BpLire.EnableWindow( FALSE );
    m_BpAffiche.EnableWindow( FALSE );
    m_BpCalcule.EnableWindow( FALSE );
}


//
// Affichage des boutons autoriss
//
void CConvImgCpcDlg::BpOn( void )
{
    m_BpSauve.EnableWindow( ImageCalculee );
    m_BpLire.EnableWindow( TRUE );
    m_BpAffiche.EnableWindow( ImageLue );
    m_BpCalcule.EnableWindow( ImageLue );
}


//
// Dtournement du OnOK, pour que l'appui sur la touche "entre"
// ne fait rien...
//
void CConvImgCpcDlg::OnOK()
{
}


//
// Gestion du click sur une couleur de la palette : ouverture
// de la fentre de choix de couleur
//
void CConvImgCpcDlg::ClickCol( int NumCol )
{
    CChoixCouleur c( PalCPC[ NumCol ], this );
    c.DoModal();
    if ( c.GetRetour() )
        PalCPC[ NumCol ] = c.GetCouleur(); // Changement de couleur

    AffichePalette();
}


void CConvImgCpcDlg::OnTailleOrg( void )
{
    m_DeplX.EnableWindow( m_TailleOrg.GetCheck() || m_NewTaille.GetCheck() );
    m_DeplY.EnableWindow( m_TailleOrg.GetCheck() || m_NewTaille.GetCheck() );
}


void CConvImgCpcDlg::OnNewTaille( void )
{
    OnTailleOrg();
    m_TailleX.EnableWindow( m_NewTaille.GetCheck() );
    m_TailleY.EnableWindow( m_NewTaille.GetCheck() );
}


void CConvImgCpcDlg::OnEfface( void )
{
    m_Liste.ResetContent();
}


void CConvImgCpcDlg::OnCol00( void )
{
    ClickCol( 0 );
}


void CConvImgCpcDlg::OnCol01( void )
{
    ClickCol( 1 );
}


void CConvImgCpcDlg::OnCol02( void )
{
    ClickCol( 2 );
}


void CConvImgCpcDlg::OnCol03( void )
{
    ClickCol( 3 );
}


void CConvImgCpcDlg::OnCol04( void )
{
    ClickCol( 4 );
}


void CConvImgCpcDlg::OnCol05( void )
{
    ClickCol( 5 );
}


void CConvImgCpcDlg::OnCol06( void )
{
    ClickCol( 6 );
}


void CConvImgCpcDlg::OnCol07( void )
{
    ClickCol( 7 );
}


void CConvImgCpcDlg::OnCol08( void )
{
    ClickCol( 8 );
}


void CConvImgCpcDlg::OnCol09( void )
{
    ClickCol( 9 );
}


void CConvImgCpcDlg::OnCol10( void )
{
    ClickCol( 10 );
}


void CConvImgCpcDlg::OnCol11( void )
{
    ClickCol( 11 );
}


void CConvImgCpcDlg::OnCol12( void )
{
    ClickCol( 12 );
}


void CConvImgCpcDlg::OnCol13( void )
{
    ClickCol( 13 );
}


void CConvImgCpcDlg::OnCol14( void )
{
    ClickCol( 14 );
}


void CConvImgCpcDlg::OnCol15( void )
{
    ClickCol( 15 );
}
