//Read preferences from file
//Adapted from Marq's PETSCII editor

final String machinenames[]={
          "C64",
          "C64M",
          "SPECTRUM",
          "MSX",
          "PLUS4",
          "PLUS4M",
          "CPC"
          };
//a bit sad
final int g_machineidx[]={C64,C64M,SPECTRUM,MSX,PLUS4,PLUS4M,CPC};

void readprefs(String namn)
    {
        String row[]=loadStrings(namn);
        
        if(row==null)
            return;
            
        for(int i=0;i<row.length;i++) // Parse each line
        {
            if(row[i].length()>1)
            {
                String s[]=split(row[i],"=");
                
                if(s[0].equals("ZOOM"))
                {
                    g_uizoom=int(s[1]);
                    if(g_uizoom<1)g_uizoom=2;
                    if(g_uizoom>3)g_uizoom=2;
                }
                    
                if(s[0].equals("MACHINE") && s.length>1)
                {
                    for(int j=0;j<machinenames.length;j++)
                        if(s[1].equals(machinenames[j]))
                            machine=g_machineidx[j];
                }
                
                if(s[0].equals("PATH") && s.length>1)
                {
                    path=s[1];
                }
                
                if(s[0].equals("KEYMACRO") && s.length>1 && s.length<80)
                {
                    g_keymacro=s[1];
                }      
                
                if(s[0].equals("PNGSCALE"))
                {
                    g_omag=int(s[1]);
                    if(g_omag<1||g_omag>10)g_omag=1;
                }
                
                if(s[0].equals("PNGHBORDER"))
                {
                    g_bordh=int(s[1]);
                    if(g_bordh<1||g_bordh>256)g_bordh=64;
                }
                
                if(s[0].equals("PNGVBORDER"))
                {
                    g_bordv=int(s[1]);
                    if(g_bordv<1||g_bordv>256)g_bordv=32;
                }
                
            }
        }
    }
