/******************************************************************************/
/* Configuration pour l'archivage des diffrents lments du fichier source   */
/******************************************************************************/
// !CONFIG!=/L/* /R/* /W"* Nom : "
// Dfinition du systme       !CONFIG!=/V1!EMULATEUR CPC!
// Dfinition du sous systme  !CONFIG!=/V2!WIN-CPC!
// Dfinition du sous ensemble !CONFIG!=/V3!Accessoires!
// Dfinition du module        !CONFIG!=/V4!Gestion sons!
/******************************************************************************/

/********************************************************* !NAME! **************
* !./FLE!
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\Fichiers
********************************************************** !0! *****************
* ------------------------------------------------------------------------------
*          SYSTEME         |      SOUS SYSTEME       |      SOUS ENSEMBLE
* ------------------------------------------------------------------------------
*  EMULATEUR CPC           | WIN-CPC                 | Accessoires
* ------------------------------------------------------------------------------
*  Fichier     : SNDWIN.C              | Version : 0.1p
* ------------------------------------------------------------------------------
*  Date        : 05/11/2002            | Auteur  : L.DEPLANQUE
* ------------------------------------------------------------------------------
*  Description : Gnration des sons
*
* ------------------------------------------------------------------------------
*  Historique  :
*           Date           |         Auteur          |       Description
* ------------------------------------------------------------------------------
*  05/11/2002              | L.DEPLANQUE             | creation
* ------------------------------------------------------------------------------
********************************************************** !END! **************/


#include  <Windows.h>

#include  "types.h"


#define SND_RATE            44100
#define SND_CHANNELS        6
#define SND_BUFSIZE         512
#define SND_BUFFERS         6
#define SND_VOLUME          50


#ifdef USE_SOUND
/********************************************************* !NAME! **************
* Nom : NoiseGen
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Gnrateur de bruit alatoire
*
********************************************************** !0! ****************/
static int NoiseGen;


/********************************************************* !NAME! **************
* Nom : Exit
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Fin demande
*
********************************************************** !0! ****************/
static int Exit;


/********************************************************* !NAME! **************
* Nom : hWave
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Structure HWAVEOUT pour gnration des sons
*
********************************************************** !0! ****************/
static HWAVEOUT hWave = 0;


/********************************************************* !NAME! **************
* Nom : Buf
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Buffer de cration des chantillons sonores par canal
*
********************************************************** !0! ****************/
static UBYTE Buf[ SND_BUFFERS ][ SND_BUFSIZE ];


/********************************************************* !NAME! **************
* Nom : Header
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Structure WAVEHDR pour gnration des sons
*
********************************************************** !0! ****************/
static WAVEHDR Header[ SND_BUFFERS ];


/********************************************************* !NAME! **************
* Nom : Wave
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Buffer de cration des chantillons sonores tout canaux
*
********************************************************** !0! ****************/
static int Wave[ SND_BUFSIZE ];


/********************************************************* !NAME! **************
* Nom : TabChannel
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Canaux sonores
*
********************************************************** !0! ****************/
static struct
    {
    int Freq;
    int Volume;
    int Count;
    } TabChannel[ SND_CHANNELS ];


/********************************************************* !NAME! **************
* Nom : ThreadFunc
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Boucle de gnration des sons
*
* Rsultat    : /
*
* Variables globales modifies : NoiseGen
*
********************************************************** !0! ****************/
static DWORD WINAPI ThreadFunc( void * Param )
{
    int i, j, k, l, n, v;
    HWAVEOUT hw;
    MSG Msg;

    while( GetMessage( &Msg, 0, 0, 0 ) )
        {
        switch( Msg.message )
            {
            case MM_WOM_CLOSE:
                return( 0 );

            case MM_WOM_DONE:
                n = ( WAVEHDR * )Msg.lParam - &Header[ 0 ];
                hw = ( HWAVEOUT )Msg.wParam;
                if ( Header[ n ].dwFlags & WHDR_PREPARED )
                    waveOutUnprepareHeader( hw, &Header[ n ], sizeof( WAVEHDR ) );

                if ( Exit )
                    break;

                for ( j = 0; j < SND_CHANNELS; j++ )
                    {
                    v = TabChannel[ j ].Volume;
                    if ( TabChannel[ j ].Freq && v )
                        if ( j > 2 )
                            {
                            //
                            // Canaux "bruit blanc"
                            //
                            if ( TabChannel[ j ].Freq <= SND_RATE )
                                k = 0x10000 * TabChannel[ j ].Freq / SND_RATE;
                            else
                                {
                                v = v * SND_RATE / TabChannel[ j ].Freq;
                                k = 0x10000;
                                }
                            l = TabChannel[ j ].Count;
                            for( i = 0; i < SND_BUFSIZE; i++ )
                                {
                                l += k;
                                if ( l & 0xFFFF0000 )
                                    {
                                    if ( ( NoiseGen <<= 1 ) & 0x80000000 )
                                        NoiseGen ^= 0x08000001;

                                    l &= 0xFFFF;
                                    }
                                Wave[ i ] += ( NoiseGen & 1 ? 127 : -128 ) * v;
                                }
                            TabChannel[ j ].Count = l;
                            }
                        else
                            //
                            // Canaux "standard"
                            //
                            if ( TabChannel[ j ].Freq < SND_RATE / 2 )
                                {
                                k = 0x10000 * TabChannel[ j ].Freq / SND_RATE;
                                l = TabChannel[ j ].Count;
                                for ( i = 0; i < SND_BUFSIZE; i++, l += k )
                                    Wave[ i ] += ( l & 0x8000 ? 127 : -128 ) * v;

                                TabChannel[ j ].Count = l & 0xFFFF;
                                }
                    }
                n = ( WAVEHDR * )Msg.lParam - &Header[ 0 ];
                for ( i = 0; i < SND_BUFSIZE; i++ )
                    {
                    Buf[ n ][ i ] = ( UBYTE )( ( ( Wave[ i ] * SND_VOLUME ) >> 16 ) + 128 );
                    Wave[ i ] = 0;
                    }
                Header[ n ].lpData = ( char * )&Buf[ n ];
                Header[ n ].dwBufferLength = SND_BUFSIZE;
                Header[ n ].dwFlags = 0;
                waveOutPrepareHeader( hw, &Header[ n ], sizeof( WAVEHDR ) );
                waveOutWrite( hw, &Header[ n ], sizeof( WAVEHDR ) );
                break;
            }
        }
    return( 0 );
}


/********************************************************* !NAME! **************
* Nom : InitWave
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Initialisation des structures de gnration de sons
*
* Rsultat    : TRUE si ok, FALSE sinon
*
* Variables globales modifies : Header
*
********************************************************** !0! ****************/
static BOOL InitWave( void )
{
    WAVEFORMATEX Format;
    DWORD ThreadID = 0;
    HANDLE hThread;
    int j;

    Exit = 0;
    hThread = CreateThread( 0, 0, ( LPTHREAD_START_ROUTINE )ThreadFunc, 0, 0, &ThreadID );
    if ( ! hThread )
        return( FALSE );

    SetThreadPriority( hThread, THREAD_PRIORITY_TIME_CRITICAL );
    CloseHandle( hThread );
    Sleep( 100 );
    Format.wFormatTag = WAVE_FORMAT_PCM;
    Format.nChannels = 1;
    Format.nSamplesPerSec = SND_RATE;
    Format.wBitsPerSample = 8;
    Format.nBlockAlign = 1;
    Format.nAvgBytesPerSec = SND_RATE;
    Format.cbSize = 0;
    if ( waveOutOpen( &hWave
                    , WAVE_MAPPER
                    , ( LPWAVEFORMATEX )&Format
                    , ThreadID
                    , 0
                    , CALLBACK_THREAD
                    )
       )
        {
        PostThreadMessage( ThreadID, MM_WOM_CLOSE, ( WPARAM )hWave, 0 );
        return( FALSE );
        }
    for ( j = 0; j < SND_BUFFERS; j++ )
        {
        memset( &Header[ j ], 0, sizeof( WAVEHDR ) );
        memset( &Buf[ j ], 128, SND_BUFSIZE );
        Header[ j ].lpData = ( char * )&Buf[ j ];
        Header[ j ].dwBufferLength = SND_BUFSIZE;
        Header[ j ].dwUser = j;
        waveOutPrepareHeader( hWave, &Header[ j ], sizeof( WAVEHDR ) );
        waveOutWrite( hWave, &Header[ j ], sizeof( WAVEHDR ) );
        }
    return( TRUE );
}


/********************************************************* !NAME! **************
* Nom : EndSound
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Termine l'mission de sons
*
* Rsultat    : /
*
* Variables globales modifies : hWave
*
********************************************************** !0! ****************/
void EndSound( void )
{
    int j;

    Exit = 1;
    if ( hWave )
        {
        waveOutReset( hWave );
        for( j = 0; j < SND_BUFFERS; j++ )
            if ( Header[ j ].dwFlags & WHDR_PREPARED )
                waveOutUnprepareHeader( hWave, &Header[ j ], sizeof( WAVEHDR ) );

        do
            {
            waveOutReset( hWave );
            }
        while( waveOutClose( hWave ) == WAVERR_STILLPLAYING );
        }
    hWave = 0;
}


/********************************************************* !NAME! **************
* Nom : InitSound
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Initialisation de l'mission sonore
*
* Rsultat    : TRUE si ok, FALSE sinon
*
* Variables globales modifies : NoiseGen
*
********************************************************** !0! ****************/
BOOL InitSound( void )
{
    EndSound();
    memset( TabChannel, 0, sizeof( TabChannel ) );
    NoiseGen = 1;
    return( InitWave() );
}


/********************************************************* !NAME! **************
* Nom : Sound
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Modifie la frquence/volume d'un canal
*
* Rsultat    : /
*
* Variables globales modifies : TabChannel
*
********************************************************** !0! ****************/
void SetSound( int Channel, int Freq, int Volume )
{
    TabChannel[ Channel ].Freq = Freq;
    TabChannel[ Channel ].Volume = Volume;
}
#endif
