/******************************************************************************/
/* Configuration pour l'archivage des diffrents lments du fichier source   */
/******************************************************************************/
// !CONFIG!=/L/* /R/* /W"* Nom : "
// Dfinition du systme       !CONFIG!=/V1!EMULATEUR CPC!
// Dfinition du sous systme  !CONFIG!=/V2!WIN-CPC!
// Dfinition du sous ensemble !CONFIG!=/V3!Accessoires!
// Dfinition du module        !CONFIG!=/V4!Snapshots!
/******************************************************************************/

/********************************************************* !NAME! **************
* !./FLE!
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\Fichiers
********************************************************** !0! *****************
* ------------------------------------------------------------------------------
*          SYSTEME         |      SOUS SYSTEME       |      SOUS ENSEMBLE
* ------------------------------------------------------------------------------
*  EMULATEUR CPC           | WIN-CPC                 | Accessoires
* ------------------------------------------------------------------------------
*  Fichier     : SNAPSHOT.C            | Version : 0.1p
* ------------------------------------------------------------------------------
*  Date        : 05/11/2002            | Auteur  : L.DEPLANQUE
* ------------------------------------------------------------------------------
*  Description : Lecture/criture des fichiers snapshots
*
* ------------------------------------------------------------------------------
*  Historique  :
*           Date           |         Auteur          |       Description
* ------------------------------------------------------------------------------
*  05/11/2002              | L.DEPLANQUE             | creation
* ------------------------------------------------------------------------------
*  13/11/2002              | L.DEPLANQUE             | Passage du nom de fichier
*                          |                         | snapshot en paramtre aux
*                          |                         | fonctions LireSnap() et
*                          |                         | SauveSnap().  
* ------------------------------------------------------------------------------
********************************************************** !END! **************/


#include  <stdio.h>

#include  "types.h"
#include  "plateform.h"
#include  "config.h"
#include  "AY8912.h"
#include  "Sound.h"
#include  "crtc.h"
#include  "ppi.h"
#include  "vga.h"
#include  "z80.h"
#ifdef USE_LOG
#include  "log.h"
#endif


/********************************************************* !NAME! **************
* Nom : StSnapShot
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Structures
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Structure en-tte fichier snapshot
*
********************************************************** !0! ****************/
typedef struct
    {
    char  Id[ 0x10 ]; // "MV - SNA'
    UBYTE Version;
    SRegs Z80;
    UBYTE InkReg;
    UBYTE InkData[ 17 ];
    UBYTE VGARom;
    UBYTE VGARam;
    UBYTE CRTCIndex;
    UBYTE CRTCReg[ 18 ];
    UBYTE NumRom;
    UBYTE PPI[ 4 ];
    UBYTE PsgIndex;
    UBYTE PsgData[ 16 ];
    USHORT MemSize;
    UBYTE Unused[ 0x93 ];
    } StSnapShot;


/********************************************************* !NAME! **************
* Nom : SnapShot
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Structure Snapshot
*
********************************************************** !0! ****************/
static StSnapShot SnapShot;


/********************************************************* !NAME! **************
* Nom : SauveSnap
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Sauvegarde d'un fichier snapshot
*
* Rsultat    : /
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
void SauveSnap( char * Nom )
{
    int i;

    FILE * fp = fopen( Nom, "wb" );
#ifdef USE_LOG
    sprintf( MsgLog, "Sauvegarde snapshot : %s", Nom );
    Log( MsgLog, LOG_INFO );
#endif
    if ( fp )
        {
        strcpy( SnapShot.Id, "MV - SNA" );
        SnapShot.Version = 1;
        memcpy( &SnapShot.Z80, &Z80, sizeof( SnapShot.Z80 ) );
        SnapShot.InkReg = ( UBYTE )PenSelect;
        for ( i = 0; i < 16; i++ )
            SnapShot.InkData[ i ] = ( UBYTE )TabInk[ i ];

        SnapShot.VGARom = ( UBYTE )DecodeurAdresse;
        SnapShot.VGARam = ( UBYTE )RamSelect;
        SnapShot.CRTCIndex = ( UBYTE )RegCRTCSel;
        for ( i = 0; i < 18; i++ )
            SnapShot.CRTCReg[ i ] = ( UBYTE )RegsCRTC[ i ];

        SnapShot.NumRom = ( UBYTE )RomExt;
        for ( i = 0; i < 4; i++ )
            SnapShot.PPI[ i ] = ( UBYTE )RegsPPI[ i ];

        SnapShot.PsgIndex = ( UBYTE )RegPSGSel;
        for ( i = 0; i < 16; i++ )
            SnapShot.PsgData[ i ] = ( UBYTE )RegsPSG[ i ];

        SnapShot.MemSize = 128;
        fwrite( &SnapShot, sizeof( SnapShot ), 1, fp );
        fwrite( MemCPC, sizeof( MemCPC ), 1, fp );
        fclose( fp );
        }
#ifdef USE_LOG
    else
        Log( "Erreur criture fichier snapshot.", LOG_WARNING );
#endif
}


/********************************************************* !NAME! **************
* Nom : LireSnap
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Lecture d'un fichier snapshot
*
* Rsultat    : /
*
* Variables globales modifies : Z80, PenSenect, RegPSGSel, RomExt, RegCRTCSel
*
********************************************************** !0! ****************/
void LireSnap( char * Nom )
{
    int i;

    FILE * fp = fopen( Nom, "rb" );
#ifdef USE_LOG
    sprintf( MsgLog, "Lecture snapshot : %s", Nom );
    Log( MsgLog, LOG_INFO );
#endif
    if ( fp )
        {
        fread( &SnapShot, sizeof( SnapShot ), 1, fp );
        if ( ! strncmp( SnapShot.Id, "MV - SNA", 8 ) )
            {
            fread( MemCPC, sizeof( MemCPC ), 1, fp );
            memcpy( &Z80, &SnapShot.Z80,  sizeof( SnapShot.Z80 ) );
            for ( i = 0; i < 17; i++ )
                {
                WriteVGA( i );
                WriteVGA( 0x40 | SnapShot.InkData[ i ] );
                }
            PenSelect = SnapShot.InkReg;

            WritePPI( 0xF400, SnapShot.PPI[ 0 ] );
            WritePPI( 0xF600, SnapShot.PPI[ 2 ] );
            WritePPI( 0xF700, SnapShot.PPI[ 3 ] );
#ifdef USE_SOUND
            Reset8912();
            for ( i = 0; i < 16; i++ )
                Write8912( i, SnapShot.PsgData[ i ] );
#endif
            RegPSGSel = SnapShot.PsgIndex;

            RomExt = SnapShot.NumRom;
            WriteVGA( 0x80 | SnapShot.VGARom );
            WriteVGA( 0xC0 | SnapShot.VGARam );

            for ( i = 0; i < 18; i++ )
                {
                WriteCRTC( 0xBC00, i );
                WriteCRTC( 0xBD00, SnapShot.CRTCReg[ i ] );
                }
            RegCRTCSel = SnapShot.CRTCIndex;
            }
#ifdef USE_LOG
        else
            Log( "Fichier snapshot non reconnu.", LOG_INFO );
#endif
        fclose( fp );
        }
#ifdef USE_LOG
    else
        Log( "Erreur lecture fichier snapshot.", LOG_WARNING );
#endif
}
