/******************************************************************************/
/* Configuration pour l'archivage des diffrents lments du fichier source   */
/******************************************************************************/
// !CONFIG!=/L/* /R/* /W"* Nom : "
// Dfinition du systme       !CONFIG!=/V1!EMULATEUR CPC!
// Dfinition du sous systme  !CONFIG!=/V2!WIN-CPC!
// Dfinition du sous ensemble !CONFIG!=/V3!Chips!
// Dfinition du module        !CONFIG!=/V4!CRTC 6845!
/******************************************************************************/

/********************************************************* !NAME! **************
* !./FLE!
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\Fichiers
********************************************************** !0! *****************
* ------------------------------------------------------------------------------
*          SYSTEME         |      SOUS SYSTEME       |      SOUS ENSEMBLE
* ------------------------------------------------------------------------------
*  EMULATEUR CPC           | WIN-CPC                 | Chips
* ------------------------------------------------------------------------------
*  Fichier     : CRTC.C                | Version : 0.1r
* ------------------------------------------------------------------------------
*  Date        : 05/11/2002            | Auteur  : L.DEPLANQUE
* ------------------------------------------------------------------------------
*  Description : Emulation du CRTC 6845
*
* ------------------------------------------------------------------------------
*  Historique  :
*           Date           |         Auteur          |       Description
* ------------------------------------------------------------------------------
*  05/11/2002              | L.DEPLANQUE             | creation
* ------------------------------------------------------------------------------
*  13/11/2002              | L.DEPLANQUE             | Changement du type de
*                          |                         | la variable TabAdrCrtc : 
*                          |                         | passage en USHORT, pour
*                          |                         | optimiser le memset
*                          |                         | dans CalcAdrEcrCPC()
* ------------------------------------------------------------------------------
********************************************************** !END! **************/


#include  <string.h>

#include  "types.h"


/********************************************************* !NAME! **************
* Nom : TabAdrCrtc
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Tableau des adresses ecran du CPC
*
********************************************************** !0! ****************/
USHORT TabAdrCrtc[ 0x10000 ];


/********************************************************* !NAME! **************
* Nom : RegsCRTC
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Registres du CRTC
*
********************************************************** !0! ****************/
int RegsCRTC[ 32 ];


/********************************************************* !NAME! **************
* Nom : OfsEcr
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Offset de l'cran
*
********************************************************** !0! ****************/
int OfsEcr;


/********************************************************* !NAME! **************
* Nom : RegCRTCSel
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Numro du registre CRTC slectionn
*
********************************************************** !0! ****************/
int RegCRTCSel = 0;


/********************************************************* !NAME! **************
* Nom : CalcAdrEcrCPC
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Calcule les adresses de conversions linaires -> mmoire cran
*               CPC
*
* Rsultat    : /
*
* Variables globales modifies : TabAdrCrtc
*
********************************************************** !0! ****************/
static void CalcAdrEcrCPC( void )
{
    int tc = RegsCRTC[ 1 ] << 1;
    int nl = RegsCRTC[ 6 ];
    int offset = ( RegsCRTC[ 13 ] + ( RegsCRTC[ 12 ] << 8 ) ) << 1;
    int ofsL = ( 46 - RegsCRTC[ 2 ]  ) << 1;
    int reste = 2048 - nl * tc, adr = 0;
    int decal, AdrCPC, TailleColonne, NbLignes, NbBlocks;
    int TailleChar = RegsCRTC[ 9 ] + 1;
    int offset7 = 259 + RegsCRTC[ 5 ] - ( RegsCRTC[ 7 ] * TailleChar );

    if ( offset7 < 0 )
        offset7 = 0;

    if ( ofsL < 0 )
        ofsL = 0;

    memset( TabAdrCrtc, -1, sizeof( TabAdrCrtc ) );
    for ( NbBlocks = 0; NbBlocks < TailleChar; NbBlocks++ )
        {
        decal = NbBlocks + offset7;
        for ( NbLignes = nl; NbLignes--; )
            {
            TailleColonne = tc;
            for ( AdrCPC = decal * 80 + ofsL; TailleColonne--; adr++ )
                TabAdrCrtc[ AdrCPC++ ] = ( USHORT )( ( adr & 0x7800 )
                                                   + ( ( offset + adr ) & 0x7FF )
                                                   );

            decal += TailleChar;
            }
        adr += reste;
        }
}


/********************************************************* !NAME! **************
* Nom : WriteCRTC
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Ecriture d'un registre du CRTC
*
* Rsultat    : /
*
* Variables globales modifies : RegsCRTC
*
********************************************************** !0! ****************/
void WriteCRTC( int adr, int val )
{
    adr &= 0xBF00;
    if ( adr == 0xBC00 )
        RegCRTCSel = val & 0x1F;
    else
        if ( adr == 0xBD00 )
            {
            if ( RegsCRTC[ RegCRTCSel ] != val )
                {
                //
                // Si changement de banque cran, mmorise seulement registre
                //
                if (  RegCRTCSel == 12 
                   && ( ( RegsCRTC[ 12 ] & 0x0F ) == ( val & 0x0F ) )
                   )
                    RegsCRTC[ RegCRTCSel ] = val;
                else
                    {
                    RegsCRTC[ RegCRTCSel ] = val;
                    CalcAdrEcrCPC();
                    }
                }
            OfsEcr = ( RegsCRTC[ 12 ] & 0x30 ) << 10;
            }
}
