/******************************************************************************/
/* Configuration pour l'archivage des diffrents lments du fichier source   */
/******************************************************************************/
// !CONFIG!=/L/* /R/* /W"* Nom : "
// Dfinition du systme       !CONFIG!=/V1!EMULATEUR CPC!
// Dfinition du sous systme  !CONFIG!=/V2!WIN-CPC!
// Dfinition du sous ensemble !CONFIG!=/V3!Accessoires!
// Dfinition du module        !CONFIG!=/V4!Gestion Configuration!
/******************************************************************************/

/********************************************************* !NAME! **************
* !./FLE!
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\Fichiers
********************************************************** !0! *****************
* ------------------------------------------------------------------------------
*          SYSTEME         |      SOUS SYSTEME       |      SOUS ENSEMBLE
* ------------------------------------------------------------------------------
*  EMULATEUR CPC           | WIN-CPC                 | Accessoires
* ------------------------------------------------------------------------------
*  Fichier     : CONFIG.C              | Version : 0.1x
* ------------------------------------------------------------------------------
*  Date        : 05/11/2002            | Auteur  : L.DEPLANQUE
* ------------------------------------------------------------------------------
*  Description : Dcodage du fichier de configuration
*
* ------------------------------------------------------------------------------
*  Historique  :
*           Date           |         Auteur          |       Description
* ------------------------------------------------------------------------------
*  05/11/2002              | L.DEPLANQUE             | creation
* ------------------------------------------------------------------------------
*  06/01/2003              | L.DEPLANQUE             | Version 0.1t : Gestion
*                          |                         | nouvelles variables :
*                          |                         | localisation des roms
* ------------------------------------------------------------------------------
*  09/01/2003              | L.DEPLANQUE             | Version 0.1u : Gestion
*                          |                         | nouvelles variables :
*                          |                         | touches joystick
* ------------------------------------------------------------------------------
*  03/02/2003              | L.DEPLANQUE             | Version 0.1v : Gestion
*                          |                         | nouvelles variables :
*                          |                         | localisation fichiers
*                          |                         | DSK, SNA, TAP
* ------------------------------------------------------------------------------
*  06/05/2003              | L.DEPLANQUE             | Version 0.1w :
*                          |                         | Initialisation des
*                          |                         | valeurs par dfaut pour
*                          |                         | les variables contenant
*                          |                         | les scan-codes des
*                          |                         | touches mulant le
*                          |                         | joystick
* ------------------------------------------------------------------------------
*  22/01/2004              | L.DEPLANQUE             | Version 0.1x : Gestion
*                          |                         | nouvelle variable :
*                          |                         | localisation rpertoire
*                          |                         | emulation disque
* ------------------------------------------------------------------------------
*  03/02/2004              | L.DEPLANQUE             | Version 0.1y : 
*                          |                         | Suppression des
*                          |                         | fonctions de lecture
*                          |                         | des variables de type
*                          |                         | paramtres, et passage
*                          |                         | de ces variables en
*                          |                         | variables globales.
* ------------------------------------------------------------------------------
********************************************************** !END! **************/


#include  <stdlib.h>
#include  <string.h>
#include  <stdio.h>

#include  "types.h"


#define     CONFIG_NAME     "CONFIG.CPC"


/********************************************************* !NAME! **************
* Nom : FrameSkip
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Frquence de rafraichissement cran
*
********************************************************** !0! ****************/
int FrameSkip = 0;


/********************************************************* !NAME! **************
* Nom : ScreenDepth
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Nombre de couleurs cran (bits)
*
********************************************************** !0! ****************/
int ScreenDepth = 8;


/********************************************************* !NAME! **************
* Nom : SmallScreen
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Petit cran ou non
*
********************************************************** !0! ****************/
int SmallScreen = 0;


/********************************************************* !NAME! **************
* Nom : Sound
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Son ou non
*
********************************************************** !0! ****************/
int Sound = 1;


/********************************************************* !NAME! **************
* Nom : Multiface
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Multiface active ou non
*
********************************************************** !0! ****************/
int Multiface = 1;


/********************************************************* !NAME! **************
* Nom : FreqLigne
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Frquence d'une ligne cran (en Hertz)
*
********************************************************** !0! ****************/
int FreqLigne = 15625;


/********************************************************* !NAME! **************
* Nom : CycleLigne
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Nombre de cycles machines par ligne cran
*
********************************************************** !0! ****************/
int CycleLigne = 256;


/********************************************************* !NAME! **************
* Nom : LogLevel
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Niveau de logging
*
********************************************************** !0! ****************/
int LogLevel = 3;


/********************************************************* !NAME! **************
* Nom : LocRomInf
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Localisation du fichier contenant la rom infrieure du CPC
*
********************************************************** !0! ****************/
char LocRomInf[ 128 ] = "..\\ROMS\\ROMINF.CPC";


/********************************************************* !NAME! **************
* Nom : LocRomSup
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Localisation du fichier contenant la rom suprieure du CPC
*
********************************************************** !0! ****************/
char LocRomSup[ 128 ] = "..\\ROMS\\ROMSUP.CPC";


/********************************************************* !NAME! **************
* Nom : LocRomDisc
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Localisation du fichier contenant la rom disque du CPC
*
********************************************************** !0! ****************/
char LocRomDisc[ 128 ] = "..\\ROMS\\ROMDISC.CPC";


/********************************************************* !NAME! **************
* Nom : LocRomMulti
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Localisation du fichier contenant la rom de l'interface
*               Multiface II
*
********************************************************** !0! ****************/
char LocRomMulti[ 128 ] = "..\\ROMS\\MULTIFACE.ROM";


/********************************************************* !NAME! **************
* Nom : JoyLeft
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Scan code de touche mulant joystick direction gauche
*
********************************************************** !0! ****************/
int JoyLeft = 0xFF;


/********************************************************* !NAME! **************
* Nom : JoyRight
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Scan code de touche mulant joystick direction droite
*
********************************************************** !0! ****************/
int JoyRight = 0xFF;


/********************************************************* !NAME! **************
* Nom : JoyUp
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Scan code de touche mulant joystick direction haut
*
********************************************************** !0! ****************/
int JoyUp = 0xFF;


/********************************************************* !NAME! **************
* Nom : JoyDown
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Scan code de touche mulant joystick direction bas
*
********************************************************** !0! ****************/
int JoyDown = 0xFF;


/********************************************************* !NAME! **************
* Nom : JoyFire1
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Scan code de touche mulant joystick bouton feux 1
*
********************************************************** !0! ****************/
int JoyFire1 = 0xFF;


/********************************************************* !NAME! **************
* Nom : JoyFire2
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Scan code de touche mulant joystick bouton feux 2
*
********************************************************** !0! ****************/
int JoyFire2 = 0xFF;


/********************************************************* !NAME! **************
* Nom : DirSnap
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Localisation du rpertoire contenant les fichiers snapshots
*
********************************************************** !0! ****************/
char DirSnap[ 256 ] = "..\\Snap";


/********************************************************* !NAME! **************
* Nom : DirTape
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Localisation du rpertoire contenant les fichiers cassettes
*
********************************************************** !0! ****************/
char DirTape[ 256 ] = "..\\Tape";


/********************************************************* !NAME! **************
* Nom : DirDisc
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Localisation du rpertoire contenant les fichiers disquettes
*
********************************************************** !0! ****************/
char DirDisc[ 256 ] = "..\\Disc";


/********************************************************* !NAME! **************
* Nom : DirEmuDisc
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Localisation du rpertoire servant  l'mulation disque
*
********************************************************** !0! ****************/
char DirEmuDisc[ 256 ] = "A:";


/********************************************************* !NAME! **************
* Nom : GetVal
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Retourne une valeur numrique contenue dans une chaine
*
* Rsultat    : La valeur contenue dans la chaine
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
static int GetVal( char * Chaine )
{
    int val = 0;

    while ( * Chaine == ' ' )
        Chaine++;

    if ( Chaine[ 0 ] == 'O' && Chaine[ 1 ] == 'N' )
        val = 1;
    else
        val = atoi( Chaine );

    return( val );
}


/********************************************************* !NAME! **************
* Nom : GetChaine
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Retourne une valeur alphanumrique contenue dans une chaine
*
* Rsultat    : La valeur contenue dans la chaine
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
static char * GetChaine( char * Chaine )
{
    char * p;

    while ( * Chaine == ' ' )
        Chaine++;

    p = Chaine;
    while( * p && * p >= ' ' )
        p++;

    * p = 0;
    return( Chaine );
}


/********************************************************* !NAME! **************
* Nom : ReadConfig
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Lecture du fichier config. et affectation des variables
*               concernes
*
* Rsultat    : TRUE si lecture fichier config. OK, FALSE sinon
*
* Variables globales modifies : FrameSkip, ScreenDepth, SmallScreen, Sound, 
*                                Multiface, LogLevel, FreqLigne, CycleLigne,
*                                LocRomInf, LocRomSup, LocRomDisc, LocRomMulti,
*                                JoyLeft, JoyRight, JoyUp, JoyDown, JoyFire1,
*                                JoyFire2, DirSnap, DirTape, DirDisc
*
********************************************************** !0! ****************/
BOOL ReadConfig( void )
{
    static char Buffer[ 80 ];

    FILE * fp = fopen( CONFIG_NAME, "rt" );
    if ( fp )
        {
        while( fgets( Buffer, sizeof( Buffer ), fp ) )
            {
            if ( Buffer[ 0 ] == '#' )
                {
                if ( ! strncmp( Buffer, "#FRAMESKIP", 10 ) )
                    FrameSkip = GetVal( &Buffer[ 12 ] );

                if ( ! strncmp( Buffer, "#SCREEN_DEPTH", 13 ) )
                    ScreenDepth = GetVal( &Buffer[ 15 ] );

                if ( ! strncmp( Buffer, "#SMALL_SCREEN", 13 ) )
                    SmallScreen = GetVal( &Buffer[ 15 ] );

                if ( ! strncmp( Buffer, "#SOUND", 6 ) )
                    Sound = GetVal( &Buffer[ 8 ] );

                if ( ! strncmp( Buffer, "#MULTIFACE", 10 ) )
                    Multiface = GetVal( &Buffer[ 12 ] );

                if ( ! strncmp( Buffer, "#LOG_LEVEL", 10 ) )
                    LogLevel = GetVal( &Buffer[ 12 ] );

                if ( ! strncmp( Buffer, "#FREQ_LIGNE", 11 ) )
                    FreqLigne = GetVal( &Buffer[ 13 ] );

                if ( ! strncmp( Buffer, "#CYCLE_LIGNE", 12 ) )
                    CycleLigne = GetVal( &Buffer[ 14 ] );

                if ( ! strncmp( Buffer, "#ROM_INF", 8 ) )
                    strcpy( LocRomInf, GetChaine( &Buffer[ 10 ] ) );

                if ( ! strncmp( Buffer, "#ROM_SUP", 8 ) )
                    strcpy( LocRomSup, GetChaine( &Buffer[ 10 ] ) );

                if ( ! strncmp( Buffer, "#ROM_DISC", 9 ) )
                    strcpy( LocRomDisc, GetChaine( &Buffer[ 11 ] ) );

                if ( ! strncmp( Buffer, "#ROM_MULTI", 10 ) )
                    strcpy( LocRomMulti, GetChaine( &Buffer[ 12 ] ) );

                if ( ! strncmp( Buffer, "#JOY_LEFT", 9 ) )
                    JoyLeft = GetVal( &Buffer[ 11 ] );

                if ( ! strncmp( Buffer, "#JOY_RIGHT", 10 ) )
                    JoyRight = GetVal( &Buffer[ 12 ] );

                if ( ! strncmp( Buffer, "#JOY_UP", 7 ) )
                    JoyUp = GetVal( &Buffer[ 9 ] );

                if ( ! strncmp( Buffer, "#JOY_DOWN", 9 ) )
                    JoyDown = GetVal( &Buffer[ 11 ] );

                if ( ! strncmp( Buffer, "#JOY_FIRE1", 10 ) )
                    JoyFire1 = GetVal( &Buffer[ 12 ] );

                if ( ! strncmp( Buffer, "#JOY_FIRE2", 10 ) )
                    JoyFire2 = GetVal( &Buffer[ 12 ] );

                if ( ! strncmp( Buffer, "#DIR_SNAP", 9 ) )
                    strcpy( DirSnap, GetChaine( &Buffer[ 11 ] ) );

                if ( ! strncmp( Buffer, "#DIR_TAPE", 9 ) )
                    strcpy( DirTape, GetChaine( &Buffer[ 11 ] ) );

                if ( ! strncmp( Buffer, "#DIR_DISC", 9 ) )
                    strcpy( DirDisc, GetChaine( &Buffer[ 11 ] ) );

                if ( ! strncmp( Buffer, "#DIR_EMU_DISC", 13 ) )
                    strcpy( DirEmuDisc, GetChaine( &Buffer[ 15 ] ) );
                }
            }
        fclose( fp );
        return( TRUE );
        }
    return( FALSE );
}
