/******************************************************************************/
/* Configuration pour l'archivage des diffrents lments du fichier source   */
/******************************************************************************/
// !CONFIG!=/L/* /R/* /W"* Nom : "
// Dfinition du systme       !CONFIG!=/V1!EMULATEUR CPC!
// Dfinition du sous systme  !CONFIG!=/V2!WIN-CPC!
// Dfinition du sous ensemble !CONFIG!=/V3!Chips!
// Dfinition du module        !CONFIG!=/V4!PSG AY3-8912!
/******************************************************************************/

/********************************************************* !NAME! **************
* !./FLE!
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\Fichiers
********************************************************** !0! *****************
* ------------------------------------------------------------------------------
*          SYSTEME         |      SOUS SYSTEME       |      SOUS ENSEMBLE
* ------------------------------------------------------------------------------
*  EMULATEUR CPC           | WIN-CPC                 | Chips
* ------------------------------------------------------------------------------
*  Fichier     : AY8912.C              | Version : 0.1s
* ------------------------------------------------------------------------------
*  Date        : 05/11/2002            | Auteur  : L.DEPLANQUE
* ------------------------------------------------------------------------------
*  Description : Emulation du PSG AY3 8912
*
* ------------------------------------------------------------------------------
*  Historique  :
*           Date           |         Auteur          |       Description
* ------------------------------------------------------------------------------
*  05/11/2002              | L.DEPLANQUE             | creation
* ------------------------------------------------------------------------------
*  06/11/2002              | L.DEPLANQUE             | optimisations minimes
* ------------------------------------------------------------------------------
*  03/12/2002              | L.DEPLANQUE             | correction bugg 
*                          |                         | (rgrssion) dans la
*                          |                         | gnration d'enveloppes  
* ------------------------------------------------------------------------------
********************************************************** !END! **************/


#include  "Types.h"
#include  "Sound.h"


#define AY8912_FMAX     62500

#define SOUND_CHANNELS  6


/********************************************************* !NAME! **************
* Nom : RegsPSG
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Registres 0  15 du PSG
*
********************************************************** !0! ****************/
int RegsPSG[ 16 ];


#ifdef USE_SOUND
/********************************************************* !NAME! **************
* Nom : Freq
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Tableau des frquences
*
********************************************************** !0! ****************/
static int Freq[ SOUND_CHANNELS ];


/********************************************************* !NAME! **************
* Nom : Vol
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Tableau des volumes
*
********************************************************** !0! ****************/
static int Vol[ SOUND_CHANNELS ];

/********************************************************* !NAME! **************
* Nom : EPeriod
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Priode d'enveloppe
*
********************************************************** !0! ****************/
static int EPeriod;

/********************************************************* !NAME! **************
* Nom : ECount
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Temps de la dernire modification de priode d'enveloppe
*
********************************************************** !0! ****************/
static int ECount;


/********************************************************* !NAME! **************
* Nom : BmChange
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Bitmap contenant les canaux qui ont ts modifis
*
********************************************************** !0! ****************/
static int BmChange;


/********************************************************* !NAME! **************
* Nom : Env
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Enveloppes de volumes
*
********************************************************** !0! ****************/
static int Env[ 3 ];


/********************************************************* !NAME! **************
* Nom : Write8912
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Ecriture d'un registre du 8912
*
* Rsultat    : /
*
* Variables globales modifies : RegsPsg
*
********************************************************** !0! ****************/
void Write8912( int Reg, int Val )
{
    int i, j, Reg7Mod;

    if ( ( RegsPSG[ Reg ] != Val ) || ( ( Reg > 7 ) && ( Reg < 11 ) ) )
        {
        Reg7Mod = ( Val ^ RegsPSG[ 7 ] ) & 0x3F;
        RegsPSG[ Reg ] = Val;
        switch( Reg )
            {
            case 0:
            case 1:
            case 2:
            case 3:
            case 4:
            case 5:
                if ( ! ( RegsPSG[ 7 ] & ( 1 << ( Reg >> 1 ) ) ) )
                    {
                    i = Reg & 0xFE;
                    j = ( ( RegsPSG[ i + 1 ] & 0x0F ) << 8 ) + RegsPSG[ i ];
                    i >>= 1;
                    Freq[ i ] = j + 1;
                    BmChange |= 1 << i;
                    }
                break;

            case 6:
                if ( ~RegsPSG[ 7 ] & 0x38 )
                    {
                    j = ( Val & 0x1F ) + 1;
                    if ( ! ( RegsPSG[ 7 ] & 0x08 ) )
                        Freq[ 3 ] = j;

                    if ( ! ( RegsPSG[ 7 ] & 0x10 ) )
                        Freq[ 4 ] = j;

                    if ( ! ( RegsPSG[ 7 ] & 0x20 ) )
                        Freq[ 5 ] = j;

                    BmChange |= 0x38 & ~RegsPSG[ 7 ];
                    }
                break;

            case 7:
                BmChange |= Reg7Mod;
                for ( j = 0; j < SOUND_CHANNELS; j++ )
                    {
                    if ( Reg7Mod & 1 )
                        {
                        if ( Val & 1 )
                            Freq[ j ] = 0x1FFFFFFF;
                        else
                            {
                            if ( j < 3 )
                                i = ( ( RegsPSG[ j * 2 + 1 ] & 0x0F ) << 8 ) + RegsPSG[ j * 2 ];
                            else
                                i = RegsPSG[ 6 ] & 0x1F;

                            Freq[ j ] = i + 1;
                            }
                        }
                    Reg7Mod >>= 1;
                    Val >>= 1;
                    }
                break;

            case 8:
            case 9:
            case 10:
                Reg -= 8;
                Vol[ Reg + 3 ] = Vol[ Reg ] = ( Val & 0x0F ) * 17;
                Env[ Reg ] = ( Val & 0x10 ) >> 4;
                BmChange |= ( 0x09 << Reg ) & ~RegsPSG[ 7 ];
                break;

            case 11:
            case 12:
                EPeriod = RegsPSG[ 11 ] + ( RegsPSG[ 12 ] << 8 );
                ECount = 0;
                break;
            }
        }
}


/********************************************************* !NAME! **************
* Nom : Loop8912
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Fonction de gnration des sons du PSG, a appeler  intervalles
*               rguliers
*
* Rsultat    : /
*
* Variables globales modifies : Vol, ECount, BmChange, Env
*
********************************************************** !0! ****************/
void Loop8912( int uS )
{
    int c, v, IncVol;

    if ( EPeriod )
        {
        ECount += uS;
        if ( ECount >= EPeriod )
            {
            ECount -= EPeriod;
            IncVol = uS >= EPeriod ? uS / EPeriod : 1;
            for ( c = 0; c < 3; c++ )
                {
                if ( Env[ c ] && ( RegsPSG[ c + 8 ] & 0x10 ) )
                    {
                    switch( RegsPSG[ 13 ] )
                        {
                        case 0x00 :
                        case 0x01 :
                        case 0x02 :
                        case 0x03 :
                        case 0x09 :
                            v = Vol[ c ] - IncVol;
                            Vol[ c + 3 ] = Vol[ c ] = v = v >= 0 ? v : 0;
                            if ( ! v )
                                Env[ c ] = 0;

                            break;

                        case 0x04 :
                        case 0x05 :
                        case 0x06 :
                        case 0x07 :
                        case 0x0F :
                            v = Vol[ c ] + IncVol;
                            Vol[ c + 3 ] = Vol[ c ] = v = v < 256 ? v:0;
                            if ( ! v )
                                Env[ c ] = 0;

                            break;

                        case 0x08 :
                            v = Vol[ c ] - IncVol;
                            Vol[ c + 3 ] = Vol[ c ] = v >= 0 ? v : 255;
                            break;

                        case 0x0A :
                            if ( Env[ c ] == 2 )
                                {
                                v = Vol[ c ] + IncVol;
                                Vol[ c + 3 ] = Vol[ c ] = v = v < 256 ? v : 255;
                                if ( v == 255 )
                                    Env[ c ] = 1;
                                }
                            else
                                {
                                v = Vol[ c ] - IncVol;
                                Vol[ c + 3 ] = Vol[ c ] = v = v >= 0 ? v : 0;
                                if ( ! v )
                                    Env[ c ] = 2;
                                }
                            break;

                        case 0x0B :
                            v = Vol[ c ] - IncVol;
                            Vol[ c + 3 ] = Vol[ c ] = v = v >= 0 ? v : 255;
                            if ( v == 255 )
                                Env[ c ] = 0;

                            break;

                        case 0x0C :
                            v = Vol[ c ] + IncVol;
                            Vol[ c + 3 ] = Vol[ c ] = v < 256 ? v : 0;
                            break; 

                        case 0x0D :
                            v = Vol[ c ] + IncVol;
                            Vol[ c + 3 ] = Vol[ c ] = v < 256 ? v : 255;
                            if ( v == 255 )
                                Env[ c ] = 0;

                            break;

                        case 0x0E :
                            if ( Env[ c ] == 2 )
                                {
                                v = Vol[ c ] - IncVol;
                                Vol[ c + 3 ] = Vol[ c ] = v = v >= 0 ? v:0;
                                if ( ! v )
                                    Env[ c ] = 1;
                                }
                            else
                                {
                                v = Vol[ c ] + IncVol;
                                Vol[ c + 3 ] = Vol[ c ] = v = v < 256 ? v : 255;
                                if ( v == 255 )
                                    Env[ c ] = 2;
                                }
                            break;
                        }
                    BmChange |= ( 0x09 << c ) & ~RegsPSG[ 7 ];
                    }
                }
            }
        }
    for ( c = 0; c < SOUND_CHANNELS; c++ )
        {
        if ( BmChange & 1 )
            SetSound( c, AY8912_FMAX / Freq[ c ], Vol[ c ] );

        BmChange >>= 1;
        }
}


/********************************************************* !NAME! **************
* Nom : Reset8912
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Effectue un reset du 8912
*
* Rsultat    : /
*
* Variables globales modifies : RegsPSG, BmChange
*
********************************************************** !0! ****************/
void Reset8912( void )
{
    int c;
    RegsPSG[ 7 ] = 0xFD;
    RegsPSG[ 14 ] = 0xFF;
    for ( c = 0; c < SOUND_CHANNELS; c++ )
        Freq[ c ] = 0x1FFFFFFF;

    BmChange = 0;
}
#endif
