/*
 * Decompiled with CFR 0.152.
 */
package tiled.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import tiled.core.Map;
import tiled.core.ObjectGroup;
import tiled.core.TileLayer;
import tiled.view.MapView;

public class ShiftedMapView
extends MapView {
    private int horSide = 16;
    private int verSide = 0;

    public ShiftedMapView(Map map) {
        super(map);
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        int unit = this.getScrollableUnitIncrement(visibleRect, orientation, direction);
        if (orientation == 1) {
            return visibleRect.height / unit * unit;
        }
        return visibleRect.width / unit * unit;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        Dimension tsize = this.getTileSize();
        if (orientation == 1) {
            return tsize.height - (tsize.height - (int)((double)this.verSide * this.zoom)) / 2;
        }
        return tsize.width - (tsize.width - (int)((double)this.horSide * this.zoom)) / 2;
    }

    public Dimension getPreferredSize() {
        Dimension tsize = this.getTileSize();
        int border = this.showGrid ? 1 : 0;
        int onceX = (tsize.width - (int)((double)this.horSide * this.zoom)) / 2;
        int repeatX = tsize.width - onceX;
        int onceY = (tsize.height - (int)((double)this.verSide * this.zoom)) / 2;
        int repeatY = tsize.height - onceY;
        return new Dimension(this.map.getWidth() * repeatX + onceX + border, this.map.getHeight() * repeatY + onceY + border);
    }

    protected void paintLayer(Graphics2D g2d, TileLayer layer) {
    }

    protected void paintObjectGroup(Graphics2D g2d, ObjectGroup og) {
    }

    protected void paintGrid(Graphics2D g2d) {
        Dimension tsize = this.getTileSize();
        if (tsize.width <= 0 || tsize.height <= 0) {
            return;
        }
        int onceX = (tsize.width - (int)((double)this.horSide * this.zoom)) / 2;
        int repeatX = tsize.width - onceX;
        int onceY = (tsize.height - (int)((double)this.verSide * this.zoom)) / 2;
        int repeatY = tsize.height - onceY;
        if (repeatX <= 0 || repeatY <= 0) {
            return;
        }
        Rectangle clipRect = g2d.getClipBounds();
        int startX = clipRect.x / repeatX;
        int startY = clipRect.y / repeatY;
        int endX = (clipRect.x + clipRect.width) / repeatX + 1;
        int endY = (clipRect.y + clipRect.height) / repeatY + 1;
        int p = startY * repeatY;
        Color prevColor = g2d.getColor();
        g2d.setColor(Color.gray);
        for (int y = startY; y < endY; ++y) {
            g2d.drawLine(clipRect.x, p, clipRect.x + clipRect.width - 1, p);
            p += repeatY;
        }
        p = startX * repeatX;
        for (int x = startX; x < endX; ++x) {
            g2d.drawLine(p, clipRect.y, p, clipRect.y + clipRect.height - 1);
            p += repeatX;
        }
        g2d.setColor(prevColor);
    }

    protected void paintCoordinates(Graphics2D g2d) {
    }

    protected void paintPropertyFlags(Graphics2D g2d, TileLayer layer) {
        throw new RuntimeException("Not yet implemented");
    }

    public void repaintRegion(Rectangle region) {
    }

    public Point screenToTileCoords(int x, int y) {
        return new Point(0, 0);
    }

    public Point screenToPixelCoords(int x, int y) {
        return new Point();
    }

    protected Dimension getTileSize() {
        return new Dimension((int)((double)this.map.getTileWidth() * this.zoom), (int)((double)this.map.getTileHeight() * this.zoom));
    }

    protected Polygon createGridPolygon(int tx, int ty, int border) {
        return new Polygon();
    }

    public Point tileToScreenCoords(int x, int y) {
        return new Point(0, 0);
    }
}

