/*
 * Decompiled with CFR 0.152.
 */
package tiled.view;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import tiled.core.Map;
import tiled.core.ObjectGroup;
import tiled.core.Tile;
import tiled.core.TileLayer;
import tiled.mapeditor.selection.SelectionLayer;
import tiled.view.MapView;

public class IsoMapView
extends MapView {
    public IsoMapView(Map map) {
        super(map);
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        Dimension tsize = this.getTileSize();
        if (orientation == 1) {
            return visibleRect.height / tsize.height * tsize.height;
        }
        return visibleRect.width / tsize.width * tsize.width;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        Dimension tsize = this.getTileSize();
        if (orientation == 1) {
            return tsize.height;
        }
        return tsize.width;
    }

    protected void paintLayer(Graphics2D g2d, TileLayer layer) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle clipRect = g2d.getClipBounds();
        Dimension tileSize = this.getTileSize();
        int tileStepY = tileSize.height / 2 == 0 ? 1 : tileSize.height / 2;
        Polygon gridPoly = this.createGridPolygon(0, -tileSize.height, 0);
        Point rowItr = this.screenToTileCoords(clipRect.x, clipRect.y);
        --rowItr.x;
        Point drawLoc = this.tileToScreenCoords(rowItr.x, rowItr.y);
        drawLoc.x -= tileSize.width / 2;
        drawLoc.y += tileSize.height;
        int columns = clipRect.width / tileSize.width + 3;
        int rows = (clipRect.height + (int)((double)this.map.getTileHeightMax() * this.zoom)) / tileStepY + 4;
        for (int y = 0; y < rows; ++y) {
            Point columnItr = new Point(rowItr);
            for (int x = 0; x < columns; ++x) {
                Tile tile = layer.getTileAt(columnItr.x, columnItr.y);
                if (tile != null) {
                    if (layer instanceof SelectionLayer) {
                        gridPoly.translate(drawLoc.x, drawLoc.y);
                        g2d.fillPolygon(gridPoly);
                        gridPoly.translate(-drawLoc.x, -drawLoc.y);
                    } else {
                        tile.draw(g2d, drawLoc.x, drawLoc.y, this.zoom);
                    }
                }
                ++columnItr.x;
                --columnItr.y;
                drawLoc.x += tileSize.width;
            }
            if ((y & 1) > 0) {
                ++rowItr.x;
                drawLoc.x += tileSize.width / 2;
            } else {
                ++rowItr.y;
                drawLoc.x -= tileSize.width / 2;
            }
            drawLoc.x -= columns * tileSize.width;
            drawLoc.y += tileStepY;
        }
    }

    protected void paintObjectGroup(Graphics2D g2d, ObjectGroup og) {
    }

    protected void paintGrid(Graphics2D g2d) {
        Point end;
        Point start;
        Dimension tileSize = this.getTileSize();
        Rectangle clipRect = g2d.getClipBounds();
        clipRect.x -= tileSize.width / 2;
        clipRect.width += tileSize.width;
        clipRect.height += tileSize.height / 2;
        int startX = Math.max(0, this.screenToTileCoords((int)clipRect.x, (int)clipRect.y).x);
        int startY = Math.max(0, this.screenToTileCoords((int)(clipRect.x + clipRect.width), (int)clipRect.y).y);
        int endX = Math.min(this.map.getWidth(), this.screenToTileCoords((int)(clipRect.x + clipRect.width), (int)(clipRect.y + clipRect.height)).x);
        int endY = Math.min(this.map.getHeight(), this.screenToTileCoords((int)clipRect.x, (int)(clipRect.y + clipRect.height)).y);
        for (int y = startY; y <= endY; ++y) {
            start = this.tileToScreenCoords(startX, y);
            end = this.tileToScreenCoords(endX, y);
            g2d.drawLine(start.x, start.y, end.x, end.y);
        }
        for (int x = startX; x <= endX; ++x) {
            start = this.tileToScreenCoords(x, startY);
            end = this.tileToScreenCoords(x, endY);
            g2d.drawLine(start.x, start.y, end.x, end.y);
        }
    }

    protected void paintCoordinates(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Rectangle clipRect = g2d.getClipBounds();
        Dimension tileSize = this.getTileSize();
        int tileStepY = tileSize.height / 2 == 0 ? 1 : tileSize.height / 2;
        Font font = new Font("SansSerif", 0, tileSize.height / 4);
        g2d.setFont(font);
        FontRenderContext fontRenderContext = g2d.getFontRenderContext();
        Point rowItr = this.screenToTileCoords(clipRect.x, clipRect.y);
        --rowItr.x;
        Point drawLoc = this.tileToScreenCoords(rowItr.x, rowItr.y);
        drawLoc.y += tileSize.height / 2;
        int columns = clipRect.width / tileSize.width + 3;
        int rows = clipRect.height / tileStepY + 4;
        for (int y = 0; y < rows; ++y) {
            Point columnItr = new Point(rowItr);
            for (int x = 0; x < columns; ++x) {
                if (this.map.contains(columnItr.x, columnItr.y)) {
                    String coords = "(" + columnItr.x + "," + columnItr.y + ")";
                    Rectangle2D textSize = font.getStringBounds(coords, fontRenderContext);
                    int fx = drawLoc.x - (int)(textSize.getWidth() / 2.0);
                    int fy = drawLoc.y + (int)(textSize.getHeight() / 2.0);
                    g2d.drawString(coords, fx, fy);
                }
                ++columnItr.x;
                --columnItr.y;
                drawLoc.x += tileSize.width;
            }
            if ((y & 1) > 0) {
                ++rowItr.x;
                drawLoc.x += tileSize.width / 2;
            } else {
                ++rowItr.y;
                drawLoc.x -= tileSize.width / 2;
            }
            drawLoc.x -= columns * tileSize.width;
            drawLoc.y += tileStepY;
        }
    }

    protected void paintPropertyFlags(Graphics2D g2d, TileLayer layer) {
        throw new RuntimeException("Not yet implemented");
    }

    public void repaintRegion(Rectangle region) {
        Dimension tileSize = this.getTileSize();
        int maxExtraHeight = (int)((double)this.map.getTileHeightMax() * this.zoom) - tileSize.height;
        int mapX1 = region.x;
        int mapY1 = region.y;
        int mapX2 = mapX1 + region.width;
        int mapY2 = mapY1 + region.height;
        int x1 = this.tileToScreenCoords((int)mapX1, (int)mapY2).x;
        int y1 = this.tileToScreenCoords((int)mapX1, (int)mapY1).y - maxExtraHeight;
        int x2 = this.tileToScreenCoords((int)mapX2, (int)mapY1).x;
        int y2 = this.tileToScreenCoords((int)mapX2, (int)mapY2).y;
        this.repaint(new Rectangle(x1, y1, x2 - x1, y2 - y1));
    }

    public Dimension getPreferredSize() {
        Dimension tileSize = this.getTileSize();
        int border = this.showGrid ? 1 : 0;
        int mapSides = this.map.getHeight() + this.map.getWidth();
        return new Dimension(mapSides * tileSize.width / 2 + border, mapSides * tileSize.height / 2 + border);
    }

    public Point screenToTileCoords(int x, int y) {
        Dimension tileSize = this.getTileSize();
        double r = this.getTileRatio();
        int mx = y + (int)((double)(x -= this.map.getHeight() * (tileSize.width / 2)) / r);
        int my = y - (int)((double)x / r);
        return new Point((mx < 0 ? mx - tileSize.height : mx) / tileSize.height, (my < 0 ? my - tileSize.height : my) / tileSize.height);
    }

    public Point screenToPixelCoords(int x, int y) {
        return new Point();
    }

    protected Polygon createGridPolygon(int tx, int ty, int border) {
        Dimension tileSize = this.getTileSize();
        tileSize.width -= border * 2;
        tileSize.height -= border * 2;
        Polygon poly = new Polygon();
        poly.addPoint(tx + tileSize.width / 2 + border, ty + border);
        poly.addPoint(tx + tileSize.width, ty + tileSize.height / 2 + border);
        poly.addPoint(tx + tileSize.width / 2 + border, ty + tileSize.height + border);
        poly.addPoint(tx + border, ty + tileSize.height / 2 + border);
        return poly;
    }

    protected Dimension getTileSize() {
        return new Dimension((int)((double)this.map.getTileWidth() * this.zoom), (int)((double)this.map.getTileHeight() * this.zoom));
    }

    protected double getTileRatio() {
        return (double)this.map.getTileWidth() / (double)this.map.getTileHeight();
    }

    public Point tileToScreenCoords(int x, int y) {
        Dimension tileSize = this.getTileSize();
        int originX = this.map.getHeight() * tileSize.width / 2;
        return new Point((x - y) * tileSize.width / 2 + originX, (x + y) * tileSize.height / 2);
    }
}

