/*
 * Decompiled with CFR 0.152.
 */
package tiled.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TiledConfiguration {
    public static final int RECENT_FILE_COUNT = 8;
    private static final Preferences prefs = Preferences.userRoot().node("tiled");

    private TiledConfiguration() {
    }

    public static Preferences node(String pathName) {
        return prefs.node(pathName);
    }

    public static Preferences root() {
        return prefs;
    }

    public static void addToRecentFiles(String mapFile) {
        assert (mapFile != null);
        List<String> recent = TiledConfiguration.getRecentFiles();
        Iterator<String> iterator = recent.iterator();
        while (iterator.hasNext()) {
            String filename = iterator.next();
            if (!filename.equals(mapFile)) continue;
            iterator.remove();
        }
        recent.add(0, mapFile);
        Preferences recentNode = prefs.node("recent");
        for (int i = 0; i < 8 && i < recent.size(); ++i) {
            String recentFile = recent.get(i);
            recentNode.put("file" + i, recentFile);
        }
    }

    public static List<String> getRecentFiles() {
        ArrayList<String> recent = new ArrayList<String>(8);
        Preferences recentNode = prefs.node("recent");
        for (int i = 0; i < 8; ++i) {
            String recentFile = recentNode.get("file" + i, "");
            if (recentFile.length() <= 0) continue;
            recent.add(recentFile);
        }
        return recent;
    }

    public static String fileDialogStartLocation() {
        return TiledConfiguration.node("recent").get("file0", null);
    }
}

