/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.util.cutter;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import tiled.mapeditor.util.cutter.TileCutter;

public class BasicTileCutter
implements TileCutter {
    private int nextX;
    private int nextY;
    private BufferedImage image;
    private final int tileWidth;
    private final int tileHeight;
    private final int tileSpacing;
    private final int tileMargin;

    public BasicTileCutter(int tileWidth, int tileHeight, int tileSpacing, int tileMargin) {
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.tileSpacing = tileSpacing;
        this.tileMargin = tileMargin;
        this.reset();
    }

    public String getName() {
        return "Basic";
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public Image getNextTile() {
        if (this.nextY + this.tileHeight + this.tileMargin <= this.image.getHeight()) {
            BufferedImage tile = this.image.getSubimage(this.nextX, this.nextY, this.tileWidth, this.tileHeight);
            this.nextX += this.tileWidth + this.tileSpacing;
            if (this.nextX + this.tileWidth + this.tileMargin > this.image.getWidth()) {
                this.nextX = this.tileMargin;
                this.nextY += this.tileHeight + this.tileSpacing;
            }
            return tile;
        }
        return null;
    }

    public void reset() {
        this.nextX = this.tileMargin;
        this.nextY = this.tileMargin;
    }

    public Dimension getTileDimensions() {
        return new Dimension(this.tileWidth, this.tileHeight);
    }

    public int getTileSpacing() {
        return this.tileSpacing;
    }

    public int getTileMargin() {
        return this.tileMargin;
    }

    public int getTilesPerRow() {
        return (this.image.getWidth() - 2 * this.tileMargin + this.tileSpacing) / (this.tileWidth + this.tileSpacing);
    }
}

