/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.util;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import tiled.io.PluggableMapIO;
import tiled.io.xml.XMLMapWriter;
import tiled.mapeditor.Resources;
import tiled.mapeditor.util.ConfirmableFileFilter;

public class TiledFileFilter
extends ConfirmableFileFilter {
    public static final int FILTER_EXT = 0;
    public static final int FILTER_TMX = 1;
    public static final int FILTER_TSX = 2;
    public static final int FILTER_BOTH = 3;
    public static final int FILTER_PLUG = 4;
    private String desc;
    private LinkedList<String> exts;
    private PluggableMapIO pmio;
    private int type = 0;
    private static final String FILETYPE_TILED = Resources.getString("general.filetype.tiled");
    private static final String FILETYPE_TMX = Resources.getString("general.filetype.tiledmap");
    private static final String FILETYPE_TSX = Resources.getString("general.filetype.tiledtileset");
    private static final String FILETYPE_EXT = Resources.getString("general.filetype.byextension");

    public TiledFileFilter() {
        this.desc = FILETYPE_TILED;
        this.exts = new LinkedList();
        this.exts.add("tmx");
        this.exts.add("tmx.gz");
        this.exts.add("tsx");
        this.pmio = new XMLMapWriter();
    }

    public TiledFileFilter(int filter) {
        this.exts = new LinkedList();
        this.desc = "";
        this.type = filter;
        if ((filter & 1) != 0) {
            this.desc = FILETYPE_TMX;
            this.exts.add("tmx");
            this.exts.add("tmx.gz");
            this.pmio = new XMLMapWriter();
        }
        if ((filter & 2) != 0) {
            this.desc = this.desc + FILETYPE_TSX;
            this.exts.add("tsx");
            if (this.pmio == null) {
                this.pmio = new XMLMapWriter();
            }
        }
        if (filter == 0) {
            this.desc = FILETYPE_EXT;
        }
    }

    public TiledFileFilter(PluggableMapIO p) throws Exception {
        this.exts = new LinkedList();
        this.pmio = p;
        this.buildFilter(p.getFilter(), p.getName());
    }

    public TiledFileFilter(String filter, String desc) {
        this.exts = new LinkedList();
        this.buildFilter(filter, desc);
    }

    private void buildFilter(String filter, String desc) {
        String[] extensions;
        this.desc = desc;
        for (String extension : extensions = filter.split(",")) {
            this.exts.add(extension.substring(extension.indexOf(46) + 1));
        }
    }

    public void setDescription(String description) {
        this.desc = description;
    }

    public void addExtention(String extension) {
        this.exts.add(extension);
    }

    public PluggableMapIO getPlugin() {
        return this.pmio;
    }

    public String getDefaultExtension() {
        if (!this.exts.isEmpty()) {
            return this.exts.getFirst();
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public boolean accept(File file) {
        if (this.type != 0 && (file.isFile() || !file.exists())) {
            String fileName = file.getPath().toLowerCase();
            for (String ext : this.exts) {
                if (!fileName.endsWith("." + ext)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public String getDescription() {
        StringBuffer filter = new StringBuffer();
        if (!this.exts.isEmpty()) {
            filter.append(" (");
            Iterator itr = this.exts.iterator();
            while (itr.hasNext()) {
                filter.append("*.").append((String)itr.next());
                if (!itr.hasNext()) continue;
                filter.append(",");
            }
            filter.append(")");
        }
        return this.desc + filter;
    }
}

