/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.util;

import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;
import tiled.mapeditor.Resources;

public class PropertiesTableModel
extends AbstractTableModel {
    private SortedMap properties = new TreeMap();
    private static final String[] columnNames = new String[]{Resources.getString("dialog.properties.column.name"), Resources.getString("dialog.properties.column.value")};

    public int getRowCount() {
        return this.properties.size() + 1;
    }

    public String getColumnName(int col) {
        return columnNames[col];
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public boolean isCellEditable(int row, int col) {
        return col == 0 || col == 1 && this.getValueAt(row, 0) != null;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object[] array = this.properties.keySet().toArray();
        if (rowIndex >= 0 && rowIndex < this.properties.size()) {
            if (columnIndex == 0) {
                return array[rowIndex];
            }
            if (columnIndex == 1) {
                return this.properties.get(array[rowIndex]);
            }
        }
        return null;
    }

    public void setValueAt(Object value, int row, int col) {
        if (row >= this.properties.size() && col == 0) {
            if (((String)value).length() > 0) {
                this.properties.put(value, "");
                this.fireTableDataChanged();
            }
        } else if (col == 1) {
            this.properties.put(this.getValueAt(row, 0), value);
            this.fireTableCellUpdated(row, col);
        } else if (col == 0) {
            String val = (String)this.getValueAt(row, 1);
            if (this.getValueAt(row, col) != null) {
                this.properties.remove(this.getValueAt(row, col));
            }
            if (((String)value).length() > 0) {
                this.properties.put(value, val);
            }
            this.fireTableDataChanged();
        }
    }

    public void remove(Object key) {
        this.properties.remove(key);
        this.fireTableDataChanged();
    }

    public void setProperties(Properties props) {
        this.properties.clear();
        this.properties.putAll(props);
        this.fireTableDataChanged();
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.properties);
        return props;
    }
}

