/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.util;

import java.awt.Component;
import java.util.HashMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import tiled.core.Tile;
import tiled.core.TileSet;
import tiled.mapeditor.Resources;

public class MultisetListRenderer
extends DefaultListCellRenderer {
    private final Icon setIcon = Resources.getIcon("source.png");
    private final HashMap<Integer, Icon> tileImages = new HashMap();
    private final double zoom;

    public MultisetListRenderer(double zoom) {
        this.zoom = zoom;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof Tile && index >= 0) {
            Tile tile = (Tile)value;
            if (!isSelected || this.zoom == 1.0) {
                if (this.tileImages.containsKey(index)) {
                    this.setIcon(this.tileImages.get(index));
                } else {
                    ImageIcon icon = new ImageIcon(tile.getScaledImage(this.zoom));
                    this.setIcon(icon);
                    this.tileImages.put(index, icon);
                }
            } else {
                this.setIcon(new ImageIcon(tile.getImage()));
            }
        } else if (value instanceof TileSet) {
            this.setIcon(this.setIcon);
        }
        return this;
    }
}

