/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.util;

import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import tiled.mapeditor.Resources;
import tiled.mapeditor.util.ConfirmableFileFilter;

public final class ConfirmingFileChooser
extends JFileChooser {
    private static final String UNKNOWN_TYPE_MESSAGE = Resources.getString("dialog.saveas.unknown-type.message");
    private static final String CONFIRM_MISMATCH = Resources.getString("dialog.saveas.confirm.mismatch");
    private static final String CONFIRM_MISMATCH_TITLE = Resources.getString("dialog.saveas.confirm.mismatch.title");
    private static final String FILE_EXISTS_MESSAGE = Resources.getString("general.file.exists.message");
    private static final String FILE_EXISTS_TITLE = Resources.getString("general.file.exists.title");

    public ConfirmingFileChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
    }

    public int showSaveDialog(Component component) throws HeadlessException {
        this.setDialogTitle(Resources.getString("dialog.saveas.title"));
        return super.showSaveDialog(component);
    }

    public ConfirmingFileChooser() {
        this((String)null);
    }

    public void approveSelection() {
        int result;
        if (this.getDialogType() == 0) {
            super.approveSelection();
            return;
        }
        File file = new File(this.getSelectedFile().getAbsolutePath());
        String filename = file.getName();
        int lastDot = filename.lastIndexOf(46);
        if ((lastDot == -1 || lastDot == filename.length() - 1) && this.getFileFilter() instanceof ConfirmableFileFilter) {
            ConfirmableFileFilter filter = (ConfirmableFileFilter)this.getFileFilter();
            String extension = filter.getDefaultExtension();
            if (extension == null) {
                JOptionPane.showMessageDialog(this, UNKNOWN_TYPE_MESSAGE);
                return;
            }
            String newFilePath = file.getAbsolutePath();
            if (lastDot != filename.length() - 1) {
                newFilePath = newFilePath + ".";
            }
            file = new File(newFilePath + extension);
            this.setSelectedFile(file);
        }
        if (!this.getFileFilter().accept(file) && (result = JOptionPane.showConfirmDialog(this, CONFIRM_MISMATCH, CONFIRM_MISMATCH_TITLE, 0)) != 0) {
            return;
        }
        if (file.exists()) {
            int answer = JOptionPane.showConfirmDialog(this, FILE_EXISTS_MESSAGE, FILE_EXISTS_TITLE, 0);
            if (answer == 0) {
                super.approveSelection();
            }
        } else {
            super.approveSelection();
        }
    }
}

