/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.undo;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import tiled.mapeditor.MapEditor;
import tiled.util.TiledConfiguration;

public class UndoHandler
extends UndoManager {
    UndoableEdit savedAt;
    private final Action undoAction = new UndoAction();
    private final Action redoAction = new RedoAction();
    private final MapEditor editor;

    public UndoHandler(MapEditor editor) {
        this.editor = editor;
        this.setLimit(TiledConfiguration.root().getInt("undoDepth", 30));
        this.updateActions();
    }

    public synchronized void discardAllEdits() {
        super.discardAllEdits();
        this.updateActions();
    }

    public synchronized void undo() throws CannotUndoException {
        super.undo();
        this.updateActions();
        this.editor.updateTitle();
        this.editor.getMapView().repaint();
    }

    public synchronized void redo() throws CannotRedoException {
        super.redo();
        this.updateActions();
        this.editor.updateTitle();
        this.editor.getMapView().repaint();
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        super.undoableEditHappened(e);
        this.updateActions();
        this.editor.updateTitle();
    }

    public boolean isAllSaved() {
        return this.editToBeUndone() == this.savedAt;
    }

    public void commitSave() {
        this.savedAt = this.editToBeUndone();
    }

    public String[] getEdits() {
        String[] list = new String[this.edits.size()];
        Iterator itr = this.edits.iterator();
        int i = 0;
        while (itr.hasNext()) {
            UndoableEdit e = (UndoableEdit)itr.next();
            list[i++] = e.getPresentationName();
        }
        return list;
    }

    public Action getRedoAction() {
        return this.redoAction;
    }

    public Action getUndoAction() {
        return this.undoAction;
    }

    private void updateActions() {
        this.undoAction.setEnabled(this.canUndo());
        this.redoAction.setEnabled(this.canRedo());
        this.undoAction.putValue("Name", this.getUndoPresentationName());
        this.redoAction.putValue("Name", this.getRedoPresentationName());
    }

    private class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super(UndoHandler.this.getRedoPresentationName());
            this.putValue("ShortDescription", "Redo one action");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control Y"));
        }

        public void actionPerformed(ActionEvent evt) {
            UndoHandler.this.redo();
        }
    }

    private class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super(UndoHandler.this.getUndoPresentationName());
            this.putValue("ShortDescription", "Undo one action");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control Z"));
        }

        public void actionPerformed(ActionEvent evt) {
            UndoHandler.this.undo();
        }
    }
}

