/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.undo;

import java.awt.Point;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import tiled.core.MapLayer;
import tiled.mapeditor.Resources;

public class MoveLayerEdit
extends AbstractUndoableEdit {
    private final MapLayer layer;
    private final Point moveDist;

    public MoveLayerEdit(MapLayer layer, Point moveDist) {
        this.layer = layer;
        this.moveDist = moveDist;
    }

    public void undo() throws CannotUndoException {
        super.undo();
        this.layer.translate(-this.moveDist.x, -this.moveDist.y);
    }

    public void redo() throws CannotRedoException {
        super.redo();
        this.layer.translate(this.moveDist.x, this.moveDist.y);
    }

    public String getPresentationName() {
        return Resources.getString("action.layer.move.name");
    }
}

