/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.undo;

import java.util.Map;
import java.util.Properties;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import tiled.core.MapObject;
import tiled.mapeditor.Resources;

public class ChangeObjectEdit
extends AbstractUndoableEdit {
    private final MapObject mapObject;
    private final String prevName;
    private final String prevType;
    private final String prevImageSource;
    private final int prevWidth;
    private final int prevHeight;
    private final Properties prevProperties = new Properties();
    private String newName;
    private String newType;
    private String newImageSource;
    private int newWidth;
    private int newHeight;
    private final Properties newProperties = new Properties();

    public ChangeObjectEdit(MapObject mapObject) {
        this.mapObject = mapObject;
        this.prevName = mapObject.getName();
        this.prevType = mapObject.getType();
        this.prevImageSource = mapObject.getImageSource();
        this.prevWidth = mapObject.getWidth();
        this.prevHeight = mapObject.getHeight();
        this.prevProperties.putAll((Map<?, ?>)mapObject.getProperties());
    }

    public void undo() throws CannotUndoException {
        super.undo();
        this.newName = this.mapObject.getName();
        this.newType = this.mapObject.getType();
        this.newImageSource = this.mapObject.getImageSource();
        this.newWidth = this.mapObject.getWidth();
        this.newHeight = this.mapObject.getHeight();
        this.newProperties.clear();
        this.newProperties.putAll((Map<?, ?>)this.mapObject.getProperties());
        this.mapObject.setName(this.prevName);
        this.mapObject.setType(this.prevType);
        this.mapObject.setImageSource(this.prevImageSource);
        this.mapObject.setWidth(this.prevWidth);
        this.mapObject.setHeight(this.prevHeight);
        this.mapObject.getProperties().clear();
        this.mapObject.getProperties().putAll((Map<?, ?>)this.prevProperties);
    }

    public void redo() throws CannotRedoException {
        super.redo();
        this.mapObject.setName(this.newName);
        this.mapObject.setType(this.newType);
        this.mapObject.setImageSource(this.newImageSource);
        this.mapObject.setWidth(this.newWidth);
        this.mapObject.setHeight(this.newHeight);
        this.mapObject.getProperties().clear();
        this.mapObject.getProperties().putAll((Map<?, ?>)this.newProperties);
    }

    public String getPresentationName() {
        return Resources.getString("action.object.change.name");
    }
}

