/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tiled.core.Map;
import tiled.mapeditor.Resources;
import tiled.mapeditor.widget.IntegerSpinner;
import tiled.mapeditor.widget.VerticalStaticJPanel;
import tiled.util.TiledConfiguration;

public class NewMapDialog
extends JDialog
implements ActionListener {
    private Map newMap;
    private IntegerSpinner mapWidth;
    private IntegerSpinner mapHeight;
    private IntegerSpinner tileWidth;
    private IntegerSpinner tileHeight;
    private JComboBox mapTypeChooser;
    private final Preferences prefs = TiledConfiguration.node("dialog/newmap");
    private static final String DIALOG_TITLE = Resources.getString("dialog.newmap.title");
    private static final String MAPSIZE_TITLE = Resources.getString("dialog.newmap.mapsize.title");
    private static final String TILESIZE_TITLE = Resources.getString("dialog.newmap.tilesize.title");
    private static final String WIDTH_LABEL = Resources.getString("dialog.newmap.width.label");
    private static final String HEIGHT_LABEL = Resources.getString("dialog.newmap.height.label");
    private static final String MAPTYPE_LABEL = Resources.getString("dialog.newmap.maptype.label");
    private static final String OK_BUTTON = Resources.getString("general.button.ok");
    private static final String CANCEL_BUTTON = Resources.getString("general.button.cancel");
    private static final String ISOMETRIC_MAPTYPE = Resources.getString("general.maptype.isometric");
    private static final String HEXAGONAL_MAPTYPE = Resources.getString("general.maptype.hexagonal");
    private static final String SHIFTED_MAPTYPE = Resources.getString("general.maptype.shifted");
    private static final String ORTHOGONAL_MAPTYPE = Resources.getString("general.maptype.orthogonal");

    public NewMapDialog(JFrame parent) {
        super(parent, DIALOG_TITLE, true);
        this.init();
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
    }

    private void init() {
        int defaultMapWidth = this.prefs.getInt("mapWidth", 64);
        int defaultMapHeight = this.prefs.getInt("mapHeight", 64);
        int defaultTileWidth = this.prefs.getInt("tileWidth", 35);
        int defaultTileHeight = this.prefs.getInt("tileHeight", 35);
        this.mapWidth = new IntegerSpinner(defaultMapWidth, 1);
        this.mapHeight = new IntegerSpinner(defaultMapHeight, 1);
        this.tileWidth = new IntegerSpinner(defaultTileWidth, 1);
        this.tileHeight = new IntegerSpinner(defaultTileHeight, 1);
        VerticalStaticJPanel mapSize = new VerticalStaticJPanel();
        mapSize.setLayout(new GridBagLayout());
        mapSize.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MAPSIZE_TITLE), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 13;
        c.fill = 0;
        c.insets = new Insets(5, 0, 0, 5);
        mapSize.add((Component)new JLabel(WIDTH_LABEL), c);
        c.gridy = 1;
        mapSize.add((Component)new JLabel(HEIGHT_LABEL), c);
        c.insets = new Insets(5, 0, 0, 0);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        mapSize.add((Component)this.mapWidth, c);
        c.gridy = 1;
        mapSize.add((Component)this.mapHeight, c);
        VerticalStaticJPanel tileSize = new VerticalStaticJPanel();
        tileSize.setLayout(new GridBagLayout());
        tileSize.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(TILESIZE_TITLE), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(5, 0, 0, 5);
        tileSize.add((Component)new JLabel(WIDTH_LABEL), c);
        c.gridy = 1;
        tileSize.add((Component)new JLabel(HEIGHT_LABEL), c);
        c.insets = new Insets(5, 0, 0, 0);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        tileSize.add((Component)this.tileWidth, c);
        c.gridy = 1;
        tileSize.add((Component)this.tileHeight, c);
        JButton okButton = new JButton(OK_BUTTON);
        JButton cancelButton = new JButton(CANCEL_BUTTON);
        okButton.addActionListener(this);
        cancelButton.addActionListener(this);
        VerticalStaticJPanel buttons = new VerticalStaticJPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(Box.createGlue());
        buttons.add(okButton);
        buttons.add(Box.createRigidArea(new Dimension(5, 0)));
        buttons.add(cancelButton);
        this.mapTypeChooser = new JComboBox();
        this.mapTypeChooser.addItem(ORTHOGONAL_MAPTYPE);
        this.mapTypeChooser.addItem(ISOMETRIC_MAPTYPE);
        this.mapTypeChooser.addItem(HEXAGONAL_MAPTYPE);
        VerticalStaticJPanel miscPropPanel = new VerticalStaticJPanel();
        miscPropPanel.setLayout(new GridBagLayout());
        miscPropPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(5, 0, 0, 5);
        miscPropPanel.add((Component)new JLabel(MAPTYPE_LABEL), c);
        c.insets = new Insets(5, 0, 0, 0);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        miscPropPanel.add((Component)this.mapTypeChooser, c);
        JPanel sizePanels = new JPanel();
        sizePanels.setLayout(new BoxLayout(sizePanels, 0));
        sizePanels.add(mapSize);
        sizePanels.add(Box.createRigidArea(new Dimension(5, 0)));
        sizePanels.add(tileSize);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainPanel.add(miscPropPanel);
        mainPanel.add(sizePanels);
        mainPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        mainPanel.add(Box.createGlue());
        mainPanel.add(buttons);
        this.getContentPane().add(mainPanel);
        this.getRootPane().setDefaultButton(okButton);
    }

    public Map create() {
        this.setVisible(true);
        return this.newMap;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(OK_BUTTON)) {
            int w = this.mapWidth.intValue();
            int h = this.mapHeight.intValue();
            int twidth = this.tileWidth.intValue();
            int theight = this.tileHeight.intValue();
            int orientation = 1;
            String mapTypeString = (String)this.mapTypeChooser.getSelectedItem();
            if (mapTypeString.equals(ISOMETRIC_MAPTYPE)) {
                orientation = 2;
            } else if (mapTypeString.equals(HEXAGONAL_MAPTYPE)) {
                orientation = 4;
            } else if (mapTypeString.equals(SHIFTED_MAPTYPE)) {
                orientation = 5;
            }
            this.newMap = new Map(w, h);
            this.newMap.addLayer();
            this.newMap.setTileWidth(twidth);
            this.newMap.setTileHeight(theight);
            this.newMap.setOrientation(orientation);
            this.prefs.putInt("mapWidth", this.mapWidth.intValue());
            this.prefs.putInt("mapHeight", this.mapHeight.intValue());
            this.prefs.putInt("tileWidth", this.tileWidth.intValue());
            this.prefs.putInt("tileHeight", this.tileHeight.intValue());
        }
        this.dispose();
    }
}

