/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tiled.core.Tile;
import tiled.io.MapHelper;
import tiled.io.MapReader;
import tiled.mapeditor.MapEditor;
import tiled.mapeditor.Resources;
import tiled.mapeditor.brush.AbstractBrush;
import tiled.mapeditor.brush.Brush;
import tiled.mapeditor.brush.CustomBrush;
import tiled.mapeditor.brush.RandomBrush;
import tiled.mapeditor.brush.ShapeBrush;
import tiled.mapeditor.plugin.PluginClassLoader;
import tiled.mapeditor.util.LayerTableModel;
import tiled.mapeditor.util.TiledFileFilter;
import tiled.mapeditor.widget.BrushBrowser;
import tiled.mapeditor.widget.IntegerSpinner;
import tiled.mapeditor.widget.MiniMapViewer;
import tiled.mapeditor.widget.VerticalStaticJPanel;
import tiled.util.TiledConfiguration;

public class BrushDialog
extends JDialog
implements ActionListener,
ItemListener,
ChangeListener,
PropertyChangeListener,
ListSelectionListener {
    private AbstractBrush myBrush;
    private final MapEditor editor;
    private JCheckBox cbRandomBrush;
    private IntegerSpinner affectLayers;
    private IntegerSpinner brushSize;
    private JSlider sRandomAmount;
    private JButton okButton;
    private JButton bApply;
    private JButton bCancel;
    private BrushBrowser brushes;
    private static final String DIALOG_TITLE = Resources.getString("dialog.brush.title");
    private static final String OK_BUTTON = Resources.getString("general.button.ok");
    private static final String APPLY_BUTTON = Resources.getString("general.button.apply");
    private static final String CANCEL_BUTTON = Resources.getString("general.button.cancel");
    private static final String SHAPE_TAB = Resources.getString("dialog.brush.tab.shape");
    private static final String CUSTOM_TAB = Resources.getString("dialog.brush.tab.custom");
    private static final String PRESETS_TITLE = Resources.getString("dialog.brush.presets.title");
    private static final String BRUSH_SIZE_TOOLTIP = Resources.getString("dialog.brush.size.tooltip");
    private static final String RANDOM_BRUSH_TOOLTIP = Resources.getString("dialog.brush.random.brush.tooltip");
    private static final String RANDOM_AMOUNT_TOOLTIP = Resources.getString("dialog.brush.random.amount.tooltip");
    private static final String RANDOM_CHECKBOX = Resources.getString("dialog.brush.random.checkbox");
    private static final String OPTIONS_TITLE = Resources.getString("dialog.brush.options.title");
    private static final String BRUSH_SIZE_LABEL = Resources.getString("dialog.brush.brush.size.label");
    private static final String AFFECTED_LAYERS_LABEL = Resources.getString("dialog.brush.affected.layers.label");
    private static final String CREATE_BUTTON = Resources.getString("dialog.brush.create.button");
    private static final String LOAD_BUTTON = Resources.getString("dialog.brush.load.button");

    public BrushDialog(MapEditor editor, JFrame parent, AbstractBrush currentBrush) {
        super(parent, DIALOG_TITLE, false);
        this.myBrush = currentBrush;
        this.editor = editor;
        this.init();
        this.update();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private JPanel createShapePanel() {
        this.brushes = new BrushBrowser();
        JScrollPane brushScrollPane = new JScrollPane(this.brushes);
        brushScrollPane.setPreferredSize(new Dimension(100, 100));
        this.brushes.addPropertyChangeListener(this);
        this.brushes.setSelectedBrush(this.myBrush);
        JPanel presets = new JPanel();
        presets.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(PRESETS_TITLE), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        presets.setLayout(new GridLayout(1, 1));
        presets.add(brushScrollPane);
        this.brushSize = new IntegerSpinner(1, 1);
        if (this.myBrush != null) {
            Rectangle r = this.myBrush.getBounds();
            this.brushSize.setValue(r.width);
        }
        this.brushSize.addChangeListener(this);
        this.brushSize.setToolTipText(BRUSH_SIZE_TOOLTIP);
        this.affectLayers = new IntegerSpinner(this.myBrush.getAffectedLayers(), 1);
        this.affectLayers.addChangeListener(this);
        this.cbRandomBrush = new JCheckBox(RANDOM_CHECKBOX);
        this.cbRandomBrush.setToolTipText(RANDOM_BRUSH_TOOLTIP);
        this.cbRandomBrush.addItemListener(this);
        this.sRandomAmount = new JSlider();
        this.sRandomAmount.setPreferredSize(new Dimension(50, this.sRandomAmount.getPreferredSize().height));
        this.sRandomAmount.setToolTipText(RANDOM_AMOUNT_TOOLTIP);
        this.sRandomAmount.addChangeListener(this);
        VerticalStaticJPanel opts = new VerticalStaticJPanel();
        opts.setLayout(new GridBagLayout());
        opts.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(OPTIONS_TITLE), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 18;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 5, 0);
        opts.add((Component)new JLabel(BRUSH_SIZE_LABEL), c);
        c.gridy = 1;
        opts.add((Component)new JLabel(AFFECTED_LAYERS_LABEL), c);
        c.gridy = 2;
        opts.add((Component)this.cbRandomBrush, c);
        c.gridy = 0;
        c.gridx = 1;
        c.weightx = 0.3;
        c.fill = 2;
        opts.add((Component)this.brushSize, c);
        c.gridy = 1;
        opts.add((Component)this.affectLayers, c);
        c.gridy = 2;
        opts.add((Component)this.sRandomAmount, c);
        JPanel shapePanel = new JPanel();
        shapePanel.setLayout(new BoxLayout(shapePanel, 1));
        shapePanel.add(presets);
        shapePanel.add(opts);
        return shapePanel;
    }

    private JPanel createCustomPanel() {
        JPanel customPanel = new JPanel();
        MiniMapViewer mmv = new MiniMapViewer();
        if (this.myBrush instanceof CustomBrush) {
            // empty if block
        }
        JScrollPane miniSp = new JScrollPane();
        miniSp.getViewport().setView(mmv);
        miniSp.setPreferredSize(new Dimension(100, 100));
        JButton bCreate = new JButton(CREATE_BUTTON);
        bCreate.addActionListener(this);
        bCreate.setEnabled(false);
        JButton bLoad = new JButton(LOAD_BUTTON);
        bLoad.addActionListener(this);
        JTable layerTable = new JTable(new LayerTableModel(this.myBrush));
        layerTable.getColumnModel().getColumn(0).setPreferredWidth(32);
        layerTable.setSelectionMode(0);
        layerTable.getSelectionModel().addListSelectionListener(this);
        customPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 11;
        c.fill = 0;
        c.weightx = 2.0;
        c.weighty = 2.0;
        customPanel.add((Component)miniSp, c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 2;
        customPanel.add((Component)bCreate, c);
        c.gridy = 1;
        customPanel.add((Component)bLoad, c);
        c.gridx = 0;
        c.gridy = 2;
        customPanel.add((Component)layerTable, c);
        return customPanel;
    }

    private void init() {
        JTabbedPane tabs = new JTabbedPane(1);
        tabs.addTab(SHAPE_TAB, this.createShapePanel());
        tabs.addTab(CUSTOM_TAB, this.createCustomPanel());
        tabs.setEnabledAt(1, false);
        this.okButton = new JButton(OK_BUTTON);
        this.bApply = new JButton(APPLY_BUTTON);
        this.bCancel = new JButton(CANCEL_BUTTON);
        this.okButton.addActionListener(this);
        this.bApply.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.bApply.setEnabled(false);
        VerticalStaticJPanel buttons = new VerticalStaticJPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(Box.createGlue());
        buttons.add(this.okButton);
        buttons.add(Box.createRigidArea(new Dimension(5, 0)));
        buttons.add(this.bApply);
        buttons.add(Box.createRigidArea(new Dimension(5, 0)));
        buttons.add(this.bCancel);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainPanel.add(tabs);
        mainPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        mainPanel.add(buttons);
        this.getContentPane().add(mainPanel);
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private void createFromOptions() {
        Tile t = null;
        if (this.myBrush instanceof ShapeBrush) {
            t = ((ShapeBrush)this.myBrush).getTile();
        }
        ShapeBrush sel = (ShapeBrush)this.brushes.getSelectedBrush();
        sel.setSize((Integer)this.brushSize.getValue());
        if (this.cbRandomBrush.isSelected()) {
            RandomBrush randomBrush = new RandomBrush(sel);
            randomBrush.setRatio((double)this.sRandomAmount.getValue() / (double)this.sRandomAmount.getMaximum());
            this.myBrush = randomBrush;
        } else {
            this.myBrush = new ShapeBrush(sel);
        }
        ((ShapeBrush)this.myBrush).setTile(t);
        this.myBrush.setAffectedLayers((Integer)this.affectLayers.getValue());
        this.update();
    }

    private void update() {
        if (this.myBrush instanceof CustomBrush) {
            this.brushSize.setEnabled(false);
            this.affectLayers.setEnabled(false);
            this.cbRandomBrush.setEnabled(false);
        } else if (this.myBrush instanceof RandomBrush) {
            this.cbRandomBrush.setSelected(true);
            this.sRandomAmount.setValue((int)(((RandomBrush)this.myBrush).getRatio() * 100.0));
        }
        this.sRandomAmount.setEnabled(this.cbRandomBrush.isSelected());
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.createFromOptions();
            this.editor.setBrush(this.myBrush);
            this.dispose();
        } else if (source == this.bApply) {
            this.createFromOptions();
            this.editor.setBrush(this.myBrush);
            this.bApply.setEnabled(false);
        } else if (source == this.bCancel) {
            this.dispose();
        } else if (e.getActionCommand().equals(LOAD_BUTTON)) {
            try {
                this.openMap();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                JOptionPane.showMessageDialog(this, e1.toString(), "Load Brush", 2);
            }
            this.repaint();
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.bApply.setEnabled(true);
    }

    public void itemStateChanged(ItemEvent event) {
        ItemSelectable source = event.getItemSelectable();
        if (source == this.cbRandomBrush) {
            this.sRandomAmount.setEnabled(this.cbRandomBrush.isSelected());
        }
        this.bApply.setEnabled(true);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Brush b;
        if (evt.getPropertyName().equals("selectedbrush") && (b = this.brushes.getSelectedBrush()) != null) {
            this.brushSize.setValue(b.getBounds().width);
        }
        this.bApply.setEnabled(true);
    }

    public void valueChanged(ListSelectionEvent e) {
    }

    private void openMap() throws Exception {
        Preferences prefs = TiledConfiguration.node("recent");
        String startLocation = prefs.get("file0", "");
        JFileChooser ch = new JFileChooser(startLocation);
        try {
            MapReader[] readers;
            for (MapReader reader : readers = PluginClassLoader.getInstance().getReaders()) {
                ch.addChoosableFileFilter(new TiledFileFilter(reader.getFilter(), reader.getName()));
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error while loading plugins: " + e.getMessage(), "Error while loading map", 0);
            e.printStackTrace();
        }
        ch.addChoosableFileFilter(new TiledFileFilter(1));
        int ret = ch.showOpenDialog(this);
        if (ret == 0) {
            this.myBrush = new CustomBrush(MapHelper.loadMap(ch.getSelectedFile().getAbsolutePath()));
        }
    }
}

