/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.dialogs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import tiled.mapeditor.Resources;

public class AboutDialog
extends JDialog {
    private final JFrame parent;
    private JProgressBar memoryBar;

    public AboutDialog(JFrame parent) {
        super((Frame)parent, Resources.getString("dialog.main.title") + " v" + "0.7.2");
        this.parent = parent;
        Timer timer = new Timer(true);
        timer.scheduleAtFixedRate((TimerTask)new UpdateTimerTask(), 0L, 1000L);
        this.setContentPane(this.createMainPanel());
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        this.pack();
    }

    private JPanel createMainPanel() {
        JLabel logo = new JLabel(Resources.getIcon("logo.png"));
        logo.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        logo.setAlignmentX(0.0f);
        logo.addMouseListener(new MouseInputAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                AboutDialog.this.setVisible(false);
            }
        });
        JSeparator separator = new JSeparator();
        separator.setAlignmentX(0.0f);
        this.memoryBar = new JProgressBar();
        this.memoryBar.setStringPainted(true);
        JButton gcButton = new JButton(new GarbageCollectAction());
        gcButton.setBorderPainted(false);
        gcButton.setBorder(null);
        gcButton.setOpaque(false);
        gcButton.setBackground(new Color(0, 0, 0, 0));
        JPanel barPanel = new JPanel();
        barPanel.setLayout(new BoxLayout(barPanel, 0));
        barPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        barPanel.setMaximumSize(new Dimension(logo.getPreferredSize().width, Short.MAX_VALUE));
        barPanel.setAlignmentX(0.0f);
        barPanel.add(this.memoryBar);
        barPanel.add(Box.createRigidArea(new Dimension(5, 5)));
        barPanel.add(gcButton);
        JPanel mainPanel = new JPanel();
        mainPanel.setOpaque(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(logo);
        mainPanel.add(separator);
        mainPanel.add(barPanel);
        return mainPanel;
    }

    private void updateMemoryBar() {
        int total = (int)Runtime.getRuntime().totalMemory();
        int used = (int)((long)total - Runtime.getRuntime().freeMemory());
        this.memoryBar.setMaximum(total);
        this.memoryBar.setValue(used);
        this.memoryBar.setString(used / 1024 + " KB / " + total / 1024 + " KB");
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.updateMemoryBar();
            this.setLocationRelativeTo(this.parent);
        }
        super.setVisible(visible);
    }

    private class GarbageCollectAction
    extends AbstractAction {
        public GarbageCollectAction() {
            this.putValue("SmallIcon", Resources.getIcon("gnome-delete.png"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.gc();
            AboutDialog.this.updateMemoryBar();
        }
    }

    private class UpdateTimerTask
    extends TimerTask {
        private UpdateTimerTask() {
        }

        public void run() {
            if (AboutDialog.this.isVisible()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AboutDialog.this.updateMemoryBar();
                    }
                });
            }
        }
    }
}

