/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.animation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tiled.core.Sprite;
import tiled.mapeditor.Resources;
import tiled.mapeditor.animation.KeyDialog;
import tiled.mapeditor.animation.SpriteCanvas;

public class AnimationDialog
extends JDialog
implements ActionListener {
    private static final int PLAYING = 1;
    private static final int STOPPED = 0;
    private Sprite currentSprite;
    private SpriteCanvas canvas;
    private int state = 0;
    private JButton playstop;
    private JComboBox keyframe;
    private JLabel lCurrentFrame;
    private JLabel lFrameRate;
    private JLabel lFrameRange;
    private Icon playIcon;
    private Icon stopIcon;

    public AnimationDialog(Dialog parent, Sprite sprite) {
        super(parent, "Animation", true);
        this.currentSprite = sprite;
        this.playIcon = Resources.getIcon("play.png");
        this.stopIcon = Resources.getIcon("stop.png");
        this.makeUp();
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public JPanel makeUp() {
        JPanel main = new JPanel(new BorderLayout());
        JPanel data = new JPanel(new BorderLayout());
        JPanel buttons = new JPanel(new GridBagLayout());
        JPanel opt = new JPanel(new GridBagLayout());
        this.canvas = new SpriteCanvas(this);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        JButton b = new JButton("", Resources.getIcon("startframe.png"));
        b.setActionCommand("startframe");
        b.setMargin(new Insets(0, 0, 0, 0));
        b.addActionListener(this);
        buttons.add((Component)b, c);
        c.gridx = 1;
        b = new JButton("", Resources.getIcon("back.png"));
        b.setActionCommand("back");
        b.setMargin(new Insets(0, 0, 0, 0));
        b.addActionListener(this);
        buttons.add((Component)b, c);
        c.gridx = 2;
        this.playstop = new JButton("", Resources.getIcon("play.png"));
        this.playstop.setActionCommand("playstop");
        this.playstop.setMargin(new Insets(0, 0, 0, 0));
        this.playstop.addActionListener(this);
        buttons.add((Component)this.playstop, c);
        c.gridx = 3;
        b = new JButton("", Resources.getIcon("forward.png"));
        b.setActionCommand("forward");
        b.setMargin(new Insets(0, 0, 0, 0));
        b.addActionListener(this);
        buttons.add((Component)b, c);
        c.gridx = 4;
        b = new JButton("", Resources.getIcon("lastframe.png"));
        b.setActionCommand("lastframe");
        b.setMargin(new Insets(0, 0, 0, 0));
        b.addActionListener(this);
        buttons.add((Component)b, c);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        String[] defaultArr = new String[]{"None"};
        this.keyframe = new JComboBox<String>(defaultArr);
        this.keyframe.addActionListener(this);
        opt.add((Component)this.keyframe, c);
        c.gridwidth = 1;
        c.gridy = 1;
        JLabel l = new JLabel("Range:");
        opt.add((Component)l, c);
        c.gridx = 1;
        this.lFrameRange = new JLabel("-");
        opt.add((Component)this.lFrameRange, c);
        c.gridy = 2;
        c.gridx = 0;
        l = new JLabel("Current:");
        opt.add((Component)l, c);
        c.gridx = 1;
        this.lCurrentFrame = new JLabel("?");
        opt.add((Component)this.lCurrentFrame, c);
        c.gridy = 3;
        c.gridx = 0;
        l = new JLabel("Rate:");
        opt.add((Component)l, c);
        c.gridx = 1;
        this.lFrameRate = new JLabel("?");
        opt.add((Component)this.lFrameRate, c);
        data.add((Component)this.canvas, "Center");
        data.add((Component)buttons, "South");
        main.add((Component)data, "Center");
        main.add((Component)opt, "East");
        return main;
    }

    public void paintSprite(Graphics g) {
        this.currentSprite.getCurrentFrame().draw(g, 0, 0, 1.0);
        if (this.state == 1 && this.currentSprite != null) {
            if (this.currentSprite.getCurrentKey() == null) {
                JOptionPane.showMessageDialog(this, "There are no keys defined!", "No Keys", 0);
                this.state = 0;
                return;
            }
            this.currentSprite.iterateFrame();
            this.updateStats();
            this.canvas.repaint();
            this.repaint();
        }
    }

    public void draw(Graphics g) {
        this.canvas.repaint();
        this.updateList();
    }

    public void updateList() {
        if (this.currentSprite != null) {
            this.keyframe.removeAllItems();
            try {
                Iterator itr = this.currentSprite.getKeys();
                while (itr.hasNext()) {
                    this.keyframe.addItem(((Sprite.KeyFrame)itr.next()).getName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void updateStats() {
        Sprite.KeyFrame k;
        if (this.currentSprite != null && (k = this.currentSprite.getKey((String)this.keyframe.getSelectedItem())) != null) {
            this.lCurrentFrame.setText(String.valueOf(this.currentSprite.getCurrentFrame()));
            this.lFrameRate.setText(String.valueOf(k.getFrameRate()));
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("New Key...") || e.getActionCommand().equalsIgnoreCase("Modify Key...")) {
            KeyDialog kd = new KeyDialog(this, this.currentSprite);
            kd.doKeys();
        } else if (e.getActionCommand().equalsIgnoreCase("Delete Key")) {
            if (this.currentSprite != null) {
                this.currentSprite.removeKey((String)this.keyframe.getSelectedItem());
            }
        } else if (e.getActionCommand().equalsIgnoreCase("comboBoxChanged")) {
            if (this.currentSprite != null) {
                this.currentSprite.setKeyFrameTo((String)this.keyframe.getSelectedItem());
                this.updateStats();
                this.canvas.repaint();
            }
        } else {
            this.handleFrames(e);
        }
        this.updateList();
        this.updateStats();
    }

    public void handleFrames(ActionEvent e) {
        if (this.currentSprite == null) {
            return;
        }
        if (e.getActionCommand().equalsIgnoreCase("startframe")) {
            if (this.currentSprite.getCurrentKey() == null) {
                JOptionPane.showMessageDialog(this, "There are no keys defined!", "No Keys", 0);
            } else {
                this.currentSprite.keySetFrame(0);
                this.canvas.repaint();
            }
        } else if (e.getActionCommand().equalsIgnoreCase("back")) {
            if (this.currentSprite.getCurrentKey() == null) {
                JOptionPane.showMessageDialog(this, "There are no keys defined!", "No Keys", 0);
            } else {
                this.currentSprite.keyStepBack(1);
                this.canvas.repaint();
            }
        } else if (e.getActionCommand().equalsIgnoreCase("playstop")) {
            if (this.currentSprite.getCurrentKey() == null) {
                JOptionPane.showMessageDialog(this, "There are no keys defined!", "No Keys", 0);
            } else {
                if (this.state == 1) {
                    this.state = 0;
                    this.currentSprite.stop();
                    this.playstop.setIcon(this.playIcon);
                } else {
                    this.state = 1;
                    this.currentSprite.play();
                    this.playstop.setIcon(this.stopIcon);
                }
                this.canvas.repaint();
            }
        } else if (e.getActionCommand().equalsIgnoreCase("forward")) {
            if (this.currentSprite.getCurrentKey() == null) {
                JOptionPane.showMessageDialog(this, "There are no keys defined!", "No Keys", 0);
            } else {
                this.currentSprite.keyStepForward(1);
                this.canvas.repaint();
            }
        } else if (e.getActionCommand().equalsIgnoreCase("lastframe")) {
            if (this.currentSprite.getCurrentKey() == null) {
                JOptionPane.showMessageDialog(this, "There are no keys defined!", "No Keys", 0);
            } else {
                this.currentSprite.keyStepForward(10000);
                this.canvas.repaint();
            }
        }
    }
}

