/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import tiled.io.MapHelper;
import tiled.io.MapWriter;
import tiled.mapeditor.MapEditor;
import tiled.mapeditor.Resources;
import tiled.mapeditor.util.ConfirmingFileChooser;
import tiled.mapeditor.util.TiledFileFilter;
import tiled.util.TiledConfiguration;

public class SaveAsAction
extends AbstractAction {
    protected MapEditor editor;
    private boolean savingCancelled;
    private static final String ACTION_NAME = Resources.getString("action.map.saveas.name");
    private static final String ACTION_TOOLTIP = Resources.getString("action.map.saveas.tooltip");
    private static final String SAVEAS_ERROR_MESSAGE = Resources.getString("dialog.saveas.error.message");
    private static final String SAVEAS_ERROR_TITLE = Resources.getString("dialog.saveas.error.title");

    public SaveAsAction(MapEditor editor) {
        super(ACTION_NAME);
        this.putValue("ShortDescription", ACTION_TOOLTIP);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control shift S"));
        this.editor = editor;
    }

    public void actionPerformed(ActionEvent e) {
        this.showFileChooser();
    }

    protected void showFileChooser() {
        MapWriter[] writers;
        String startLocation = TiledConfiguration.node("recent").get("file0", null);
        TiledFileFilter byExtensionFilter = new TiledFileFilter(0);
        TiledFileFilter tmxFilter = new TiledFileFilter(1);
        ConfirmingFileChooser chooser = new ConfirmingFileChooser(startLocation);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter(byExtensionFilter);
        chooser.addChoosableFileFilter(tmxFilter);
        for (MapWriter writer : writers = this.editor.getPluginLoader().getWriters()) {
            try {
                chooser.addChoosableFileFilter(new TiledFileFilter(writer));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        chooser.setFileFilter(byExtensionFilter);
        int result = ((JFileChooser)chooser).showSaveDialog(this.editor.getAppFrame());
        if (result == 0) {
            this.savingCancelled = false;
            TiledFileFilter saver = (TiledFileFilter)chooser.getFileFilter();
            String selectedFile = chooser.getSelectedFile().getAbsolutePath();
            this.saveFile(saver, selectedFile);
        } else {
            this.savingCancelled = true;
        }
    }

    protected void saveFile(TiledFileFilter saver, String filename) {
        try {
            if (saver.getType() == 0) {
                MapHelper.saveMap(this.editor.getCurrentMap(), filename);
            } else {
                MapHelper.saveMap(this.editor.getCurrentMap(), saver.getPlugin(), filename);
            }
            this.editor.getCurrentMap().setFilename(filename);
            this.editor.updateRecent(filename);
            this.editor.getUndoHandler().commitSave();
            this.editor.updateTitle();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.editor.getAppFrame(), SAVEAS_ERROR_MESSAGE + " " + filename + ": " + e.getLocalizedMessage(), SAVEAS_ERROR_TITLE, 0);
        }
    }

    public boolean isSavingCancelled() {
        return this.savingCancelled;
    }
}

