/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.actions;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import tiled.io.MapReader;
import tiled.mapeditor.MapEditor;
import tiled.mapeditor.Resources;
import tiled.mapeditor.actions.AbstractFileAction;
import tiled.mapeditor.actions.SaveAction;
import tiled.mapeditor.util.TiledFileFilter;
import tiled.util.TiledConfiguration;

public class OpenMapAction
extends AbstractFileAction {
    private static final String OPEN_ERROR_TITLE = Resources.getString("dialog.saveas.error.title");

    public OpenMapAction(MapEditor editor, SaveAction saveAction) {
        super(editor, saveAction, Resources.getString("action.map.open.name"), Resources.getString("action.map.open.tooltip"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control O"));
    }

    protected void doPerformAction() {
        String startLocation = TiledConfiguration.fileDialogStartLocation();
        JFileChooser chooser = new JFileChooser(startLocation);
        try {
            MapReader[] readers;
            for (MapReader reader : readers = this.editor.getPluginLoader().getReaders()) {
                chooser.addChoosableFileFilter(new TiledFileFilter(reader.getFilter(), reader.getName()));
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.editor.getAppFrame(), "Error while loading plugins: " + e.getLocalizedMessage(), OPEN_ERROR_TITLE, 0);
            e.printStackTrace();
        }
        chooser.addChoosableFileFilter(new TiledFileFilter(1));
        int ret = chooser.showOpenDialog(this.editor.getAppFrame());
        if (ret == 0) {
            this.editor.loadMap(chooser.getSelectedFile().getAbsolutePath());
        }
    }
}

