/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.actions;

import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import tiled.core.Map;
import tiled.core.MapLayer;
import tiled.mapeditor.MapEditor;
import tiled.mapeditor.undo.MapLayerStateEdit;

public abstract class AbstractLayerAction
extends AbstractAction {
    protected final MapEditor editor;

    protected AbstractLayerAction(MapEditor editor, String name, String description) {
        super(name);
        this.putValue("ShortDescription", description);
        this.putValue("ActionCommandKey", name);
        this.editor = editor;
    }

    protected AbstractLayerAction(MapEditor editor, String name, String description, Icon icon) {
        this(editor, name, description);
        this.putValue("SmallIcon", icon);
    }

    public final void actionPerformed(ActionEvent e) {
        Map map = this.editor.getCurrentMap();
        Vector<MapLayer> layersBefore = new Vector<MapLayer>(map.getLayerVector());
        this.doPerformAction();
        Vector<MapLayer> layersAfter = new Vector<MapLayer>(map.getLayerVector());
        MapLayerStateEdit mapLayerStateEdit = new MapLayerStateEdit(map, layersBefore, layersAfter, e.getActionCommand());
        this.editor.getUndoSupport().postEdit(mapLayerStateEdit);
    }

    protected abstract void doPerformAction();
}

