/*
 * Decompiled with CFR 0.152.
 */
package tiled.io.xml;

import java.awt.Color;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import tiled.core.AnimatedTile;
import tiled.core.Map;
import tiled.core.MapLayer;
import tiled.core.MapObject;
import tiled.core.ObjectGroup;
import tiled.core.Tile;
import tiled.core.TileLayer;
import tiled.core.TileSet;
import tiled.io.ImageHelper;
import tiled.io.MapReader;
import tiled.io.PluginLogger;
import tiled.mapeditor.Resources;
import tiled.mapeditor.util.cutter.BasicTileCutter;
import tiled.mapeditor.util.cutter.TileCutter;
import tiled.util.Base64;
import tiled.util.Util;

public class XMLMapTransformer
implements MapReader {
    private Map map;
    private String xmlPath;
    private PluginLogger logger;
    private final EntityResolver entityResolver = new MapEntityResolver();

    public XMLMapTransformer() {
        this.logger = new PluginLogger();
    }

    private static String makeUrl(String filename) throws MalformedURLException {
        String url = filename.indexOf("://") > 0 || filename.startsWith("file:") ? filename : new File(filename).toURI().toString();
        return url;
    }

    private static int reflectFindMethodByName(Class c, String methodName) {
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equalsIgnoreCase(methodName)) continue;
            return i;
        }
        return -1;
    }

    private void reflectInvokeMethod(Object invokeVictim, Method method, String[] args) throws Exception {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] conformingArguments = new Object[parameterTypes.length];
        if (args.length < parameterTypes.length) {
            throw new Exception("Insufficient arguments were supplied");
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if ("int".equalsIgnoreCase(parameterTypes[i].getName())) {
                conformingArguments[i] = new Integer(args[i]);
                continue;
            }
            if ("float".equalsIgnoreCase(parameterTypes[i].getName())) {
                conformingArguments[i] = new Float(args[i]);
                continue;
            }
            if (parameterTypes[i].getName().endsWith("String")) {
                conformingArguments[i] = args[i];
                continue;
            }
            if ("boolean".equalsIgnoreCase(parameterTypes[i].getName())) {
                conformingArguments[i] = Boolean.valueOf(args[i]);
                continue;
            }
            this.logger.debug("Unsupported argument type " + parameterTypes[i].getName() + ", defaulting to java.lang.String");
            conformingArguments[i] = args[i];
        }
        method.invoke(invokeVictim, conformingArguments);
    }

    private void setOrientation(String o) {
        if ("isometric".equalsIgnoreCase(o)) {
            this.map.setOrientation(2);
        } else if ("orthogonal".equalsIgnoreCase(o)) {
            this.map.setOrientation(1);
        } else if ("hexagonal".equalsIgnoreCase(o)) {
            this.map.setOrientation(4);
        } else if ("shifted".equalsIgnoreCase(o)) {
            this.map.setOrientation(5);
        } else {
            this.logger.warn("Unknown orientation '" + o + "'");
        }
    }

    private static String getAttributeValue(Node node, String attribname) {
        Node attribute;
        NamedNodeMap attributes = node.getAttributes();
        String value = null;
        if (attributes != null && (attribute = attributes.getNamedItem(attribname)) != null) {
            value = attribute.getNodeValue();
        }
        return value;
    }

    private static int getAttribute(Node node, String attribname, int def) {
        String attr = XMLMapTransformer.getAttributeValue(node, attribname);
        if (attr != null) {
            return Integer.parseInt(attr);
        }
        return def;
    }

    private Object unmarshalClass(Class reflector, Node node) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor cons = null;
        try {
            cons = reflector.getConstructor(new Class[0]);
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchMethodException e1) {
            e1.printStackTrace();
            return null;
        }
        Object o = cons.newInstance(new Object[0]);
        Method[] methods = reflector.getMethods();
        NamedNodeMap nnm = node.getAttributes();
        if (nnm != null) {
            for (int i = 0; i < nnm.getLength(); ++i) {
                Node n = nnm.item(i);
                try {
                    int j = XMLMapTransformer.reflectFindMethodByName(reflector, "set" + n.getNodeName());
                    if (j >= 0) {
                        this.reflectInvokeMethod(o, methods[j], new String[]{n.getNodeValue()});
                        continue;
                    }
                    this.logger.warn("Unsupported attribute '" + n.getNodeName() + "' on <" + node.getNodeName() + "> tag");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return o;
    }

    private Image unmarshalImage(Node t, String baseDir) throws IOException {
        Image img = null;
        String source = XMLMapTransformer.getAttributeValue(t, "source");
        if (source != null) {
            source = Util.checkRoot(source) ? XMLMapTransformer.makeUrl(source) : XMLMapTransformer.makeUrl(baseDir + source);
            img = ImageIO.read(new URL(source));
        } else {
            NodeList nl = t.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (!"data".equals(node.getNodeName())) continue;
                Node cdata = node.getFirstChild();
                if (cdata == null) {
                    this.logger.warn("image <data> tag enclosed no data. (empty data tag)");
                    break;
                }
                String sdata = cdata.getNodeValue();
                char[] charArray = sdata.trim().toCharArray();
                byte[] imageData = Base64.decode(charArray);
                img = ImageHelper.bytesToImage(imageData);
                img = img.getScaledInstance(((Image)img).getWidth(null), ((Image)img).getHeight(null), 2);
                break;
            }
        }
        return img;
    }

    private TileSet unmarshalTilesetFile(InputStream in, String filename) throws Exception {
        TileSet set = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            NodeList tsNodeList;
            Node tsNode;
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document tsDoc = builder.parse(in, ".");
            String xmlPathSave = this.xmlPath;
            if (filename.indexOf(File.separatorChar) >= 0) {
                this.xmlPath = filename.substring(0, filename.lastIndexOf(File.separatorChar) + 1);
            }
            if ((tsNode = (tsNodeList = tsDoc.getElementsByTagName("tileset")).item(0)) != null) {
                set = this.unmarshalTileset(tsNode);
                if (set.getSource() != null) {
                    this.logger.warn("Recursive external Tilesets are not supported.");
                }
                set.setSource(filename);
            }
            this.xmlPath = xmlPathSave;
        }
        catch (SAXException e) {
            this.logger.error("Failed while loading " + filename + ": " + e.getLocalizedMessage());
        }
        return set;
    }

    private TileSet unmarshalTileset(Node t) throws Exception {
        String source = XMLMapTransformer.getAttributeValue(t, "source");
        String basedir = XMLMapTransformer.getAttributeValue(t, "basedir");
        int firstGid = XMLMapTransformer.getAttribute(t, "firstgid", 1);
        String tilesetBaseDir = this.xmlPath;
        if (basedir != null) {
            tilesetBaseDir = basedir;
        }
        if (source != null) {
            String filename = tilesetBaseDir + source;
            TileSet ext = null;
            try {
                String extention = source.substring(source.lastIndexOf(46) + 1);
                if (!"tsx".equals(extention.toLowerCase())) {
                    this.logger.warn("tileset files should end in .tsx! (" + source + ")");
                }
                InputStream in = new URL(XMLMapTransformer.makeUrl(filename)).openStream();
                ext = this.unmarshalTilesetFile(in, filename);
            }
            catch (FileNotFoundException fnf) {
                this.logger.error("Could not find external tileset file " + filename);
            }
            if (ext == null) {
                this.logger.error("tileset " + source + " was not loaded correctly!");
                ext = new TileSet();
            }
            ext.setFirstGid(firstGid);
            return ext;
        }
        int tileWidth = XMLMapTransformer.getAttribute(t, "tilewidth", this.map != null ? this.map.getTileWidth() : 0);
        int tileHeight = XMLMapTransformer.getAttribute(t, "tileheight", this.map != null ? this.map.getTileHeight() : 0);
        int tileSpacing = XMLMapTransformer.getAttribute(t, "spacing", 0);
        int tileMargin = XMLMapTransformer.getAttribute(t, "margin", 0);
        TileSet set = new TileSet();
        set.setName(XMLMapTransformer.getAttributeValue(t, "name"));
        set.setBaseDir(basedir);
        set.setFirstGid(firstGid);
        boolean hasTilesetImage = false;
        NodeList children = t.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeName().equalsIgnoreCase("image")) {
                if (hasTilesetImage) {
                    this.logger.warn("Ignoring illegal image element after tileset image.");
                    continue;
                }
                String imgSource = XMLMapTransformer.getAttributeValue(child, "source");
                String id = XMLMapTransformer.getAttributeValue(child, "id");
                String transStr = XMLMapTransformer.getAttributeValue(child, "trans");
                if (imgSource != null && id == null) {
                    hasTilesetImage = true;
                    String sourcePath = imgSource;
                    if (!new File(imgSource).isAbsolute()) {
                        sourcePath = tilesetBaseDir + imgSource;
                    }
                    this.logger.info("Importing " + sourcePath + "...");
                    if (transStr != null) {
                        int colorInt = Integer.parseInt(transStr, 16);
                        Color color = new Color(colorInt);
                        set.setTransparentColor(color);
                    }
                    set.importTileBitmap(sourcePath, (TileCutter)new BasicTileCutter(tileWidth, tileHeight, tileSpacing, tileMargin));
                    continue;
                }
                Image image = this.unmarshalImage(child, tilesetBaseDir);
                String idValue = XMLMapTransformer.getAttributeValue(child, "id");
                int imageId = Integer.parseInt(idValue);
                set.addImage(image, imageId);
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("tile")) continue;
            Tile tile = this.unmarshalTile(set, child, tilesetBaseDir);
            if (!hasTilesetImage || tile.getId() > set.getMaxTileId()) {
                set.addTile(tile);
                continue;
            }
            Tile myTile = set.getTile(tile.getId());
            myTile.setProperties(tile.getProperties());
        }
        return set;
    }

    private MapObject readMapObject(Node t) throws Exception {
        String name = XMLMapTransformer.getAttributeValue(t, "name");
        String type = XMLMapTransformer.getAttributeValue(t, "type");
        int x = XMLMapTransformer.getAttribute(t, "x", 0);
        int y = XMLMapTransformer.getAttribute(t, "y", 0);
        int width = XMLMapTransformer.getAttribute(t, "width", 0);
        int height = XMLMapTransformer.getAttribute(t, "height", 0);
        MapObject obj = new MapObject(x, y, width, height);
        if (name != null) {
            obj.setName(name);
        }
        if (type != null) {
            obj.setType(type);
        }
        NodeList children = t.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!"image".equalsIgnoreCase(child.getNodeName())) continue;
            String source = XMLMapTransformer.getAttributeValue(child, "source");
            if (source == null) break;
            if (!new File(source).isAbsolute()) {
                source = this.xmlPath + source;
            }
            obj.setImageSource(source);
            break;
        }
        Properties props = new Properties();
        XMLMapTransformer.readProperties(children, props);
        obj.setProperties(props);
        return obj;
    }

    private static void readProperties(NodeList children, Properties props) {
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if ("property".equalsIgnoreCase(child.getNodeName())) {
                Node grandChild;
                String key = XMLMapTransformer.getAttributeValue(child, "name");
                String value = XMLMapTransformer.getAttributeValue(child, "value");
                if (value == null && (grandChild = child.getFirstChild()) != null && (value = grandChild.getNodeValue()) != null) {
                    value = value.trim();
                }
                if (value == null) continue;
                props.setProperty(key, value);
                continue;
            }
            if (!"properties".equals(child.getNodeName())) continue;
            XMLMapTransformer.readProperties(child.getChildNodes(), props);
        }
    }

    private Tile unmarshalTile(TileSet set, Node t, String baseDir) throws Exception {
        Node child;
        int i;
        Tile tile = null;
        NodeList children = t.getChildNodes();
        boolean isAnimated = false;
        for (i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            if (!"animation".equalsIgnoreCase(child.getNodeName())) continue;
            isAnimated = true;
            break;
        }
        try {
            tile = isAnimated ? (Tile)this.unmarshalClass(AnimatedTile.class, t) : (Tile)this.unmarshalClass(Tile.class, t);
        }
        catch (Exception e) {
            this.logger.error("failed creating tile: " + e.getLocalizedMessage());
            return tile;
        }
        tile.setTileSet(set);
        XMLMapTransformer.readProperties(children, tile.getProperties());
        for (i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            if ("image".equalsIgnoreCase(child.getNodeName())) {
                int id = XMLMapTransformer.getAttribute(child, "id", -1);
                Image img = this.unmarshalImage(child, baseDir);
                if (id < 0) {
                    id = set.addImage(img);
                }
                tile.setImage(id);
                continue;
            }
            if (!"animation".equalsIgnoreCase(child.getNodeName())) continue;
        }
        return tile;
    }

    private MapLayer unmarshalObjectGroup(Node t) throws Exception {
        ObjectGroup og = null;
        try {
            og = (ObjectGroup)this.unmarshalClass(ObjectGroup.class, t);
        }
        catch (Exception e) {
            e.printStackTrace();
            return og;
        }
        int offsetX = XMLMapTransformer.getAttribute(t, "x", 0);
        int offsetY = XMLMapTransformer.getAttribute(t, "y", 0);
        og.setOffset(offsetX, offsetY);
        NodeList children = t.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!"object".equalsIgnoreCase(child.getNodeName())) continue;
            og.addObject(this.readMapObject(child));
        }
        Properties props = new Properties();
        XMLMapTransformer.readProperties(children, props);
        og.setProperties(props);
        return og;
    }

    private MapLayer readLayer(Node t) throws Exception {
        int layerWidth = XMLMapTransformer.getAttribute(t, "width", this.map.getWidth());
        int layerHeight = XMLMapTransformer.getAttribute(t, "height", this.map.getHeight());
        TileLayer ml = new TileLayer(layerWidth, layerHeight);
        int offsetX = XMLMapTransformer.getAttribute(t, "x", 0);
        int offsetY = XMLMapTransformer.getAttribute(t, "y", 0);
        int visible = XMLMapTransformer.getAttribute(t, "visible", 1);
        String opacity = XMLMapTransformer.getAttributeValue(t, "opacity");
        ml.setName(XMLMapTransformer.getAttributeValue(t, "name"));
        if (opacity != null) {
            ml.setOpacity(Float.parseFloat(opacity));
        }
        XMLMapTransformer.readProperties(t.getChildNodes(), ml.getProperties());
        block0: for (Node child = t.getFirstChild(); child != null; child = child.getNextSibling()) {
            String nodeName = child.getNodeName();
            if ("data".equalsIgnoreCase(nodeName)) {
                String encoding = XMLMapTransformer.getAttributeValue(child, "encoding");
                if (encoding != null && "base64".equalsIgnoreCase(encoding)) {
                    Node cdata = child.getFirstChild();
                    if (cdata == null) {
                        this.logger.warn("layer <data> tag enclosed no data. (empty data tag)");
                        continue;
                    }
                    char[] enc = cdata.getNodeValue().trim().toCharArray();
                    byte[] dec = Base64.decode(enc);
                    ByteArrayInputStream bais = new ByteArrayInputStream(dec);
                    String comp = XMLMapTransformer.getAttributeValue(child, "compression");
                    InputStream is = comp != null && "gzip".equalsIgnoreCase(comp) ? new GZIPInputStream(bais) : bais;
                    for (int y = 0; y < ml.getHeight(); ++y) {
                        for (int x = 0; x < ml.getWidth(); ++x) {
                            int tileId = 0;
                            tileId |= is.read();
                            tileId |= is.read() << 8;
                            tileId |= is.read() << 16;
                            TileSet ts = this.map.findTileSetForTileGID(tileId |= is.read() << 24);
                            if (ts != null) {
                                ml.setTileAt(x, y, ts.getTile(tileId - ts.getFirstGid()));
                                continue;
                            }
                            ml.setTileAt(x, y, null);
                        }
                    }
                    continue;
                }
                int x = 0;
                int y = 0;
                for (Node dataChild = child.getFirstChild(); dataChild != null; dataChild = dataChild.getNextSibling()) {
                    if (!"tile".equalsIgnoreCase(dataChild.getNodeName())) continue;
                    int tileId = XMLMapTransformer.getAttribute(dataChild, "gid", -1);
                    TileSet ts = this.map.findTileSetForTileGID(tileId);
                    if (ts != null) {
                        ml.setTileAt(x, y, ts.getTile(tileId - ts.getFirstGid()));
                    } else {
                        ml.setTileAt(x, y, null);
                    }
                    if (++x == ml.getWidth()) {
                        x = 0;
                        ++y;
                    }
                    if (y == ml.getHeight()) continue block0;
                }
                continue;
            }
            if (!"tileproperties".equalsIgnoreCase(nodeName)) continue;
            for (Node tpn = child.getFirstChild(); tpn != null; tpn = tpn.getNextSibling()) {
                if (!"tile".equalsIgnoreCase(tpn.getNodeName())) continue;
                int x = XMLMapTransformer.getAttribute(tpn, "x", -1);
                int y = XMLMapTransformer.getAttribute(tpn, "y", -1);
                Properties tip = new Properties();
                XMLMapTransformer.readProperties(tpn.getChildNodes(), tip);
                ml.setTileInstancePropertiesAt(x, y, tip);
            }
        }
        ml.setOffset(offsetX, offsetY);
        ml.setVisible(visible == 1);
        return ml;
    }

    private void buildMap(Document doc) throws Exception {
        Node item;
        Element mapNode = doc.getDocumentElement();
        if (!"map".equals(mapNode.getNodeName())) {
            throw new Exception("Not a valid tmx map file.");
        }
        int mapWidth = XMLMapTransformer.getAttribute(mapNode, "width", 0);
        int mapHeight = XMLMapTransformer.getAttribute(mapNode, "height", 0);
        if (mapWidth > 0 && mapHeight > 0) {
            this.map = new Map(mapWidth, mapHeight);
        } else {
            NodeList l = doc.getElementsByTagName("dimensions");
            int i = 0;
            while ((item = l.item(i)) != null) {
                if (item.getParentNode() == mapNode) {
                    mapWidth = XMLMapTransformer.getAttribute(item, "width", 0);
                    mapHeight = XMLMapTransformer.getAttribute(item, "height", 0);
                    if (mapWidth > 0 && mapHeight > 0) {
                        this.map = new Map(mapWidth, mapHeight);
                    }
                }
                ++i;
            }
        }
        if (this.map == null) {
            throw new Exception("Couldn't locate map dimensions.");
        }
        String orientation = XMLMapTransformer.getAttributeValue(mapNode, "orientation");
        int tileWidth = XMLMapTransformer.getAttribute(mapNode, "tilewidth", 0);
        int tileHeight = XMLMapTransformer.getAttribute(mapNode, "tileheight", 0);
        if (tileWidth > 0) {
            this.map.setTileWidth(tileWidth);
        }
        if (tileHeight > 0) {
            this.map.setTileHeight(tileHeight);
        }
        if (orientation != null) {
            this.setOrientation(orientation);
        } else {
            this.setOrientation("orthogonal");
        }
        XMLMapTransformer.readProperties(mapNode.getChildNodes(), this.map.getProperties());
        NodeList l = doc.getElementsByTagName("tileset");
        int i = 0;
        while ((item = l.item(i)) != null) {
            this.map.addTileset(this.unmarshalTileset(item));
            ++i;
        }
        for (Node sibs = mapNode.getFirstChild(); sibs != null; sibs = sibs.getNextSibling()) {
            MapLayer layer;
            if ("layer".equals(sibs.getNodeName())) {
                layer = this.readLayer(sibs);
                if (layer == null) continue;
                this.map.addLayer(layer);
                continue;
            }
            if (!"objectgroup".equals(sibs.getNodeName()) || (layer = this.unmarshalObjectGroup(sibs)) == null) continue;
            this.map.addLayer(layer);
        }
    }

    private Map unmarshal(InputStream in) throws Exception {
        Document doc;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setExpandEntityReferences(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(this.entityResolver);
            InputSource insrc = new InputSource(in);
            insrc.setSystemId(this.xmlPath);
            insrc.setEncoding("UTF8");
            doc = builder.parse(insrc);
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new Exception("Error while parsing map file: " + e.toString());
        }
        this.buildMap(doc);
        return this.map;
    }

    public Map readMap(String filename) throws Exception {
        this.xmlPath = filename.substring(0, filename.lastIndexOf(File.separatorChar) + 1);
        String xmlFile = XMLMapTransformer.makeUrl(filename);
        URL url = new URL(xmlFile);
        InputStream is = url.openStream();
        if (filename.endsWith(".gz")) {
            is = new GZIPInputStream(is);
        }
        Map unmarshalledMap = this.unmarshal(is);
        unmarshalledMap.setFilename(filename);
        this.map = null;
        return unmarshalledMap;
    }

    public Map readMap(InputStream in) throws Exception {
        this.xmlPath = XMLMapTransformer.makeUrl(".");
        Map unmarshalledMap = this.unmarshal(in);
        return unmarshalledMap;
    }

    public TileSet readTileset(String filename) throws Exception {
        String xmlFile = filename;
        this.xmlPath = filename.substring(0, filename.lastIndexOf(File.separatorChar) + 1);
        xmlFile = XMLMapTransformer.makeUrl(xmlFile);
        this.xmlPath = XMLMapTransformer.makeUrl(this.xmlPath);
        URL url = new URL(xmlFile);
        return this.unmarshalTilesetFile(url.openStream(), filename);
    }

    public TileSet readTileset(InputStream in) throws Exception {
        return this.unmarshalTilesetFile(in, ".");
    }

    public String getFilter() throws Exception {
        return "*.tmx,*.tmx.gz,*.tsx";
    }

    public String getPluginPackage() {
        return "Tiled internal TMX reader/writer";
    }

    public String getDescription() {
        return "This is the core Tiled TMX format reader\n\nTiled Map Editor, (c) 2004-2008\nAdam Turk\nBjorn Lindeijer";
    }

    public String getName() {
        return "Default Tiled XML (TMX) map reader";
    }

    public boolean accept(File pathname) {
        try {
            String path = pathname.getCanonicalPath();
            if (path.endsWith(".tmx") || path.endsWith(".tsx") || path.endsWith(".tmx.gz")) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public void setLogger(PluginLogger logger) {
        this.logger = logger;
    }

    private class MapEntityResolver
    implements EntityResolver {
        private MapEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            if (systemId.equals("http://mapeditor.org/dtd/1.0/map.dtd")) {
                return new InputSource(Resources.class.getResourceAsStream("resources/map.dtd"));
            }
            return null;
        }
    }
}

