/*
 * Decompiled with CFR 0.152.
 */
package tiled.io;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageHelper {
    public static byte[] imageToPNG(Image image) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            BufferedImage buffer = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            buffer.createGraphics().drawImage(image, 0, 0, null);
            ImageIO.write((RenderedImage)buffer, "PNG", baos);
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return baos.toByteArray();
    }

    public static BufferedImage bytesToImage(byte[] imageData) throws IOException {
        return ImageIO.read(new ByteArrayInputStream(imageData));
    }

    public static BufferedImage loadImageFile(File file) throws IOException {
        return ImageIO.read(file);
    }
}

