/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.quicktime;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.monte.media.AbstractVideoCodec;
import org.monte.media.Buffer;
import org.monte.media.BufferFlag;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.io.ByteArrayImageOutputStream;
import org.monte.media.math.Rational;

public class AnimationCodec
extends AbstractVideoCodec {
    private Object previousPixels;
    private int frameCounter;

    public AnimationCodec() {
        super(new Format[]{new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "Java", VideoFormatKeys.EncodingKey, "image"})}, new Format[]{new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "video/quicktime", VideoFormatKeys.EncodingKey, "rle ", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.DepthKey, 8}), new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "video/quicktime", VideoFormatKeys.EncodingKey, "rle ", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.DepthKey, 16}), new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "video/quicktime", VideoFormatKeys.EncodingKey, "rle ", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.DepthKey, 24}), new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "video/quicktime", VideoFormatKeys.EncodingKey, "rle ", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.DepthKey, 32})});
    }

    public Format setOutputFormat(Format f) {
        Format sf = super.setOutputFormat(f);
        return new Format(VideoFormatKeys.KeyFrameIntervalKey, Math.max(1, ((Rational)sf.get(VideoFormatKeys.FrameRateKey)).intValue())).append(sf);
    }

    public void reset() {
        this.frameCounter = 0;
    }

    public int process(Buffer in, Buffer out) {
        Rectangle r;
        int scanlineStride;
        out.setMetaTo(in);
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        out.format = this.outputFormat;
        ByteArrayImageOutputStream tmp = out.data instanceof byte[] ? new ByteArrayImageOutputStream((byte[])out.data) : new ByteArrayImageOutputStream();
        Format vf = this.outputFormat;
        if (in.data instanceof BufferedImage) {
            BufferedImage image = (BufferedImage)in.data;
            WritableRaster raster = image.getRaster();
            scanlineStride = raster.getSampleModel().getWidth();
            r = raster.getBounds();
            r.x -= raster.getSampleModelTranslateX();
            r.y -= raster.getSampleModelTranslateY();
        } else {
            r = new Rectangle(0, 0, vf.get(VideoFormatKeys.WidthKey), vf.get(VideoFormatKeys.HeightKey));
            scanlineStride = vf.get(VideoFormatKeys.WidthKey);
        }
        boolean isKeyframe = this.frameCounter == 0 || this.frameCounter % this.outputFormat.get(VideoFormatKeys.KeyFrameIntervalKey, ((Rational)this.outputFormat.get(VideoFormatKeys.FrameRateKey)).intValue()) == 0;
        ++this.frameCounter;
        try {
            switch (vf.get(VideoFormatKeys.DepthKey)) {
                case 8: {
                    Object[] pixels = this.getIndexed8(in);
                    if (pixels == null) {
                        return 1;
                    }
                    if (isKeyframe || this.previousPixels == null) {
                        this.encodeKey8(tmp, (byte[])pixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                        out.setFlag(BufferFlag.KEYFRAME, true);
                    } else {
                        this.encodeDelta8(tmp, (byte[])pixels, (byte[])this.previousPixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                        out.setFlag(BufferFlag.KEYFRAME, false);
                    }
                    if (this.previousPixels == null) {
                        this.previousPixels = pixels.clone();
                        break;
                    }
                    System.arraycopy(pixels, 0, this.previousPixels, 0, pixels.length);
                    break;
                }
                case 16: {
                    Object[] pixels = this.getRGB15(in);
                    if (pixels == null) {
                        return 1;
                    }
                    if (isKeyframe || this.previousPixels == null) {
                        this.encodeKey16(tmp, (short[])pixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                        out.setFlag(BufferFlag.KEYFRAME, true);
                    } else {
                        this.encodeDelta16(tmp, (short[])pixels, (short[])this.previousPixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                        out.setFlag(BufferFlag.KEYFRAME, false);
                    }
                    if (this.previousPixels == null) {
                        this.previousPixels = pixels.clone();
                        break;
                    }
                    System.arraycopy(pixels, 0, this.previousPixels, 0, pixels.length);
                    break;
                }
                case 24: {
                    Object[] pixels = this.getRGB24(in);
                    if (pixels == null) {
                        return 1;
                    }
                    if (isKeyframe || this.previousPixels == null) {
                        this.encodeKey24(tmp, (int[])pixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                        out.setFlag(BufferFlag.KEYFRAME, true);
                    } else {
                        this.encodeDelta24(tmp, (int[])pixels, (int[])this.previousPixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                        out.setFlag(BufferFlag.KEYFRAME, false);
                    }
                    if (this.previousPixels == null) {
                        this.previousPixels = pixels.clone();
                        break;
                    }
                    System.arraycopy(pixels, 0, this.previousPixels, 0, pixels.length);
                    break;
                }
                case 32: {
                    Object[] pixels = this.getARGB32(in);
                    if (pixels == null) {
                        out.setFlag(BufferFlag.DISCARD);
                        return 1;
                    }
                    if (in.isFlag(BufferFlag.KEYFRAME) || this.previousPixels == null) {
                        this.encodeKey32(tmp, (int[])pixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                        out.setFlag(BufferFlag.KEYFRAME, true);
                    } else {
                        this.encodeDelta32(tmp, (int[])pixels, (int[])this.previousPixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                        out.setFlag(BufferFlag.KEYFRAME, false);
                    }
                    if (this.previousPixels == null) {
                        this.previousPixels = pixels.clone();
                        break;
                    }
                    System.arraycopy(pixels, 0, this.previousPixels, 0, pixels.length);
                    break;
                }
                default: {
                    out.setFlag(BufferFlag.DISCARD);
                    return 1;
                }
            }
            out.format = this.outputFormat;
            out.data = tmp.getBuffer();
            out.sampleCount = 1;
            out.offset = 0;
            out.length = (int)tmp.getStreamPosition();
            return 0;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
    }

    public void encodeKey8(ImageOutputStream out, byte[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        if (width % 4 != 0 || offset % 4 != 0 || scanlineStride % 4 != 0) {
            throw new UnsupportedOperationException("Conversion is not fully implemented yet.");
        }
        int[] ints = new int[data.length / 4];
        int i = 0;
        int j = 0;
        while (i < data.length) {
            ints[j] = (data[i] & 0xFF) << 24 | (data[i + 1] & 0xFF) << 16 | (data[i + 2] & 0xFF) << 8 | data[i + 3] & 0xFF;
            i += 4;
            ++j;
        }
        this.encodeKey32(out, ints, width / 4, height, offset / 4, scanlineStride / 4);
    }

    public void encodeDelta8(ImageOutputStream out, byte[] data, byte[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        if (width % 4 != 0 || offset % 4 != 0 || scanlineStride % 4 != 0) {
            throw new UnsupportedOperationException("Conversion is not fully implemented yet.");
        }
        out.setByteOrder(ByteOrder.BIG_ENDIAN);
        int[] ints = new int[data.length / 4];
        int i = 0;
        int j = 0;
        while (i < data.length) {
            ints[j] = (data[i] & 0xFF) << 24 | (data[i + 1] & 0xFF) << 16 | (data[i + 2] & 0xFF) << 8 | data[i + 3] & 0xFF;
            i += 4;
            ++j;
        }
        int[] pints = new int[prev.length / 4];
        int i2 = 0;
        int j2 = 0;
        while (i2 < prev.length) {
            pints[j2] = (prev[i2] & 0xFF) << 24 | (prev[i2 + 1] & 0xFF) << 16 | (prev[i2 + 2] & 0xFF) << 8 | prev[i2 + 3] & 0xFF;
            i2 += 4;
            ++j2;
        }
        this.encodeDelta32(out, ints, pints, width / 4, height, offset / 4, scanlineStride / 4);
    }

    public void encodeKey16(ImageOutputStream out, short[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        out.setByteOrder(ByteOrder.BIG_ENDIAN);
        long headerPos = out.getStreamPosition();
        out.writeInt(0);
        out.writeShort(0);
        int ymax = offset + height * scanlineStride;
        for (int y = offset; y < ymax; y += scanlineStride) {
            int xy;
            int xymax = y + width;
            out.write(1);
            int literalCount = 0;
            int repeatCount = 0;
            for (xy = y; xy < xymax; ++xy) {
                short v = data[xy];
                for (repeatCount = 0; xy < xymax && repeatCount < 127 && data[xy] == v; ++xy, ++repeatCount) {
                }
                xy -= repeatCount;
                if (repeatCount < 2) {
                    if (++literalCount != 127) continue;
                    out.write(literalCount);
                    out.writeShorts(data, xy - literalCount + 1, literalCount);
                    literalCount = 0;
                    continue;
                }
                if (literalCount > 0) {
                    out.write(literalCount);
                    out.writeShorts(data, xy - literalCount, literalCount);
                    literalCount = 0;
                }
                out.write(-repeatCount);
                out.writeShort(v);
                xy += repeatCount - 1;
            }
            if (literalCount > 0) {
                out.write(literalCount);
                out.writeShorts(data, xy - literalCount, literalCount);
                literalCount = 0;
            }
            out.write(-1);
        }
        long pos = out.getStreamPosition();
        out.seek(headerPos);
        out.writeInt((int)(pos - headerPos));
        out.seek(pos);
    }

    public void encodeDelta16(ImageOutputStream out, short[] data, short[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        int xy;
        int xymax;
        int ymin;
        out.setByteOrder(ByteOrder.BIG_ENDIAN);
        int ymax = offset + height * scanlineStride;
        block0: for (ymin = offset; ymin < ymax; ymin += scanlineStride) {
            xymax = ymin + width;
            for (xy = ymin; xy < xymax; ++xy) {
                if (data[xy] != prev[xy]) break block0;
            }
        }
        if (ymin == ymax) {
            out.writeInt(4);
            return;
        }
        block2: while (ymax > ymin) {
            xymax = ymax - scanlineStride + width;
            for (xy = ymax - scanlineStride; xy < xymax; ++xy) {
                if (data[xy] != prev[xy]) break block2;
            }
            ymax -= scanlineStride;
        }
        long headerPos = out.getStreamPosition();
        out.writeInt(0);
        if (ymin == offset && ymax == offset + height * scanlineStride) {
            out.writeShort(0);
        } else {
            out.writeShort(8);
            out.writeShort((ymin - offset) / scanlineStride);
            out.writeShort(0);
            out.writeShort((ymax - ymin + 1 - offset) / scanlineStride);
            out.writeShort(0);
        }
        for (int y = ymin; y < ymax; y += scanlineStride) {
            int xy2 = y;
            int xymax2 = y + width;
            int skipCount = 0;
            while (xy2 < xymax2 && data[xy2] == prev[xy2]) {
                ++xy2;
                ++skipCount;
            }
            if (skipCount == width) {
                out.write(1);
                out.write(-1);
                continue;
            }
            out.write(Math.min(255, skipCount + 1));
            skipCount -= Math.min(254, skipCount);
            while (skipCount > 0) {
                out.write(0);
                out.write(Math.min(255, skipCount + 1));
                skipCount -= Math.min(254, skipCount);
            }
            int literalCount = 0;
            int repeatCount = 0;
            while (xy2 < xymax2) {
                skipCount = 0;
                while (xy2 < xymax2 && data[xy2] == prev[xy2]) {
                    ++xy2;
                    ++skipCount;
                }
                short v = data[xy2 -= skipCount];
                for (repeatCount = 0; xy2 < xymax2 && repeatCount < 127 && data[xy2] == v; ++xy2, ++repeatCount) {
                }
                if (skipCount < 2 && (xy2 -= repeatCount) + skipCount < xymax2 && repeatCount < 2) {
                    if (++literalCount == 127) {
                        out.write(literalCount);
                        out.writeShorts(data, xy2 - literalCount + 1, literalCount);
                        literalCount = 0;
                    }
                } else {
                    if (literalCount > 0) {
                        out.write(literalCount);
                        out.writeShorts(data, xy2 - literalCount, literalCount);
                        literalCount = 0;
                    }
                    if (xy2 + skipCount == xymax2) {
                        xy2 += skipCount - 1;
                    } else if (skipCount >= repeatCount) {
                        xy2 += skipCount - 1;
                        while (skipCount > 0) {
                            out.write(0);
                            out.write(Math.min(255, skipCount + 1));
                            skipCount -= Math.min(254, skipCount);
                        }
                    } else {
                        out.write(-repeatCount);
                        out.writeShort(v);
                        xy2 += repeatCount - 1;
                    }
                }
                ++xy2;
            }
            if (literalCount > 0) {
                out.write(literalCount);
                out.writeShorts(data, xy2 - literalCount, literalCount);
                literalCount = 0;
            }
            out.write(-1);
        }
        long pos = out.getStreamPosition();
        out.seek(headerPos);
        out.writeInt((int)(pos - headerPos));
        out.seek(pos);
    }

    public void encodeKey24(ImageOutputStream out, int[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        out.setByteOrder(ByteOrder.BIG_ENDIAN);
        long headerPos = out.getStreamPosition();
        out.writeInt(0);
        out.writeShort(0);
        int ymax = offset + height * scanlineStride;
        for (int y = offset; y < ymax; y += scanlineStride) {
            int xy;
            int xymax = y + width;
            out.write(1);
            int literalCount = 0;
            int repeatCount = 0;
            for (xy = y; xy < xymax; ++xy) {
                int v = data[xy];
                for (repeatCount = 0; xy < xymax && repeatCount < 127 && data[xy] == v; ++xy, ++repeatCount) {
                }
                xy -= repeatCount;
                if (repeatCount < 2) {
                    if (++literalCount <= 126) continue;
                    out.write(literalCount);
                    this.writeInts24(out, data, xy - literalCount + 1, literalCount);
                    literalCount = 0;
                    continue;
                }
                if (literalCount > 0) {
                    out.write(literalCount);
                    this.writeInts24(out, data, xy - literalCount, literalCount);
                    literalCount = 0;
                }
                out.write(-repeatCount);
                this.writeInt24(out, v);
                xy += repeatCount - 1;
            }
            if (literalCount > 0) {
                out.write(literalCount);
                this.writeInts24(out, data, xy - literalCount, literalCount);
                literalCount = 0;
            }
            out.write(-1);
        }
        long pos = out.getStreamPosition();
        out.seek(headerPos);
        out.writeInt((int)(pos - headerPos));
        out.seek(pos);
    }

    public void encodeDelta24(ImageOutputStream out, int[] data, int[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        int xy;
        int xymax;
        int ymin;
        out.setByteOrder(ByteOrder.BIG_ENDIAN);
        int ymax = offset + height * scanlineStride;
        block0: for (ymin = offset; ymin < ymax; ymin += scanlineStride) {
            xymax = ymin + width;
            for (xy = ymin; xy < xymax; ++xy) {
                if (data[xy] != prev[xy]) break block0;
            }
        }
        if (ymin == ymax) {
            out.writeInt(4);
            return;
        }
        block2: while (ymax > ymin) {
            xymax = ymax - scanlineStride + width;
            for (xy = ymax - scanlineStride; xy < xymax; ++xy) {
                if (data[xy] != prev[xy]) break block2;
            }
            ymax -= scanlineStride;
        }
        long headerPos = out.getStreamPosition();
        out.writeInt(0);
        if (ymin == offset && ymax == offset + height * scanlineStride) {
            out.writeShort(0);
        } else {
            out.writeShort(8);
            out.writeShort((ymin - offset) / scanlineStride);
            out.writeShort(0);
            out.writeShort((ymax - ymin + 1 - offset) / scanlineStride);
            out.writeShort(0);
        }
        for (int y = ymin; y < ymax; y += scanlineStride) {
            int xy2 = y;
            int xymax2 = y + width;
            int skipCount = 0;
            while (xy2 < xymax2 && data[xy2] == prev[xy2]) {
                ++xy2;
                ++skipCount;
            }
            if (skipCount == width) {
                out.write(1);
                out.write(-1);
                continue;
            }
            out.write(Math.min(255, skipCount + 1));
            skipCount -= Math.min(254, skipCount);
            while (skipCount > 0) {
                out.write(0);
                out.write(Math.min(255, skipCount + 1));
                skipCount -= Math.min(254, skipCount);
            }
            int literalCount = 0;
            int repeatCount = 0;
            while (xy2 < xymax2) {
                skipCount = 0;
                while (xy2 < xymax2 && data[xy2] == prev[xy2]) {
                    ++xy2;
                    ++skipCount;
                }
                int v = data[xy2 -= skipCount];
                for (repeatCount = 0; xy2 < xymax2 && repeatCount < 127 && data[xy2] == v; ++xy2, ++repeatCount) {
                }
                if (skipCount < 1 && (xy2 -= repeatCount) + skipCount < xymax2 && repeatCount < 2) {
                    if (++literalCount == 127) {
                        out.write(literalCount);
                        this.writeInts24(out, data, xy2 - literalCount + 1, literalCount);
                        literalCount = 0;
                    }
                } else {
                    if (literalCount > 0) {
                        out.write(literalCount);
                        this.writeInts24(out, data, xy2 - literalCount, literalCount);
                        literalCount = 0;
                    }
                    if (xy2 + skipCount == xymax2) {
                        xy2 += skipCount - 1;
                    } else if (skipCount >= repeatCount) {
                        xy2 += skipCount - 1;
                        while (skipCount > 0) {
                            out.write(0);
                            out.write(Math.min(255, skipCount + 1));
                            skipCount -= Math.min(254, skipCount);
                        }
                    } else {
                        out.write(-repeatCount);
                        this.writeInt24(out, v);
                        xy2 += repeatCount - 1;
                    }
                }
                ++xy2;
            }
            if (literalCount > 0) {
                out.write(literalCount);
                this.writeInts24(out, data, xy2 - literalCount, literalCount);
                literalCount = 0;
            }
            out.write(-1);
        }
        long pos = out.getStreamPosition();
        out.seek(headerPos);
        out.writeInt((int)(pos - headerPos));
        out.seek(pos);
    }

    public void encodeKey32(ImageOutputStream out, int[] data, int width, int height, int offset, int scanlineStride) throws IOException {
        out.setByteOrder(ByteOrder.BIG_ENDIAN);
        long headerPos = out.getStreamPosition();
        out.writeInt(0);
        out.writeShort(0);
        int ymax = offset + height * scanlineStride;
        for (int y = offset; y < ymax; y += scanlineStride) {
            int xy;
            int xymax = y + width;
            out.write(1);
            int literalCount = 0;
            int repeatCount = 0;
            for (xy = y; xy < xymax; ++xy) {
                int v = data[xy];
                for (repeatCount = 0; xy < xymax && repeatCount < 127 && data[xy] == v; ++xy, ++repeatCount) {
                }
                xy -= repeatCount;
                if (repeatCount < 2) {
                    if (++literalCount <= 126) continue;
                    out.write(literalCount);
                    out.writeInts(data, xy - literalCount + 1, literalCount);
                    literalCount = 0;
                    continue;
                }
                if (literalCount > 0) {
                    out.write(literalCount);
                    out.writeInts(data, xy - literalCount, literalCount);
                    literalCount = 0;
                }
                out.write(-repeatCount);
                out.writeInt(v);
                xy += repeatCount - 1;
            }
            if (literalCount > 0) {
                out.write(literalCount);
                out.writeInts(data, xy - literalCount, literalCount);
                literalCount = 0;
            }
            out.write(-1);
        }
        long pos = out.getStreamPosition();
        out.seek(headerPos);
        out.writeInt((int)(pos - headerPos));
        out.seek(pos);
    }

    public void encodeDelta32(ImageOutputStream out, int[] data, int[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        int xy;
        int xymax;
        int ymin;
        out.setByteOrder(ByteOrder.BIG_ENDIAN);
        int ymax = offset + height * scanlineStride;
        block0: for (ymin = offset; ymin < ymax; ymin += scanlineStride) {
            xymax = ymin + width;
            for (xy = ymin; xy < xymax; ++xy) {
                if (data[xy] != prev[xy]) break block0;
            }
        }
        if (ymin == ymax) {
            out.writeInt(4);
            return;
        }
        block2: while (ymax > ymin) {
            xymax = ymax - scanlineStride + width;
            for (xy = ymax - scanlineStride; xy < xymax; ++xy) {
                if (data[xy] != prev[xy]) break block2;
            }
            ymax -= scanlineStride;
        }
        long headerPos = out.getStreamPosition();
        out.writeInt(0);
        if (ymin == offset && ymax == offset + height * scanlineStride) {
            out.writeShort(0);
        } else {
            out.writeShort(8);
            out.writeShort((ymin - offset) / scanlineStride);
            out.writeShort(0);
            out.writeShort((ymax - ymin + 1 - offset) / scanlineStride);
            out.writeShort(0);
        }
        for (int y = ymin; y < ymax; y += scanlineStride) {
            int xy2 = y;
            int xymax2 = y + width;
            int skipCount = 0;
            while (xy2 < xymax2 && data[xy2] == prev[xy2]) {
                ++xy2;
                ++skipCount;
            }
            if (skipCount == width) {
                out.write(1);
                out.write(-1);
                continue;
            }
            out.write(Math.min(255, skipCount + 1));
            if (skipCount > 254) {
                skipCount -= 254;
                while (skipCount > 254) {
                    out.write(0);
                    out.write(255);
                    skipCount -= 254;
                }
                out.write(0);
                out.write(skipCount + 1);
            }
            int literalCount = 0;
            int repeatCount = 0;
            while (xy2 < xymax2) {
                skipCount = 0;
                while (xy2 < xymax2 && data[xy2] == prev[xy2]) {
                    ++xy2;
                    ++skipCount;
                }
                int v = data[xy2 -= skipCount];
                for (repeatCount = 0; xy2 < xymax2 && repeatCount < 127 && data[xy2] == v; ++xy2, ++repeatCount) {
                }
                if (skipCount < 1 && (xy2 -= repeatCount) + skipCount < xymax2 && repeatCount < 2) {
                    if (++literalCount == 127) {
                        out.write(literalCount);
                        out.writeInts(data, xy2 - literalCount + 1, literalCount);
                        literalCount = 0;
                    }
                } else {
                    if (literalCount > 0) {
                        out.write(literalCount);
                        out.writeInts(data, xy2 - literalCount, literalCount);
                        literalCount = 0;
                    }
                    if (xy2 + skipCount == xymax2) {
                        xy2 += skipCount - 1;
                    } else if (skipCount >= repeatCount) {
                        while (skipCount > 254) {
                            out.write(0);
                            out.write(255);
                            xy2 += 254;
                            skipCount -= 254;
                        }
                        out.write(0);
                        out.write(skipCount + 1);
                        xy2 += skipCount - 1;
                    } else {
                        out.write(-repeatCount);
                        out.writeInt(v);
                        xy2 += repeatCount - 1;
                    }
                }
                ++xy2;
            }
            if (literalCount > 0) {
                out.write(literalCount);
                out.writeInts(data, xy2 - literalCount, literalCount);
                literalCount = 0;
            }
            out.write(-1);
        }
        long pos = out.getStreamPosition();
        out.seek(headerPos);
        out.writeInt((int)(pos - headerPos));
        out.seek(pos);
    }

    /*
     * Unable to fully structure code
     */
    public void decodeDelta16(ImageInputStream in, short[] data, short[] prev, int width, int height, int offset, int scanlineStride) throws IOException {
        in.setByteOrder(ByteOrder.BIG_ENDIAN);
        chunkSize = in.readUnsignedInt();
        if (chunkSize <= 8L) {
            return;
        }
        if (in.length() != chunkSize) {
            throw new IOException("Illegal chunk size:" + chunkSize + " expected:" + in.length());
        }
        header = in.readUnsignedShort();
        if (header == 0) {
            startingLine = 0;
            numberOfLines = height;
        } else if (header == 8) {
            startingLine = in.readUnsignedShort();
            reserved1 = in.readUnsignedShort();
            if (reserved1 != 0) {
                throw new IOException("Illegal value in reserved1 0x" + Integer.toHexString(reserved1));
            }
            numberOfLines = in.readUnsignedShort();
            reserved2 = in.readUnsignedShort();
            if (reserved2 != 0) {
                throw new IOException("Illegal value in reserved2 0x" + Integer.toHexString(reserved2));
            }
        } else {
            throw new IOException("Unknown header 0x" + Integer.toHexString(header));
        }
        if (startingLine > height || numberOfLines == 0) {
            return;
        }
        if (startingLine + numberOfLines - 1 > height) {
            throw new IOException("Illegal startingLine or numberOfLines, startingLine=" + startingLine + ", numberOfLines=" + numberOfLines);
        }
        for (l = 0; l < numberOfLines; ++l) {
            i = offset + (startingLine + l) * scanlineStride;
            skipCode = in.readUnsignedByte() - 1;
            if (skipCode == -1) break;
            if (skipCode > 0) {
                if (data == prev) {
                    i += skipCode;
                } else {
                    for (j = 0; j < skipCode; ++j) {
                        data[i] = prev[i];
                        ++i;
                    }
                }
            }
            block4: while (true) {
                if ((opCode = in.readByte()) == 0) {
                    skipCode = in.readUnsignedByte() - 1;
                    if (skipCode <= 0) continue;
                    if (prev != data) {
                        System.arraycopy(prev, i, data, i, skipCode);
                    }
                    i += skipCode;
                    continue;
                }
                if (opCode > 0) {
                    try {
                        in.readFully(data, i, (int)opCode);
                    }
                    catch (EOFException e) {
                        System.exit(5);
                        return;
                    }
                    i += opCode;
                    continue;
                }
                if (opCode == -1) break;
                if (opCode >= -1) continue;
                d = in.readShort();
                end = i - opCode;
                while (true) {
                    if (i < end) ** break;
                    continue block4;
                    data[i++] = d;
                }
                break;
            }
            if (!AnimationCodec.$assertionsDisabled && i > offset + (startingLine + l + 1) * scanlineStride) {
                throw new AssertionError();
            }
        }
        if (!AnimationCodec.$assertionsDisabled && in.getStreamPosition() != in.length()) {
            throw new AssertionError();
        }
    }
}

