/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.math;

import java.math.BigInteger;
import java.util.Random;
import org.monte.media.math.IntMath;

public class Rational
extends Number {
    public static final long serialVersionUID = 1L;
    private final long num;
    private final long den;

    public Rational(long numerator, long denominator) {
        if (numerator == 0L) {
            denominator = 1L;
        }
        if (denominator == 0L) {
            numerator = numerator > 0L ? 1L : -1L;
        } else if (denominator < 0L) {
            denominator = -denominator;
            numerator = -numerator;
        }
        long g = IntMath.gcd(numerator, denominator);
        this.num = numerator / g;
        this.den = denominator / g;
    }

    public Rational(Rational r) {
        this(r.num, r.den);
    }

    public long getNumerator() {
        return this.num;
    }

    public long getDenominator() {
        return this.den;
    }

    public Rational add(Rational that) {
        if (this.den == that.den) {
            return new Rational(this.num + that.num, this.den);
        }
        long s = IntMath.scm(this.den, that.den);
        Rational result = new Rational(this.num * (s / this.den) + that.num * (s / that.den), s);
        return result;
    }

    public Rational subtract(Rational that) {
        return this.add(that.negate());
    }

    public Rational negate() {
        return new Rational(-this.num, this.den);
    }

    public Rational inverse() {
        return new Rational(this.den, this.num);
    }

    public Rational floor(long d) {
        if (d == this.den) {
            return new Rational(this.num, this.den);
        }
        long s = IntMath.scm(this.den, d);
        if (s == d) {
            return new Rational(this.num * s / this.den, d);
        }
        if (s == this.den) {
            return new Rational(this.num * d / this.den, d);
        }
        return new Rational(this.num * d / this.den, d);
    }

    public Rational ceil(long d) {
        if (d == this.den) {
            return new Rational(this.num, this.den);
        }
        long s = IntMath.scm(this.den, d);
        if (s == d) {
            return new Rational((this.num * s + this.den - 1L) / this.den, d);
        }
        if (s == this.den) {
            return new Rational((this.num * d + this.den - 1L) / this.den, d);
        }
        return new Rational((this.num * d + this.den - 1L) / this.den, d);
    }

    public Rational multiply(Rational that) {
        return new Rational(this.num * that.num, this.den * that.den);
    }

    public Rational multiply(long integer) {
        return new Rational(this.num * integer, this.den);
    }

    public Rational divide(Rational that) {
        return new Rational(this.num * that.den, this.den * that.num);
    }

    public String toString() {
        if (this.num == 0L) {
            return "0";
        }
        if (this.den == 1L) {
            return Long.toString(this.num);
        }
        return Float.toString((float)this.num / (float)this.den);
    }

    public String toDescriptiveString() {
        long gcd = IntMath.gcd(this.num, this.den);
        if (gcd == 0L || this.num == 0L) {
            return this.num + "/" + this.den + " = " + 0;
        }
        if (gcd == this.den) {
            return this.num + "/" + this.den + " = " + Long.toString(this.num / this.den);
        }
        return this.num + "/" + this.den + " \u2248 " + (float)this.num / (float)this.den;
    }

    public int intValue() {
        return (int)(this.num / this.den);
    }

    public long longValue() {
        return this.num / this.den;
    }

    public float floatValue() {
        return (float)this.num / (float)this.den;
    }

    public double doubleValue() {
        return (double)this.num / (double)this.den;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rational that = (Rational)obj;
        return this.compareTo(that) == 0;
    }

    public int compareTo(Rational that) {
        BigInteger rhs;
        BigInteger lhs;
        if (this.den == 0L && that.den == 0L) {
            lhs = BigInteger.valueOf(this.num == 1L ? Long.MAX_VALUE : Long.MIN_VALUE);
            rhs = BigInteger.valueOf(that.num == 1L ? Long.MAX_VALUE : Long.MIN_VALUE);
        } else {
            lhs = BigInteger.valueOf(this.num).multiply(BigInteger.valueOf(that.den));
            rhs = BigInteger.valueOf(this.den).multiply(BigInteger.valueOf(that.num));
        }
        int cmp = lhs.compareTo(rhs);
        if (cmp < 0) {
            return -1;
        }
        if (cmp > 0) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return (int)(this.num ^ this.num >>> 32 ^ (this.den ^ this.den >>> 32));
    }

    public static Rational max(Rational a, Rational b) {
        return a.compareTo(b) >= 0 ? a : b;
    }

    public static Rational min(Rational a, Rational b) {
        return a.compareTo(b) <= 0 ? a : b;
    }

    public boolean isZero() {
        return this.num == 0L;
    }

    public boolean isLessOrEqualZero() {
        return this.num <= 0L;
    }

    public static Rational valueOf(double d) {
        if (d == 0.0) {
            return new Rational(0L, 1L);
        }
        if (Double.isInfinite(d)) {
            return new Rational((long)Math.signum(d), 0L);
        }
        if (Double.isNaN(d)) {
            return new Rational(0L, 1L);
        }
        return Rational.toRational(d, 2.147483647E9, 100);
    }

    private static Rational toRational(double x, double limit, int iterations) {
        double intpart = Math.floor(x);
        double fractpart = x - intpart;
        double d = 1.0 / fractpart;
        long left = (long)intpart;
        if (d > limit || iterations == 0) {
            return new Rational(left, 1L);
        }
        return new Rational(left, 1L).add(Rational.toRational(d, limit * 0.1, --iterations).inverse());
    }

    public static void main(String[] args) {
        Random r = new Random();
        long num = r.nextInt(1000);
        long den = r.nextInt(1000);
        double dbl = (double)num / (double)den;
        dbl = r.nextDouble();
        System.out.println("num/den=" + num + "/" + den);
        System.out.println("dbl=" + dbl);
        System.out.println(Rational.valueOf(dbl).toDescriptiveString());
    }

    public Rational round(long d) {
        if (d == this.den) {
            return new Rational(this.num, this.den);
        }
        Rational fl = this.floor(d);
        Rational diffFl = this.subtract(fl);
        if (diffFl.isZero()) {
            return fl;
        }
        Rational cl = this.ceil(d);
        Rational diffCl = this.subtract(cl);
        if (diffCl.isZero()) {
            return cl;
        }
        if (diffFl.isNegative()) {
            diffFl = diffFl.negate();
        }
        if (diffCl.isNegative()) {
            diffCl = diffCl.negate();
        }
        return diffFl.compareTo(diffCl) <= 0 ? fl : cl;
    }

    private boolean isNegative() {
        return this.num < 0L;
    }
}

