/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.avi;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import org.monte.media.AbstractVideoCodec;
import org.monte.media.Buffer;
import org.monte.media.BufferFlag;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.io.SeekableByteArrayOutputStream;

public class DIBCodec
extends AbstractVideoCodec {
    public DIBCodec() {
        super(new Format[]{new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "Java", VideoFormatKeys.EncodingKey, "image", VideoFormatKeys.FixedFrameRateKey, true})}, new Format[]{new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "video/avi", VideoFormatKeys.EncodingKey, "DIB ", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 4}), new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "video/avi", VideoFormatKeys.EncodingKey, "DIB ", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 8}), new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "video/avi", VideoFormatKeys.EncodingKey, "DIB ", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true, VideoFormatKeys.DepthKey, 24})});
    }

    public int process(Buffer in, Buffer out) {
        Rectangle r;
        int scanlineStride;
        out.setMetaTo(in);
        out.format = this.outputFormat;
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        SeekableByteArrayOutputStream tmp = out.data instanceof byte[] ? new SeekableByteArrayOutputStream((byte[])out.data) : new SeekableByteArrayOutputStream();
        if (in.data instanceof BufferedImage) {
            BufferedImage image = (BufferedImage)in.data;
            WritableRaster raster = image.getRaster();
            scanlineStride = raster.getSampleModel().getWidth();
            r = raster.getBounds();
            r.x -= raster.getSampleModelTranslateX();
            r.y -= raster.getSampleModelTranslateY();
            out.header = image.getColorModel();
        } else {
            r = new Rectangle(0, 0, this.outputFormat.get(VideoFormatKeys.WidthKey), this.outputFormat.get(VideoFormatKeys.HeightKey));
            scanlineStride = this.outputFormat.get(VideoFormatKeys.WidthKey);
            out.header = null;
        }
        try {
            switch (this.outputFormat.get(VideoFormatKeys.DepthKey)) {
                case 4: {
                    Object[] pixels = this.getIndexed8(in);
                    if (pixels == null) {
                        out.setFlag(BufferFlag.DISCARD);
                        return 0;
                    }
                    this.writeKey4(tmp, (byte[])pixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                    break;
                }
                case 8: {
                    Object[] pixels = this.getIndexed8(in);
                    if (pixels == null) {
                        out.setFlag(BufferFlag.DISCARD);
                        return 0;
                    }
                    this.writeKey8(tmp, (byte[])pixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                    break;
                }
                case 24: {
                    Object[] pixels = this.getRGB24(in);
                    if (pixels == null) {
                        out.setFlag(BufferFlag.DISCARD);
                        return 0;
                    }
                    this.writeKey24(tmp, (int[])pixels, r.width, r.height, r.x + r.y * scanlineStride, scanlineStride);
                    break;
                }
                default: {
                    out.setFlag(BufferFlag.DISCARD);
                    return 0;
                }
            }
            out.setFlag(BufferFlag.KEYFRAME);
            out.data = tmp.getBuffer();
            out.sampleCount = 1;
            out.offset = 0;
            out.length = (int)tmp.getStreamPosition();
            return 0;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
    }

    public void writeKey4(OutputStream out, byte[] pixels, int width, int height, int offset, int scanlineStride) throws IOException {
        byte[] bytes = new byte[width];
        for (int y = (height - 1) * scanlineStride; y >= 0; y -= scanlineStride) {
            int x = offset;
            int xx = 0;
            int n = offset + width;
            while (x < n) {
                bytes[xx] = (byte)((pixels[y + x] & 0xF) << 4 | pixels[y + x + 1] & 0xF);
                x += 2;
                ++xx;
            }
            out.write(bytes);
        }
    }

    public void writeKey8(OutputStream out, byte[] pixels, int width, int height, int offset, int scanlineStride) throws IOException {
        for (int y = (height - 1) * scanlineStride; y >= 0; y -= scanlineStride) {
            out.write(pixels, y + offset, width);
        }
    }

    public void writeKey24(OutputStream out, int[] pixels, int width, int height, int offset, int scanlineStride) throws IOException {
        int w3 = width * 3;
        byte[] bytes = new byte[w3];
        for (int xy = (height - 1) * scanlineStride + offset; xy >= offset; xy -= scanlineStride) {
            int x = 0;
            int xp = 0;
            while (x < w3) {
                int p = pixels[xy + xp];
                bytes[x] = (byte)p;
                bytes[x + 1] = (byte)(p >> 8);
                bytes[x + 2] = (byte)(p >> 16);
                x += 3;
                ++xp;
            }
            out.write(bytes);
        }
    }
}

