/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.SquiggleUnderlineHighlightPainter;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.ToolTipInfo;

class ParserManager
implements DocumentListener,
ActionListener,
HyperlinkListener {
    private RSyntaxTextArea textArea;
    private List parsers;
    private Timer timer;
    private boolean running;
    private Map noticesToHighlights;
    private Parser parserForTip;
    private Position firstOffsetModded;
    private Position lastOffsetModded;
    private SquiggleUnderlineHighlightPainter parserErrorHighlightPainter = new SquiggleUnderlineHighlightPainter(Color.RED);
    private static final boolean DEBUG_PARSING = false;
    private static final int DEFAULT_DELAY_MS = 1250;

    public ParserManager(RSyntaxTextArea textArea) {
        this(1250, textArea);
    }

    public ParserManager(int delay, RSyntaxTextArea textArea) {
        this.textArea = textArea;
        textArea.getDocument().addDocumentListener(this);
        this.parsers = new ArrayList(1);
        this.timer = new Timer(delay, this);
        this.timer.setRepeats(false);
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        int parserCount = this.getParserCount();
        if (parserCount == 0) {
            return;
        }
        long begin = 0L;
        RSyntaxDocument doc = (RSyntaxDocument)this.textArea.getDocument();
        Element root = doc.getDefaultRootElement();
        int firstLine = this.firstOffsetModded == null ? 0 : root.getElementIndex(this.firstOffsetModded.getOffset());
        int lastLine = this.lastOffsetModded == null ? root.getElementCount() - 1 : root.getElementIndex(this.lastOffsetModded.getOffset());
        this.lastOffsetModded = null;
        this.firstOffsetModded = null;
        String style = this.textArea.getSyntaxEditingStyle();
        doc.readLock();
        try {
            for (int i = 0; i < parserCount; ++i) {
                Parser parser = this.getParser(i);
                ParseResult res = parser.parse(doc, style);
                this.addParserNoticeHighlights(res);
            }
            this.textArea.fireParserNoticesChange();
        }
        finally {
            doc.readUnlock();
        }
    }

    public void addParser(Parser parser) {
        if (parser != null && !this.parsers.contains(parser)) {
            if (this.running) {
                this.timer.stop();
            }
            this.parsers.add(parser);
            if (this.parsers.size() == 1) {
                ToolTipManager.sharedInstance().registerComponent(this.textArea);
            }
            if (this.running) {
                this.timer.restart();
            }
        }
    }

    private void addParserNoticeHighlights(ParseResult res) {
        if (this.noticesToHighlights == null) {
            this.noticesToHighlights = new HashMap();
        }
        this.removeParserNotices(res);
        List notices = res.getNotices();
        if (notices.size() > 0) {
            RSyntaxTextAreaHighlighter h = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
            for (ParserNotice notice : notices) {
                try {
                    Object highlight = null;
                    if (notice.getShowInEditor()) {
                        highlight = h.addParserHighlight(notice, this.parserErrorHighlightPainter);
                    }
                    this.noticesToHighlights.put(notice, highlight);
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
        }
    }

    public void changedUpdate(DocumentEvent e) {
    }

    private void clearParserNoticeHighlights() {
        RSyntaxTextAreaHighlighter h = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
        if (h != null) {
            h.clearParserHighlights();
        }
        if (this.noticesToHighlights != null) {
            this.noticesToHighlights.clear();
        }
    }

    public void clearParsers() {
        this.timer.stop();
        this.clearParserNoticeHighlights();
        this.parsers.clear();
        this.textArea.fireParserNoticesChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceReparsing(int parser) {
        Parser p = this.getParser(parser);
        RSyntaxDocument doc = (RSyntaxDocument)this.textArea.getDocument();
        String style = this.textArea.getSyntaxEditingStyle();
        doc.readLock();
        try {
            ParseResult res = p.parse(doc, style);
            this.addParserNoticeHighlights(res);
            this.textArea.fireParserNoticesChange();
        }
        finally {
            doc.readUnlock();
        }
    }

    public int getDelay() {
        return this.timer.getDelay();
    }

    public Parser getParser(int index) {
        return (Parser)this.parsers.get(index);
    }

    public int getParserCount() {
        return this.parsers.size();
    }

    public List getParserNotices() {
        ArrayList<ParserNotice> notices = new ArrayList<ParserNotice>();
        if (this.noticesToHighlights != null) {
            for (ParserNotice notice : this.noticesToHighlights.keySet()) {
                notices.add(notice);
            }
        }
        return notices;
    }

    public ToolTipInfo getToolTipText(MouseEvent e) {
        String tip = null;
        HyperlinkListener listener = null;
        this.parserForTip = null;
        int pos = this.textArea.viewToModel(e.getPoint());
        if (this.noticesToHighlights != null) {
            for (ParserNotice notice : this.noticesToHighlights.keySet()) {
                if (!notice.containsPosition(pos)) continue;
                tip = notice.getToolTipText();
                this.parserForTip = notice.getParser();
                if (!(notice.getParser() instanceof HyperlinkListener)) break;
                listener = (HyperlinkListener)((Object)notice.getParser());
                break;
            }
        }
        URL imageBase = this.parserForTip == null ? null : this.parserForTip.getImageBase();
        return new ToolTipInfo(tip, listener, imageBase);
    }

    public void handleDocumentEvent(DocumentEvent e) {
        if (this.running && this.parsers.size() > 0) {
            this.timer.restart();
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (this.parserForTip != null && this.parserForTip.getHyperlinkListener() != null) {
            this.parserForTip.getHyperlinkListener().linkClicked(this.textArea, e);
        }
    }

    public void insertUpdate(DocumentEvent e) {
        try {
            int offs = e.getOffset();
            if (this.firstOffsetModded == null || offs < this.firstOffsetModded.getOffset()) {
                this.firstOffsetModded = e.getDocument().createPosition(offs);
            }
            offs = e.getOffset() + e.getLength();
            if (this.lastOffsetModded == null || offs > this.lastOffsetModded.getOffset()) {
                this.lastOffsetModded = e.getDocument().createPosition(offs);
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        this.handleDocumentEvent(e);
    }

    public boolean removeParser(Parser parser) {
        this.removeParserNotices(parser);
        boolean removed = this.parsers.remove(parser);
        if (removed) {
            this.textArea.fireParserNoticesChange();
        }
        return removed;
    }

    private void removeParserNotices(Parser parser) {
        if (this.noticesToHighlights != null) {
            RSyntaxTextAreaHighlighter h = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
            Iterator i = this.noticesToHighlights.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                ParserNotice notice = (ParserNotice)entry.getKey();
                if (notice.getParser() != parser || entry.getValue() == null) continue;
                h.removeParserHighlight(entry.getValue());
                i.remove();
            }
        }
    }

    private void removeParserNotices(ParseResult res) {
        if (this.noticesToHighlights != null) {
            RSyntaxTextAreaHighlighter h = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
            Iterator i = this.noticesToHighlights.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                ParserNotice notice = (ParserNotice)entry.getKey();
                if (!this.shouldRemoveNotice(notice, res)) continue;
                if (entry.getValue() != null) {
                    h.removeParserHighlight(entry.getValue());
                }
                i.remove();
            }
        }
    }

    public void removeUpdate(DocumentEvent e) {
        try {
            int offs = e.getOffset();
            if (this.firstOffsetModded == null || offs < this.firstOffsetModded.getOffset()) {
                this.firstOffsetModded = e.getDocument().createPosition(offs);
            }
            if (this.lastOffsetModded == null || offs > this.lastOffsetModded.getOffset()) {
                this.lastOffsetModded = e.getDocument().createPosition(offs);
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        this.handleDocumentEvent(e);
    }

    public void restartParsing() {
        this.timer.restart();
        this.running = true;
    }

    public void setDelay(int millis) {
        if (this.running) {
            this.timer.stop();
        }
        this.timer.setDelay(millis);
        if (this.running) {
            this.timer.start();
        }
    }

    private final boolean shouldRemoveNotice(ParserNotice notice, ParseResult res) {
        return notice.getParser() == res.getParser() && notice.getLine() >= res.getFirstLineParsed() && notice.getLine() <= res.getLastLineParsed();
    }

    public void stopParsing() {
        this.timer.stop();
        this.running = false;
    }
}

