/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lhadecompressor;

import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.lhadecompressor.LhaException;
import net.sourceforge.lhadecompressor.SlidingDicDecoder;

public class Lz5Decoder
extends SlidingDicDecoder {
    private static final int MAGIC = 19;
    private int flag;
    private int flagCount;
    private int matchPosition;

    public Lz5Decoder(InputStream in, long originalSize) {
        super(in, originalSize, 12, 253);
    }

    protected int decodeCode() throws IOException {
        if (this.flagCount == 0) {
            this.flagCount = 8;
            this.flag = this.in.read();
        }
        --this.flagCount;
        int c = this.in.read();
        if ((this.flag & 1) == 0) {
            this.matchPosition = c;
            c = this.in.read();
            this.matchPosition += (c & 0xF0) << 4;
            c &= 0xF;
            c |= 0x100;
        }
        this.flag >>>= 1;
        return c;
    }

    protected int decodePosition() throws IOException {
        return this.bufferPointerEnd - this.matchPosition - 19 & this.dictionaryMask;
    }

    protected void initRead() throws LhaException, IOException {
        int i;
        this.flagCount = 0;
        for (i = 0; i < 256; ++i) {
            for (int j = 0; j < 13; ++j) {
                this.dictionaryBuffer[i * 13 + 18 + j] = (byte)i;
            }
            this.dictionaryBuffer[3346 + i] = (byte)i;
            this.dictionaryBuffer[3602 + i] = (byte)(255 - i);
        }
        for (i = 0; i < 128; ++i) {
            this.dictionaryBuffer[3858] = 0;
        }
        for (i = 0; i < 110; ++i) {
            this.dictionaryBuffer[3986] = 32;
        }
    }
}

