/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lhadecompressor;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Checksum;
import net.sourceforge.lhadecompressor.CRC16;
import net.sourceforge.lhadecompressor.Lh1Decoder;
import net.sourceforge.lhadecompressor.Lh4Decoder;
import net.sourceforge.lhadecompressor.LhaDecoder;
import net.sourceforge.lhadecompressor.LhaEntry;
import net.sourceforge.lhadecompressor.LhaException;
import net.sourceforge.lhadecompressor.LhdDecoder;
import net.sourceforge.lhadecompressor.Lz5Decoder;
import net.sourceforge.lhadecompressor.LzsDecoder;
import net.sourceforge.lhadecompressor.NocompressDecoder;

public class LhaDecoderInputStream
extends InputStream {
    private static final int SIZE_SKIP_BUFFER = 512;
    protected LhaDecoder decoder;
    protected LhaEntry entry;
    protected Checksum crc;
    protected byte[] skipBuffer;
    protected long entryCount;

    public LhaDecoderInputStream(InputStream in, LhaEntry entry) throws LhaException, IOException {
        this.entry = entry;
        this.crc = new CRC16();
        this.skipBuffer = new byte[512];
        this.entryCount = entry.getOriginalSize();
        this.decoder = LhaDecoderInputStream.createDecorder(in, this.entryCount, entry.getMethod());
        this.crc.reset();
    }

    public Checksum getChecksum() {
        return this.crc;
    }

    public int available() throws IOException {
        if (this.decoder == null) {
            return 0;
        }
        return this.entryCount > 0L ? 1 : 0;
    }

    public int read() throws IOException {
        if (this.decoder == null) {
            return -1;
        }
        byte[] b = new byte[1];
        int n = this.decoder.read(b, 0, 1);
        if (n > 0) {
            this.crc.update(b[0]);
            --this.entryCount;
        }
        return b[0];
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.decoder == null) {
            return -1;
        }
        int n = this.decoder.read(b, off, len);
        if (n > 0) {
            this.crc.update(b, off, n);
            this.entryCount -= (long)n;
        }
        return n;
    }

    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        if (n > Integer.MAX_VALUE) {
            n = Integer.MAX_VALUE;
        }
        int total = 0;
        while ((long)total < n) {
            int len = (int)n - total;
            if (len > this.skipBuffer.length) {
                len = this.skipBuffer.length;
            }
            if ((len = this.read(this.skipBuffer, 0, len)) == -1) break;
            this.crc.update(this.skipBuffer, 0, len);
            total += len;
        }
        this.entryCount -= (long)total;
        return total;
    }

    public void close() throws IOException {
        if (this.decoder != null) {
            this.decoder.close();
            this.decoder = null;
            this.entry = null;
            this.crc = null;
        }
    }

    public void closeEntry() throws LhaException, IOException {
        long skipCount = this.skip(this.entryCount);
        if (this.entryCount != skipCount) {
            throw new LhaException("Data length not matched");
        }
        if (this.entry.hasCRC() && (long)this.entry.getCRC() != this.crc.getValue()) {
            throw new LhaException("Data crc is not matched");
        }
        this.close();
    }

    private static LhaDecoder createDecorder(InputStream in, long originalSize, String method) throws LhaException, IOException {
        if (method.equals("-lhd-")) {
            return new LhdDecoder();
        }
        if (method.equals("-lh0-")) {
            return new NocompressDecoder(in, originalSize);
        }
        if (method.equals("-lh1-")) {
            return new Lh1Decoder(in, originalSize);
        }
        if (method.equals("-lh2-")) {
            throw new LhaException("Unsupported method: " + method);
        }
        if (method.equals("-lh3-")) {
            throw new LhaException("Unsupported method: " + method);
        }
        if (method.equals("-lh4-")) {
            return new Lh4Decoder(in, originalSize, 12, 14, 4);
        }
        if (method.equals("-lh5-")) {
            return new Lh4Decoder(in, originalSize, 13, 14, 4);
        }
        if (method.equals("-lh6-")) {
            return new Lh4Decoder(in, originalSize, 15, 16, 5);
        }
        if (method.equals("-lh7-")) {
            return new Lh4Decoder(in, originalSize, 16, 17, 5);
        }
        if (method.equals("-lzs-")) {
            return new LzsDecoder(in, originalSize);
        }
        if (method.equals("-lz4-")) {
            return new NocompressDecoder(in, originalSize);
        }
        if (method.equals("-lz5-")) {
            return new Lz5Decoder(in, originalSize);
        }
        throw new LhaException("Unknown method: " + method);
    }
}

