/*
 * Decompiled with CFR 0.152.
 */
package jemu.util.hexeditor;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jemu.util.hexeditor.HexEditor;

class Text
extends JPanel
implements ChangeListener,
KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    static final Color ACTIVE_CURSOR;
    static final Color ACTIVE_SELECT;
    static final int MAX_FONT_SIZE = 73;
    static final int MIN_FONT_SIZE = 10;
    static final Color PANEL_COLOR;
    static final int PANEL_MARGIN = 10;
    static final Color SHADOW_CURSOR;
    static final Color SHADOW_SELECT;
    static final Color TEXT_COLOR;
    int[] charShifts = new int[127];
    int[] charWidths = new int[127];
    int cursorDot = 0;
    int cursorMark = 0;
    boolean cursorOnText = false;
    int lineAscent = -1;
    int lineHeight = -1;
    int maxWidth = -1;
    int mousePressNibble;
    boolean mousePressOnText;
    int mouseTempNibble;
    boolean mouseTempOnText;
    int panelColumns = -1;
    int panelDumpWidth = -1;
    Font panelFont = null;
    String panelFontName = "";
    int panelFontSize = -1;
    int panelHeight = -1;
    int panelWidth = -1;
    int panelOffset = 0;
    int panelRows = -1;

    public Text() {
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    void adjustScrollBar() {
        this.panelOffset = Math.max(0, Math.min(this.panelOffset, (HexEditor.nibbleCount / (this.panelDumpWidth * 2) - this.panelRows + 1) * this.panelDumpWidth));
        this.panelOffset -= this.panelOffset % this.panelDumpWidth;
        HexEditor.textScroll.setValues(this.panelOffset / this.panelDumpWidth, this.panelRows, 0, HexEditor.nibbleCount / (this.panelDumpWidth * 2) + 1);
        HexEditor.textScroll.setBlockIncrement(Math.max(1, this.panelRows - 1));
        HexEditor.textScroll.setUnitIncrement(1);
    }

    void beginFile() {
        this.cursorDot = 0;
        this.cursorMark = 0;
        this.cursorOnText = false;
        this.panelDumpWidth = -1;
        this.panelOffset = 0;
        this.repaint();
    }

    void convertMouse(MouseEvent event) {
        int column;
        this.mouseTempOnText = event.getX() > 10 + (int)(((double)(8 + this.panelDumpWidth * 3) + 2.8) * (double)this.maxWidth);
        int row = (event.getY() - 10) / this.lineHeight;
        row = Math.max(0, Math.min(row, this.panelRows - 1));
        if (this.mouseTempOnText) {
            int x = event.getX() - 10 - (int)(((double)(8 + this.panelDumpWidth * 3) + 3.8) * (double)this.maxWidth);
            column = x / this.maxWidth * 2;
        } else {
            int x = event.getX() - 10 - (int)(9.5 * (double)this.maxWidth);
            column = x / (this.maxWidth * 3) * 2;
            column += (double)(x % (this.maxWidth * 3)) <= (double)this.maxWidth * 1.3 ? 0 : 1;
        }
        column = Math.max(0, Math.min(column, this.panelDumpWidth * 2));
        this.mouseTempNibble = (this.panelOffset + row * this.panelDumpWidth) * 2 + column;
        this.mouseTempNibble = Math.min(this.mouseTempNibble, HexEditor.nibbleCount);
    }

    void finishArrowKey(KeyEvent event) {
        if (!event.isShiftDown()) {
            this.cursorMark = this.cursorDot;
        }
        this.limitCursorRange();
        this.makeVisible(this.cursorDot);
        this.repaint();
    }

    public void keyPressed(KeyEvent keyevent) {
    }

    public void keyReleased(KeyEvent event) {
        int key = event.getKeyCode();
        switch (key) {
            default: {
                break;
            }
            case 40: 
            case 225: {
                if (this.cursorOnText) {
                    this.cursorDot += this.cursorDot % 2;
                    this.cursorMark -= this.cursorMark % 2;
                }
                this.cursorDot += this.panelDumpWidth * 2;
                this.finishArrowKey(event);
                break;
            }
            case 35: {
                if (this.cursorOnText) {
                    this.cursorMark -= this.cursorMark % 2;
                }
                if (event.isControlDown()) {
                    this.cursorDot = HexEditor.nibbleCount;
                } else {
                    this.cursorDot += this.panelDumpWidth * 2;
                    this.cursorDot -= this.cursorDot % (this.panelDumpWidth * 2);
                }
                this.finishArrowKey(event);
                break;
            }
            case 114: {
                HexEditor.searchFindNext();
                break;
            }
            case 117: {
                this.cursorOnText = !event.isShiftDown();
                this.limitCursorRange();
                this.repaint();
                break;
            }
            case 36: {
                if (this.cursorOnText) {
                    this.cursorMark += this.cursorMark % 2;
                }
                if (event.isControlDown()) {
                    this.cursorDot = 0;
                } else {
                    --this.cursorDot;
                    this.cursorDot -= this.cursorDot % (this.panelDumpWidth * 2);
                }
                this.finishArrowKey(event);
                break;
            }
            case 155: {
                HexEditor.overFlag = !HexEditor.overFlag;
                HexEditor.overDialog.setSelected(HexEditor.overFlag);
                this.repaint();
                break;
            }
            case 37: 
            case 226: {
                if (this.cursorOnText) {
                    --this.cursorDot;
                    this.cursorDot -= this.cursorDot % 2;
                    this.cursorMark += this.cursorMark % 2;
                } else {
                    --this.cursorDot;
                }
                this.finishArrowKey(event);
                break;
            }
            case 34: {
                if (this.cursorOnText) {
                    this.cursorDot += this.cursorDot % 2;
                    this.cursorMark -= this.cursorMark % 2;
                }
                this.cursorDot += this.panelDumpWidth * 2 * Math.max(1, this.panelRows - 1);
                this.finishArrowKey(event);
                break;
            }
            case 33: {
                if (this.cursorOnText) {
                    this.cursorDot -= this.cursorDot % 2;
                    this.cursorMark += this.cursorMark % 2;
                }
                this.cursorDot -= this.panelDumpWidth * 2 * Math.max(1, this.panelRows - 1);
                this.finishArrowKey(event);
                break;
            }
            case 39: 
            case 227: {
                if (this.cursorOnText) {
                    ++this.cursorDot;
                    this.cursorDot += this.cursorDot % 2;
                    this.cursorMark -= this.cursorMark % 2;
                } else {
                    ++this.cursorDot;
                }
                this.finishArrowKey(event);
                break;
            }
            case 38: 
            case 224: {
                if (this.cursorOnText) {
                    this.cursorDot -= this.cursorDot % 2;
                    this.cursorMark += this.cursorMark % 2;
                }
                this.cursorDot -= this.panelDumpWidth * 2;
                this.finishArrowKey(event);
            }
        }
    }

    public void keyTyped(KeyEvent event) {
        char ch = event.getKeyChar();
        if (!event.isAltDown()) {
            if (event.isControlDown()) {
                switch (ch) {
                    case '\u0001': {
                        HexEditor.selectAll();
                        break;
                    }
                    case '\u0003': {
                        if (this.cursorOnText) {
                            HexEditor.copyText();
                            break;
                        }
                        HexEditor.copyHex();
                        break;
                    }
                    case '\u0006': {
                        HexEditor.showSearchDialog();
                        break;
                    }
                    case '\u000e': {
                        HexEditor.searchFindNext();
                        break;
                    }
                    case '\u0012': {
                        HexEditor.searchReplaceThis();
                        break;
                    }
                    case '\u0016': {
                        if (this.cursorOnText) {
                            HexEditor.pasteText();
                            break;
                        }
                        HexEditor.pasteHex();
                        break;
                    }
                    case '\u0018': {
                        if (this.cursorOnText) {
                            HexEditor.copyText();
                        } else {
                            HexEditor.copyHex();
                        }
                        HexEditor.deleteSelected();
                    }
                }
            } else if (ch == '\b') {
                if (this.cursorDot != this.cursorMark) {
                    HexEditor.deleteSelected();
                } else if (this.cursorDot > 0) {
                    if (this.cursorOnText) {
                        --this.cursorDot;
                        this.cursorDot -= this.cursorDot % 2;
                        if (this.cursorDot < HexEditor.nibbleCount - 1) {
                            HexEditor.nibbleData.delete(this.cursorDot + 1);
                        }
                        HexEditor.nibbleData.delete(this.cursorDot);
                    } else {
                        --this.cursorDot;
                        HexEditor.nibbleData.delete(this.cursorDot);
                    }
                    this.cursorMark = this.cursorDot;
                    this.limitCursorRange();
                    this.makeVisible(this.cursorDot);
                    this.adjustScrollBar();
                    this.repaint();
                }
            } else if (ch == '\u001b') {
                this.cursorDot = this.cursorMark;
                this.repaint();
            } else if (ch == '\u007f') {
                if (this.cursorDot != this.cursorMark) {
                    HexEditor.deleteSelected();
                } else if (this.cursorDot < HexEditor.nibbleCount) {
                    if (this.cursorOnText) {
                        this.cursorDot -= this.cursorDot % 2;
                        if (this.cursorDot < HexEditor.nibbleCount - 1) {
                            HexEditor.nibbleData.delete(this.cursorDot);
                        }
                        HexEditor.nibbleData.delete(this.cursorDot);
                    } else {
                        HexEditor.nibbleData.delete(this.cursorDot);
                    }
                    this.cursorMark = this.cursorDot;
                    this.limitCursorRange();
                    this.makeVisible(this.cursorDot);
                    this.adjustScrollBar();
                    this.repaint();
                }
            } else if (!Character.isISOControl(ch)) {
                if (this.cursorOnText) {
                    if (HexEditor.overFlag) {
                        this.cursorDot = this.cursorMark = Math.min(this.cursorDot, this.cursorMark);
                    }
                    byte[] bytes = String.valueOf(ch).getBytes();
                    int[] nibbles = new int[bytes.length * 2];
                    int used = 0;
                    for (int i = 0; i < bytes.length; ++i) {
                        nibbles[used++] = bytes[i] >> 4 & 0xF;
                        nibbles[used++] = bytes[i] & 0xF;
                    }
                    HexEditor.pasteNibbles(nibbles, used);
                } else {
                    if (HexEditor.overFlag) {
                        this.cursorDot = this.cursorMark = Math.min(this.cursorDot, this.cursorMark);
                    }
                    int hexValue = HexEditor.charHexValue(ch);
                    int[] nibbles = new int[1];
                    int used = 0;
                    if (hexValue >= 0) {
                        nibbles[used++] = hexValue;
                    } else if (hexValue != -1) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                    if (used > 0) {
                        HexEditor.pasteNibbles(nibbles, used);
                    }
                }
            }
        }
    }

    void limitCursorRange() {
        HexEditor.refreshDataSize();
        this.cursorDot = Math.max(0, Math.min(this.cursorDot, HexEditor.nibbleCount));
        this.cursorMark = Math.max(0, Math.min(this.cursorMark, HexEditor.nibbleCount));
    }

    void makeVisible(int nibbleIndex) {
        if (nibbleIndex < this.panelOffset * 2) {
            this.panelOffset = nibbleIndex / (2 * this.panelDumpWidth) * this.panelDumpWidth;
            this.adjustScrollBar();
            this.repaint();
        } else if (nibbleIndex >= (this.panelOffset + this.panelRows * this.panelDumpWidth) * 2) {
            this.panelOffset = (nibbleIndex / (2 * this.panelDumpWidth) - this.panelRows + 1) * this.panelDumpWidth;
            this.adjustScrollBar();
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent event) {
        this.requestFocusInWindow();
        this.convertMouse(event);
        if (this.mouseTempNibble < 0) {
            this.cursorDot = this.cursorMark;
            this.repaint();
        } else if (event.isControlDown() || event.getButton() != 1) {
            HexEditor.showEditMenu(this, event.getX(), event.getY());
        } else if (event.isShiftDown()) {
            this.cursorDot = this.mouseTempNibble;
            this.cursorOnText = this.mouseTempOnText;
            this.limitCursorRange();
            this.makeVisible(this.cursorDot);
            this.repaint();
        } else {
            this.cursorDot = this.cursorMark = this.mouseTempNibble;
            this.cursorOnText = this.mouseTempOnText;
            this.limitCursorRange();
            this.makeVisible(this.cursorDot);
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent event) {
        this.requestFocusInWindow();
        this.convertMouse(event);
        if (this.mousePressNibble < 0 || this.mouseTempNibble < 0 || this.mousePressOnText != this.mouseTempOnText) {
            if (this.cursorDot != this.cursorMark) {
                this.cursorDot = this.cursorMark;
                this.repaint();
            }
        } else {
            boolean updateFlag = false;
            if (this.cursorDot != this.mouseTempNibble) {
                this.cursorDot = this.mouseTempNibble;
                updateFlag = true;
            }
            if (this.cursorMark != this.mousePressNibble) {
                this.cursorMark = this.mousePressNibble;
                updateFlag = true;
            }
            if (this.cursorOnText != this.mouseTempOnText) {
                this.cursorOnText = this.mouseTempOnText;
                updateFlag = true;
            }
            if (updateFlag) {
                this.repaint();
            }
        }
    }

    public void mouseEntered(MouseEvent event) {
        this.requestFocusInWindow();
    }

    public void mouseExited(MouseEvent mouseevent) {
    }

    public void mouseMoved(MouseEvent event) {
        this.requestFocusInWindow();
    }

    public void mousePressed(MouseEvent event) {
        this.requestFocusInWindow();
        this.convertMouse(event);
        this.mousePressNibble = this.mouseTempNibble;
        this.mousePressOnText = this.mouseTempOnText;
    }

    public void mouseReleased(MouseEvent event) {
        this.requestFocusInWindow();
    }

    public void mouseWheelMoved(MouseWheelEvent event) {
        switch (event.getScrollType()) {
            case 1: {
                HexEditor.textScroll.setValue(HexEditor.textScroll.getValue() + event.getWheelRotation() * Math.max(1, this.panelRows - 1));
                break;
            }
            case 0: {
                int i = Math.max(1, this.panelRows - 1);
                i = Math.max(-i, Math.min(i, event.getUnitsToScroll()));
                HexEditor.textScroll.setValue(HexEditor.textScroll.getValue() + i);
            }
        }
    }

    protected void paintComponent(Graphics context) {
        int rowFirstTextX;
        int nibbleIndex;
        context.setColor(PANEL_COLOR);
        context.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (HexEditor.dumpWidth != this.panelDumpWidth || !HexEditor.fontName.equals(this.panelFontName) || this.getWidth() != this.panelWidth) {
            int testSize;
            this.panelDumpWidth = HexEditor.dumpWidth;
            this.panelFontName = HexEditor.fontName;
            this.panelHeight = this.getHeight();
            this.panelWidth = this.getWidth();
            this.panelColumns = 9 + this.panelDumpWidth * 3 + 2 + 1 + this.panelDumpWidth + 1;
            int fontSizeLow = 10;
            int fontSizeHigh = 73;
            this.panelFontSize = -1;
            while (this.panelFontSize != (testSize = (fontSizeLow + fontSizeHigh) / 2)) {
                this.panelFontSize = testSize;
                this.panelFont = new Font(this.panelFontName, 1, this.panelFontSize);
                FontMetrics fm = context.getFontMetrics(this.panelFont);
                this.lineAscent = fm.getAscent();
                this.lineHeight = fm.getHeight();
                this.maxWidth = -1;
                for (int i = 32; i <= 126; ++i) {
                    this.charWidths[i] = fm.charWidth(i);
                    this.maxWidth = Math.max(this.charWidths[i], this.maxWidth);
                }
                if (this.panelColumns * this.maxWidth < this.panelWidth - 20) {
                    fontSizeLow = this.panelFontSize;
                    continue;
                }
                fontSizeHigh = this.panelFontSize;
            }
            for (int i = 32; i <= 126; ++i) {
                this.charShifts[i] = (this.maxWidth - this.charWidths[i]) / 2;
            }
            this.panelRows = Math.max(1, (this.panelHeight - 20) / this.lineHeight);
            this.adjustScrollBar();
        } else if (this.getHeight() != this.panelHeight) {
            this.panelHeight = this.getHeight();
            this.panelRows = Math.max(1, (this.panelHeight - 20) / this.lineHeight);
            this.adjustScrollBar();
        }
        int panelNibbleBegin = this.panelOffset * 2;
        int panelNibbleEnd = panelNibbleBegin + this.panelRows * this.panelDumpWidth * 2;
        int selectBegin = Math.max(panelNibbleBegin, Math.min(this.cursorDot, this.cursorMark));
        int selectEnd = Math.min(panelNibbleEnd, Math.max(this.cursorDot, this.cursorMark));
        if (selectBegin < selectEnd) {
            context.setColor(this.cursorOnText ? SHADOW_SELECT : ACTIVE_SELECT);
            int row = (selectBegin / 2 - this.panelOffset) / this.panelDumpWidth;
            int thisRowY = 10 + row * this.lineHeight;
            int rowNibbleCount = this.panelDumpWidth * 2;
            int nibble = selectBegin % rowNibbleCount;
            int rowFirstDumpX = 10 + this.maxWidth * 10;
            int thisColumnX = rowFirstDumpX + this.maxWidth * (nibble + nibble / 2);
            nibbleIndex = selectBegin;
            while (nibbleIndex < selectEnd) {
                context.fillRect(thisColumnX, thisRowY, this.maxWidth, this.lineHeight);
                ++nibbleIndex;
                thisColumnX += this.maxWidth;
                if (++nibble >= rowNibbleCount) {
                    nibble = 0;
                    thisColumnX = rowFirstDumpX;
                    thisRowY += this.lineHeight;
                    continue;
                }
                if (nibbleIndex >= selectEnd || nibbleIndex % 2 != 0) continue;
                context.fillRect(thisColumnX, thisRowY, this.maxWidth, this.lineHeight);
                thisColumnX += this.maxWidth;
            }
            context.setColor(this.cursorOnText ? ACTIVE_SELECT : SHADOW_SELECT);
            row = (selectBegin / 2 - this.panelOffset) / this.panelDumpWidth;
            thisRowY = 10 + row * this.lineHeight;
            int column = selectBegin % (this.panelDumpWidth * 2) / 2;
            rowFirstTextX = 10 + this.maxWidth * (8 + 3 * this.panelDumpWidth + 4);
            thisColumnX = rowFirstTextX + this.maxWidth * column;
            nibbleIndex = selectBegin - selectBegin % 2;
            while (nibbleIndex < selectEnd) {
                context.fillRect(thisColumnX, thisRowY, this.maxWidth, this.lineHeight);
                nibbleIndex += 2;
                thisColumnX += this.maxWidth;
                if (++column < this.panelDumpWidth) continue;
                column = 0;
                thisColumnX = rowFirstTextX;
                thisRowY += this.lineHeight;
            }
        }
        if (this.cursorDot >= panelNibbleBegin && this.cursorDot < panelNibbleEnd) {
            int cursorY = (this.cursorDot - panelNibbleBegin) / (this.panelDumpWidth * 2);
            cursorY = 10 + cursorY * this.lineHeight;
            int cursorX = this.cursorDot % (this.panelDumpWidth * 2) / 2;
            cursorX = 10 + this.maxWidth * (8 + 3 * cursorX + 2);
            if (this.cursorDot % 2 > 0) {
                cursorX += this.maxWidth;
            }
            context.setColor(this.cursorOnText ? SHADOW_CURSOR : ACTIVE_CURSOR);
            if (HexEditor.overFlag) {
                context.drawRect(cursorX - 1, cursorY, this.maxWidth + 1, this.lineHeight - 1);
                if (this.panelFontSize > 24) {
                    context.drawRect(cursorX, cursorY + 1, this.maxWidth - 1, this.lineHeight - 3);
                }
            } else {
                context.fillRect(cursorX - 1, cursorY, this.panelFontSize <= 24 ? 2 : 3, this.lineHeight);
            }
            cursorX = this.cursorDot % (this.panelDumpWidth * 2) / 2;
            cursorX = 10 + this.maxWidth * (8 + 3 * this.panelDumpWidth + cursorX + 4);
            context.setColor(this.cursorOnText ? ACTIVE_CURSOR : SHADOW_CURSOR);
            if (HexEditor.overFlag) {
                context.drawRect(cursorX - 1, cursorY, this.maxWidth + 1, this.lineHeight - 1);
                if (this.panelFontSize > 24) {
                    context.drawRect(cursorX, cursorY + 1, this.maxWidth - 1, this.lineHeight - 3);
                }
            } else {
                context.fillRect(cursorX - 1, cursorY, this.panelFontSize <= 24 ? 2 : 3, this.lineHeight);
            }
        }
        context.setColor(TEXT_COLOR);
        context.setFont(this.panelFont);
        int maxOffset = HexEditor.nibbleCount / 2;
        int rowLastDigitX = 10 + 7 * this.maxWidth;
        int rowLeftMarkerX = 10 + this.maxWidth * (11 + 3 * this.panelDumpWidth) + this.charShifts[124];
        int rowRightMarkerX = rowLeftMarkerX + this.maxWidth * (this.panelDumpWidth + 1);
        int rowY = 10 + this.lineAscent;
        int thisOffset = this.panelOffset;
        for (int row = 0; row < this.panelRows && thisOffset <= maxOffset; thisOffset += this.panelDumpWidth, ++row) {
            int shiftedOffset = thisOffset;
            int thisDigitX = rowLastDigitX;
            for (int i = 8; i > 0; --i) {
                char ch = HexEditor.HEX_DIGITS[shiftedOffset & 0xF];
                context.drawString(Character.toString(ch), thisDigitX + this.charShifts[ch], rowY);
                shiftedOffset >>= 4;
                thisDigitX -= this.maxWidth;
            }
            context.drawString(HexEditor.MARKER_STRING, rowLeftMarkerX, rowY);
            context.drawString(HexEditor.MARKER_STRING, rowRightMarkerX, rowY);
            rowY += this.lineHeight;
        }
        nibbleIndex = this.panelOffset * 2;
        int rowFirstDumpX = 10 + this.maxWidth * 10;
        rowFirstTextX = rowFirstDumpX + this.maxWidth * (3 * this.panelDumpWidth + 2);
        rowY = 10 + this.lineAscent;
        for (int row = 0; row < this.panelRows; ++row) {
            int thisDumpX = rowFirstDumpX;
            int thisTextX = rowFirstTextX;
            for (int column = 0; column < this.panelDumpWidth && nibbleIndex < HexEditor.nibbleCount; ++column) {
                int thisNibble = HexEditor.nibbleData.get(nibbleIndex++);
                char ch = HexEditor.HEX_DIGITS[thisNibble & 0xF];
                context.drawString(Character.toString(ch), thisDumpX + this.charShifts[ch], rowY);
                thisDumpX += this.maxWidth;
                int byteValue = thisNibble << 4;
                if (nibbleIndex < HexEditor.nibbleCount) {
                    thisNibble = HexEditor.nibbleData.get(nibbleIndex++);
                    ch = HexEditor.HEX_DIGITS[thisNibble & 0xF];
                    context.drawString(Character.toString(ch), thisDumpX + this.charShifts[ch], rowY);
                    thisDumpX += this.maxWidth;
                    byteValue |= thisNibble;
                } else {
                    byteValue = -1;
                }
                thisDumpX += this.maxWidth;
                if (byteValue < 32 || byteValue > 126) {
                    byteValue = 46;
                }
                context.drawString(Character.toString((char)byteValue), thisTextX + this.charShifts[byteValue], rowY);
                thisTextX += this.maxWidth;
            }
            rowY += this.lineHeight;
        }
    }

    public void stateChanged(ChangeEvent event) {
        int scroll;
        int newOffset;
        if (this.panelDumpWidth > 1 && (newOffset = (scroll = HexEditor.textScroll.getValue()) * this.panelDumpWidth) != this.panelOffset) {
            this.panelOffset = newOffset;
            this.repaint();
        }
    }

    static {
        ACTIVE_SELECT = new Color(151, 151, 255);
        SHADOW_CURSOR = new Color(102, 102, 102);
        SHADOW_SELECT = new Color(151, 151, 151);
        ACTIVE_CURSOR = Color.BLUE;
        PANEL_COLOR = Color.WHITE;
        TEXT_COLOR = Color.BLACK;
    }
}

