/*
 * Decompiled with CFR 0.152.
 */
package jemu.util.diss;

import jemu.core.Util;
import jemu.core.device.memory.Memory;
import jemu.ui.Debugger;
import jemu.util.diss.Disassembler;

public class DissZ80
extends Disassembler {
    protected static final String[] r = new String[]{"B", "C", "D", "E", "H", "L", "(HL)", "A"};
    protected static final String[] dd = new String[]{"BC", "DE", "HL", "SP"};
    protected static final String[] cc = new String[]{"NZ", "Z", "NC", "C", "PO", "PE", "P", "M"};
    protected static final int[] ddfd = new int[]{9, 25, 33, 34, 35, 36, 37, 38, 41, 42, 43, 44, 45, 46, 52, 53, 54, 57, 68, 69, 70, 76, 77, 78, 84, 85, 86, 92, 93, 94, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 119, 124, 125, 127, 132, 133, 134, 140, 141, 142, 148, 149, 150, 156, 157, 158, 164, 165, 166, 172, 173, 174, 180, 181, 182, 188, 189, 190, 203, 225, 227, 229, 233};
    protected static final int[] ddfd3 = new int[]{195, 17, 1, 250, 205, 49, 218, 252};
    protected static final int[] ddfd2 = new int[]{126, 6, 14, 16};
    protected String add;
    protected String g;
    protected static final String[] CB_CODES = new String[]{"RLC    ", "RRC    ", "RL     ", "RR     ", "SLA    ", "SRA    ", "SLL    ", "SRL    ", "BIT    ", "RES    ", "SET    "};

    public String disassemble(Memory memory, int[] address) {
        int opcode = 0;
        opcode = this.read ? memory.readByte(this.nextAddress(address), this.config) : (this.any ? memory.readWriteByte(this.nextAddress(address), this.config, this.forcedbank, true) : memory.readWriteByte(this.nextAddress(address), this.config));
        String replace = null;
        if (opcode == 221 || opcode == 253) {
            int check = 0;
            if (this.read) {
                check = memory.readByte(this.nextAddress(address), this.config);
                memory.readByte(this.previousAddress(address), this.config);
            } else if (this.any) {
                check = memory.readWriteByte(this.nextAddress(address), this.config, this.forcedbank, true);
                memory.readWriteByte(this.previousAddress(address), this.config, this.forcedbank, true);
            } else {
                check = memory.readWriteByte(this.nextAddress(address), this.config);
                memory.readWriteByte(this.previousAddress(address), this.config);
            }
            boolean skip = true;
            for (int g = 0; g < ddfd.length; ++g) {
                if (check != ddfd[g] && (opcode != 221 || check != 249)) continue;
                skip = false;
                break;
            }
            if (!skip) {
                String string = replace = opcode == 221 ? "IX" : "IY";
                opcode = this.read ? memory.readByte(this.nextAddress(address), this.config) : (this.any ? memory.readWriteByte(this.nextAddress(address), this.config, this.forcedbank, true) : memory.readWriteByte(this.nextAddress(address), this.config));
            }
        }
        return this.disassemble(memory, address, opcode, replace);
    }

    protected String disassemble(Memory memory, int[] address, int opcode, String replace) {
        String result = "  #### UNKNOWN INSTRUCTION!!! ####";
        switch (opcode) {
            case 0: {
                result = "NOP";
                break;
            }
            case 1: 
            case 17: 
            case 33: 
            case 49: {
                result = "LD      " + this.dd(opcode >> 4, replace) + "," + this.nn(memory, address);
                break;
            }
            case 2: {
                result = "LD      (BC),A";
                break;
            }
            case 3: 
            case 19: 
            case 35: 
            case 51: {
                result = "INC     " + this.ss(opcode >> 4, replace);
                break;
            }
            case 4: 
            case 12: 
            case 20: 
            case 28: 
            case 36: 
            case 44: 
            case 52: 
            case 60: {
                result = "INC     " + this.r(memory, address, -1, opcode >> 3, replace);
                break;
            }
            case 5: 
            case 13: 
            case 21: 
            case 29: 
            case 37: 
            case 45: 
            case 53: 
            case 61: {
                result = "DEC     " + this.r(memory, address, -1, opcode >> 3, replace);
                break;
            }
            case 6: 
            case 14: 
            case 22: 
            case 30: 
            case 38: 
            case 46: 
            case 54: 
            case 62: {
                result = "LD      " + this.r(memory, address, -1, opcode >> 3, replace) + "," + this.n(memory, address);
                break;
            }
            case 7: {
                result = "RLCA";
                break;
            }
            case 8: {
                result = "EX      AF,AF'";
                break;
            }
            case 9: 
            case 25: 
            case 41: 
            case 57: {
                result = "ADD     " + (replace == null ? "HL" : replace) + "," + this.ss(opcode >> 4, replace);
                break;
            }
            case 10: {
                result = "LD      A,(BC)";
                break;
            }
            case 11: 
            case 27: 
            case 43: 
            case 59: {
                result = "DEC     " + this.ss(opcode >> 4, replace);
                break;
            }
            case 15: {
                result = "RRCA";
                break;
            }
            case 16: {
                result = "DJNZ    " + this.e(memory, address);
                break;
            }
            case 18: {
                result = "LD      (DE),A";
                break;
            }
            case 23: {
                result = "RLA";
                break;
            }
            case 24: {
                result = "JR      " + this.e(memory, address);
                break;
            }
            case 26: {
                result = "LD      A,(DE)";
                break;
            }
            case 31: {
                result = "RRA";
                break;
            }
            case 32: {
                result = "JR      NZ," + this.e(memory, address);
                break;
            }
            case 34: {
                result = "LD      (" + this.nn(memory, address) + ")," + (replace == null ? "HL" : replace);
                break;
            }
            case 39: {
                result = "DAA";
                break;
            }
            case 40: {
                result = "JR      Z," + this.e(memory, address);
                break;
            }
            case 42: {
                result = "LD      " + (replace == null ? "HL" : replace) + ",(" + this.nn(memory, address) + ")";
                break;
            }
            case 47: {
                result = "CPL";
                break;
            }
            case 48: {
                result = "JR      NC," + this.e(memory, address);
                break;
            }
            case 50: {
                result = "LD      (" + this.nn(memory, address) + "),A";
                break;
            }
            case 55: {
                result = "SCF";
                break;
            }
            case 56: {
                result = "JR      C," + this.e(memory, address);
                break;
            }
            case 58: {
                result = "LD      A,(" + this.nn(memory, address) + ")";
                break;
            }
            case 63: {
                result = "CCF";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                result = "LD      " + this.r(memory, address, -1, opcode >> 3, replace) + "," + this.r(memory, address, -1, opcode, replace);
                break;
            }
            case 102: 
            case 110: {
                result = "LD      " + this.r(null, null, -1, opcode >> 3, null) + "," + this.r(memory, address, -1, 6, replace);
                break;
            }
            case 116: 
            case 117: {
                result = "LD      " + this.r(memory, address, -1, 6, replace) + "," + this.r(null, null, -1, opcode, null);
                break;
            }
            case 118: {
                result = "HALT";
                break;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: {
                result = "ADD     " + this.r(memory, address, -1, opcode, replace);
                break;
            }
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: {
                result = "ADC     " + this.r(memory, address, -1, opcode, replace);
                break;
            }
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: {
                result = "SUB     " + this.r(memory, address, -1, opcode, replace);
                break;
            }
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: {
                result = "SBC     " + this.r(memory, address, -1, opcode, replace);
                break;
            }
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: {
                result = "AND     " + this.r(memory, address, -1, opcode, replace);
                break;
            }
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: {
                result = "XOR     " + this.r(memory, address, -1, opcode, replace);
                break;
            }
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: {
                result = "OR      " + this.r(memory, address, -1, opcode, replace);
                break;
            }
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                result = "CP      " + this.r(memory, address, -1, opcode, replace);
                break;
            }
            case 192: 
            case 200: 
            case 208: 
            case 216: 
            case 224: 
            case 232: 
            case 240: 
            case 248: {
                result = "RET     " + this.cc(opcode >> 3);
                break;
            }
            case 193: 
            case 209: 
            case 225: 
            case 241: {
                result = "POP     " + this.qq(opcode >> 4, replace);
                break;
            }
            case 194: 
            case 202: 
            case 210: 
            case 218: 
            case 226: 
            case 234: 
            case 242: 
            case 250: {
                result = "JP      " + this.cc(opcode >> 3) + "," + this.nn(memory, address);
                break;
            }
            case 195: {
                result = "JP      " + this.nn(memory, address);
                break;
            }
            case 196: 
            case 204: 
            case 212: 
            case 220: 
            case 228: 
            case 236: 
            case 244: 
            case 252: {
                result = "CALL    " + this.cc(opcode >> 3) + "," + this.nn(memory, address);
                break;
            }
            case 197: 
            case 213: 
            case 229: 
            case 245: {
                result = "PUSH    " + this.qq(opcode >> 4, replace);
                break;
            }
            case 198: {
                result = "ADD     " + this.n(memory, address);
                break;
            }
            case 199: 
            case 207: 
            case 215: 
            case 223: 
            case 231: 
            case 239: 
            case 247: 
            case 255: {
                result = "RST     &" + Util.hex((byte)(opcode & 0x38));
                break;
            }
            case 201: {
                result = "RET";
                break;
            }
            case 203: {
                result = this.cbCode(memory, address, replace);
                break;
            }
            case 205: {
                result = "CALL    " + this.nn(memory, address);
                break;
            }
            case 206: {
                result = "ADC     " + this.n(memory, address);
                break;
            }
            case 211: {
                result = "OUT     (" + this.n(memory, address) + "),A";
                break;
            }
            case 214: {
                result = "SUB     " + this.n(memory, address);
                break;
            }
            case 217: {
                result = "EXX";
                break;
            }
            case 219: {
                result = "IN      A,(" + this.n(memory, address) + ")";
                break;
            }
            case 221: {
                this.add = "";
                this.g = this.n(memory, address);
                this.add = this.add + "," + this.g;
                try {
                    int h;
                    int tocheck = Util.hexValue(this.g.substring(1));
                    for (h = 0; h < ddfd3.length; ++h) {
                        if (tocheck != ddfd3[h]) continue;
                        this.g = this.n(memory, address);
                        this.add = this.add + "," + this.g;
                        this.g = this.n(memory, address);
                        this.add = this.add + "," + this.g;
                        break;
                    }
                    for (h = 0; h < ddfd2.length; ++h) {
                        if (tocheck != ddfd2[h]) continue;
                        this.g = this.n(memory, address);
                        this.add = this.add + "," + this.g;
                        break;
                    }
                }
                catch (Exception tocheck) {
                    // empty catch block
                }
                result = "DB      &DD" + this.add;
                if (!result.contains("DB      &DD,&7E")) break;
                result = "LD      A,(IX+" + result.substring(16) + ")";
                break;
            }
            case 253: {
                this.add = "";
                this.g = this.n(memory, address);
                this.add = this.add + "," + this.g;
                try {
                    int h;
                    int tocheck = Util.hexValue(this.g.substring(1));
                    for (h = 0; h < ddfd3.length; ++h) {
                        if (tocheck != ddfd3[h]) continue;
                        this.g = this.n(memory, address);
                        this.add = this.add + "," + this.g;
                        this.g = this.n(memory, address);
                        this.add = this.add + "," + this.g;
                        break;
                    }
                    for (h = 0; h < ddfd2.length; ++h) {
                        if (tocheck != ddfd2[h]) continue;
                        this.g = this.n(memory, address);
                        this.add = this.add + "," + this.g;
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                result = "DB      &FD" + this.add;
                if (result.contains("DB      &FD,&7E")) {
                    result = "LD      A,(IY+" + result.substring(16) + ")";
                }
                if (!result.contains("DB      &FD,&F9")) break;
                result = "LD      SP,IY";
                break;
            }
            case 222: {
                result = "SBC     " + this.n(memory, address);
                break;
            }
            case 227: {
                result = "EX      (SP),HL";
                break;
            }
            case 230: {
                result = "AND     " + this.n(memory, address);
                break;
            }
            case 233: {
                result = replace == null ? "JP      (HL)" : "JP      (" + replace + ")";
                break;
            }
            case 235: {
                result = "EX      DE,HL";
                break;
            }
            case 237: {
                result = this.edCode(memory, address);
                break;
            }
            case 238: {
                result = "XOR     " + this.n(memory, address);
                break;
            }
            case 243: {
                result = "DI";
                break;
            }
            case 246: {
                result = "OR      " + this.n(memory, address);
                break;
            }
            case 249: {
                result = "LD      SP,HL";
                break;
            }
            case 251: {
                result = "EI";
                break;
            }
            case 254: {
                result = "CP      " + this.n(memory, address);
                break;
            }
            default: {
                throw new RuntimeException("Invalid Opcode: " + Integer.toHexString(opcode));
            }
        }
        if (!Debugger.bWinape.isSelected()) {
            if (result.equals("JP      (IX)")) {
                return "LD      PC,IX";
            }
            if (result.equals("JP      (HL)")) {
                return "LD      PC,HL";
            }
        }
        return result;
    }

    protected String cbCode(Memory memory, int[] address, String replace) {
        int offset = 0;
        int opcode = 0;
        if (this.read) {
            offset = replace == null ? 0 : memory.readByte(this.nextAddress(address), this.config);
            opcode = memory.readByte(this.nextAddress(address), this.config);
        } else if (this.any) {
            offset = replace == null ? 0 : memory.readWriteByte(this.nextAddress(address), this.config, this.forcedbank, true);
            opcode = memory.readWriteByte(this.nextAddress(address), this.config, this.forcedbank, true);
        } else {
            offset = replace == null ? 0 : memory.readWriteByte(this.nextAddress(address), this.config);
            opcode = memory.readWriteByte(this.nextAddress(address), this.config);
        }
        String result = opcode < 64 ? CB_CODES[opcode >> 3 & 7] + " " + this.r(null, null, offset, opcode, replace) : CB_CODES[(opcode >> 6 & 3) + 7] + " " + (char)(48 + (opcode >> 3 & 7)) + "," + this.r(null, null, offset, opcode, replace);
        if (replace != null && opcode < 64 | opcode > 127 && (opcode & 7) != 6) {
            result = "LD      " + this.r(null, null, -1, opcode, null) + result;
        }
        return result;
    }

    protected String edCode(Memory memory, int[] address) {
        String result;
        int opcode = 0;
        opcode = this.read ? memory.readByte(this.nextAddress(address), this.config) : (this.any ? memory.readWriteByte(this.nextAddress(address), this.config, this.forcedbank, true) : memory.readWriteByte(this.nextAddress(address), this.config));
        switch (opcode) {
            case 64: 
            case 72: 
            case 80: 
            case 88: 
            case 96: 
            case 104: 
            case 120: {
                result = "IN      " + this.r(null, null, -1, opcode >> 3, null) + ",(C)";
                break;
            }
            case 65: 
            case 73: 
            case 81: 
            case 89: 
            case 97: 
            case 105: 
            case 121: {
                result = "OUT     (C)," + this.r(null, null, -1, opcode >> 3, null);
                break;
            }
            case 66: 
            case 82: 
            case 98: 
            case 114: {
                result = "SBC     HL," + this.ss(opcode >> 4, null);
                break;
            }
            case 67: 
            case 83: 
            case 99: 
            case 115: {
                result = "LD      (" + this.nn(memory, address) + ")," + this.ss(opcode >> 4, null);
                break;
            }
            case 68: 
            case 76: 
            case 84: 
            case 92: 
            case 100: 
            case 108: 
            case 116: 
            case 124: {
                result = "NEG";
                break;
            }
            case 69: 
            case 85: 
            case 101: 
            case 117: {
                result = "RETN";
                break;
            }
            case 70: 
            case 78: 
            case 102: 
            case 110: {
                result = "IM      0";
                break;
            }
            case 71: {
                result = "LD      I,A";
                break;
            }
            case 74: 
            case 90: 
            case 106: 
            case 122: {
                result = "ADC     HL," + this.ss(opcode >> 4, null);
                break;
            }
            case 75: 
            case 91: 
            case 123: {
                result = "LD      " + this.dd(opcode >> 4, null) + ",(" + this.nn(memory, address) + ")";
                break;
            }
            case 107: {
                String nn = this.nn(memory, address);
                result = "DB      &ED,&" + Util.hex((byte)opcode) + ",";
                String n1 = "";
                String n2 = "";
                n1 = n1 + nn.charAt(0);
                n1 = n1 + nn.charAt(1);
                n1 = n1 + nn.charAt(2);
                n2 = n2 + nn.charAt(0);
                n2 = n2 + nn.charAt(3);
                n2 = n2 + nn.charAt(4);
                n2 = n2 + ",";
                result = result + n2 + n1;
                break;
            }
            case 77: 
            case 93: 
            case 109: 
            case 125: {
                result = "RETI";
                break;
            }
            case 79: {
                result = "LD      R,A";
                break;
            }
            case 86: 
            case 118: {
                result = "IM      1";
                break;
            }
            case 87: {
                result = "LD      A,I";
                break;
            }
            case 94: 
            case 126: {
                result = "IM      2";
                break;
            }
            case 95: {
                result = "LD      A,R";
                break;
            }
            case 103: {
                result = "RRD";
                break;
            }
            case 111: {
                result = "RLD";
                break;
            }
            case 112: {
                result = "IN      (C)";
                break;
            }
            case 113: {
                result = "DB      &ED,&71";
                break;
            }
            case 160: {
                result = "LDI";
                break;
            }
            case 161: {
                result = "CPI";
                break;
            }
            case 162: {
                result = "INI";
                break;
            }
            case 163: {
                result = "OUTI";
                break;
            }
            case 168: {
                result = "LDD";
                break;
            }
            case 169: {
                result = "CPD";
                break;
            }
            case 170: {
                result = "IND";
                break;
            }
            case 171: {
                result = "OUTD";
                break;
            }
            case 176: {
                result = "LDIR";
                break;
            }
            case 177: {
                result = "CPIR";
                break;
            }
            case 178: {
                result = "INIR";
                break;
            }
            case 179: {
                result = "OTIR";
                break;
            }
            case 184: {
                result = "LDDR";
                break;
            }
            case 185: {
                result = "CPDR";
                break;
            }
            case 186: {
                result = "INDR";
                break;
            }
            case 187: {
                result = "OTDR";
                break;
            }
            case 251: {
                result = "DB      &ED,&" + Integer.toHexString(opcode).toUpperCase();
                break;
            }
            default: {
                result = "DB      &ED,&" + Integer.toHexString(opcode).toUpperCase();
            }
        }
        return result;
    }

    protected String ss(int index, String replace) {
        return this.dd(index, replace);
    }

    protected String dd(int index, String replace) {
        return replace != null && index == 2 ? replace : dd[index &= 3];
    }

    protected String qq(int index, String replace) {
        return (index & 3) == 3 ? "AF" : this.dd(index, replace);
    }

    protected String nn(Memory memory, int[] address) {
        int lsb = 0;
        if (this.read) {
            lsb = memory.readByte(this.nextAddress(address), this.config);
            return "&" + Util.hex((short)(lsb + (memory.readByte(this.nextAddress(address), this.config) << 8)));
        }
        if (this.any) {
            lsb = memory.readWriteByte(this.nextAddress(address), this.config, this.forcedbank, true);
            return "&" + Util.hex((short)(lsb + (memory.readWriteByte(this.nextAddress(address), this.config, this.forcedbank, true) << 8)));
        }
        lsb = memory.readWriteByte(this.nextAddress(address), this.config);
        return "&" + Util.hex((short)(lsb + (memory.readWriteByte(this.nextAddress(address), this.config) << 8)));
    }

    protected String r(Memory memory, int[] address, int offset, int index, String replace) {
        if (replace == null || (index &= 7) < 4 || index == 7) {
            return r[index];
        }
        if (index != 6) {
            return r[index] + replace.substring(1);
        }
        if (offset == -1) {
            offset = this.read ? memory.readByte(this.nextAddress(address), this.config) : (this.any ? memory.readWriteByte(this.nextAddress(address), this.config, this.forcedbank, true) : memory.readWriteByte(this.nextAddress(address), this.config));
        }
        int e = offset;
        String sign = "+";
        if (e < 128) {
            sign = "+";
        } else {
            sign = "-";
            e = (e ^ 0xFF) + 1;
        }
        return "(" + replace + sign + "&" + Util.hex((byte)e) + ")";
    }

    protected String n(Memory memory, int[] address) {
        if (this.read) {
            return "&" + Util.hex((byte)memory.readByte(this.nextAddress(address), this.config));
        }
        if (this.any) {
            return "&" + Util.hex((byte)memory.readWriteByte(this.nextAddress(address), this.config, this.forcedbank, true));
        }
        return "&" + Util.hex((byte)memory.readWriteByte(this.nextAddress(address), this.config));
    }

    protected String e(Memory memory, int[] address) {
        int addr = this.nextAddress(address);
        int result = 0;
        result = this.read ? memory.readByte(addr, this.config) : (this.any ? memory.readWriteByte(addr, this.config, this.forcedbank, true) : memory.readWriteByte(addr, this.config));
        addr = addr + 1 + (byte)result & 0xFFFF;
        return "&" + Util.hex((short)addr);
    }

    protected String cc(int index) {
        return cc[index & 7];
    }
}

