/*
 * Decompiled with CFR 0.152.
 */
package jemu.util.diss;

import jemu.core.Util;
import jemu.core.device.memory.Memory;
import jemu.ui.Debugger;

public abstract class Disassembler {
    protected boolean winape = false;
    protected Object config;
    protected int addrMask = 65535;
    public boolean read = true;
    public boolean any = false;
    public int forcedbank = 192;

    protected int nextAddress(int[] address) {
        int result = address[0];
        address[0] = result + 1 & this.addrMask;
        return result;
    }

    protected int previousAddress(int[] address) {
        int result = address[0];
        address[0] = result - 1 & this.addrMask;
        return result;
    }

    public abstract String disassemble(Memory var1, int[] var2);

    public String disassemble(Memory memory, int[] address, boolean showAddr, int dataPos, int breakPos) {
        this.winape = Debugger.bWinape.isSelected();
        int start = address[0];
        String result = Util.hex((short)start) + ": " + this.disassemble(memory, address);
        if (dataPos != 0) {
            while (result.length() < dataPos) {
                result = result + " ";
            }
            if (this.winape) {
                result = result + ";";
            }
            result = result + ";";
            int i = start;
            while (i != address[0]) {
                if (i != start) {
                    result = result + " ";
                }
                result = this.read ? result + Util.hex((byte)memory.readByte(i, this.config)) : (this.any ? result + Util.hex((byte)memory.readWriteByte(i, this.config)) : result + Util.hex((byte)memory.readWriteByte(i, this.config, this.forcedbank, true)));
                i = i + 1 & 0xFFFF;
            }
        }
        if (!this.winape) {
            if (result.contains("HY")) {
                result = result.replace("HY", "YH");
            }
            if (result.contains("HX")) {
                result = result.replace("HX", "XH");
            }
            if (result.contains("LY")) {
                result = result.replace("LY", "YL");
            }
            if (result.contains("LX")) {
                result = result.replace("LX", "XL");
            }
        }
        while (result.length() < breakPos) {
            result = result + " ";
        }
        return result;
    }

    public String disass(Memory memory, int[] address, boolean showAddr, int dataPos, int breakPos) {
        this.winape = Debugger.bWinape.isSelected();
        int start = address[0];
        String result = this.disassemble(memory, address);
        String ret = "";
        if (result.contains("RET") && !result.contains("RETI")) {
            ret = "\r\n";
        }
        if (dataPos != 0) {
            while (result.length() < dataPos) {
                result = result + " ";
            }
            result = this.winape ? result + " ;;" + Util.hex((short)start) + ":   " : result + " ;" + Util.hex((short)start) + ":   ";
            String letters = "";
            int i = start;
            while (i != address[0]) {
                int res = 0;
                res = this.read ? memory.readByte(i, this.config) : (this.any ? memory.readWriteByte(i, this.config, this.forcedbank, true) : memory.readWriteByte(i, this.config));
                letters = res >= 32 && res <= 126 ? letters + (char)res : letters + ".";
                i = i + 1 & 0xFFFF;
            }
            result = result + letters;
            if (letters.length() == 3) {
                result = result + " ";
            }
            if (letters.length() == 2) {
                result = result + "  ";
            }
            if (letters.length() == 1) {
                result = result + "   ";
            }
            if (letters.length() == 0) {
                result = result + "    ";
            }
            result = result + "    ";
            i = start;
            while (i != address[0]) {
                if (i != start) {
                    result = result + " ";
                }
                result = this.read ? result + Util.hex((byte)memory.readByte(i, this.config)) : (this.any ? result + Util.hex((byte)memory.readWriteByte(i, this.config, this.forcedbank, true)) : result + Util.hex((byte)memory.readWriteByte(i, this.config)));
                i = i + 1 & 0xFFFF;
            }
        }
        if (!this.winape) {
            if (result.contains("HY")) {
                result = result.replace("HY", "YH");
            }
            if (result.contains("HX")) {
                result = result.replace("HX", "XH");
            }
            if (result.contains("LY")) {
                result = result.replace("LY", "YL");
            }
            if (result.contains("LX")) {
                result = result.replace("LX", "XL");
            }
        }
        if (result.contains("LD      LSLL     XL")) {
            result = result.replace("LD      LSLL     XL", "SLL     (IX+&14)->L");
        }
        result = result + ret;
        return result;
    }

    public void setMemoryConfiguration(Object value) {
        this.config = value;
    }

    public Object getMemoryConfiguration() {
        return this.config;
    }
}

